/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.controller;

import com.alibaba.fastjson2.JSONObject;
import java.util.List;
import java.util.Map;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.Result;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.ActivitiService;
import org.openoa.base.vo.BpmVerifyInfoVo;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.base.vo.ConfDetailRequestDto;
import org.openoa.base.vo.DetailRequestDto;
import org.openoa.base.vo.PreviewNode;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.base.vo.TaskMgmtVO;
import org.openoa.engine.bpmnconf.service.biz.BpmVerifyInfoBizServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmnConfBizServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.ProcessApprovalServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeToServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnConfBizService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bpmnConf"})
public class BpmnConfController {
    private static final Logger log = LoggerFactory.getLogger(BpmnConfController.class);
    @Autowired
    private BpmnConfBizService bpmnConfBizService;
    @Autowired
    private BpmnNodeToServiceImpl bpmnNodeToService;
    @Autowired
    private ProcessApprovalServiceImpl processApprovalService;
    @Autowired
    private BpmnConfBizServiceImpl bpmnConfCommonService;
    @Autowired
    private BpmVerifyInfoBizServiceImpl bpmVerifyInfoBizService;
    @Autowired(required=false)
    private Map<String, ActivitiService> activitiServices;
    @Autowired
    private BpmnNodeServiceImpl testService;

    @GetMapping(value={"/todoList"})
    public Result<TaskMgmtVO> todoList() {
        TaskMgmtVO taskMgmtVO = this.processApprovalService.processStatistics();
        return Result.newSuccessResult((Object)taskMgmtVO);
    }

    @PostMapping(value={"/edit"})
    public Result edit(@RequestBody BpmnConfVo bpmnConfVo) {
        this.bpmnConfBizService.edit(bpmnConfVo);
        return Result.newSuccessResult((Object)"ok");
    }

    @PostMapping(value={"/listPage"})
    public Result<ResultAndPage<BpmnConfVo>> listPage(@RequestBody ConfDetailRequestDto dto) {
        PageDto page = dto.getPageDto();
        BpmnConfVo vo = (BpmnConfVo)dto.getEntity();
        return Result.newSuccessResult(this.bpmnConfBizService.selectPage(page, vo));
    }

    @PostMapping(value={"/preview"})
    public Result preview(@RequestBody String params) {
        return Result.newSuccessResult((Object)this.bpmnConfCommonService.previewNode(params));
    }

    @PostMapping(value={"/startPagePreviewNode"})
    public Result<PreviewNode> startPagePreviewNode(@RequestBody String params) {
        JSONObject jsonObject = JSONObject.parseObject((String)params);
        Boolean isStartPreview = jsonObject.getBoolean("isStartPreview");
        if (isStartPreview == null || isStartPreview.booleanValue()) {
            return Result.newSuccessResult((Object)this.bpmnConfCommonService.startPagePreviewNode(params));
        }
        return Result.newSuccessResult((Object)this.bpmnConfCommonService.taskPagePreviewNode(params));
    }

    @GetMapping(value={"/getBpmVerifyInfoVos"})
    public Result<List<BpmVerifyInfoVo>> getBpmVerifyInfoVos(@RequestParam(value="processNumber") String processNumber) {
        return Result.newSuccessResult(this.bpmVerifyInfoBizService.getBpmVerifyInfoVos(processNumber, false));
    }

    @PostMapping(value={"/process/viewBusinessProcess"})
    public Result<BusinessDataVo> viewBusinessProcess(@RequestBody String values, String formCode) {
        return Result.newSuccessResult((Object)this.processApprovalService.getBusinessInfo(values, formCode));
    }

    @PostMapping(value={"/process/buttonsOperation"})
    public Result buttonsOperation(@RequestBody String values, String formCode) {
        BusinessDataVo resultData = this.processApprovalService.buttonsOperation(values, formCode);
        return Result.newSuccessResult((Object)resultData);
    }

    @GetMapping(value={"/effectiveBpmn/{id}"})
    public Result effectiveBpmn(@PathVariable(value="id") Integer id) {
        this.bpmnConfBizService.effectiveBpmnConf(id);
        return Result.newSuccessResult(null);
    }

    @RequestMapping(value={"/detail/{id}"})
    public Result<BpmnConfVo> detail(@PathVariable(value="id") Integer id) {
        return Result.newSuccessResult((Object)this.bpmnConfBizService.detail(id.intValue()));
    }

    @RequestMapping(value={"/process/listPage/{type}"})
    public ResultAndPage<TaskMgmtVO> viewPcProcessList(@RequestBody DetailRequestDto requestDto, @PathVariable(value="type") Integer type) throws AFBizException {
        PageDto pageDto = requestDto.getPageDto();
        TaskMgmtVO taskMgmtVO = requestDto.getTaskMgmtVO();
        taskMgmtVO.setType(type);
        return this.processApprovalService.findPcProcessList(pageDto, taskMgmtVO);
    }
}

