/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.openoa.base.constant.enums.EventTypeEnum;
import org.openoa.base.constant.enums.ProcessNoticeEnum;
import org.openoa.base.constant.enums.WildcardCharacterEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.BpmProcessNotice;
import org.openoa.base.entity.InformationTemplate;
import org.openoa.base.entity.Result;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseNumIdStruVo;
import org.openoa.base.vo.DefaultTemplateVo;
import org.openoa.base.vo.EnumerateVo;
import org.openoa.base.vo.InformationPgeRequestDto;
import org.openoa.base.vo.InformationTemplateVo;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.service.impl.BpmProcessNoticeServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableApproveRemindBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.InformationTemplateBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.InformationTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/informationTemplates"})
public class InformationTemplateController {
    @Resource
    private InformationTemplateBizService informationTemplateBizService;
    @Resource
    private BpmVariableApproveRemindBizService variableApproveRemindBizService;
    @Autowired
    private BpmProcessNoticeServiceImpl processNoticeService;

    @PostMapping(value={"/listPage"})
    public ResultAndPage list(InformationPgeRequestDto dto) {
        PageDto pageDto = dto.getPageDto();
        InformationTemplateVo informationTemplateVo = (InformationTemplateVo)dto.getEntity();
        if (informationTemplateVo == null) {
            informationTemplateVo = new InformationTemplateVo();
        }
        return ((InformationTemplateService)this.informationTemplateBizService.getService()).list(pageDto, informationTemplateVo);
    }

    @GetMapping(value={"/getInformationTemplateById"})
    public Result getInformationTemplateById(@Param(value="templateId") Long templateId) {
        if (templateId == null) {
            Result.newFailureResult((String)"\u53c2\u6570\u4e3a\u7a7a\u9519\u8bef", (String)"\u6a21\u677fId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InformationTemplateVo informationTemplateById = ((InformationTemplateService)this.informationTemplateBizService.getService()).getInformationTemplateById(templateId);
        return Result.newSuccessResult((Object)informationTemplateById);
    }

    @PostMapping(value={"/updateById"})
    public Result updateById(@RequestBody InformationTemplateVo informationTemplateVo) {
        this.informationTemplateBizService.edit(informationTemplateVo);
        return Result.success();
    }

    @PostMapping(value={"/save"})
    public Result save(@RequestBody InformationTemplateVo informationTemplateVo) {
        long templateId = this.informationTemplateBizService.edit(informationTemplateVo);
        return Result.newSuccessResult((Object)templateId);
    }

    @PostMapping(value={"/deleteById"})
    public Result deleteById(@RequestParam Long id) {
        ((InformationTemplateService)this.informationTemplateBizService.getService()).updateById(InformationTemplate.builder().id(id).updateUser(SecurityUtils.getLogInEmpNameSafe()).isDel(Integer.valueOf(1)).build());
        return Result.success();
    }

    @GetMapping(value={"/listByName"})
    public Result list(@RequestParam(required=false) String name) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_del", (Object)0)).eq((Object)"status", (Object)0)).like(!StringUtils.isEmpty((CharSequence)name), (Object)"name", (Object)name);
        List results = ((InformationTemplateService)this.informationTemplateBizService.getService()).list((Wrapper)queryWrapper);
        return Result.newSuccessResult((Object)results);
    }

    @GetMapping(value={"/defaultTemplates"})
    public Result getList() {
        return Result.newSuccessResult(this.informationTemplateBizService.getList());
    }

    @PostMapping(value={"/setDefaultTemplates"})
    public Result setList(@RequestBody DefaultTemplateVo[] vos) {
        this.informationTemplateBizService.setList(Arrays.asList(vos));
        return Result.success();
    }

    @GetMapping(value={"/getWildcardCharacter"})
    public Result getWildcardCharacter(@RequestParam(required=false) String name) {
        return Result.newSuccessResult(!StringUtils.isEmpty((CharSequence)name) ? new ArrayList<WildcardCharacterEnum>(Arrays.asList(WildcardCharacterEnum.values())).stream().filter(o -> o.getDesc().contains(name)).map(o -> EnumerateVo.builder().code(o.getCode()).desc(o.getDesc()).build()).collect(Collectors.toList()) : new ArrayList<WildcardCharacterEnum>(Arrays.asList(WildcardCharacterEnum.values())).stream().map(o -> EnumerateVo.builder().code(o.getCode()).desc(o.getDesc()).build()).collect(Collectors.toList()));
    }

    @GetMapping(value={"/getProcessEvents"})
    public Result getAllProcessEvents() {
        ArrayList<BaseNumIdStruVo> lists = new ArrayList<BaseNumIdStruVo>();
        for (EventTypeEnum anEnum : EventTypeEnum.values()) {
            lists.add(BaseNumIdStruVo.builder().id(Long.valueOf(anEnum.getCode().longValue())).name(anEnum.getDesc()).build());
        }
        return Result.newSuccessResult(lists);
    }

    @GetMapping(value={"/getAllNoticeTypes"})
    public Result getAllNoticeTypes() {
        ProcessNoticeEnum[] processNoticeEnums = ProcessNoticeEnum.values();
        ArrayList<BaseNumIdStruVo> lists = new ArrayList<BaseNumIdStruVo>();
        for (ProcessNoticeEnum processNoticeEnum : processNoticeEnums) {
            lists.add(BaseNumIdStruVo.builder().id(Long.valueOf(processNoticeEnum.getCode())).name(processNoticeEnum.getDesc()).build());
        }
        return Result.newSuccessResult(lists);
    }

    @GetMapping(value={"/getNoticeTypeByFormCode"})
    public Result getNoticeTypeByFormCode(@RequestParam String formCode) {
        if (StringUtils.isEmpty((CharSequence)formCode)) {
            throw new AFBizException("\u8bf7\u4f20\u5165\u8868\u5355\u7f16\u7801");
        }
        List<BpmProcessNotice> bpmProcessNotices = this.processNoticeService.processNoticeList(formCode);
        ArrayList<BaseNumIdStruVo> lists = new ArrayList<BaseNumIdStruVo>();
        for (BpmProcessNotice bpmProcessNotice : bpmProcessNotices) {
            Integer type = bpmProcessNotice.getType();
            String descByCode = ProcessNoticeEnum.getDescByCode((Integer)type);
            lists.add(BaseNumIdStruVo.builder().id(Long.valueOf(type.intValue())).name(descByCode).active(Boolean.valueOf(true)).build());
        }
        return Result.newSuccessResult(lists);
    }

    @GetMapping(value={"/testDoTimeoutReminder"})
    public void testDoTimeoutReminder() {
        this.variableApproveRemindBizService.doTimeoutReminder();
    }
}

