/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.controller;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.BpmnConfLfFormdata;
import org.openoa.base.entity.Result;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.vo.BaseKeyValueStruVo;
import org.openoa.base.vo.DetailRequestDto;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.base.vo.TaskMgmtVO;
import org.openoa.engine.bpmnconf.service.interf.biz.LowCodeFlowBizService;
import org.openoa.engine.lowflow.service.BpmnConfLFFormDataBizServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/lowcode"})
public class LowCodeFlowController {
    @Autowired
    private BpmnConfLFFormDataBizServiceImpl lfFormDataBizService;
    @Autowired(required=false)
    private LowCodeFlowBizService lowCodeFlowBizService;

    @GetMapping(value={"/getLowCodeFlowFormCodes"})
    public Result<List<BaseKeyValueStruVo>> getLowCodeFormCodes() {
        return Result.newSuccessResult(this.lowCodeFlowBizService.getLowCodeFlowFormCodes());
    }

    @PostMapping(value={"/getLFFormCodePageList"})
    public ResultAndPage<BaseKeyValueStruVo> getLFFormCodePageList(@RequestBody DetailRequestDto requestDto) {
        PageDto pageDto = requestDto.getPageDto();
        TaskMgmtVO taskMgmtVO = requestDto.getTaskMgmtVO();
        return this.lowCodeFlowBizService.selectLFFormCodePageList(pageDto, taskMgmtVO);
    }

    @PostMapping(value={"/getLFActiveFormCodePageList"})
    public ResultAndPage<BaseKeyValueStruVo> getLFActiveFormCodePageList(@RequestBody DetailRequestDto requestDto) {
        PageDto pageDto = requestDto.getPageDto();
        TaskMgmtVO taskMgmtVO = requestDto.getTaskMgmtVO();
        return this.lowCodeFlowBizService.selectLFActiveFormCodePageList(pageDto, taskMgmtVO);
    }

    @GetMapping(value={"/getformDataByFormCode"})
    public Result<String> getLFFormDataByFormCode(String formCode) {
        if (StringUtils.isEmpty((CharSequence)formCode)) {
            throw new AFBizException("\u8bf7\u4f20\u5165formcode");
        }
        BpmnConfLfFormdata lfFormDataByFormCode = this.lfFormDataBizService.getLFFormDataByFormCode(formCode);
        return Result.newSuccessResult((Object)lfFormDataByFormCode.getFormdata());
    }

    @PostMapping(value={"/createLowCodeFormCode"})
    public Result createLowCodeFormCode(@RequestBody BaseKeyValueStruVo vo) {
        return Result.newSuccessResult((Object)this.lowCodeFlowBizService.addFormCode(vo));
    }
}

