/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.controller;

import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.Result;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.ConfDetailRequestDto;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmConditionsTemplateServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.OutSideBpmAccessBusinessBizService;
import org.openoa.engine.vo.OutSideBpmAccessBusinessVo;
import org.openoa.engine.vo.OutSideBpmAccessRespVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outSide"})
@Validated
public class OutSideBpmAccessController {
    private static final Logger log = LoggerFactory.getLogger(OutSideBpmAccessController.class);
    @Autowired
    private OutSideBpmAccessBusinessBizService outSideBpmAccessBusinessService;
    @Autowired
    private OutSideBpmConditionsTemplateServiceImpl outSideBpmConditionsTemplateService;

    @PostMapping(value={"/processSubmit"})
    public Result<OutSideBpmAccessRespVo> accessBusinessStart(@RequestBody OutSideBpmAccessBusinessVo vo) {
        return Result.newSuccessResult((Object)this.outSideBpmAccessBusinessService.accessBusinessStart(vo));
    }

    @PostMapping(value={"/getOutSideFormCodePageList"})
    public ResultAndPage<BpmnConfVo> listPage(@RequestBody ConfDetailRequestDto dto) {
        PageDto page = dto.getPageDto();
        BpmnConfVo vo = (BpmnConfVo)dto.getEntity();
        return this.outSideBpmAccessBusinessService.selectOutSideFormCodePageList(page, vo);
    }

    @PostMapping(value={"/processPreview"})
    public Result accessBusinessPreview(@RequestBody OutSideBpmAccessBusinessVo vo) {
        return Result.newSuccessResult(this.outSideBpmAccessBusinessService.accessBusinessPreview(vo));
    }

    @PostMapping(value={"/processBreak"})
    public Result accessBusinessBreak(@RequestBody OutSideBpmAccessBusinessVo vo) {
        this.outSideBpmAccessBusinessService.processBreak(vo);
        return Result.newSuccessResult(null);
    }

    @GetMapping(value={"/outSideProcessRecord"})
    public Result outSideProcessRecord(@RequestParam(value="processNumber") String processNumber) {
        return Result.newSuccessResult(this.outSideBpmAccessBusinessService.outSideProcessRecord(processNumber));
    }
}

