/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.controller;

import com.google.common.base.Strings;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.Result;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.ConfDetailRequestDto;
import org.openoa.engine.bpmnconf.service.impl.BpmProcessAppApplicationServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmApproveTemplateServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.OutSideBpmBusinessPartyBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.OutSideBpmConditionsTemplateBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmConditionsTemplateService;
import org.openoa.engine.vo.BpmProcessAppApplicationVo;
import org.openoa.engine.vo.OutSideBpmApproveTemplateVo;
import org.openoa.engine.vo.OutSideBpmBusinessPartyVo;
import org.openoa.engine.vo.OutSideBpmConditionsTemplateVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outSideBpm"})
@Validated
public class OutSideBpmBusinessController {
    private static final Logger log = LoggerFactory.getLogger(OutSideBpmBusinessController.class);
    @Autowired
    private OutSideBpmBusinessPartyBizService outSideBpmBusinessPartyBizService;
    @Autowired
    private BpmProcessAppApplicationServiceImpl outProcessAppApplicationService;
    @Autowired
    private OutSideBpmConditionsTemplateBizService outSideBpmConditionsTemplateBizService;
    @Autowired
    private OutSideBpmApproveTemplateServiceImpl outSideBpmApproveTemplateService;

    @PostMapping(value={"/businessParty/listPage"})
    public Result listPage(@RequestBody ConfDetailRequestDto dto) {
        PageDto page = dto.getPageDto();
        BpmnConfVo vo = (BpmnConfVo)dto.getEntity();
        OutSideBpmBusinessPartyVo searchVo = new OutSideBpmBusinessPartyVo();
        if (!Strings.isNullOrEmpty((String)vo.getRemark())) {
            searchVo.setName(vo.getRemark());
            searchVo.setRemark(vo.getRemark());
        }
        return Result.newSuccessResult(this.outSideBpmBusinessPartyBizService.listPage(page, searchVo));
    }

    @GetMapping(value={"/businessParty/detail/{id}"})
    public Result detail(@PathVariable(value="id") Integer id) {
        return Result.newSuccessResult((Object)this.outSideBpmBusinessPartyBizService.detail(id));
    }

    @PostMapping(value={"/businessParty/edit"})
    public Result edit(@RequestBody OutSideBpmBusinessPartyVo vo) {
        this.outSideBpmBusinessPartyBizService.edit(vo);
        return Result.newSuccessResult(null);
    }

    @PostMapping(value={"/businessParty/applicationsPageList"})
    public Result applicationsPageList(@RequestBody ConfDetailRequestDto dto) {
        PageDto page = dto.getPageDto();
        BpmnConfVo vo = (BpmnConfVo)dto.getEntity();
        BpmProcessAppApplicationVo searchVo = new BpmProcessAppApplicationVo();
        if (!Strings.isNullOrEmpty((String)vo.getRemark())) {
            searchVo.setBusinessName(vo.getRemark());
            searchVo.setProcessKey(vo.getRemark());
        }
        if (Strings.isNullOrEmpty((String)page.getOrderColumn())) {
            page.setOrderColumn("id");
        }
        return Result.newSuccessResult(this.outSideBpmBusinessPartyBizService.applicationsPageList(page, searchVo));
    }

    @PostMapping(value={"/businessParty/addBpmProcessAppApplication"})
    public Result<Boolean> addBpmProcessAppApplication(@RequestBody BpmProcessAppApplicationVo vo) {
        boolean ret = this.outProcessAppApplicationService.addBpmProcessAppApplication(vo);
        return Result.newSuccessResult((Object)ret);
    }

    @GetMapping(value={"/businessParty/applicationDetail/{id}"})
    public Result applicationDetail(@PathVariable(value="id") Integer id) {
        return Result.newSuccessResult((Object)this.outSideBpmBusinessPartyBizService.getApplicationDetailById(id));
    }

    @GetMapping(value={"/conditionTemplate/listPage"})
    public Result listPage(PageDto page, OutSideBpmConditionsTemplateVo vo) {
        return Result.newSuccessResult(this.outSideBpmConditionsTemplateBizService.listPage(page, vo));
    }

    @GetMapping(value={"/conditionTemplate/selectListByTemp/{applicationId}"})
    public Result selectConditionListByAppId(@PathVariable(value="applicationId") Integer applicationId) {
        return Result.newSuccessResult(((OutSideBpmConditionsTemplateService)this.outSideBpmConditionsTemplateBizService.getService()).selectConditionListByAppId(applicationId));
    }

    @PostMapping(value={"/conditionTemplate/edit"})
    public Result edit(@RequestBody OutSideBpmConditionsTemplateVo vo) {
        ((OutSideBpmConditionsTemplateService)this.outSideBpmConditionsTemplateBizService.getService()).edit(vo);
        return Result.success();
    }

    @GetMapping(value={"/conditionTemplate/delete/{id}"})
    public Result delete(@PathVariable(value="id") Integer id) {
        this.outSideBpmConditionsTemplateBizService.delete(id);
        return Result.newSuccessResult(null);
    }

    @GetMapping(value={"/approveTemplate/listPage"})
    public Result approveTemplateListPage(PageDto page, OutSideBpmApproveTemplateVo vo) {
        return Result.newSuccessResult(this.outSideBpmApproveTemplateService.listPage(page, vo));
    }

    @GetMapping(value={"/approveTemplate/selectListByTemp/{applicationId}"})
    public Result selectApproveListByPartMarkIdAndAppId(@PathVariable(value="applicationId") Integer applicationId) {
        return Result.newSuccessResult(this.outSideBpmApproveTemplateService.selectListByTemp(applicationId));
    }

    @PostMapping(value={"/approveTemplate/edit"})
    public Result approveTemplateEdit(@RequestBody OutSideBpmApproveTemplateVo vo) {
        this.outSideBpmApproveTemplateService.edit(vo);
        return Result.success();
    }

    @GetMapping(value={"/approveTemplate/detail/{id}"})
    public Result approveTemplateDetail(@PathVariable(value="id") Integer id) {
        return Result.newSuccessResult((Object)this.outSideBpmApproveTemplateService.detail(id));
    }
}

