/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.activiti.engine.impl.cfg.multitenant.TenantInfoHolder;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.Result;
import org.openoa.base.interf.anno.IgnoreLog;
import org.openoa.base.mapper.RoleMapper;
import org.openoa.base.mapper.UserMapper;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.PageUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.DetailRequestDto;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.base.vo.TaskMgmtVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@IgnoreLog
@RequestMapping(value={"/user"})
@RestController
public class UserController {
    @Autowired
    private AfUserService userService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;
    @Autowired
    private TenantInfoHolder infoHolder;
    @Autowired
    private RoleMapper roleMapper;

    @RequestMapping(value={"/queryUserByNameFuzzy"})
    public Result queryUserByNameFuzzy(String userName) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return Result.newSuccessResult((Object)Lists.newArrayList());
        }
        List users = this.userService.queryByNameFuzzy(userName);
        return Result.newSuccessResult((Object)users);
    }

    @RequestMapping(value={"/queryCompanyByNameFuzzy"})
    public Result queryCompanyByNameFuzzy(String companyName) {
        if (StringUtils.isEmpty((CharSequence)companyName)) {
            return Result.newSuccessResult((Object)Lists.newArrayList());
        }
        List codeTranStruVos = this.userService.queryCompanyByNameFuzzy(companyName);
        return Result.newSuccessResult((Object)codeTranStruVos);
    }

    @GetMapping(value={"/getUser/{roleId}", "/getUser"})
    public Result<List<BaseIdTranStruVo>> getUsers(@PathVariable(required=false) Integer roleId) {
        LinkedList list = this.userMapper.selectAll(roleId);
        return Result.newSuccessResult((Object)list);
    }

    @PostMapping(value={"/getUserPageList"})
    public ResultAndPage<BaseIdTranStruVo> getUserPageList(@RequestBody DetailRequestDto requestDto) {
        PageDto pageDto = requestDto.getPageDto();
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto);
        TaskMgmtVO taskMgmtVO = requestDto.getTaskMgmtVO();
        List results = this.userMapper.selectUserPageList(page, taskMgmtVO);
        page.setRecords(results);
        return PageUtils.getResultAndPage((Page)page);
    }

    @GetMapping(value={"/getRoleInfo"})
    public Result<List<BaseIdTranStruVo>> getRoleInfo() {
        LinkedList list = this.roleMapper.selectAll();
        return Result.newSuccessResult((Object)list);
    }
}

