/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service;

import java.util.List;
import java.util.Map;
import org.openoa.base.constant.enums.ButtonPageTypeEnum;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.constant.enums.ProcessStateEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.base.vo.ProcessActionButtonVo;
import org.openoa.engine.bpmnconf.common.ConfigFlowButtonContans;
import org.openoa.engine.bpmnconf.common.ProcessBusinessContans;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableSignUpBizService;
import org.openoa.engine.factory.FormFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ViewBusinessProcessImpl
implements ProcessOperationAdaptor {
    @Autowired
    private BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private FormFactory formFactory;
    @Autowired
    private ProcessBusinessContans businessContans;
    @Autowired
    private ConfigFlowButtonContans configFlowButtonContans;
    @Autowired
    private BpmVariableSignUpBizService variableSignUpBizService;

    public void doProcessButton(BusinessDataVo businessDataVo) {
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(businessDataVo.getProcessNumber());
        if (ObjectUtils.isEmpty((Object)bpmBusinessProcess)) {
            throw new AFBizException(String.format("processNumber%s,its data not in existence!", businessDataVo.getProcessNumber()));
        }
        businessDataVo.setBusinessId(bpmBusinessProcess.getBusinessId());
        businessDataVo = this.formFactory.getFormAdaptor(businessDataVo).queryData(businessDataVo);
        businessDataVo.setBusinessId(bpmBusinessProcess.getBusinessId());
        businessDataVo.setProcessRecordInfo(this.businessContans.processInfo(bpmBusinessProcess));
        businessDataVo.setProcessKey(bpmBusinessProcess.getBusinessNumber());
        businessDataVo.setProcessState(Boolean.valueOf(!bpmBusinessProcess.getProcessState().equals(ProcessStateEnum.END_STATE.getCode()) && !bpmBusinessProcess.getProcessState().equals(ProcessStateEnum.REJECT_STATE.getCode())));
        boolean flag = businessDataVo.getProcessRecordInfo().getStartUserId().equals(SecurityUtils.getLogInEmpIdStr());
        boolean isJurisdiction = false;
        businessDataVo.getProcessRecordInfo().setPcButtons(this.configFlowButtonContans.getButtons(bpmBusinessProcess.getBusinessNumber(), businessDataVo.getProcessRecordInfo().getNodeId(), isJurisdiction, flag));
        String nodeId = businessDataVo.getProcessRecordInfo().getNodeId();
        Boolean nodeIsSignUp = this.variableSignUpBizService.checkNodeIsSignUp(businessDataVo.getProcessNumber(), nodeId);
        businessDataVo.setIsSignUpNode(nodeIsSignUp);
        if (nodeIsSignUp.booleanValue()) {
            this.addApproverButton(businessDataVo);
        }
    }

    private void addApproverButton(BusinessDataVo businessDataVo) {
        ProcessActionButtonVo addApproverButton = ProcessActionButtonVo.builder().buttonType(ProcessOperationEnum.BUTTON_TYPE_JP.getCode()).name(ProcessOperationEnum.BUTTON_TYPE_JP.getDesc()).build();
        Map pcButtons = businessDataVo.getProcessRecordInfo().getPcButtons();
        List pcProcButtons = (List)pcButtons.get(ButtonPageTypeEnum.AUDIT.getName());
        if (!pcProcButtons.stream().anyMatch(a -> ProcessOperationEnum.BUTTON_TYPE_JP.getCode().equals(a.getButtonType()))) {
            pcProcButtons.add(addApproverButton);
        }
        businessDataVo.getProcessRecordInfo().setPcButtons(pcButtons);
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{ProcessOperationEnum.BUTTON_TYPE_VIEW_BUSINESS_PROCESS});
        this.addSupportBusinessObjects(ProcessOperationEnum.getOutSideAccessmarker(), new Enum[]{ProcessOperationEnum.BUTTON_TYPE_VIEW_BUSINESS_PROCESS});
    }
}

