/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.common.mapper.BpmVariableMultiplayerMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmFlowrunEntrustService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AbstractAddOrRemoveFutureAssigneeSerivceImpl {
    @Autowired
    protected BpmVariableMultiplayerMapper bpmVariableMultiplayerMapper;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected BpmFlowrunEntrustService bpmFlowrunEntrustService;
    @Autowired
    protected BpmBusinessProcessService businessProcessService;

    protected void checkParam(BusinessDataVo vo) {
        String processNumber = vo.getProcessNumber();
        List userInfos = vo.getUserInfos();
        String nodeId = vo.getNodeId();
        if (StringUtils.isEmpty((CharSequence)processNumber)) {
            throw new AFBizException("\u6d41\u7a0b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)userInfos)) {
            throw new AFBizException("\u8981\u53d8\u66f4\u7684\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            throw new AFBizException("\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void modifyFutureAssigneesByProcessInstance(BpmBusinessProcess bpmBusinessProcess, String taskdefKey, List<BaseIdTranStruVo> userInfos, int action) {
        String processNumber;
        String varName;
        String procInstId = bpmBusinessProcess.getProcInstId();
        Object currentValue = this.runtimeService.getVariable(procInstId, varName = this.bpmVariableMultiplayerMapper.getVarNameByElementId(processNumber = bpmBusinessProcess.getBusinessNumber(), taskdefKey));
        if (!(currentValue instanceof List)) {
            throw new AFBizException("Variable " + varName + " is not a list.");
        }
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).taskDefinitionKey(taskdefKey)).list();
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            throw new AFBizException("\u6d41\u7a0b\u4efb\u52a1\u5df2\u751f\u6210,\u4e0d\u80fd\u4fee\u6539,\u8bf7\u4f7f\u7528\u53d8\u66f4\u5bf9\u5f53\u524d\u8282\u70b9\u8fdb\u884c\u64cd\u4f5c\u7684\u65b9\u6cd5\u4fee\u6539!");
        }
        ArrayList currentList = new ArrayList((List)currentValue);
        List assigneeIds = userInfos.stream().map(BaseIdTranStruVo::getId).collect(Collectors.toList());
        if (action == 1) {
            currentList.addAll(assigneeIds);
        } else if (action == 2) {
            currentList.removeAll(assigneeIds);
        } else {
            throw new AFBizException("action is not 1 or 2");
        }
        this.runtimeService.setVariable(procInstId, varName, currentList);
        Map variables = this.runtimeService.getVariables(procInstId);
        String varSize = taskdefKey + "size";
        if (variables.get(varSize) != null) {
            this.runtimeService.setVariable(procInstId, varSize, (Object)currentList.size());
        }
        for (BaseIdTranStruVo userInfo : userInfos) {
            String userId = userInfo.getId();
            String userName = userInfo.getName();
            if (StringUtils.isEmpty((CharSequence)userName)) continue;
            String adminName = action == 1 ? "\u7ba1\u7406\u5458\u52a0\u7b7e" : "\u7ba1\u7406\u5458\u51cf\u7b7e";
            this.bpmFlowrunEntrustService.addFlowrunEntrust(userId, userName, "0", adminName, taskdefKey, 1, procInstId, bpmBusinessProcess.getProcessinessKey());
        }
    }
}

