/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.alibaba.fastjson2.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.bean.BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.openoa.base.constant.enums.MessageSendTypeEnum;
import org.openoa.base.constant.enums.MsgNoticeTypeEnum;
import org.openoa.base.constant.enums.NoticeReplaceEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmProcessNotice;
import org.openoa.base.entity.BpmnConfNoticeTemplateDetail;
import org.openoa.base.entity.Employee;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.service.AfUserService;
import org.openoa.base.vo.ActivitiBpmMsgVo;
import org.openoa.base.vo.BpmProcessNodeOvertimeVo;
import org.openoa.base.vo.UserMsgBatchVo;
import org.openoa.base.vo.UserMsgVo;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnConfNoticeTemplateBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessNodeOvertimeService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessNoticeService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnConfNoticeTemplateDetailService;
import org.openoa.engine.utils.UserMsgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivitiBpmMsgTemplateServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ActivitiBpmMsgTemplateServiceImpl.class);
    @Autowired
    private AfUserService employeeService;
    @Autowired
    private BpmProcessNoticeService bpmProcessNoticeService;
    @Autowired
    private BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private BpmProcessNodeOvertimeService processNodeOvertimeService;
    @Autowired
    private BpmnConfNoticeTemplateBizService bpmnConfNoticeTemplateBizService;
    @Autowired
    private BpmnConfNoticeTemplateDetailService bpmnConfNoticeTemplateDetailService;
    @Value(value="${system.domain:test}")
    private String systemDomain;
    private static final String baseTitle = "\u5de5\u4f5c\u6d41\u901a\u77e5";
    private static final String baseSpace = "\u3002   ";
    private static final String DATETIME_PATTERN = "yyyy/MM/dd HH:mm:ss";
    private static final FastDateFormat SDF_DATETIME_PATTERN = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss");

    public void sendBpmCustomMsg(ActivitiBpmMsgVo activitiBpmMsgVo, String content) {
        this.doUserMsgSend(activitiBpmMsgVo, content);
    }

    @Async
    public void sendBpmApprovalMsg(ActivitiBpmMsgVo activitiBpmMsgVo) {
        if (activitiBpmMsgVo == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5de5\u4f5c\u6d41\u6d41\u8f6c\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)activitiBpmMsgVo.getProcessId(), JSON.toJSON((Object)activitiBpmMsgVo));
        }
        String content = this.getContent(activitiBpmMsgVo, MsgNoticeTypeEnum.PROCESS_FLOW.getCode());
        this.doUserMsgSend(activitiBpmMsgVo, content);
    }

    @Async
    public void sendBpmApprovalMsgBatch(List<ActivitiBpmMsgVo> activitiBpmMsgVos) {
        if (activitiBpmMsgVos == null) {
            return;
        }
        UserMsgUtils.sendMessageBatch(activitiBpmMsgVos.stream().filter(Objects::nonNull).map(o -> {
            if (log.isDebugEnabled()) {
                log.debug("\u5de5\u4f5c\u6d41\u6d41\u8f6c\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)o.getProcessId(), JSON.toJSON((Object)o));
            }
            String content = this.getContent((ActivitiBpmMsgVo)o, MsgNoticeTypeEnum.PROCESS_FLOW.getCode());
            return this.buildUserMsgBatchVo((ActivitiBpmMsgVo)o, content);
        }).collect(Collectors.toList()));
    }

    @Async
    public void sendBpmForwardedlMsg(ActivitiBpmMsgVo activitiBpmMsgVo) {
        if (activitiBpmMsgVo == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u6536\u5230\u8f6c\u53d1\u5de5\u4f5c\u6d41\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)activitiBpmMsgVo.getProcessId(), JSON.toJSON((Object)activitiBpmMsgVo));
        }
        String content = this.getContent(activitiBpmMsgVo, MsgNoticeTypeEnum.RECEIVE_FLOW_PROCESS.getCode());
        this.doUserMsgSend(activitiBpmMsgVo, content);
    }

    @Async
    public void sendBpmForwardedMsgBatch(List<ActivitiBpmMsgVo> activitiBpmMsgVos) {
        if (CollectionUtils.isEmpty(activitiBpmMsgVos)) {
            return;
        }
        UserMsgUtils.sendMessageBatch(activitiBpmMsgVos.stream().filter(Objects::nonNull).map(o -> {
            if (log.isDebugEnabled()) {
                log.debug("\u6536\u5230\u8f6c\u53d1\u5de5\u4f5c\u6d41\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)o.getProcessId(), JSON.toJSON((Object)o));
            }
            String content = this.getContent((ActivitiBpmMsgVo)o, MsgNoticeTypeEnum.RECEIVE_FLOW_PROCESS.getCode());
            return this.buildUserMsgBatchVo((ActivitiBpmMsgVo)o, content);
        }).collect(Collectors.toList()));
    }

    @Async
    public void sendBpmFinishMsg(ActivitiBpmMsgVo activitiBpmMsgVo) {
        if (activitiBpmMsgVo == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5de5\u4f5c\u6d41\u5b8c\u6210\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)activitiBpmMsgVo.getProcessId(), JSON.toJSON((Object)activitiBpmMsgVo));
        }
        String content = this.getContent(activitiBpmMsgVo, MsgNoticeTypeEnum.PROCESS_FINISH.getCode());
        this.doUserMsgSend(activitiBpmMsgVo, content);
    }

    @Async
    public void sendBpmFinishMsgBatch(List<ActivitiBpmMsgVo> activitiBpmMsgVos) {
        if (CollectionUtils.isEmpty(activitiBpmMsgVos)) {
            return;
        }
        UserMsgUtils.sendMessageBatch(activitiBpmMsgVos.stream().filter(Objects::nonNull).map(o -> {
            if (log.isDebugEnabled()) {
                log.debug("\u5de5\u4f5c\u6d41\u5b8c\u6210\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)o.getProcessId(), JSON.toJSON((Object)o));
            }
            String content = this.getContent((ActivitiBpmMsgVo)o, MsgNoticeTypeEnum.PROCESS_FINISH.getCode());
            return this.buildUserMsgBatchVo((ActivitiBpmMsgVo)o, content);
        }).collect(Collectors.toList()));
    }

    @Async
    public void sendBpmRejectMsg(ActivitiBpmMsgVo activitiBpmMsgVo) {
        if (activitiBpmMsgVo == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5de5\u4f5c\u6d41\u6d41\u7a0b\u5ba1\u6279\u4e0d\u901a\u8fc7\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)activitiBpmMsgVo.getProcessId(), JSON.toJSON((Object)activitiBpmMsgVo));
        }
        String content = this.getContent(activitiBpmMsgVo, MsgNoticeTypeEnum.PROCESS_REJECT.getCode());
        this.doUserMsgSend(activitiBpmMsgVo, content);
    }

    @Async
    public void sendBpmRejectMsgBatch(List<ActivitiBpmMsgVo> activitiBpmMsgVos) {
        if (CollectionUtils.isEmpty(activitiBpmMsgVos)) {
            return;
        }
        UserMsgUtils.sendMessageBatch(activitiBpmMsgVos.stream().filter(Objects::nonNull).map(o -> {
            if (log.isDebugEnabled()) {
                log.debug("\u5de5\u4f5c\u6d41\u6d41\u7a0b\u5ba1\u6279\u4e0d\u901a\u8fc7\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)o.getProcessId(), JSON.toJSON((Object)o));
            }
            String content = this.getContent((ActivitiBpmMsgVo)o, MsgNoticeTypeEnum.PROCESS_REJECT.getCode());
            return this.buildUserMsgBatchVo((ActivitiBpmMsgVo)o, content);
        }).collect(Collectors.toList()));
    }

    @Async
    public void sendBpmOverTimeMsg(ActivitiBpmMsgVo activitiBpmMsgVo) {
        if (activitiBpmMsgVo == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5de5\u4f5c\u6d41\u8d85\u65f6\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)activitiBpmMsgVo.getProcessId(), JSON.toJSON((Object)activitiBpmMsgVo));
        }
        String content = this.getContent(activitiBpmMsgVo, MsgNoticeTypeEnum.PROCESS_TIME_OUT.getCode());
        this.doUserMsgSend(activitiBpmMsgVo, content, 2);
    }

    @Async
    public void sendBpmOverTimeMsgBatch(List<ActivitiBpmMsgVo> activitiBpmMsgVos) {
        if (CollectionUtils.isEmpty(activitiBpmMsgVos)) {
            return;
        }
        UserMsgUtils.sendMessageBatch(activitiBpmMsgVos.stream().filter(Objects::nonNull).map(o -> {
            if (log.isDebugEnabled()) {
                log.debug("\u5de5\u4f5c\u6d41\u8d85\u65f6\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)o.getProcessId(), JSON.toJSON((Object)o));
            }
            String content = this.getContent((ActivitiBpmMsgVo)o, MsgNoticeTypeEnum.PROCESS_TIME_OUT.getCode());
            return this.buildUserMsgBatchVo((ActivitiBpmMsgVo)o, content, 2);
        }).collect(Collectors.toList()));
    }

    @Async
    public void sendBpmTerminationMsg(ActivitiBpmMsgVo activitiBpmMsgVo) {
        if (activitiBpmMsgVo == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5de5\u4f5c\u6d41\u88ab\u7ec8\u6b62\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)activitiBpmMsgVo.getProcessId(), JSON.toJSON((Object)activitiBpmMsgVo));
        }
        String content = this.getContent(activitiBpmMsgVo, MsgNoticeTypeEnum.PROCESS_STOP.getCode());
        this.doUserMsgSend(activitiBpmMsgVo, content);
    }

    @Async
    public void sendBpmTerminationMsgBatch(List<ActivitiBpmMsgVo> activitiBpmMsgVos) {
        if (CollectionUtils.isEmpty(activitiBpmMsgVos)) {
            return;
        }
        UserMsgUtils.sendMessageBatch(activitiBpmMsgVos.stream().filter(Objects::nonNull).map(o -> {
            if (log.isDebugEnabled()) {
                log.debug("\u5de5\u4f5c\u6d41\u88ab\u7ec8\u6b62\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)o.getProcessId(), JSON.toJSON((Object)o));
            }
            String content = this.getContent((ActivitiBpmMsgVo)o, MsgNoticeTypeEnum.PROCESS_STOP.getCode());
            return this.buildUserMsgBatchVo((ActivitiBpmMsgVo)o, content);
        }).collect(Collectors.toList()));
    }

    @Async
    public void sendBpmGenerationApprovalMsg(ActivitiBpmMsgVo activitiBpmMsgVo) {
        if (activitiBpmMsgVo == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5de5\u4f5c\u6d41\u4ee3\u5ba1\u6279\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)activitiBpmMsgVo.getProcessId(), JSON.toJSON((Object)activitiBpmMsgVo));
        }
        String content = this.getContent(activitiBpmMsgVo, MsgNoticeTypeEnum.PROCESS_WAIR_VERIFY.getCode());
        this.doUserMsgSend(activitiBpmMsgVo, content);
    }

    @Async
    public void sendBpmGenerationApprovalMsgBatch(List<ActivitiBpmMsgVo> activitiBpmMsgVos) {
        if (CollectionUtils.isEmpty(activitiBpmMsgVos)) {
            return;
        }
        UserMsgUtils.sendMessageBatch(activitiBpmMsgVos.stream().filter(Objects::nonNull).map(o -> {
            if (log.isDebugEnabled()) {
                log.debug("\u5de5\u4f5c\u6d41\u4ee3\u5ba1\u6279\u901a\u77e5\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)o.getProcessId(), JSON.toJSON((Object)o));
            }
            String content = this.getContent((ActivitiBpmMsgVo)o, MsgNoticeTypeEnum.PROCESS_WAIR_VERIFY.getCode());
            return this.buildUserMsgBatchVo((ActivitiBpmMsgVo)o, content);
        }).collect(Collectors.toList()));
    }

    @Async
    public void sendBpmChangePersonOrgiMsg(ActivitiBpmMsgVo activitiBpmMsgVo) {
        if (activitiBpmMsgVo == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5de5\u4f5c\u6d41\u53d8\u66f4\u5904\u7406\u4eba\u901a\u77e5(\u539f\u5ba1\u6279\u8282\u70b9\u5904\u7406\u4eba)\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)activitiBpmMsgVo.getProcessId(), JSON.toJSON((Object)activitiBpmMsgVo));
        }
        String content = this.getContent(activitiBpmMsgVo, MsgNoticeTypeEnum.PROCESS_CHANGE_OPERATOR.getCode());
        this.doUserMsgSend(activitiBpmMsgVo, content);
    }

    @Async
    public void sendBpmChangePersonNewMsg(ActivitiBpmMsgVo activitiBpmMsgVo) {
        if (activitiBpmMsgVo == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5de5\u4f5c\u6d41\u53d8\u66f4\u5904\u7406\u4eba\u901a\u77e5(\u73b0\u5ba1\u6279\u8282\u70b9\u5904\u7406\u4eba)\uff0c\u6d41\u7a0b\u7f16\u53f7{}\uff0c\u5165\u53c2{}", (Object)activitiBpmMsgVo.getProcessId(), JSON.toJSON((Object)activitiBpmMsgVo));
        }
        String content = this.getContent(activitiBpmMsgVo, MsgNoticeTypeEnum.PROCESS_CHANGE_NOW_OPERATOR.getCode());
        this.doUserMsgSend(activitiBpmMsgVo, content);
    }

    private UserMsgBatchVo buildUserMsgBatchVo(ActivitiBpmMsgVo o, String content) {
        content = StringUtils.join((Object[])new String[]{content, baseSpace, SDF_DATETIME_PATTERN.format(new Date())});
        return UserMsgBatchVo.builder().userMsgVo(this.bulidUserMsgVo(o, content)).messageSendTypeEnums((List)Lists.newArrayList((Object[])this.getMessageSendTypeEnums(o.getProcessId(), o.getFormCode(), 1))).build();
    }

    private UserMsgVo bulidUserMsgVo(ActivitiBpmMsgVo activitiBpmMsgVo, String content) {
        Employee employee = this.getEmployee(activitiBpmMsgVo.getUserId(), activitiBpmMsgVo);
        return UserMsgVo.builder().userId(activitiBpmMsgVo.getUserId()).email(employee.getEmail()).mobile(employee.getMobile()).title(baseTitle).content(content).emailUrl(activitiBpmMsgVo.getEmailUrl()).url(activitiBpmMsgVo.getUrl()).appPushUrl(activitiBpmMsgVo.getAppPushUrl()).taskId(activitiBpmMsgVo.getTaskId()).ssoSessionDomain(this.systemDomain).build();
    }

    private UserMsgBatchVo buildUserMsgBatchVo(ActivitiBpmMsgVo o, String content, Integer selectMack) {
        content = StringUtils.join((Object[])new String[]{content, baseSpace, SDF_DATETIME_PATTERN.format(new Date())});
        return UserMsgBatchVo.builder().userMsgVo(this.bulidUserMsgVo(o, content)).messageSendTypeEnums((List)Lists.newArrayList((Object[])this.getMessageSendTypeEnums(o.getProcessId(), o.getFormCode(), selectMack))).build();
    }

    private void doUserMsgSend(ActivitiBpmMsgVo activitiBpmMsgVo, String content) {
        content = StringUtils.join((Object[])new String[]{content, baseSpace, SDF_DATETIME_PATTERN.format(new Date())});
        UserMsgVo userMsgVo = this.bulidUserMsgVo(activitiBpmMsgVo, content);
        MessageSendTypeEnum[] messageSendTypeEnums = this.getMessageSendTypeEnums(activitiBpmMsgVo.getProcessId(), activitiBpmMsgVo.getFormCode(), 1);
        UserMsgUtils.sendMessages(userMsgVo, messageSendTypeEnums);
    }

    private void doUserMsgSend(ActivitiBpmMsgVo activitiBpmMsgVo, String content, Integer selectMack) {
        content = StringUtils.join((Object[])new String[]{content, baseSpace, SDF_DATETIME_PATTERN.format(new Date())});
        UserMsgVo userMsgVo = this.bulidUserMsgVo(activitiBpmMsgVo, content);
        MessageSendTypeEnum[] messageSendTypeEnums = this.getMessageSendTypeEnums(activitiBpmMsgVo.getProcessId(), activitiBpmMsgVo.getFormCode(), selectMack);
        UserMsgUtils.sendMessages(userMsgVo, messageSendTypeEnums);
    }

    private Employee getEmployee(String employeeId, ActivitiBpmMsgVo activitiBpmMsgVo) {
        Employee employee = this.employeeService.getEmployeeDetailById(employeeId);
        if (employee == null) {
            employee = new Employee();
            log.error("\u6d41\u7a0b\u6d88\u606f\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25\uff0c\u6d88\u606f\u5165\u53c2{}", JSON.toJSON((Object)activitiBpmMsgVo));
        }
        return employee;
    }

    private MessageSendTypeEnum[] getMessageSendTypeEnums(String processId, String formCode, Integer selectMack) {
        BpmBusinessProcess bpmBusinessProcess;
        List<BpmProcessNodeOvertimeVo> bpmProcessNodeOvertimeVos;
        if (selectMack == 1) {
            List<BpmProcessNotice> bpmProcessNotices = this.bpmProcessNoticeService.processNoticeList(formCode);
            if (!CollectionUtils.isEmpty(bpmProcessNotices)) {
                return (MessageSendTypeEnum[])bpmProcessNotices.stream().map(o -> MessageSendTypeEnum.getEnumByCode((Integer)o.getType())).toArray(MessageSendTypeEnum[]::new);
            }
        } else if (selectMack == 2 && !CollectionUtils.isEmpty(bpmProcessNodeOvertimeVos = this.processNodeOvertimeService.selectNoticeNodeName(Optional.ofNullable((bpmBusinessProcess = Optional.ofNullable(this.bpmBusinessProcessService.getBpmBusinessProcess(processId)).orElse(new BpmBusinessProcess())).getProcessinessKey()).orElse(processId)))) {
            return (MessageSendTypeEnum[])bpmProcessNodeOvertimeVos.stream().map(o -> MessageSendTypeEnum.getEnumByCode((Integer)o.getNoticeType())).toArray(MessageSendTypeEnum[]::new);
        }
        return new MessageSendTypeEnum[0];
    }

    public String getContent(ActivitiBpmMsgVo activitiBpmMsgVo, Integer msgNoticeType) {
        log.info("content\u6570\u636e\u8f6c\u6362,activitiBpmMsgVo:{},msgNoticeType:{}", (Object)JSON.toJSONString((Object)activitiBpmMsgVo), (Object)msgNoticeType);
        BpmnConfNoticeTemplateDetail bpmnConfNoticeTemplateDetail = null;
        if (!StringUtils.isBlank((CharSequence)activitiBpmMsgVo.getBpmnCode())) {
            bpmnConfNoticeTemplateDetail = this.bpmnConfNoticeTemplateBizService.getDetailByCodeAndType(activitiBpmMsgVo.getBpmnCode(), msgNoticeType);
        }
        String content = null;
        if (bpmnConfNoticeTemplateDetail == null) {
            log.info("\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a,bpmnCode:{}", (Object)activitiBpmMsgVo.getBpmnCode());
            content = MsgNoticeTypeEnum.getDefaultValueByCode((Integer)msgNoticeType);
        } else {
            content = bpmnConfNoticeTemplateDetail.getNoticeTemplateDetail();
        }
        String result = this.replaceTemplateDetail(activitiBpmMsgVo, content);
        log.info("\u8f6c\u6362\u540e\u6570\u636econtent:{}", (Object)result);
        return result;
    }

    public String replaceTemplateDetail(ActivitiBpmMsgVo activitiBpmMsgVo, String content) {
        ArrayList noticeReplaceEnums = Lists.newArrayList();
        for (NoticeReplaceEnum noticeReplaceEnum : NoticeReplaceEnum.values()) {
            if (!content.contains("{" + noticeReplaceEnum.getDesc() + "}")) continue;
            noticeReplaceEnums.add(noticeReplaceEnum);
        }
        if (!CollectionUtils.isEmpty((Collection)noticeReplaceEnums)) {
            Employee employee = null;
            if (noticeReplaceEnums.stream().anyMatch(NoticeReplaceEnum::getIsSelectEmpl)) {
                employee = this.employeeService.getEmployeeDetailById(activitiBpmMsgVo.getOtherUserId());
            }
            for (NoticeReplaceEnum noticeReplaceEnum : noticeReplaceEnums) {
                if (noticeReplaceEnum.getIsSelectEmpl().booleanValue()) {
                    String name = Optional.ofNullable(employee).orElse(new Employee()).getUsername();
                    content = content.replace("{" + noticeReplaceEnum.getDesc() + "}", name);
                    continue;
                }
                String property = Optional.ofNullable(BeanUtil.pojo.getProperty((Object)activitiBpmMsgVo, noticeReplaceEnum.getFilName())).orElse("").toString();
                content = content.replace("{" + noticeReplaceEnum.getDesc() + "}", property);
            }
        }
        return content;
    }
}

