/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.AdminPersonnelTypeEnum;
import org.openoa.base.constant.enums.SortTypeEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.BpmProcessAppApplication;
import org.openoa.base.entity.BpmProcessApplicationType;
import org.openoa.base.entity.BpmProcessCategory;
import org.openoa.base.entity.OutSideBpmBusinessParty;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.PageUtils;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.mapper.BpmProcessAppApplicationMapper;
import org.openoa.engine.bpmnconf.mapper.OutSideBpmBusinessPartyMapper;
import org.openoa.engine.bpmnconf.service.biz.OutSideBpmBaseServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmProcessApplicationTypeServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmProcessCategoryServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnConfServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmBusinessPartyServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.ApplicationBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.ApplicationService;
import org.openoa.engine.utils.AFWrappers;
import org.openoa.engine.vo.BpmProcessAppApplicationVo;
import org.openoa.engine.vo.BpmProcessApplicationTypeVo;
import org.openoa.engine.vo.BpmProcessCategoryVo;
import org.openoa.engine.vo.OutSideBpmBusinessPartyVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApplicationBizServiceImpl
implements ApplicationBizService {
    @Autowired
    private BpmProcessApplicationTypeServiceImpl bpmProcessApplicationTypeService;
    @Autowired
    private OutSideBpmBaseServiceImpl outSideBpmBaseService;
    @Autowired
    private AfUserService employeeService;
    @Autowired
    private BpmProcessCategoryServiceImpl processCategoryService;
    @Autowired
    private OutSideBpmBusinessPartyServiceImpl outSideBpmBusinessPartyService;
    @Autowired
    private BpmnConfServiceImpl bpmnConfService;

    @Override
    public void edit(BpmProcessAppApplicationVo vo) {
        List list;
        BpmProcessAppApplication application = new BpmProcessAppApplication();
        BeanUtils.copyProperties((Object)vo, (Object)application);
        if (!StringUtil.isEmpty((CharSequence)application.getRoute())) {
            application.setRoute(StringEscapeUtils.unescapeHtml4((String)application.getRoute()));
        }
        if (vo.getId() != null) {
            application.setCreateUserId(SecurityUtils.getLogInEmpIdSafe());
        }
        if (!CollectionUtils.isEmpty((Collection)(list = ((ApplicationService)this.getService()).list((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().ne(application.getId() != null, BpmProcessAppApplication::getId, (Object)application.getId())).eq(BpmProcessAppApplication::getTitle, (Object)application.getTitle()))))) {
            throw new AFBizException("\u8be5\u9009\u9879\u540d\u79f0\u5df2\u5b58\u5728");
        }
        List list1 = ((ApplicationService)this.getService()).list((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().ne(application.getId() != null, BpmProcessAppApplication::getId, (Object)application.getId())).eq(BpmProcessAppApplication::getProcessKey, (Object)application.getProcessKey()));
        if (!CollectionUtils.isEmpty((Collection)list1)) {
            throw new AFBizException("\u8be5\u9009\u9879\u540d\u79f0\u5df2\u5b58\u5728");
        }
        ((ApplicationService)this.getService()).saveOrUpdate(application);
        if (!CollectionUtils.isEmpty(vo.getProcessTypes())) {
            this.bpmProcessApplicationTypeService.editProcessApplicationType(BpmProcessApplicationTypeVo.builder().applicationId(application.getId().longValue()).processTypes(vo.getProcessTypes()).visbleState(!StringUtil.isEmpty((CharSequence)vo.getBusinessCode()) ? 0 : 1).build());
            if (vo.getId() != null && vo.getApplyType().equals(3)) {
                List sonIds = ((ApplicationService)this.getService()).list((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmProcessAppApplication::getIsSon, (Object)1)).eq(BpmProcessAppApplication::getParentId, (Object)vo.getId())).stream().map(BpmProcessAppApplication::getId).collect(Collectors.toList());
                for (Integer sonId : sonIds) {
                    List types = this.bpmProcessApplicationTypeService.list((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmProcessApplicationType::getApplicationId, (Object)sonId)).stream().map(BpmProcessApplicationType::getCategoryId).collect(Collectors.toList());
                    List<Long> pTypes = vo.getProcessTypes();
                    List<Long> newTypes = types.stream().filter(pTypes::contains).collect(Collectors.toList());
                    if (newTypes.size() >= types.size()) continue;
                    this.bpmProcessApplicationTypeService.editProcessApplicationType(BpmProcessApplicationTypeVo.builder().applicationId(sonId.longValue()).processTypes(newTypes).visbleState(!StringUtil.isEmpty((CharSequence)vo.getBusinessCode()) ? 0 : 1).build());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResultAndPage<BpmProcessAppApplicationVo> pageList(PageDto pageDto, BpmProcessAppApplicationVo vo) {
        if (vo.getIsBusiness().equals(1)) {
            List<OutSideBpmBusinessPartyVo> list = this.outSideBpmBaseService.getEmplBusinessPartys("", AdminPersonnelTypeEnum.ADMIN_PERSONNEL_TYPE_APPLICATION.getPermCode());
            if (CollectionUtils.isEmpty(list)) return new ResultAndPage(new ArrayList(), new PageDto());
            vo.setBusinessCodeList(list.stream().map(OutSideBpmBusinessPartyVo::getBusinessPartyMark).collect(Collectors.toList()));
        } else {
            if (!vo.getIsBusiness().equals(2)) return new ResultAndPage(new ArrayList(), new PageDto());
            vo.setBusinessCodeList(Lists.newArrayList());
        }
        LinkedHashMap<String, SortTypeEnum> orderFieldMap = new LinkedHashMap<String, SortTypeEnum>();
        orderFieldMap.put("id", SortTypeEnum.DESC);
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto, orderFieldMap);
        List<BpmProcessAppApplicationVo> list = ((BpmProcessAppApplicationMapper)this.getMapper()).newListPage(page, vo);
        if (CollectionUtils.isEmpty(list)) {
            return PageUtils.getResultAndPage((Page)page);
        }
        Map<Long, String> categoryMap = this.processCategoryService.list((Wrapper)new QueryWrapper()).stream().collect(Collectors.toMap(BpmProcessCategory::getId, v -> v.getProcessTypeName() + v.getEntrance(), (v1, v2) -> v1));
        List userIds = list.stream().filter(o -> o.getCreateUserId() != null).map(BpmProcessAppApplicationVo::getCreateUserId).collect(Collectors.toList());
        HashMap employeeMap = !CollectionUtils.isEmpty(userIds) ? this.employeeService.queryUserByIds(userIds).stream().collect(Collectors.toMap(BaseIdTranStruVo::getId, v -> v, (v1, v2) -> v1)) : Maps.newHashMap();
        for (BpmProcessAppApplicationVo o2 : list) {
            o2.setIsCanDel(true);
            if (this.bpmnConfService.count((Wrapper)AFWrappers.lambdaTenantQuery().eq((SFunction & Serializable)a -> a.getFormCode(), (Object)(o2.getBusinessCode() + "_" + o2.getProcessKey()))) > 0L) {
                o2.setIsCanDel(false);
            }
            OutSideBpmBusinessParty party = (OutSideBpmBusinessParty)Optional.ofNullable(((OutSideBpmBusinessPartyMapper)this.outSideBpmBusinessPartyService.getBaseMapper()).selectOne((Wrapper)AFWrappers.lambdaTenantQuery().eq(OutSideBpmBusinessParty::getBusinessPartyMark, (Object)o2.getBusinessCode()))).orElse(new OutSideBpmBusinessParty());
            o2.setBusinessName(party.getName());
            o2.setAccessType(party.getType());
            List<Long> processTypes = this.bpmProcessApplicationTypeService.list((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmProcessApplicationType::getApplicationId, (Object)o2.getId())).stream().map(BpmProcessApplicationType::getCategoryId).filter(type -> !type.equals(1L) && !type.equals(2L)).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(processTypes)) {
                o2.setProcessTypes(processTypes);
                o2.setProcessTypeNames(processTypes.stream().map(categoryMap::get).collect(Collectors.toList()));
            }
            if (o2.getApplyType() != null) {
                if (o2.getApplyType().equals(1)) {
                    o2.setApplyTypeName("\u6d41\u7a0b");
                    if (o2.getIsSon().equals(1)) {
                        o2.setApplyTypeName("\u5b50\u6d41\u7a0b");
                    }
                } else if (o2.getApplyType().equals(2)) {
                    o2.setApplyTypeName("\u5e94\u7528");
                    if (o2.getIsSon().equals(1)) {
                        o2.setApplyTypeName("\u5b50\u5e94\u7528");
                    }
                } else {
                    o2.setApplyTypeName("\u7236\u7ea7\u5e94\u7528");
                }
            }
            BaseIdTranStruVo employee = Optional.ofNullable(employeeMap.get(o2.getCreateUserId())).orElse(new BaseIdTranStruVo());
            o2.setCreateUserName(employee.getName());
            if (!StringUtils.isEmpty((CharSequence)o2.getLookUrl())) {
                o2.setLookUrl(StringEscapeUtils.unescapeHtml4((String)o2.getLookUrl()));
            }
            if (!StringUtils.isEmpty((CharSequence)o2.getSubmitUrl())) {
                o2.setSubmitUrl(StringEscapeUtils.unescapeHtml4((String)o2.getSubmitUrl()));
            }
            if (StringUtils.isEmpty((CharSequence)vo.getConditionUrl())) continue;
            o2.setConditionUrl(StringEscapeUtils.unescapeHtml4((String)o2.getConditionUrl()));
        }
        page.setRecords(list);
        return PageUtils.getResultAndPage((Page)page);
    }

    @Override
    public List<BpmProcessAppApplicationVo> getParentApplicationList(BpmProcessAppApplicationVo applicationVo) {
        List list = applicationVo != null && !StringUtil.isEmpty((CharSequence)applicationVo.getBusinessCode()) ? ((ApplicationService)this.getService()).list((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmProcessAppApplication::getBusinessCode, (Object)applicationVo.getBusinessCode())).eq(BpmProcessAppApplication::getApplyType, (Object)3)) : ((ApplicationService)this.getService()).list((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().isNull(BpmProcessAppApplication::getBusinessCode)).eq(BpmProcessAppApplication::getApplyType, (Object)3));
        Map<Long, String> categoryMap = this.processCategoryService.list((Wrapper)new QueryWrapper()).stream().collect(Collectors.toMap(BpmProcessCategory::getId, v -> v.getProcessTypeName() + v.getEntrance(), (v1, v2) -> v1));
        return list.stream().map(o -> {
            BpmProcessAppApplicationVo vo = new BpmProcessAppApplicationVo();
            List processTypes = this.bpmProcessApplicationTypeService.list((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmProcessApplicationType::getApplicationId, (Object)o.getId())).stream().map(BpmProcessApplicationType::getCategoryId).filter(type -> !type.equals(1L) && !type.equals(2L)).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(processTypes)) {
                vo.setProcessTypeList(processTypes.stream().map(type -> BpmProcessCategoryVo.builder().id((Long)type).name((String)categoryMap.get(type)).build()).collect(Collectors.toList()));
            }
            vo.setId(o.getId());
            vo.setTitle(o.getTitle());
            return vo;
        }).collect(Collectors.toList());
    }

    @Override
    public List<BpmProcessCategoryVo> getProcessTypeList(BpmProcessAppApplicationVo vo) {
        BpmProcessAppApplication application = (BpmProcessAppApplication)((ApplicationService)this.getService()).getById(vo.getId());
        if (application != null) {
            Map<Long, String> categoryMap = this.processCategoryService.list((Wrapper)new QueryWrapper()).stream().collect(Collectors.toMap(BpmProcessCategory::getId, v -> v.getProcessTypeName() + v.getEntrance(), (v1, v2) -> v1));
            List processTypes = this.bpmProcessApplicationTypeService.list((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmProcessApplicationType::getApplicationId, (Object)application.getId())).stream().map(BpmProcessApplicationType::getCategoryId).filter(type -> !type.equals(1L) && !type.equals(2L)).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(processTypes)) {
                return processTypes.stream().map(type -> BpmProcessCategoryVo.builder().id((Long)type).name((String)categoryMap.get(type)).build()).collect(Collectors.toList());
            }
        }
        return Lists.newArrayList();
    }
}

