/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openoa.base.constant.enums.ProcessEnum;
import org.openoa.base.constant.enums.ProcessStateEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.engine.bpmnconf.mapper.BpmBusinessProcessMapper;
import org.openoa.engine.utils.AFWrappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class BpmBusinessProcessServiceImpl
extends ServiceImpl<BpmBusinessProcessMapper, BpmBusinessProcess>
implements BpmBusinessProcessService {
    private static final Logger log = LoggerFactory.getLogger(BpmBusinessProcessServiceImpl.class);

    public BpmBusinessProcess findBpmBusinessProcess(String businessId, String businessNumber) {
        return ((BpmBusinessProcessMapper)this.getBaseMapper()).findBpmBusinessProcess(BpmBusinessProcess.builder().businessNumber(businessNumber).businessId(businessId).build());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void addBusinessProcess(BpmBusinessProcess businessProcess) {
        ((BpmBusinessProcessMapper)this.getBaseMapper()).insert(businessProcess);
    }

    public void addBusinessProcess(String businessId, String key, String entryId, String processNum, String bpmnCode, String description) {
        BpmBusinessProcess bpmBusinessProcess = new BpmBusinessProcess();
        bpmBusinessProcess.setVersion(bpmnCode);
        Date nowDate = new Date();
        bpmBusinessProcess.setCreateTime(nowDate);
        bpmBusinessProcess.setUpdateTime(nowDate);
        bpmBusinessProcess.setBusinessId(businessId);
        bpmBusinessProcess.setProcessinessKey(key);
        bpmBusinessProcess.setEntryId(entryId);
        bpmBusinessProcess.setDescription(description);
        bpmBusinessProcess.setBusinessNumber(processNum);
        bpmBusinessProcess.setProcessState(Integer.valueOf(ProcessEnum.COMLETE_STATE.getCode()));
        bpmBusinessProcess.setTenantId(MultiTenantUtil.getCurrentTenantId());
        ((BpmBusinessProcessMapper)this.getBaseMapper()).insert(bpmBusinessProcess);
    }

    public BpmBusinessProcess updateBusinessProcess(BpmBusinessProcess bpmBusinessProcess) {
        List bpmBusinessProcesses = ((BpmBusinessProcessMapper)this.getBaseMapper()).selectList((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmBusinessProcess::getBusinessNumber, (Object)bpmBusinessProcess.getBusinessNumber()));
        bpmBusinessProcesses.forEach(o -> {
            o.setProcessState(bpmBusinessProcess.getProcessState());
            if (!ObjectUtils.isEmpty((Object)bpmBusinessProcess)) {
                o.setDescription(bpmBusinessProcess.getDescription());
            }
            ((BpmBusinessProcessMapper)this.getBaseMapper()).updateById(o);
        });
        return (BpmBusinessProcess)bpmBusinessProcesses.get(0);
    }

    public BpmBusinessProcess getBpmBusinessProcess(String processCode) {
        BpmBusinessProcess bpmBusinessProcess = (BpmBusinessProcess)this.getOne((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmBusinessProcess::getBusinessNumber, (Object)processCode));
        return bpmBusinessProcess;
    }

    public BpmBusinessProcess getBpmBusinessProcess(BpmBusinessProcess bpmBusinessProcess) {
        return ((BpmBusinessProcessMapper)this.getBaseMapper()).findBpmBusinessProcess(bpmBusinessProcess);
    }

    public boolean updateBpmBusinessProcess(String procInstId) {
        ((BpmBusinessProcessMapper)this.getBaseMapper()).selectList((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmBusinessProcess::getProcInstId, (Object)procInstId)).forEach(o -> {
            o.setProcessState(Integer.valueOf(ProcessStateEnum.END_STATE.getCode()));
            ((BpmBusinessProcessMapper)this.getBaseMapper()).updateById(o);
        });
        return true;
    }

    public List<BpmBusinessProcess> listBpmBusinessProcess(List<String> processNumbers) {
        List<Object> result = new ArrayList<BpmBusinessProcess>();
        if (ObjectUtils.isEmpty(processNumbers)) {
            return result;
        }
        result = ((BpmBusinessProcessMapper)this.getBaseMapper()).selectList((Wrapper)AFWrappers.lambdaTenantQuery().select(new SFunction[]{BpmBusinessProcess::getBusinessNumber, BpmBusinessProcess::getDescription}).in(BpmBusinessProcess::getBusinessNumber, processNumbers));
        return result;
    }

    public boolean checkData(String processNumber) {
        long number = ((BpmBusinessProcessMapper)this.getBaseMapper()).selectCount((Wrapper)Wrappers.lambdaQuery().eq(BpmBusinessProcess::getBusinessNumber, (Object)processNumber));
        return number <= 0L;
    }

    public boolean checkProcessData(String entryId) {
        long number = ((BpmBusinessProcessMapper)this.getBaseMapper()).selectCount((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmBusinessProcess::getEntryId, (Object)entryId));
        return number <= 0L;
    }

    public void updateProcessIsDel(String processNumber) {
        BpmBusinessProcess bpmBusinessProcess = (BpmBusinessProcess)((BpmBusinessProcessMapper)this.getBaseMapper()).selectOne((Wrapper)Wrappers.lambdaQuery().eq(BpmBusinessProcess::getBusinessNumber, (Object)processNumber));
        bpmBusinessProcess.setIsDel(Integer.valueOf(1));
        this.updateById(bpmBusinessProcess);
    }
}

