/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openoa.base.constant.enums.AppApplicationType;
import org.openoa.base.constant.enums.ApplyType;
import org.openoa.base.constant.enums.ProcessJurisdictionEnum;
import org.openoa.base.constant.enums.SortTypeEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmProcessAppApplication;
import org.openoa.base.entity.BpmProcessAppData;
import org.openoa.base.entity.BpmProcessCategory;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.entity.SysVersion;
import org.openoa.base.util.PageUtils;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.common.ProcessBusinessContans;
import org.openoa.engine.bpmnconf.mapper.BpmProcessAppApplicationMapper;
import org.openoa.engine.bpmnconf.mapper.BpmnConfMapper;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessDeptBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessPermissionsBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnConfBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessAppApplicationBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessAppDataService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessApplicationTypeService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessCategoryService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessDeptService;
import org.openoa.engine.bpmnconf.service.interf.repository.QuickEntryService;
import org.openoa.engine.bpmnconf.service.interf.repository.SysVersionService;
import org.openoa.engine.vo.BpmProcessAppApplicationVo;
import org.openoa.engine.vo.BpmProcessCategoryVo;
import org.openoa.engine.vo.GenericEmployee;
import org.openoa.engine.vo.IconInforVo;
import org.openoa.engine.vo.ProcessTypeInforVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BpmProcessAppApplicationBizServiceImpl
implements BpmProcessAppApplicationBizService {
    @Autowired
    @Lazy
    private BpmProcessAppDataService processAppDataService;
    @Autowired
    private BpmProcessPermissionsBizService processPermissionsBizService;
    @Autowired
    @Lazy
    private SysVersionService sysVersionService;
    @Autowired
    private BpmProcessApplicationTypeService bpmProcessApplicationTypeService;
    @Autowired
    private BpmProcessCategoryService bpmProcessCategoryService;
    @Autowired
    @Lazy
    private QuickEntryService quickEntryService;
    @Autowired
    private BpmProcessDeptBizService processDeptBizService;
    @Autowired
    private BpmnConfBizService bpmnConfBizService;
    @Autowired
    private ProcessBusinessContans processBusinessContans;
    public static final Integer appCommonId = 2;
    public static final Integer pcCommonId = 1;

    @Override
    public List<String> getAppEntrance(String version) {
        SysVersion sysVersion = this.sysVersionService.getInfoByVersion(version);
        if (sysVersion != null) {
            List<BpmProcessAppData> appDataList = this.processAppDataService.getProcessAppData(sysVersion.getId(), 0, AppApplicationType.TWO_TYPE.getCode());
            return appDataList.stream().map(o -> o.getProcessKey()).collect(Collectors.toList());
        }
        return Arrays.asList(new String[0]);
    }

    @Override
    public Page<BpmProcessAppApplicationVo> getPcProcessData(Page<BpmProcessAppApplicationVo> page) {
        return page.setRecords(page.getRecords().stream().map(o -> {
            if (!StringUtil.isEmpty((CharSequence)o.getEntrance())) {
                o.setName(o.getTitle() + "," + o.getEntrance());
            } else {
                o.setName(o.getTitle());
            }
            if (!StringUtil.isEmpty((CharSequence)o.getTypeIds())) {
                String[] split = o.getTypeIds().split(",");
                ArrayList<Long> list = new ArrayList<Long>();
                if (split.length > 1) {
                    for (String typeId : split) {
                        List<String> stringList = Arrays.asList(appCommonId.toString(), pcCommonId.toString());
                        if (stringList.contains(typeId)) continue;
                        list.add(Long.parseLong(typeId));
                    }
                    o.setProcessTypes(list);
                } else {
                    list.add(Long.parseLong(o.getTypeIds()));
                }
                o.setProcessTypes(list);
            }
            o.setApplyTypeName(ApplyType.getDescByCode((Integer)o.getApplyType()));
            return o;
        }).collect(Collectors.toList()));
    }

    @Override
    public List<ProcessTypeInforVo> processApplicationList() {
        List bpmProcessCategories = this.bpmProcessCategoryService.getBaseMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_app", (Object)1)).eq((Object)"is_del", (Object)0)).ne((Object)"id", (Object)appCommonId));
        bpmProcessCategories.sort((bpmProcessAppApplication, appApplication) -> bpmProcessAppApplication.getSort().compareTo(appApplication.getSort()));
        ArrayList<ProcessTypeInforVo> list = new ArrayList<ProcessTypeInforVo>();
        for (BpmProcessCategory processCategory : bpmProcessCategories) {
            ProcessTypeInforVo processTypeInforVo = new ProcessTypeInforVo();
            processTypeInforVo.setProcessTypeName(processCategory.getProcessTypeName());
            processTypeInforVo.setApplicationList(((BpmProcessAppApplicationMapper)this.getMapper()).listProcessIcon(BpmProcessAppApplicationVo.builder().id(processCategory.getId().intValue()).build()));
            list.add(processTypeInforVo);
        }
        return list;
    }

    @Override
    public IconInforVo iconConfig(Integer isApp, Integer parentId, Integer processCategoryId) {
        if (parentId != null && processCategoryId != null) {
            BpmProcessCategory processCategory = (BpmProcessCategory)this.bpmProcessCategoryService.getBaseMapper().selectById((Serializable)processCategoryId);
            IconInforVo iconInforVo = new IconInforVo();
            ProcessTypeInforVo typeInforVo = new ProcessTypeInforVo();
            List<BpmProcessAppApplicationVo> vos = ((BpmProcessAppApplicationMapper)this.getMapper()).listIcon(BpmProcessAppApplicationVo.builder().id(processCategoryId).isSon(1).parentId(parentId).build());
            typeInforVo.setIconList(this.bpmProcessAppApplicationVoList(vos));
            typeInforVo.setTypeId(processCategory.getId().intValue());
            typeInforVo.setProcessTypeName(processCategory.getProcessTypeName());
            iconInforVo.setSonApplicationList(typeInforVo);
            return iconInforVo;
        }
        Integer isPc = 1;
        Integer id = appCommonId;
        if (isApp.equals(0)) {
            isPc = 0;
            id = pcCommonId;
        }
        IconInforVo iconInforVo = new IconInforVo();
        List<BpmProcessCategory> bpmProcessCategoryList = this.bpmProcessCategoryService.processCategoryList(BpmProcessCategoryVo.builder().isApp(isPc).build());
        ProcessTypeInforVo typeInforVo = new ProcessTypeInforVo();
        BpmProcessCategory processCategory = this.bpmProcessCategoryService.getProcessCategory(id.longValue());
        if (processCategory != null) {
            List<BpmProcessAppApplicationVo> vos = ((BpmProcessAppApplicationMapper)this.getMapper()).listIcon(BpmProcessAppApplicationVo.builder().id(processCategory.getId().intValue()).build());
            typeInforVo.setIconList(this.bpmProcessAppApplicationVoList(vos));
            typeInforVo.setTypeId(processCategory.getId().intValue());
            typeInforVo.setProcessTypeName(processCategory.getProcessTypeName());
        }
        iconInforVo.setCommonFunction(typeInforVo);
        ArrayList<ProcessTypeInforVo> typeInforVoList = new ArrayList<ProcessTypeInforVo>();
        for (BpmProcessCategory bpmProcessCategory : bpmProcessCategoryList) {
            ProcessTypeInforVo processTypeInforVo = new ProcessTypeInforVo();
            if (bpmProcessCategory.getId().equals(id.longValue())) continue;
            List<BpmProcessAppApplicationVo> vos = ((BpmProcessAppApplicationMapper)this.getMapper()).listIcon(BpmProcessAppApplicationVo.builder().id(bpmProcessCategory.getId().intValue()).isSon(0).build());
            processTypeInforVo.setIconList(this.bpmProcessAppApplicationVoList(vos));
            processTypeInforVo.setTypeId(bpmProcessCategory.getId().intValue());
            processTypeInforVo.setProcessTypeName(bpmProcessCategory.getProcessTypeName());
            typeInforVoList.add(processTypeInforVo);
        }
        iconInforVo.setApplicationList(typeInforVoList);
        return iconInforVo;
    }

    @Override
    public List<ProcessTypeInforVo> homePageIcon(BpmProcessAppApplicationVo vo) {
        ArrayList<ProcessTypeInforVo> typeInforVoList = new ArrayList<ProcessTypeInforVo>();
        List<String> collect = this.processDeptBizService.findProcessKey();
        collect.addAll(this.permissionsProcessKeys());
        if (vo != null && vo.getParentId() != null) {
            if (vo.getProcessCategoryId() != null) {
                BpmProcessAppApplication application = (BpmProcessAppApplication)((BpmProcessAppApplicationMapper)this.getMapper()).selectById(vo.getParentId());
                ProcessTypeInforVo processTypeInforVo = new ProcessTypeInforVo();
                List<BpmProcessAppApplicationVo> vos = ((BpmProcessAppApplicationMapper)this.getMapper()).listIcon(BpmProcessAppApplicationVo.builder().processKeyList(collect).visbleState(1).isSon(1).parentId(vo.getParentId()).id(vo.getProcessCategoryId()).build());
                processTypeInforVo.setIconList(this.bpmProcessAppApplicationVoList(vos));
                processTypeInforVo.setTypeId(application.getId());
                processTypeInforVo.setProcessTypeName(application.getTitle());
                typeInforVoList.add(processTypeInforVo);
                return typeInforVoList;
            }
            BpmProcessAppApplication application = (BpmProcessAppApplication)((BpmProcessAppApplicationMapper)this.getMapper()).selectById(vo.getParentId());
            ProcessTypeInforVo processTypeInforVo = new ProcessTypeInforVo();
            List<BpmProcessAppApplicationVo> vos = ((BpmProcessAppApplicationMapper)this.getMapper()).listIcon(BpmProcessAppApplicationVo.builder().processKeyList(collect).visbleState(1).isSon(1).parentId(vo.getParentId()).build());
            Map<Integer, BpmProcessAppApplicationVo> map = vos.stream().collect(Collectors.toMap(BpmProcessAppApplicationVo::getApplicationId, v -> v, (v1, v2) -> v1));
            vos = new ArrayList<BpmProcessAppApplicationVo>(map.values());
            processTypeInforVo.setIconList(this.bpmProcessAppApplicationVoList(vos));
            processTypeInforVo.setTypeId(application.getId());
            processTypeInforVo.setProcessTypeName(application.getTitle());
            typeInforVoList.add(processTypeInforVo);
            return typeInforVoList;
        }
        List<BpmProcessCategory> bpmProcessCategoryList = this.bpmProcessCategoryService.processCategoryList(BpmProcessCategoryVo.builder().isApp(0).build());
        for (BpmProcessCategory bpmProcessCategory : bpmProcessCategoryList) {
            List<Integer> list;
            List<BpmProcessAppApplicationVo> vos;
            ProcessTypeInforVo processTypeInforVo = new ProcessTypeInforVo();
            if (bpmProcessCategory.getId() == 1L) {
                vos = ((BpmProcessAppApplicationMapper)this.getMapper()).listIcon(BpmProcessAppApplicationVo.builder().processKeyList(collect).visbleState(1).id(bpmProcessCategory.getId().intValue()).build());
                list = vos.stream().filter(o -> o.getIsSon().equals(1)).map(BpmProcessAppApplicationVo::getParentId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(list)) {
                    vos.addAll(((BpmProcessAppApplicationMapper)this.getMapper()).listIcon(BpmProcessAppApplicationVo.builder().visbleState(1).id(bpmProcessCategory.getId().intValue()).ids(list).build()));
                }
            } else {
                vos = ((BpmProcessAppApplicationMapper)this.getMapper()).listIcon(BpmProcessAppApplicationVo.builder().processKeyList(collect).visbleState(1).id(bpmProcessCategory.getId().intValue()).build());
                list = vos.stream().filter(o -> o.getIsSon().equals(1)).map(BpmProcessAppApplicationVo::getParentId).collect(Collectors.toList());
                vos = vos.stream().filter(o -> o.getIsSon().equals(0)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(list)) {
                    vos.addAll(((BpmProcessAppApplicationMapper)this.getMapper()).listIcon(BpmProcessAppApplicationVo.builder().visbleState(1).id(bpmProcessCategory.getId().intValue()).ids(list).build()));
                }
            }
            processTypeInforVo.setIconList(this.bpmProcessAppApplicationVoList(vos));
            processTypeInforVo.setTypeId(bpmProcessCategory.getId().intValue());
            processTypeInforVo.setProcessTypeName(bpmProcessCategory.getProcessTypeName());
            typeInforVoList.add(processTypeInforVo);
        }
        return typeInforVoList;
    }

    @Override
    public List<BpmProcessAppApplicationVo> bpmProcessAppApplicationVoList(List<BpmProcessAppApplicationVo> list) {
        List keys = list.stream().map(BpmProcessAppApplicationVo::getProcessKey).collect(Collectors.toList());
        Map<String, BpmnConf> map = ((BpmnConfMapper)this.bpmnConfBizService.getMapper()).selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"form_code", keys)).eq((Object)"effective_status", (Object)1)).stream().collect(Collectors.toMap(BpmnConf::getFormCode, o -> o, (a, b) -> a));
        return list.stream().peek(o -> {
            if (!StringUtil.isEmpty((CharSequence)o.getProcessKey())) {
                o.setSource(o.getEffectiveSource());
                if (!StringUtil.isEmpty((CharSequence)o.getBusinessCode())) {
                    o.setProcessCode(o.getBusinessCode() + "_" + o.getProcessKey());
                    o.setProcessKey(o.getProcessCode());
                } else {
                    BpmnConf bpmnConfByCode = (BpmnConf)map.get(o.getProcessKey());
                    if (bpmnConfByCode != null && bpmnConfByCode.getId() != null) {
                        o.setProcessCode(bpmnConfByCode.getFormCode());
                    } else {
                        o.setProcessCode(o.getProcessKey().split("\\_")[0].toString());
                    }
                    o.setAppVersion(BpmBusinessProcess.VERSION_DEFAULT_0);
                }
            }
        }).collect(Collectors.toList());
    }

    @Override
    public ProcessTypeInforVo iconCommon() {
        BpmProcessCategory processCategory = (BpmProcessCategory)this.bpmProcessCategoryService.getBaseMapper().selectById((Serializable)appCommonId);
        if (processCategory != null) {
            List<BpmProcessAppApplicationVo> vos = ((BpmProcessAppApplicationMapper)this.getMapper()).listIcon(BpmProcessAppApplicationVo.builder().id(appCommonId).visbleState(1).build());
            return ProcessTypeInforVo.builder().applicationList(vos).processTypeName(processCategory.getProcessTypeName()).build();
        }
        return null;
    }

    @Override
    public ResultAndPage<BpmProcessAppApplicationVo> applicationsNewList(PageDto pageDto, BpmProcessAppApplicationVo vo) {
        LinkedHashMap<String, SortTypeEnum> orderFieldMap = new LinkedHashMap<String, SortTypeEnum>();
        orderFieldMap.put("id", SortTypeEnum.DESC);
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto, orderFieldMap);
        page.setRecords(((BpmProcessAppApplicationMapper)this.getMapper()).newListPage(page, vo));
        this.getPcProcessData((Page<BpmProcessAppApplicationVo>)page);
        return PageUtils.getResultAndPage((Page)page);
    }

    @Override
    public ResultAndPage<BpmProcessAppApplicationVo> applicationsList(PageDto pageDto, BpmProcessAppApplicationVo vo) {
        LinkedHashMap<String, SortTypeEnum> orderFieldMap = new LinkedHashMap<String, SortTypeEnum>();
        orderFieldMap.put("id", SortTypeEnum.DESC);
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto, orderFieldMap);
        page.setRecords(((BpmProcessAppApplicationMapper)this.getMapper()).listPage(page, vo));
        this.getPcProcessData((Page<BpmProcessAppApplicationVo>)page);
        return PageUtils.getResultAndPage((Page)page);
    }

    private List<String> permissionsProcessKeys() {
        ArrayList<String> processKey = new ArrayList<String>();
        List appApplications = ((BpmProcessAppApplicationMapper)this.getMapper()).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_del", (Object)0)).eq((Object)"apply_type", (Object)2));
        if (!CollectionUtils.isEmpty((Collection)appApplications)) {
            for (BpmProcessAppApplication appApplication : appApplications) {
                if (!StringUtil.isEmpty((CharSequence)appApplication.getPermissionsCode())) continue;
                processKey.add(appApplication.getProcessKey());
            }
        }
        return processKey;
    }

    private List<String> findBpmProcessAppApplication(String version) {
        GenericEmployee genericEmployee = new GenericEmployee();
        genericEmployee.setUserId(SecurityUtils.getLogInEmpIdSafe());
        genericEmployee.setUsername(SecurityUtils.getLogInEmpNameSafe());
        SysVersion sysVersion = this.sysVersionService.getInfoByVersion(version);
        if (sysVersion == null) {
            return Arrays.asList(new String[0]);
        }
        List<String> allProcess = ((BpmProcessDeptService)this.processDeptBizService.getService()).getAllProcess();
        List<BpmnConf> allConfList = Optional.ofNullable(this.bpmnConfBizService.getIsAllConfs()).orElse(Arrays.asList(new BpmnConf[0]));
        List collect = allConfList.stream().map(BpmnConf::getFormCode).collect(Collectors.toList());
        allProcess.addAll(collect);
        List<String> processKeyList = this.processPermissionsBizService.getProcessKey(genericEmployee.getUserId(), ProcessJurisdictionEnum.CREATE_TYPE.getCode());
        if (!CollectionUtils.isEmpty(processKeyList)) {
            allProcess.addAll(processKeyList);
        }
        List<String> allAppData = this.processAppDataService.getBpmProcessAppDataVo(sysVersion.getId(), allProcess);
        allAppData.addAll(((BpmProcessAppApplicationMapper)this.getMapper()).findProcessAppApplication().stream().map(BpmProcessAppApplication::getProcessKey).collect(Collectors.toList()));
        allAppData.addAll(this.permissionsProcessKeys());
        return allAppData;
    }

    private List<BpmProcessAppApplicationVo> processAppDate(List<BpmProcessAppApplicationVo> list) {
        return list.stream().map(o -> {
            o.setSource(o.getEffectiveSource());
            BpmnConf bpmnConfByCode = this.bpmnConfBizService.getBpmnConfByFormCode(o.getProcessKey());
            if (bpmnConfByCode != null && bpmnConfByCode.getId() != null) {
                boolean isOutSide = false;
                if (bpmnConfByCode.getIsOutSideProcess() != null && bpmnConfByCode.getIsOutSideProcess() == 1) {
                    isOutSide = true;
                }
                o.setRoute(this.processBusinessContans.applyRoute(bpmnConfByCode.getBpmnCode(), bpmnConfByCode.getFormCode(), isOutSide));
            } else if (o.getRoute() != null) {
                String route = StringEscapeUtils.unescapeJson((String)o.getRoute());
                try {
                    o.setRoute(URLEncoder.encode(route, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return o;
        }).collect(Collectors.toList());
    }
}

