/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.AppApplicationType;
import org.openoa.base.entity.BpmProcessAppApplication;
import org.openoa.base.entity.BpmProcessAppData;
import org.openoa.base.entity.QuickEntry;
import org.openoa.base.entity.SysVersion;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessAppDataBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessAppApplicationService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessAppDataService;
import org.openoa.engine.bpmnconf.service.interf.repository.QuickEntryService;
import org.openoa.engine.bpmnconf.service.interf.repository.SysVersionService;
import org.openoa.engine.vo.SysVersionVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BpmProcessAppDataBizServiceImpl
implements BpmProcessAppDataBizService {
    @Autowired
    @Lazy
    private SysVersionService sysVersionService;
    @Autowired
    private BpmProcessAppApplicationService bpmProcessAppApplicationService;
    @Autowired
    @Lazy
    private QuickEntryService quickEntryService;

    @Override
    public SysVersionVo findMaxAppData() {
        List sysVersions = this.sysVersionService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_del", (Object)0)).orderByAsc((Object)"id"));
        SysVersionVo vo = new SysVersionVo();
        if (!CollectionUtils.isEmpty((Collection)sysVersions)) {
            SysVersion sysVersion = (SysVersion)sysVersions.get(0);
            List<BpmProcessAppData> processAppData = ((BpmProcessAppDataService)this.getService()).getProcessAppData(sysVersion.getId(), 0, AppApplicationType.TWO_TYPE.getCode());
            ArrayList<BaseIdTranStruVo> voList = new ArrayList<BaseIdTranStruVo>();
            voList.addAll(processAppData.stream().map(o -> BaseIdTranStruVo.builder().id(o.getApplicationId().toString()).name(o.getProcessName()).build()).collect(Collectors.toList()));
            List<BpmProcessAppData> appDataList = ((BpmProcessAppDataService)this.getService()).getProcessAppData(sysVersion.getId(), 0, AppApplicationType.ONE_TYPE.getCode());
            ArrayList<BaseIdTranStruVo> list = new ArrayList<BaseIdTranStruVo>();
            list.addAll(appDataList.stream().map(o -> BaseIdTranStruVo.builder().id(o.getApplicationId().toString()).name(o.getProcessName()).build()).collect(Collectors.toList()));
            vo.setApplication(list);
            vo.setData(voList);
            vo.setDownloadCode(sysVersion.getDownloadCode());
            return vo;
        }
        return vo;
    }

    @Override
    public List<BaseIdTranStruVo> findAppDataByVersionId(Long versionId, Integer type) {
        if (versionId != null) {
            List<BpmProcessAppData> processAppData = ((BpmProcessAppDataService)this.getService()).getProcessAppData(versionId, 0, type);
            ArrayList<BaseIdTranStruVo> voList = new ArrayList<BaseIdTranStruVo>();
            voList.addAll(processAppData.stream().map(o -> BaseIdTranStruVo.builder().id(o.getApplicationId().toString()).name(o.getProcessName()).build()).collect(Collectors.toList()));
            return voList;
        }
        return Arrays.asList(new BaseIdTranStruVo[0]);
    }

    @Override
    public void addAppVersionData(List<Long> applicationIds, Long versionId, Integer type) {
        ((BpmProcessAppDataService)this.getService()).deleteAppVersionData(versionId, type);
        ((BpmProcessAppDataService)this.getService()).saveBatch(applicationIds.stream().map(o -> {
            BpmProcessAppApplication bpmProcessAppApplication = (BpmProcessAppApplication)this.bpmProcessAppApplicationService.getById((Serializable)o);
            if (bpmProcessAppApplication != null) {
                return BpmProcessAppData.builder().processName(bpmProcessAppApplication.getTitle()).processKey(this.getProcessKey((Long)o)).versionId(versionId).type(type).applicationId(o).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private String getProcessKey(Long id) {
        BpmProcessAppApplication bpmProcessAppApplication = (BpmProcessAppApplication)this.bpmProcessAppApplicationService.getById(id);
        if (bpmProcessAppApplication == null) {
            return "";
        }
        if (!StringUtil.isEmpty((CharSequence)bpmProcessAppApplication.getBusinessCode())) {
            return StringUtils.join((Object[])new String[]{bpmProcessAppApplication.getBusinessCode(), "_", bpmProcessAppApplication.getProcessKey()});
        }
        return bpmProcessAppApplication.getProcessKey();
    }

    @Override
    public void addVersionData(List<Long> applicationIds, Long versionId, Integer type) {
        ((BpmProcessAppDataService)this.getService()).deleteAppVersionData(versionId, type);
        ((BpmProcessAppDataService)this.getService()).saveBatch(applicationIds.stream().map(o -> BpmProcessAppData.builder().versionId(versionId).type(type).applicationId(o).processName(((QuickEntry)Optional.ofNullable(this.quickEntryService.getById((Serializable)o)).orElse(new QuickEntry())).getTitle()).build()).collect(Collectors.toList()));
    }
}

