/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.ProcessJurisdictionEnum;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmProcessDeptVo;
import org.openoa.engine.bpmnconf.service.impl.BpmProcessNoticeServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessDeptBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessNameBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessPermissionsBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnConfBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class BpmProcessDeptBizServiceImpl
implements BpmProcessDeptBizService {
    @Autowired
    private BpmProcessNoticeServiceImpl processNoticeService;
    @Autowired
    @Lazy
    private BpmnConfBizService confCommonService;
    @Autowired
    private BpmProcessNameBizService bpmProcessNameBizService;
    @Autowired
    private BpmProcessPermissionsBizService processPermissionsBizService;

    @Override
    public void editRelevance(BpmnConf bpmnConf) {
        this.bpmProcessNameBizService.editProcessName(bpmnConf);
    }

    @Override
    public List<String> findProcessKey() {
        List<String> processKeyList = Optional.ofNullable(this.processPermissionsBizService.getProcessKey(SecurityUtils.getLogInEmpIdSafe(), ProcessJurisdictionEnum.CREATE_TYPE.getCode())).orElse(Arrays.asList(new String[0]));
        List<BpmnConf> confList = Optional.ofNullable(this.confCommonService.getIsAllConfs()).orElse(Arrays.asList(new BpmnConf[0]));
        List collect = confList.stream().map(BpmnConf::getFormCode).collect(Collectors.toList());
        List<String> processList = Optional.ofNullable(((BpmProcessDeptService)this.getService()).getAllProcess()).orElse(Arrays.asList(new String[0]));
        processList.addAll(processKeyList);
        processList.addAll(collect);
        return processList;
    }

    @Override
    public void editProcessConf(BpmProcessDeptVo vo) throws AFBizException {
        this.processNoticeService.saveProcessNotice(vo);
    }
}

