/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.entity.BpmProcessForward;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.util.SecurityUtils;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessForwardBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessForwardService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class BpmProcessForwardBizServiceImpl
implements BpmProcessForwardBizService {
    private static Map<String, BpmProcessForward> processForwardMap = new ConcurrentHashMap<String, BpmProcessForward>();
    private static Map<String, Task> taskMap = new ConcurrentHashMap<String, Task>();
    @Autowired
    private TaskService taskService;
    @Autowired
    private BpmnEmployeeInfoProviderService employeeInfoProviderService;

    @Override
    public void loadProcessForward(String userId) {
        HashMap<String, BpmProcessForward> map = new HashMap<String, BpmProcessForward>();
        List<BpmProcessForward> list = ((BpmProcessForwardService)this.getService()).allBpmProcessForward(userId);
        if (list == null) {
            return;
        }
        for (BpmProcessForward next : list) {
            map.put(next.getProcessInstanceId(), next);
        }
        processForwardMap.putAll(map);
    }

    public BpmProcessForward getProcessForward(String processInstanceId) {
        if (Strings.isNullOrEmpty((String)processInstanceId)) {
            return null;
        }
        return processForwardMap.get(processInstanceId);
    }

    public List<Task> findTaskByEmpId(String userId) {
        return Optional.ofNullable(((TaskQuery)this.taskService.createTaskQuery().taskAssignee(userId)).list()).orElse(Arrays.asList(new Task[0]));
    }

    @Override
    public void loadTask(String userId) {
        HashMap<String, Task> map = new HashMap<String, Task>();
        List<Task> list = this.findTaskByEmpId(userId);
        if (list == null) {
            return;
        }
        for (Task next : list) {
            if (StringUtils.isEmpty((CharSequence)next.getProcessInstanceId())) continue;
            map.put(next.getProcessInstanceId(), next);
        }
        taskMap.putAll(map);
    }

    public Task getTask(String processInstanceId) {
        if (Strings.isNullOrEmpty((String)processInstanceId)) {
            return null;
        }
        return taskMap.get(processInstanceId);
    }

    @Override
    public boolean isForward(String processInstanceId) {
        if (ObjectUtils.isEmpty((Object)this.getTask(processInstanceId))) {
            return false;
        }
        return !ObjectUtils.isEmpty((Object)this.getProcessForward(processInstanceId));
    }

    @Override
    public void addProcessForwardBatch(String procInstId, String processNumber, List<String> forwardUserIds) {
        if (CollectionUtils.isEmpty(forwardUserIds)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)procInstId) || Strings.isNullOrEmpty((String)processNumber)) {
            return;
        }
        Map employeeInfo = this.employeeInfoProviderService.provideEmployeeInfo(forwardUserIds);
        ArrayList<BpmProcessForward> processForwardList = new ArrayList<BpmProcessForward>();
        for (String userId : forwardUserIds) {
            BpmProcessForward processForward = BpmProcessForward.builder().createTime(new Date()).createUserId(SecurityUtils.getLogInEmpIdStr()).ForwardUserName((String)employeeInfo.get(userId)).forwardUserId(userId).processInstanceId(procInstId).processNumber(processNumber).build();
            processForwardList.add(processForward);
        }
        ((BpmProcessForwardService)this.getService()).saveBatch(processForwardList);
    }
}

