/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Date;
import java.util.List;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.openoa.base.constant.enums.ProcessEnum;
import org.openoa.base.constant.enums.ProcessKeyEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmProcessNodeOvertime;
import org.openoa.base.entity.BpmProcessNodeRecord;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.DateUtil;
import org.openoa.engine.bpmnconf.common.ProcessBusinessContans;
import org.openoa.engine.bpmnconf.mapper.BpmBusinessProcessMapper;
import org.openoa.engine.bpmnconf.mapper.BpmProcessNodeOvertimeMapper;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.impl.BpmProcessNodeRecordServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessNodeOvertimeBizService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BpmProcessNodeOvertimeBizServiceImpl
implements BpmProcessNodeOvertimeBizService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private BpmProcessNodeRecordServiceImpl processNodeRecordService;
    @Autowired
    private ProcessBusinessContans processBusinessContans;
    @Autowired
    private TaskMgmtMapper taskMgmtMapper;
    @Autowired
    private BpmBusinessProcessMapper bpmBusinessProcessService;

    @Override
    public Boolean nodeOvertime(String processKey, String taskId) {
        Boolean isOvertime = false;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"process_key", (Object)processKey);
        wrapper.eq((Object)"node_key", (Object)task.getTaskDefinitionKey());
        List list = ((BpmProcessNodeOvertimeMapper)this.getMapper()).selectList((Wrapper)wrapper);
        if (!ObjectUtils.isEmpty((Object)list)) {
            BpmProcessNodeOvertime processNodeOvertime = (BpmProcessNodeOvertime)list.get(0);
            Long hours = DateUtil.dateDiff((Date)new Date(), (Date)task.getCreateTime(), (Integer)2);
            isOvertime = !ObjectUtils.isEmpty((Object)processNodeOvertime.getNoticeTime()) ? (processNodeOvertime.getNoticeTime() <= hours.intValue() ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(false);
        }
        return isOvertime;
    }

    @Override
    public void checkTaskOvertime() throws AFBizException {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            try {
                BpmProcessNodeRecord processNodeRecord;
                String processKey = task.getProcessDefinitionId().split("\\:")[0].toString();
                if (ObjectUtils.isEmpty((Object)ProcessKeyEnum.getCodeByDesc((String)processKey)) || !ObjectUtils.isEmpty((Object)(processNodeRecord = this.processNodeRecordService.getBpmProcessNodeRecord(BpmProcessNodeRecord.builder().processInstanceId(task.getProcessInstanceId()).taskId(task.getId()).build()))) || task.getAssignee().equals(ProcessEnum.PROC_MAN.getDesc()) || ObjectUtils.isEmpty((Object)task.getAssignee()) || !this.nodeOvertime(processKey, task.getId()).booleanValue()) continue;
                String businessKey = this.taskMgmtMapper.findByProcinstIdTask(task.getProcessInstanceId());
                BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.findBpmBusinessProcess(BpmBusinessProcess.builder().entryId(businessKey).build());
                this.processNodeRecordService.addBpmProcessNodeRecord(BpmProcessNodeRecord.builder().taskId(task.getId()).processInstanceId(task.getProcessInstanceId()).build());
            }
            catch (AFBizException e) {
                e.printStackTrace();
            }
        }
    }
}

