/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.List;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.ProcessJurisdictionEnum;
import org.openoa.base.entity.BpmProcessPermissions;
import org.openoa.base.entity.Department;
import org.openoa.base.util.SecurityUtils;
import org.openoa.engine.bpmnconf.mapper.BpmProcessPermissionsMapper;
import org.openoa.engine.bpmnconf.service.impl.DepartmentServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessPermissionsBizService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BpmProcessPermissionsBizServiceImpl
implements BpmProcessPermissionsBizService {
    @Autowired
    private DepartmentServiceImpl departmentService;

    @Override
    public List<String> getProcessKey(String userId, Integer type) {
        QueryWrapper permissionsWrapper = new QueryWrapper();
        permissionsWrapper.eq((Object)"permissions_type", (Object)type);
        permissionsWrapper.eq((Object)"user_id", (Object)userId);
        List list = ((BpmProcessPermissionsMapper)this.getMapper()).selectList((Wrapper)permissionsWrapper);
        List<Department> departmentVos = this.departmentService.ListSubDepartmentByEmployeeId(userId);
        List depList = departmentVos.stream().map(Department::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(depList)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"permissions_type", (Object)type);
            wrapper.in((Object)"dep_id", depList);
            List permissionsList = ((BpmProcessPermissionsMapper)this.getMapper()).selectList((Wrapper)wrapper);
            list.addAll(permissionsList);
        }
        List<String> processKeyList = list.stream().map(BpmProcessPermissions::getProcessKey).distinct().collect(Collectors.toList());
        return processKeyList;
    }

    @Override
    public boolean getJurisdiction(String processKey) {
        List<String> processKeyList = this.getProcessKey(SecurityUtils.getLogInEmpIdSafe(), ProcessJurisdictionEnum.CONTROL_TYPE.getCode());
        return processKeyList.contains(processKey);
    }
}

