/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.bean.BeanCopy;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.openoa.base.constant.enums.MessageSendTypeEnum;
import org.openoa.base.constant.enums.WildcardCharacterEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmVariable;
import org.openoa.base.entity.BpmVariableApproveRemind;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.entity.Employee;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.DateUtil;
import org.openoa.base.vo.BpmnApproveRemindVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.base.vo.BpmnTimeoutReminderTaskVo;
import org.openoa.base.vo.BpmnTimeoutReminderVariableVo;
import org.openoa.base.vo.InformationTemplateVo;
import org.openoa.base.vo.UserMsgVo;
import org.openoa.engine.bpmnconf.common.ProcessBusinessContans;
import org.openoa.engine.bpmnconf.mapper.BpmVariableApproveRemindMapper;
import org.openoa.engine.bpmnconf.mapper.BpmVariableMapper;
import org.openoa.engine.bpmnconf.service.impl.BpmVariableServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableApproveRemindBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnConfService;
import org.openoa.engine.utils.InformationTemplateUtils;
import org.openoa.engine.utils.UserMsgUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BpmVariableApproveRemindBizServiceImpl
implements BpmVariableApproveRemindBizService {
    @Autowired
    private BpmVariableServiceImpl bpmVariableService;
    @Autowired
    private BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessBusinessContans processBusinessContans;
    @Autowired
    private AfUserService employeeService;
    @Autowired
    private BpmnConfService bpmnConfService;
    @Autowired
    private InformationTemplateUtils informationTemplateUtils;
    @Value(value="${system.domain:test}")
    private String systemDomain;

    @Override
    public void doTimeoutReminder() {
        Multimap<String, BpmnTimeoutReminderTaskVo> tasksMultimap = this.getBpmnTimeoutReminderTaskVoMultimap();
        Map<String, BpmnTimeoutReminderVariableVo> bpmnTimeoutReminderVariableVoMap = this.getBpmnTimeoutReminderVariableVoMap(tasksMultimap);
        this.checkAndSendMessage(tasksMultimap, bpmnTimeoutReminderVariableVoMap);
    }

    private void doSendMessage(BpmnTimeoutReminderVariableVo bpmnTimeoutReminderVariableVo, BpmnTimeoutReminderTaskVo bpmnTimeoutReminderTaskVo, BpmnApproveRemindVo bpmnApproveRemindVo) {
        BpmnConf bpmnConf;
        boolean isOutside = false;
        if (!Strings.isNullOrEmpty((String)bpmnTimeoutReminderVariableVo.getBpmnCode()) && !ObjectUtils.isEmpty((Object)(bpmnConf = (BpmnConf)this.bpmnConfService.getBaseMapper().selectOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_code", (Object)bpmnTimeoutReminderVariableVo.getBpmnCode())))) && bpmnConf.getIsOutSideProcess() == 1) {
            isOutside = true;
        }
        String emailUrl = "";
        String appUrl = "";
        String emplId = bpmnTimeoutReminderTaskVo.getAssignee();
        Employee employee = this.employeeService.getEmployeeDetailById(emplId);
        InformationTemplateVo informationTemplateVo = this.getInformationTemplateVo(bpmnTimeoutReminderVariableVo, bpmnApproveRemindVo, employee);
        this.sendMail(bpmnTimeoutReminderTaskVo, emailUrl, appUrl, emplId, employee, informationTemplateVo);
        this.sendMessageAndPush(bpmnTimeoutReminderTaskVo, emailUrl, appUrl, emplId, employee, informationTemplateVo);
        this.insertUserMessage(bpmnTimeoutReminderTaskVo, emailUrl, appUrl, emplId, employee, informationTemplateVo);
    }

    private Map<String, BpmnTimeoutReminderVariableVo> getBpmnTimeoutReminderVariableVoMap(Multimap<String, BpmnTimeoutReminderTaskVo> tasksMultimap) {
        List bpmBusinessProcesses = this.bpmBusinessProcessService.getBaseMapper().selectList((Wrapper)new QueryWrapper().in((Object)"PROC_INST_ID_", (Collection)tasksMultimap.keys()));
        List bpmVariables = ((BpmVariableMapper)this.bpmVariableService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().in((Object)"process_num", (Collection)bpmBusinessProcesses.stream().map(BpmBusinessProcess::getBusinessNumber).collect(Collectors.toList())));
        List bpmVariableApproveReminds = ((BpmVariableApproveRemindMapper)this.getMapper()).selectList((Wrapper)new QueryWrapper().in((Object)"variable_id", (Collection)bpmVariables.stream().map(BpmVariable::getId).collect(Collectors.toList())));
        HashMap processMap = Maps.newHashMap();
        for (String procinstId : tasksMultimap.keys()) {
            BpmBusinessProcess bpmBusinessProcess = bpmBusinessProcesses.stream().filter(bbp -> procinstId.equals(bbp.getEntryId())).findFirst().orElse(null);
            processMap.put(procinstId, bpmBusinessProcess);
        }
        HashMap bpmnTimeoutReminderVariableVoMap = Maps.newHashMap();
        for (String key : processMap.keySet()) {
            BpmnStartConditionsVo bpmnStartConditionsVo;
            BpmVariable bpmVariable;
            BpmBusinessProcess val = (BpmBusinessProcess)processMap.get(key);
            if (ObjectUtils.isEmpty((Object)val) || ObjectUtils.isEmpty((Object)(bpmVariable = (BpmVariable)bpmVariables.stream().filter(o -> val.getBusinessNumber().equals(o.getProcessNum())).findFirst().orElse(null)))) continue;
            BpmnTimeoutReminderVariableVo bpmnTimeoutReminderVariableVo = new BpmnTimeoutReminderVariableVo();
            BeanCopy.from((Object)bpmVariable).to((Object)bpmnTimeoutReminderVariableVo).copy();
            bpmnTimeoutReminderVariableVo.setProcessinessKey(val.getProcessinessKey());
            bpmnTimeoutReminderVariableVo.setBusinessId(val.getBusinessId());
            bpmnTimeoutReminderVariableVo.setEntryId(val.getEntryId());
            bpmnTimeoutReminderVariableVo.setBpmVariableApproveReminds(bpmVariableApproveReminds.stream().filter(o -> bpmVariable.getId().equals(o.getVariableId())).collect(Collectors.toList()));
            bpmnTimeoutReminderVariableVo.setBpmnName(bpmVariable.getProcessName());
            bpmnTimeoutReminderVariableVo.setProcessNumber(bpmVariable.getProcessNum());
            Employee employee = this.employeeService.getEmployeeDetailById(val.getCreateUser());
            bpmnTimeoutReminderVariableVo.setStartUser(employee.getUsername());
            bpmnTimeoutReminderVariableVo.setApplyDate(DateUtil.SDF_DATE_PATTERN.format(val.getCreateTime()));
            bpmnTimeoutReminderVariableVo.setApplyTime(DateUtil.SDF_DATETIME_PATTERN.format(val.getCreateTime()));
            if (!(ObjectUtils.isEmpty((Object)bpmVariable.getProcessStartConditions()) || ObjectUtils.isEmpty((Object)(bpmnStartConditionsVo = (BpmnStartConditionsVo)JSON.parseObject((String)bpmVariable.getProcessStartConditions(), BpmnStartConditionsVo.class))) || ObjectUtils.isEmpty((Object)bpmnStartConditionsVo.getApprovalEmplId()))) {
                employee = this.employeeService.getEmployeeDetailById(bpmnStartConditionsVo.getApprovalEmplId());
                bpmnTimeoutReminderVariableVo.setApprovalEmpl(employee.getUsername());
            }
            bpmnTimeoutReminderVariableVoMap.put(key, bpmnTimeoutReminderVariableVo);
        }
        return bpmnTimeoutReminderVariableVoMap;
    }

    private Multimap<String, BpmnTimeoutReminderTaskVo> getBpmnTimeoutReminderTaskVoMultimap() {
        ArrayListMultimap bpmnTimeoutReminderTaskVoMultimap = ArrayListMultimap.create();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            Integer standbyDay;
            if (ObjectUtils.isEmpty((Object)task.getAssignee()) || (standbyDay = Integer.valueOf(Optional.ofNullable(DateUtil.dateDiff((Date)task.getCreateTime(), (Date)new Date(), (Integer)1)).orElse(0L).intValue())) <= 0) continue;
            bpmnTimeoutReminderTaskVoMultimap.put((Object)task.getProcessInstanceId(), (Object)BpmnTimeoutReminderTaskVo.builder().procInstId(task.getProcessInstanceId()).taskId(task.getId()).elementId(task.getTaskDefinitionKey()).assignee(task.getAssignee()).createTime(task.getCreateTime()).standbyDay(standbyDay).build());
        }
        return bpmnTimeoutReminderTaskVoMultimap;
    }

    private InformationTemplateVo getInformationTemplateVo(BpmnTimeoutReminderVariableVo bpmnTimeoutReminderVariableVo, BpmnApproveRemindVo bpmnApproveRemindVo, Employee employee) {
        HashMap wildcardCharacterMap = Maps.newHashMap();
        wildcardCharacterMap.put(WildcardCharacterEnum.ONE_CHARACTER.getCode(), bpmnTimeoutReminderVariableVo.getProcessName());
        wildcardCharacterMap.put(WildcardCharacterEnum.TWO_CHARACTER.getCode(), bpmnTimeoutReminderVariableVo.getProcessNum());
        wildcardCharacterMap.put(WildcardCharacterEnum.THREE_CHARACTER.getCode(), bpmnTimeoutReminderVariableVo.getStartUser());
        wildcardCharacterMap.put(WildcardCharacterEnum.FOUR_CHARACTER.getCode(), bpmnTimeoutReminderVariableVo.getApprovalEmpl());
        wildcardCharacterMap.put(WildcardCharacterEnum.FIVE_CHARACTER.getCode(), bpmnTimeoutReminderVariableVo.getApplyDate());
        wildcardCharacterMap.put(WildcardCharacterEnum.SIX_CHARACTER.getCode(), bpmnTimeoutReminderVariableVo.getApplyTime());
        wildcardCharacterMap.put(WildcardCharacterEnum.EIGHT_CHARACTER.getCode(), employee.getUsername());
        return this.informationTemplateUtils.translateInformationTemplate(InformationTemplateVo.builder().id(bpmnApproveRemindVo.getTemplateId()).wildcardCharacterMap((Map)wildcardCharacterMap).build());
    }

    private void sendMail(BpmnTimeoutReminderTaskVo bpmnTimeoutReminderTaskVo, String emailUrl, String appUrl, String emplId, Employee employee, InformationTemplateVo informationTemplateVo) {
        UserMsgVo userMsgVo = this.getUserMsgVo(bpmnTimeoutReminderTaskVo, emailUrl, appUrl, emplId, employee, informationTemplateVo.getMailTitle(), informationTemplateVo.getMailContent());
        UserMsgUtils.sendMessagesNoUserMessage(userMsgVo, MessageSendTypeEnum.MAIL);
    }

    private UserMsgVo getUserMsgVo(BpmnTimeoutReminderTaskVo bpmnTimeoutReminderTaskVo, String emailUrl, String appUrl, String emplId, Employee employee, String title, String content) {
        return UserMsgVo.builder().userId(emplId).email(employee.getEmail()).mobile(employee.getMobile()).title(title).content(content).emailUrl(emailUrl).url(emailUrl).appPushUrl(appUrl).taskId(bpmnTimeoutReminderTaskVo.getTaskId()).ssoSessionDomain(this.systemDomain).build();
    }

    private void checkAndSendMessage(Multimap<String, BpmnTimeoutReminderTaskVo> tasksMultimap, Map<String, BpmnTimeoutReminderVariableVo> bpmnTimeoutReminderVariableVoMap) {
        for (String key : tasksMultimap.keySet()) {
            List bpmVariableApproveReminds;
            BpmnTimeoutReminderVariableVo bpmnTimeoutReminderVariableVo;
            List bpmnTimeoutReminderTaskVos = (List)tasksMultimap.get((Object)key);
            if (ObjectUtils.isEmpty((Object)bpmnTimeoutReminderTaskVos) || ObjectUtils.isEmpty((Object)(bpmnTimeoutReminderVariableVo = bpmnTimeoutReminderVariableVoMap.get(key))) || ObjectUtils.isEmpty((Object)(bpmVariableApproveReminds = bpmnTimeoutReminderVariableVo.getBpmVariableApproveReminds()))) continue;
            for (BpmnTimeoutReminderTaskVo bpmnTimeoutReminderTaskVo : bpmnTimeoutReminderTaskVos) {
                Integer standbyDay;
                List confDays;
                BpmnApproveRemindVo bpmnApproveRemindVo;
                BpmVariableApproveRemind bpmVariableApproveRemind = bpmVariableApproveReminds.stream().filter(o -> bpmnTimeoutReminderTaskVo.getElementId().equals(o.getElementId())).findFirst().orElse(null);
                if (ObjectUtils.isEmpty((Object)bpmVariableApproveRemind) || Strings.isNullOrEmpty((String)bpmVariableApproveRemind.getContent()) || ObjectUtils.isEmpty((Object)(bpmnApproveRemindVo = (BpmnApproveRemindVo)JSON.parseObject((String)bpmVariableApproveRemind.getContent(), BpmnApproveRemindVo.class)).getDayList()) || !(confDays = bpmnApproveRemindVo.getDayList().stream().sorted().collect(Collectors.toList())).contains(standbyDay = bpmnTimeoutReminderTaskVo.getStandbyDay())) continue;
                this.doSendMessage(bpmnTimeoutReminderVariableVo, bpmnTimeoutReminderTaskVo, bpmnApproveRemindVo);
            }
        }
    }

    private void insertUserMessage(BpmnTimeoutReminderTaskVo bpmnTimeoutReminderTaskVo, String emailUrl, String appUrl, String emplId, Employee employee, InformationTemplateVo informationTemplateVo) {
        UserMsgVo userMsgVo = this.getUserMsgVo(bpmnTimeoutReminderTaskVo, emailUrl, appUrl, emplId, employee, informationTemplateVo.getSystemTitle(), informationTemplateVo.getSystemContent());
        UserMsgUtils.insertUserMessage(userMsgVo);
    }

    private void sendMessageAndPush(BpmnTimeoutReminderTaskVo bpmnTimeoutReminderTaskVo, String emailUrl, String appUrl, String emplId, Employee employee, InformationTemplateVo informationTemplateVo) {
        UserMsgVo userMsgVo = this.getUserMsgVo(bpmnTimeoutReminderTaskVo, emailUrl, appUrl, emplId, employee, "", informationTemplateVo.getNoteContent());
        UserMsgUtils.sendMessagesNoUserMessage(userMsgVo, MessageSendTypeEnum.MESSAGE, MessageSendTypeEnum.PUSH);
    }
}

