/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.entity.BpmVariable;
import org.openoa.base.entity.BpmVariableSignUpPersonnel;
import org.openoa.base.service.BpmVariableSignUpPersonnelService;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.common.entity.BpmVariableMultiplayer;
import org.openoa.common.entity.BpmVariableMultiplayerPersonnel;
import org.openoa.common.entity.BpmVariableSingle;
import org.openoa.common.mapper.BpmVariableMultiplayerMapper;
import org.openoa.common.mapper.BpmVariableMultiplayerPersonnelMapper;
import org.openoa.common.mapper.BpmVariableSingleMapper;
import org.openoa.common.service.BpmVariableMultiplayerPersonnelServiceImpl;
import org.openoa.common.service.BpmVariableMultiplayerServiceImpl;
import org.openoa.common.service.BpmVariableSingleServiceImpl;
import org.openoa.engine.bpmnconf.mapper.BpmVariableMapper;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableBizService;
import org.openoa.engine.utils.AFWrappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BpmVariableBizServiceImpl
implements BpmVariableBizService {
    @Autowired
    private BpmVariableSingleServiceImpl bpmVariableSingleService;
    @Autowired
    private BpmVariableMultiplayerServiceImpl bpmVariableMultiplayerService;
    @Autowired
    private BpmVariableMultiplayerPersonnelServiceImpl bpmVariableMultiplayerPersonnelService;
    @Autowired
    private BpmVariableSignUpPersonnelService bpmVariableSignUpPersonnelService;

    @Override
    public Boolean checkIsInProcess(String formCode, Integer businessId, Integer loginEmplId, String loginUsername) {
        if (!Strings.isNullOrEmpty((String)formCode) || ObjectUtils.isEmpty((Object)businessId) || ObjectUtils.isEmpty((Object)loginEmplId) || ObjectUtils.isEmpty((Object)loginUsername)) {
            return false;
        }
        String processNum = StringUtils.join((Object[])new Serializable[]{formCode, "_", businessId});
        BpmVariable bpmVariable = (BpmVariable)((BpmVariableMapper)this.getMapper()).selectOne((Wrapper)new QueryWrapper().eq((Object)"process_num", (Object)processNum));
        if (ObjectUtils.isEmpty((Object)bpmVariable)) {
            return false;
        }
        Long variableId = bpmVariable.getId();
        ArrayList assignees = Lists.newArrayList();
        if (((BpmVariableSingleMapper)this.bpmVariableSingleService.getBaseMapper()).selectCount((Wrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)) > 0L) {
            for (BpmVariableSingle bpmVariableSingle : ((BpmVariableSingleMapper)this.bpmVariableSingleService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId))) {
                assignees.add(bpmVariableSingle.getAssignee());
            }
        }
        if (((BpmVariableMultiplayerMapper)this.bpmVariableMultiplayerService.getBaseMapper()).selectCount((Wrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)) > 0L) {
            List bpmVariableMultiplayers = ((BpmVariableMultiplayerMapper)this.bpmVariableMultiplayerService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId));
            for (BpmVariableMultiplayer bpmVariableMultiplayer : bpmVariableMultiplayers) {
                List bpmVariableMultiplayerPersonnels = ((BpmVariableMultiplayerPersonnelMapper)this.bpmVariableMultiplayerPersonnelService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().eq((Object)"variable_multiplayer_id", (Object)bpmVariableMultiplayer.getId()));
                if (ObjectUtils.isEmpty((Object)bpmVariableMultiplayerPersonnels)) continue;
                for (BpmVariableMultiplayerPersonnel bpmVariableMultiplayerPersonnel : bpmVariableMultiplayerPersonnels) {
                    assignees.add(bpmVariableMultiplayerPersonnel.getAssignee());
                }
            }
        }
        if (this.bpmVariableSignUpPersonnelService.getBaseMapper().selectCount((Wrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)) > 0L) {
            ArrayListMultimap listMultimap = ArrayListMultimap.create();
            for (BpmVariableSignUpPersonnel bpmVariableSignUpPersonnel : this.bpmVariableSignUpPersonnelService.getBaseMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId))) {
                listMultimap.put((Object)bpmVariableSignUpPersonnel.getElementId(), (Object)bpmVariableSignUpPersonnel.getAssignee());
            }
            for (String key : listMultimap.keySet()) {
                List signUpAssignees = listMultimap.get((Object)key).stream().collect(Collectors.toList());
                assignees.addAll(signUpAssignees);
            }
        }
        if (assignees.contains(loginEmplId.toString()) || assignees.contains(loginUsername)) {
            return true;
        }
        return false;
    }

    @Override
    public List<BaseIdTranStruVo> getApproversByNodeId(String processNumber, String nodeId) {
        List currentNodeAssignees = ((BpmVariableMultiplayerMapper)this.bpmVariableMultiplayerService.getBaseMapper()).getAssigneeByNodeId(processNumber, nodeId);
        return currentNodeAssignees;
    }

    @Override
    public List<BaseIdTranStruVo> getApproversByElementId(String processNumber, String elementId) {
        List currentNodeAssignees = ((BpmVariableMultiplayerMapper)this.bpmVariableMultiplayerService.getBaseMapper()).getAssigneeByElementId(processNumber, elementId);
        return currentNodeAssignees;
    }

    @Override
    public void deleteByProcessNumber(String processNumber) {
        LambdaQueryWrapper variableQry = (LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmVariable::getProcessNum, (Object)processNumber);
        BpmVariable bpmVariable = (BpmVariable)((BpmVariableMapper)this.getMapper()).selectOne((Wrapper)variableQry);
        Long variableId = bpmVariable.getId();
        ((BpmVariableMapper)this.getMapper()).deleteById(variableId);
        LambdaQueryWrapper singleQry = (LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmVariableSingle::getVariableId, (Object)variableId);
        ((BpmVariableSingleMapper)this.bpmVariableSingleService.getBaseMapper()).delete((Wrapper)singleQry);
        LambdaQueryWrapper multiplayerQry = (LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmVariableMultiplayer::getVariableId, (Object)variableId);
        ((BpmVariableMultiplayerMapper)this.bpmVariableMultiplayerService.getBaseMapper()).delete((Wrapper)multiplayerQry);
    }
}

