/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.bean.BeanUtil;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.EventTypeEnum;
import org.openoa.base.constant.enums.InformEnum;
import org.openoa.base.constant.enums.JumpUrlEnum;
import org.openoa.base.constant.enums.MessageSendTypeEnum;
import org.openoa.base.constant.enums.ProcessNoticeEnum;
import org.openoa.base.constant.enums.WildcardCharacterEnum;
import org.openoa.base.entity.ActHiTaskinst;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmVariable;
import org.openoa.base.entity.BpmVariableApproveRemind;
import org.openoa.base.entity.BpmVariableMessage;
import org.openoa.base.entity.BpmVariableSignUpPersonnel;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.entity.Employee;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.service.AfRoleService;
import org.openoa.base.service.AfUserService;
import org.openoa.base.service.BpmVariableService;
import org.openoa.base.util.DateUtil;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmVariableMessageVo;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.base.vo.BpmnConfCommonVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.base.vo.BpmnTemplateVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.base.vo.InformationTemplateVo;
import org.openoa.base.vo.UserMsgBatchVo;
import org.openoa.base.vo.UserMsgVo;
import org.openoa.common.entity.BpmVariableMultiplayer;
import org.openoa.common.entity.BpmVariableMultiplayerPersonnel;
import org.openoa.common.entity.BpmVariableSingle;
import org.openoa.common.mapper.BpmVariableMultiplayerMapper;
import org.openoa.common.mapper.BpmVariableMultiplayerPersonnelMapper;
import org.openoa.common.mapper.BpmVariableSingleMapper;
import org.openoa.common.service.BpmVariableMultiplayerPersonnelServiceImpl;
import org.openoa.common.service.BpmVariableMultiplayerServiceImpl;
import org.openoa.common.service.BpmVariableSingleServiceImpl;
import org.openoa.engine.bpmnconf.common.ProcessBusinessContans;
import org.openoa.engine.bpmnconf.common.ProcessConstants;
import org.openoa.engine.bpmnconf.mapper.BpmVariableMessageMapper;
import org.openoa.engine.bpmnconf.mapper.BpmVariableSignUpPersonnelMapper;
import org.openoa.engine.bpmnconf.service.impl.ActHiTaskinstServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmVariableSignUpPersonnelServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableMessageBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessForwardService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessNoticeService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmVariableApproveRemindService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmVariableMessageService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnConfService;
import org.openoa.engine.utils.InformationTemplateUtils;
import org.openoa.engine.utils.UserMsgUtils;
import org.openoa.engine.vo.ProcessInforVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class BpmVariableMessageBizServiceImpl
implements BpmVariableMessageBizService {
    @Autowired
    private BpmnConfService bpmnConfService;
    @Autowired
    private BpmVariableService bpmVariableService;
    @Autowired
    private BpmVariableApproveRemindService bpmVariableApproveRemindService;
    @Autowired
    private AfUserService employeeService;
    @Autowired
    private AfRoleService roleService;
    @Autowired
    private BpmProcessNoticeService bpmProcessNoticeService;
    @Autowired
    private ProcessBusinessContans processBusinessContans;
    @Autowired
    private BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private ActHiTaskinstServiceImpl hiTaskinstService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessConstants processConstants;
    @Autowired
    private BpmVariableSingleServiceImpl bpmVariableSingleService;
    @Autowired
    private BpmVariableMultiplayerServiceImpl bpmVariableMultiplayerService;
    @Autowired
    private BpmVariableMultiplayerPersonnelServiceImpl bpmVariableMultiplayerPersonnelService;
    @Autowired
    private BpmVariableSignUpPersonnelServiceImpl bpmVariableSignUpPersonnelService;
    @Autowired
    private BpmProcessForwardService bpmProcessForwardService;
    @Autowired
    private InformationTemplateUtils informationTemplateUtils;

    @Override
    public void insertVariableMessage(Long variableId, BpmnConfCommonVo bpmnConfCommonVo) {
        ArrayList bpmVariableMessages = Lists.newArrayList();
        ArrayList bpmVariableApproveReminds = Lists.newArrayList();
        if (!ObjectUtils.isEmpty((Object)bpmnConfCommonVo.getTemplateVos())) {
            bpmVariableMessages.addAll(this.getBpmVariableMessages(variableId, bpmnConfCommonVo.getTemplateVos(), "", 1));
        }
        if (!ObjectUtils.isEmpty((Object)bpmnConfCommonVo.getElementList())) {
            for (BpmnConfCommonElementVo elementVo : bpmnConfCommonVo.getElementList()) {
                if (ObjectUtils.isEmpty((Object)elementVo.getTemplateVos())) continue;
                bpmVariableMessages.addAll(this.getBpmVariableMessages(variableId, elementVo.getTemplateVos(), elementVo.getElementId(), 2));
                if (ObjectUtils.isEmpty((Object)elementVo.getApproveRemindVo()) || ObjectUtils.isEmpty((Object)elementVo.getApproveRemindVo().getDays())) continue;
                bpmVariableApproveReminds.add(BpmVariableApproveRemind.builder().variableId(variableId).elementId(elementVo.getElementId()).content(JSON.toJSONString((Object)elementVo.getApproveRemindVo())).tenantId(MultiTenantUtil.getCurrentTenantId()).build());
            }
        }
        if (!ObjectUtils.isEmpty((Object)bpmVariableMessages)) {
            ((BpmVariableMessageService)this.getService()).saveBatch(bpmVariableMessages);
        }
        if (!ObjectUtils.isEmpty((Object)bpmVariableApproveReminds)) {
            this.bpmVariableApproveRemindService.saveBatch(bpmVariableApproveReminds);
        }
    }

    @Override
    public Boolean checkIsSendByTemplate(BpmVariableMessageVo vo) {
        BpmVariable bpmVariable = (BpmVariable)this.bpmVariableService.getBaseMapper().selectOne((Wrapper)new QueryWrapper().eq((Object)"process_num", (Object)vo.getProcessNumber()));
        if (ObjectUtils.isEmpty((Object)bpmVariable)) {
            return false;
        }
        if (vo.getMessageType() != null && vo.getMessageType() == 2) {
            return ((BpmVariableMessageMapper)this.getMapper()).selectCount((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)bpmVariable.getId())).eq((Object)"message_type", (Object)2)).eq((Object)"event_type", (Object)vo.getEventType())) > 0L;
        }
        if (vo.getMessageType() != null && vo.getMessageType() == 1) {
            return ((BpmVariableMessageMapper)this.getMapper()).selectCount((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)bpmVariable.getId())).eq((Object)"message_type", (Object)1)).eq((Object)"event_type", (Object)vo.getEventType())) > 0L;
        }
        return false;
    }

    @Override
    public BpmVariableMessageVo getBpmVariableMessageVo(BpmVariableMessageVo vo) {
        List tasks;
        BpmBusinessProcess businessProcess;
        if (ObjectUtils.isEmpty((Object)vo)) {
            return null;
        }
        BpmVariable bpmVariable = null;
        List bpmVariables = this.bpmVariableService.getBaseMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"process_num", (Object)vo.getProcessNumber()));
        if (!ObjectUtils.isEmpty((Object)bpmVariables)) {
            bpmVariable = (BpmVariable)bpmVariables.get(0);
        }
        if (ObjectUtils.isEmpty(bpmVariable)) {
            return null;
        }
        vo.setVariableId(bpmVariable.getId());
        BpmnConf bpmnConf = (BpmnConf)this.bpmnConfService.getBaseMapper().selectOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_code", (Object)bpmVariable.getBpmnCode()));
        if (bpmnConf == null) {
            throw new AFBizException(Strings.lenientFormat((String)"can not get bpmnConf by bpmncode:%s", (Object[])new Object[]{bpmVariable.getBpmnCode()}));
        }
        vo.setBpmnCode(bpmnConf.getBpmnCode());
        vo.setBpmnName(bpmnConf.getBpmnName());
        vo.setFormCode(bpmnConf.getFormCode());
        if (!StringUtils.isEmpty((CharSequence)bpmVariable.getProcessStartConditions())) {
            BpmnStartConditionsVo bpmnStartConditionsVo = (BpmnStartConditionsVo)JSON.parseObject((String)bpmVariable.getProcessStartConditions(), BpmnStartConditionsVo.class);
            vo.setBpmnStartConditions(bpmnStartConditionsVo);
            vo.setApprovalEmplId(Optional.ofNullable(bpmnStartConditionsVo.getApprovalEmplId()).map(String::valueOf).orElse("0"));
        }
        if (ObjectUtils.isEmpty((Object)(businessProcess = (BpmBusinessProcess)this.bpmBusinessProcessService.getBaseMapper().selectOne((Wrapper)new QueryWrapper().eq((Object)"BUSINESS_NUMBER", (Object)vo.getProcessNumber()))))) {
            throw new AFBizException(Strings.lenientFormat((String)"can not get BpmBusinessProcess by process Numbeer:%s", (Object[])new Object[]{vo.getProcessNumber()}));
        }
        String procInstId = businessProcess.getProcInstId();
        String createUser = businessProcess.getCreateUser();
        Date createTime = businessProcess.getCreateTime();
        vo.setProcessInsId(procInstId);
        vo.setStartUser(createUser);
        vo.setApplyDate(DateUtil.SDF_DATE_PATTERN.format(createTime));
        vo.setApplyTime(DateUtil.SDF_DATETIME_PATTERN.format(createTime));
        List<ActHiTaskinst> hisTask = this.hiTaskinstService.queryRecordsByProcInstId(procInstId);
        vo.setApproveds(hisTask.stream().map(ActHiTaskinst::getAssignee).filter(assignee -> !StringUtils.isEmpty((CharSequence)assignee)).distinct().collect(Collectors.toList()));
        if (StringUtils.isEmpty((CharSequence)vo.getAssignee())) {
            vo.setAssignee(SecurityUtils.getLogInEmpIdSafe());
        }
        if (vo.getEventTypeEnum().getIsInNode().booleanValue() && !ObjectUtils.isEmpty((Object)(tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).list()))) {
            PvmActivity nextNodePvmActivity;
            if (ObjectUtils.isEmpty((Object)vo.getElementId())) {
                String elementId = tasks.stream().map(TaskInfo::getTaskDefinitionKey).distinct().findFirst().orElse("");
                vo.setElementId(elementId);
            }
            if (ObjectUtils.isEmpty((Object)vo.getTaskId())) {
                String taskId = tasks.stream().map(TaskInfo::getId).distinct().findFirst().orElse("");
                vo.setTaskId(taskId);
            }
            if (vo.getType() == null) {
                vo.setType(Integer.valueOf(1));
            }
            if (!ObjectUtils.isEmpty((Object)(nextNodePvmActivity = this.processConstants.getNextNodePvmActivity(procInstId))) && !"endEvent".equals(nextNodePvmActivity.getProperty("type"))) {
                String nextElementId = nextNodePvmActivity.getId();
                vo.setNextNodeApproveds(this.getNextNodeApproveds(bpmVariable.getId(), nextElementId));
            }
        }
        return vo;
    }

    @Override
    public Map<String, String> getUrlMap(BpmVariableMessageVo vo, InformationTemplateVo informationTemplateVo) {
        HashMap urlMap = Maps.newHashMap();
        String emailUrl = "";
        String appUrl = "";
        if (informationTemplateVo.getJumpUrl() != null && (informationTemplateVo.getJumpUrl().equals(JumpUrlEnum.PROCESS_APPROVE.getCode()) || informationTemplateVo.getJumpUrl().equals(JumpUrlEnum.PROCESS_VIEW.getCode()))) {
            Integer type = informationTemplateVo.getJumpUrl() == 1 ? 2 : 1;
            emailUrl = this.processBusinessContans.getRoute(ProcessNoticeEnum.EMAIL_TYPE.getCode(), ProcessInforVo.builder().processinessKey(vo.getBpmnCode()).businessNumber(vo.getProcessNumber()).formCode(vo.getFormCode()).type(type).build(), Optional.ofNullable(vo.getIsOutside()).orElse(false));
            appUrl = this.processBusinessContans.getRoute(ProcessNoticeEnum.APP_TYPE.getCode(), ProcessInforVo.builder().processinessKey(vo.getBpmnCode()).businessNumber(vo.getProcessNumber()).formCode(vo.getFormCode()).type(type).build(), Optional.ofNullable(vo.getIsOutside()).orElse(false));
        } else if (informationTemplateVo.getJumpUrl() != null && informationTemplateVo.getJumpUrl().equals(JumpUrlEnum.PROCESS_BACKLOG.getCode())) {
            emailUrl = "/user/workflow/upcoming?page=1&pageSize=10";
            appUrl = "";
        }
        urlMap.put("emailUrl", emailUrl);
        urlMap.put("appUrl", appUrl);
        return urlMap;
    }

    @Override
    public BpmVariableMessageVo fromBusinessDataVo(BusinessDataVo businessDataVo) {
        if (ObjectUtils.isEmpty((Object)businessDataVo)) {
            return null;
        }
        EventTypeEnum eventTypeEnum = EventTypeEnum.getEnumByOperationType((Integer)businessDataVo.getOperationType());
        if (ObjectUtils.isEmpty((Object)eventTypeEnum)) {
            return null;
        }
        Integer type = 2;
        if (eventTypeEnum.equals((Object)EventTypeEnum.PROCESS_CANCELLATION)) {
            type = 1;
        }
        return this.getBpmVariableMessageVo(BpmVariableMessageVo.builder().processNumber(businessDataVo.getProcessNumber()).formCode(businessDataVo.getFormCode()).eventType(eventTypeEnum.getCode()).forwardUsers(Optional.ofNullable(businessDataVo.getUserIds()).orElse(Lists.newArrayList()).stream().map(String::valueOf).collect(Collectors.toList())).signUpUsers(Optional.ofNullable(businessDataVo.getSignUpUsers()).orElse(Lists.newArrayList()).stream().map(BaseIdTranStruVo::getId).collect(Collectors.toList())).messageType(Integer.valueOf(eventTypeEnum.getIsInNode() != false ? 2 : 1)).eventTypeEnum(eventTypeEnum).type(type).build());
    }

    @Override
    @Async
    public void sendTemplateMessagesAsync(BpmVariableMessageVo vo) {
        this.doSendTemplateMessages(vo);
    }

    @Async
    void sendTemplateMessagesAsync(BusinessDataVo businessDataVo) {
        BpmVariableMessageVo bpmVariableMessageVo = this.fromBusinessDataVo(businessDataVo);
        this.doSendTemplateMessages(bpmVariableMessageVo);
    }

    @Override
    public void sendTemplateMessages(BpmVariableMessageVo vo) {
        this.doSendTemplateMessages(vo);
    }

    @Override
    public void sendTemplateMessages(BusinessDataVo businessDataVo) {
        BpmVariableMessageVo bpmVariableMessageVo = this.fromBusinessDataVo(businessDataVo);
        this.doSendTemplateMessages(bpmVariableMessageVo);
    }

    private List<BpmVariableMessage> getBpmVariableMessages(Long variableId, List<BpmnTemplateVo> templateVos, String elementId, Integer messageType) {
        return templateVos.stream().map(o -> BpmVariableMessage.builder().variableId(variableId).elementId(elementId).messageType(this.getMessageSendType(o.getEvent(), messageType)).eventType(o.getEvent()).content(JSON.toJSONString((Object)o)).tenantId(MultiTenantUtil.getCurrentTenantId()).build()).collect(Collectors.toList());
    }

    private Integer getMessageSendType(Integer event, Integer defaultMessageSendType) {
        if (event == null) {
            return defaultMessageSendType;
        }
        EventTypeEnum eventTypeEnum = EventTypeEnum.getByCode((Integer)event);
        if (eventTypeEnum == null) {
            return defaultMessageSendType;
        }
        return eventTypeEnum.getIsInNode() != false ? 2 : 1;
    }

    private List<String> getNextNodeApproveds(Long variableId, String nextElementId) {
        if (((BpmVariableSingleMapper)this.bpmVariableSingleService.getBaseMapper()).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId)) > 0L) {
            ArrayList nextNodeApproveds = Lists.newArrayList();
            BpmVariableSingle bpmVariableSingle = (BpmVariableSingle)((BpmVariableSingleMapper)this.bpmVariableSingleService.getBaseMapper()).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId));
            nextNodeApproveds.add(bpmVariableSingle.getAssignee());
            return nextNodeApproveds;
        }
        if (((BpmVariableMultiplayerMapper)this.bpmVariableMultiplayerService.getBaseMapper()).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId)) > 0L) {
            ArrayList nextNodeApproveds = Lists.newArrayList();
            BpmVariableMultiplayer bpmVariableMultiplayer = (BpmVariableMultiplayer)((BpmVariableMultiplayerMapper)this.bpmVariableMultiplayerService.getBaseMapper()).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId));
            nextNodeApproveds.addAll(((BpmVariableMultiplayerPersonnelMapper)this.bpmVariableMultiplayerPersonnelService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().eq((Object)"variable_multiplayer_id", (Object)bpmVariableMultiplayer.getId())).stream().map(BpmVariableMultiplayerPersonnel::getAssignee).collect(Collectors.toList()));
            return nextNodeApproveds;
        }
        if (((BpmVariableSignUpPersonnelMapper)this.bpmVariableSignUpPersonnelService.getBaseMapper()).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId)) > 0L) {
            ArrayList nextNodeApproveds = Lists.newArrayList();
            nextNodeApproveds.addAll(((BpmVariableSignUpPersonnelMapper)this.bpmVariableSignUpPersonnelService.getBaseMapper()).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId)).stream().map(BpmVariableSignUpPersonnel::getAssignee).collect(Collectors.toList()));
            return nextNodeApproveds;
        }
        return Collections.EMPTY_LIST;
    }

    private void doSendTemplateMessages(BpmVariableMessageVo vo) {
        block7: {
            List bpmVariableMessages;
            block6: {
                List tasks;
                if (CollectionUtils.isEmpty((Collection)vo.getNextNodeApproveds()) && !ObjectUtils.isEmpty((Object)(tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(vo.getProcessInsId())).list()))) {
                    vo.setNextNodeApproveds(tasks.stream().map(TaskInfo::getAssignee).distinct().collect(Collectors.toList()));
                }
                if (!Objects.equals(vo.getMessageType(), 1)) break block6;
                bpmVariableMessages = ((BpmVariableMessageMapper)this.getMapper()).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)vo.getVariableId())).eq((Object)"message_type", (Object)1)).eq((Object)"event_type", (Object)vo.getEventType()));
                if (CollectionUtils.isEmpty((Collection)bpmVariableMessages)) break block7;
                for (BpmVariableMessage bpmVariableMessage : bpmVariableMessages) {
                    this.doSendTemplateMessages(bpmVariableMessage, vo);
                }
                break block7;
            }
            if (Objects.equals(vo.getMessageType(), 2)) {
                List currentNodeVariableMessages;
                bpmVariableMessages = ((BpmVariableMessageMapper)this.getMapper()).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)vo.getVariableId())).eq((Object)"event_type", (Object)vo.getEventType()));
                if (!StringUtils.isEmpty((CharSequence)vo.getElementId()) && !CollectionUtils.isEmpty(currentNodeVariableMessages = bpmVariableMessages.stream().filter(a -> vo.getElementId().equals(a.getElementId())).collect(Collectors.toList()))) {
                    bpmVariableMessages = currentNodeVariableMessages;
                }
                if (!CollectionUtils.isEmpty((Collection)bpmVariableMessages)) {
                    for (BpmVariableMessage bpmVariableMessage : bpmVariableMessages) {
                        this.doSendTemplateMessages(bpmVariableMessage, vo);
                    }
                }
            }
        }
    }

    private void doSendTemplateMessages(BpmVariableMessage bpmVariableMessage, BpmVariableMessageVo vo) {
        List<String> sendToUsers;
        BpmnTemplateVo bpmnTemplateVo = new BpmnTemplateVo();
        if (!ObjectUtils.isEmpty((Object)bpmVariableMessage.getContent())) {
            bpmnTemplateVo = (BpmnTemplateVo)JSON.parseObject((String)bpmVariableMessage.getContent(), BpmnTemplateVo.class);
        }
        if (ObjectUtils.isEmpty(sendToUsers = this.getSendToUsers(vo, bpmnTemplateVo))) {
            return;
        }
        List employeeDetailByIds = this.employeeService.getEmployeeDetailByIds((Collection)sendToUsers.stream().distinct().collect(Collectors.toList()));
        if (ObjectUtils.isEmpty((Object)employeeDetailByIds)) {
            return;
        }
        this.sendMessage(vo, bpmnTemplateVo, employeeDetailByIds);
    }

    private void sendMessage(BpmVariableMessageVo vo, BpmnTemplateVo bpmnTemplateVo, List<Employee> employees) {
        List messageSendTypeEnums = this.bpmProcessNoticeService.processNoticeList(vo.getFormCode()).stream().map(o -> MessageSendTypeEnum.getEnumByCode((Integer)o.getType())).collect(Collectors.toList());
        List messageSendTypeList = bpmnTemplateVo.getMessageSendTypeList();
        if (!messageSendTypeEnums.isEmpty() && !CollectionUtils.isEmpty((Collection)messageSendTypeList)) {
            messageSendTypeEnums = messageSendTypeList.stream().map(a -> MessageSendTypeEnum.getEnumByCode((Integer)a.getId().intValue())).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map<Integer, String> wildcardCharacterMap = this.getWildcardCharacterMap(vo);
        InformationTemplateVo informationTemplateVo = this.informationTemplateUtils.translateInformationTemplate(InformationTemplateVo.builder().id(bpmnTemplateVo.getTemplateId()).wildcardCharacterMap(wildcardCharacterMap).build());
        Map<String, String> urlMap = this.getUrlMap(vo, informationTemplateVo);
        String emailUrl = urlMap.get("emailUrl");
        String appUrl = urlMap.get("appUrl");
        for (MessageSendTypeEnum messageSendTypeEnum : messageSendTypeEnums) {
            if (Objects.isNull(messageSendTypeEnum)) continue;
            UserMsgUtils.sendMessageBatchNoUserMessage(employees.stream().map(o -> this.getUserMsgBatchVo((Employee)o, informationTemplateVo.getMailTitle(), informationTemplateVo.getMailContent(), vo.getTaskId(), emailUrl, appUrl, messageSendTypeEnum)).collect(Collectors.toList()));
        }
    }

    private Map<Integer, String> getWildcardCharacterMap(BpmVariableMessageVo vo) {
        HashMap wildcardCharacterMap = Maps.newHashMap();
        for (WildcardCharacterEnum wildcardCharacterEnum : WildcardCharacterEnum.values()) {
            Object property;
            if (StringUtils.isEmpty((CharSequence)wildcardCharacterEnum.getFilName()) || (property = BeanUtil.pojo.getProperty((Object)vo, wildcardCharacterEnum.getFilName())) == null) continue;
            if (wildcardCharacterEnum.getIsSearchEmpl().booleanValue()) {
                BaseIdTranStruVo employee;
                if (property instanceof List) {
                    List emplNames;
                    List propertys = (List)property;
                    if (ObjectUtils.isEmpty((Object)propertys) || ObjectUtils.isEmpty(emplNames = this.employeeService.queryUserByIds((Collection)propertys).stream().map(BaseIdTranStruVo::getName).collect(Collectors.toList()))) continue;
                    wildcardCharacterMap.put(wildcardCharacterEnum.getCode(), StringUtils.join(emplNames, (String)","));
                    continue;
                }
                if (property.toString().equals("0") || (employee = this.employeeService.getById(property.toString())) == null) continue;
                wildcardCharacterMap.put(wildcardCharacterEnum.getCode(), employee.getName());
                continue;
            }
            wildcardCharacterMap.put(wildcardCharacterEnum.getCode(), property.toString());
        }
        return wildcardCharacterMap;
    }

    private List<String> getSendToUsers(BpmVariableMessageVo vo, BpmnTemplateVo bpmnTemplateVo) {
        List users;
        ArrayList sendUsers = Lists.newArrayList();
        if (!ObjectUtils.isEmpty((Object)bpmnTemplateVo.getEmpIdList())) {
            sendUsers.addAll(new ArrayList(bpmnTemplateVo.getEmpIdList()));
        }
        if (!CollectionUtils.isEmpty((Collection)bpmnTemplateVo.getRoleIdList()) && !CollectionUtils.isEmpty((Collection)(users = this.roleService.queryUserByRoleIds((Collection)bpmnTemplateVo.getRoleIdList())))) {
            sendUsers.addAll(users.stream().map(BaseIdTranStruVo::getId).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getSignUpUsers())) {
            sendUsers.addAll(vo.getSignUpUsers());
        }
        List<Object> forwardUsers = null;
        List bpmProcessForwards = this.bpmProcessForwardService.list((Wrapper)new QueryWrapper().eq((Object)"processInstance_Id", (Object)vo.getProcessInsId()));
        if (!CollectionUtils.isEmpty((Collection)vo.getForwardUsers()) && !CollectionUtils.isEmpty((Collection)bpmProcessForwards)) {
            forwardUsers = Lists.newArrayList();
            forwardUsers.addAll(vo.getForwardUsers());
            forwardUsers.addAll(bpmProcessForwards.stream().map(o -> String.valueOf(o.getForwardUserId())).distinct().collect(Collectors.toList()));
            forwardUsers = forwardUsers.stream().distinct().collect(Collectors.toList());
        } else if (CollectionUtils.isEmpty((Collection)vo.getForwardUsers()) && !CollectionUtils.isEmpty((Collection)bpmProcessForwards)) {
            forwardUsers = Lists.newArrayList();
            forwardUsers.addAll(bpmProcessForwards.stream().map(o -> String.valueOf(o.getForwardUserId())).distinct().collect(Collectors.toList()));
            forwardUsers = forwardUsers.stream().distinct().collect(Collectors.toList());
        } else if (!CollectionUtils.isEmpty((Collection)vo.getForwardUsers()) && CollectionUtils.isEmpty((Collection)bpmProcessForwards)) {
            forwardUsers = Lists.newArrayList();
            forwardUsers.addAll(vo.getForwardUsers());
            forwardUsers = forwardUsers.stream().distinct().collect(Collectors.toList());
        }
        vo.setForwardUsers((List)forwardUsers);
        if (!CollectionUtils.isEmpty((Collection)bpmnTemplateVo.getInformIdList())) {
            for (String informId : bpmnTemplateVo.getInformIdList()) {
                InformEnum informEnum = InformEnum.getEnumByByCode((Integer)Integer.parseInt(informId));
                if (informEnum == InformEnum.ASSIGNED_USER || informEnum == InformEnum.ASSIGNEED_ROLES) continue;
                Object filObject = BeanUtil.pojo.getProperty((Object)vo, informEnum.getFilName());
                if (filObject instanceof List) {
                    sendUsers.addAll((List)filObject);
                    continue;
                }
                if (filObject == null) continue;
                sendUsers.add(filObject.toString());
            }
        }
        return sendUsers;
    }

    private UserMsgBatchVo getUserMsgBatchVo(Employee o, String title, String content, String taskId, String emailUrl, String appUrl, MessageSendTypeEnum messageSendTypeEnum) {
        return UserMsgBatchVo.builder().userMsgVo(UserMsgVo.builder().userId(o.getId()).email(o.getEmail()).mobile(o.getMobile()).title(title).content(content).emailUrl(emailUrl).url(emailUrl).appPushUrl(appUrl).taskId(taskId).build()).messageSendTypeEnums((List)Lists.newArrayList((Object[])new MessageSendTypeEnum[]{messageSendTypeEnum})).build();
    }
}

