/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.TaskService;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.entity.BpmVariable;
import org.openoa.base.entity.BpmVariableSignUp;
import org.openoa.base.entity.BpmVariableSignUpPersonnel;
import org.openoa.base.service.BpmVariableSignUpPersonnelService;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.common.constant.enus.ElementPropertyEnum;
import org.openoa.engine.bpmnconf.mapper.BpmVariableMapper;
import org.openoa.engine.bpmnconf.service.impl.BpmVariableServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableSignUpPersonnelBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmVariableSignUpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BpmVariableSignUpPersonnelBizServiceImpl
implements BpmVariableSignUpPersonnelBizService {
    @Autowired
    private BpmVariableServiceImpl bpmVariableService;
    @Autowired
    private BpmVariableSignUpService bpmVariableSignUpService;

    @Override
    public void insertSignUpPersonnel(TaskService taskService, String taskId, String processNumber, String nodeId, String assignee, List<BaseIdTranStruVo> signUpUsers) {
        if (ObjectUtils.isEmpty(signUpUsers)) {
            return;
        }
        BpmVariable bpmVariable = (BpmVariable)((BpmVariableMapper)this.bpmVariableService.getBaseMapper()).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"process_num", (Object)processNumber)).eq((Object)"is_del", (Object)0));
        if (ObjectUtils.isEmpty((Object)bpmVariable)) {
            return;
        }
        BpmVariableSignUp bpmVariableSignUp = (BpmVariableSignUp)this.bpmVariableSignUpService.getBaseMapper().selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)bpmVariable.getId())).eq((Object)"element_id", (Object)nodeId));
        if (ObjectUtils.isEmpty((Object)bpmVariableSignUp) || ObjectUtils.isEmpty((Object)bpmVariableSignUp.getSubElements())) {
            return;
        }
        List subElementVos = JSON.parseArray((String)bpmVariableSignUp.getSubElements(), BpmnConfCommonElementVo.class);
        BpmnConfCommonElementVo signUpElement = subElementVos.stream().filter(o -> o.getIsBackSignUp() == 0).findFirst().orElse(new BpmnConfCommonElementVo());
        List signeeUpAssignees = signUpUsers.stream().map(BaseIdTranStruVo::getId).collect(Collectors.toList());
        taskService.setVariable(taskId, signUpElement.getCollectionName(), signeeUpAssignees);
        if (!ObjectUtils.isEmpty((Object)signUpElement.getElementProperty()) && signUpElement.getElementProperty().intValue() == ElementPropertyEnum.ELEMENT_PROPERTY_SIGN_UP_SERIAL.getCode().intValue()) {
            taskService.setVariable(taskId, StringUtils.join((Object[])new String[]{signUpElement.getElementId(), "size"}), (Object)signUpUsers.size());
        }
        BpmnConfCommonElementVo backSignUpElement = null;
        if (bpmVariableSignUp.getAfterSignUpWay() == 1) {
            backSignUpElement = subElementVos.stream().filter(o -> o.getIsBackSignUp() == 1).findFirst().orElse(new BpmnConfCommonElementVo());
            ArrayList assignees = Lists.newArrayList((Object[])new String[]{assignee});
            taskService.setVariable(taskId, backSignUpElement.getCollectionName(), (Object)assignees);
            taskService.setVariable(taskId, StringUtils.join((Object[])new String[]{backSignUpElement.getElementId(), "size"}), (Object)assignees.size());
        }
        ((BpmVariableSignUpPersonnelService)this.getService()).getBaseMapper().delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)bpmVariable.getId())).eq((Object)"element_id", (Object)signUpElement.getElementId()));
        ((BpmVariableSignUpPersonnelService)this.getService()).saveBatch((Collection)signUpUsers.stream().map(o -> BpmVariableSignUpPersonnel.builder().variableId(bpmVariable.getId()).assignee(o.getId()).assigneeName(o.getName()).elementId(signUpElement.getElementId()).build()).collect(Collectors.toList()));
        if (backSignUpElement != null) {
            ((BpmVariableSignUpPersonnelService)this.getService()).save((Object)BpmVariableSignUpPersonnel.builder().variableId(bpmVariable.getId()).assignee(assignee).assigneeName(SecurityUtils.getLogInEmpName()).elementId(backSignUpElement.getElementId()).build());
        }
    }
}

