/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.bpmn.behavior.ParallelGatewayActivityBehavior;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.ProcesTypeEnum;
import org.openoa.base.constant.enums.ProcessEnum;
import org.openoa.base.constant.enums.ProcessNodeEnum;
import org.openoa.base.constant.enums.ProcessStateEnum;
import org.openoa.base.entity.ActHiTaskinst;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmFlowrunEntrust;
import org.openoa.base.entity.BpmVariable;
import org.openoa.base.entity.BpmVariableSignUp;
import org.openoa.base.entity.BpmVerifyInfo;
import org.openoa.base.entity.BpmnNode;
import org.openoa.base.service.BpmVariableService;
import org.openoa.base.service.BpmVariableSignUpPersonnelService;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmVerifyInfoVo;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.common.entity.BpmVariableMultiplayer;
import org.openoa.common.entity.BpmVariableSingle;
import org.openoa.common.mapper.BpmVariableMultiplayerMapper;
import org.openoa.common.mapper.BpmVariableMultiplayerPersonnelMapper;
import org.openoa.common.mapper.BpmVariableSingleMapper;
import org.openoa.common.service.BpmVariableMultiplayerPersonnelServiceImpl;
import org.openoa.common.service.BpmVariableMultiplayerServiceImpl;
import org.openoa.common.service.BpmVariableSingleServiceImpl;
import org.openoa.engine.bpmnconf.common.ActivitiAdditionalInfoServiceImpl;
import org.openoa.engine.bpmnconf.common.ProcessConstants;
import org.openoa.engine.bpmnconf.mapper.BpmBusinessProcessMapper;
import org.openoa.engine.bpmnconf.mapper.BpmFlowrunEntrustMapper;
import org.openoa.engine.bpmnconf.mapper.BpmVariableMapper;
import org.openoa.engine.bpmnconf.mapper.BpmVariableSignUpMapper;
import org.openoa.engine.bpmnconf.mapper.BpmVerifyInfoMapper;
import org.openoa.engine.bpmnconf.mapper.BpmnNodeMapper;
import org.openoa.engine.bpmnconf.mapper.EmployeeMapper;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.ActHiTaskinstServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVerifyInfoBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmFlowrunEntrustService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmVariableSignUpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class BpmVerifyInfoBizServiceImpl
implements BpmVerifyInfoBizService {
    private static final Logger log = LoggerFactory.getLogger(BpmVerifyInfoBizServiceImpl.class);
    @Autowired
    private BpmBusinessProcessServiceImpl bpmBusinessProcessService;
    @Autowired
    private ActHiTaskinstServiceImpl actHiTaskinstService;
    @Autowired
    private BpmVariableService bpmVariableService;
    @Autowired
    private ActivitiAdditionalInfoServiceImpl activitiAdditionalInfoService;
    @Autowired
    private BpmVariableSignUpService bpmVariableSignUpService;
    @Autowired
    private BpmVariableSignUpPersonnelService bpmVariableSignUpPersonnelService;
    @Autowired
    private BpmVariableSingleServiceImpl bpmVariableSingleService;
    @Autowired
    private BpmVariableMultiplayerServiceImpl bpmVariableMultiplayerService;
    @Autowired
    private BpmVariableMultiplayerPersonnelServiceImpl bpmVariableMultiplayerPersonnelService;
    @Autowired
    private BpmnEmployeeInfoProviderService employeeInfoProvider;
    @Resource
    private BpmFlowrunEntrustService bpmFlowrunEntrustService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private BpmBusinessProcessServiceImpl processService;
    @Autowired
    private ProcessConstants processConstants;
    @Autowired
    private EmployeeMapper employeeMapper;
    @Autowired
    private BpmnEmployeeInfoProviderService bpmnEmployeeInfoProviderService;
    @Autowired
    private BpmVariableMapper bpmVariableMapper;
    @Autowired
    private BpmnNodeMapper bpmnNodeMapper;

    @Override
    public List<BpmVerifyInfoVo> getVerifyInfoList(String processCode) {
        List<BpmVerifyInfoVo> bpmVerifyInfoVos = this.verifyInfoList(processCode);
        return bpmVerifyInfoVos;
    }

    @Override
    public List<BpmVerifyInfoVo> getBpmVerifyInfoVos(String processNumber, boolean finishFlag) {
        BpmVerifyInfoVo taskVo;
        ArrayList bpmVerifyInfoVos = Lists.newArrayList();
        BpmBusinessProcess bpmBusinessProcess = (BpmBusinessProcess)((BpmBusinessProcessMapper)this.bpmBusinessProcessService.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().eq((Object)"BUSINESS_NUMBER", (Object)processNumber));
        finishFlag = Objects.equals(bpmBusinessProcess.getProcessState(), ProcessStateEnum.HANDLED_STATE.getCode());
        if (ObjectUtils.isEmpty((Object)bpmBusinessProcess)) {
            return bpmVerifyInfoVos;
        }
        bpmVerifyInfoVos.add(BpmVerifyInfoVo.builder().taskName("\u53d1\u8d77").verifyStatus(Integer.valueOf(1)).verifyUserIds((List)Lists.newArrayList((Object[])new String[]{bpmBusinessProcess.getCreateUser()})).verifyUserName(bpmBusinessProcess.getUserName()).verifyDate(bpmBusinessProcess.getCreateTime()).verifyStatusName("\u63d0\u4ea4").build());
        List<Object> searchBpmVerifyInfoVos = this.verifyInfoList(processNumber, bpmBusinessProcess.getProcInstId());
        searchBpmVerifyInfoVos = searchBpmVerifyInfoVos.stream().sorted(Comparator.comparing(BpmVerifyInfoVo::getVerifyDate)).collect(Collectors.toList());
        bpmVerifyInfoVos.addAll(searchBpmVerifyInfoVos);
        ActHiTaskinst actHiTaskinst = this.actHiTaskinstService.queryLastHisRecord(bpmBusinessProcess.getProcInstId());
        int sort = 0;
        Boolean noApproval = false;
        ArrayList bpmVerifyInfoSortVos = Lists.newArrayList();
        for (BpmVerifyInfoVo bpmVerifyInfoVo2 : bpmVerifyInfoVos) {
            if (bpmVerifyInfoVo2.getVerifyStatus() == 3 || bpmVerifyInfoVo2.getVerifyStatus() == 6) {
                bpmVerifyInfoVo2.setTaskName(actHiTaskinst.getName());
                bpmVerifyInfoVo2.setVerifyStatusName("\u5ba1\u6279\u62d2\u7edd");
                noApproval = true;
            }
            if (bpmVerifyInfoVo2.getVerifyStatus() == 5) {
                String lastAssignee = actHiTaskinst.getAssignee();
                String lastAssigneeName = actHiTaskinst.getAssigneeName();
                BpmVerifyInfoVo vo = new BpmVerifyInfoVo();
                BeanUtils.copyProperties((Object)bpmVerifyInfoVo2, (Object)vo);
                vo.setTaskName("\u53d1\u8d77\u4eba");
                vo.setVerifyUserIds((List)Lists.newArrayList((Object[])new String[]{bpmBusinessProcess.getCreateUser()}));
                vo.setVerifyUserName(bpmBusinessProcess.getUserName());
                vo.setVerifyDate(vo.getVerifyDate());
                vo.setSort(Integer.valueOf(sort));
                ++sort;
                bpmVerifyInfoSortVos.add(vo);
                bpmVerifyInfoVo2.setTaskName(actHiTaskinst.getName());
                bpmVerifyInfoVo2.setVerifyUserId(lastAssignee);
                if (!StringUtils.isEmpty((CharSequence)lastAssigneeName)) {
                    bpmVerifyInfoVo2.setVerifyUserName(lastAssigneeName);
                } else {
                    Map provideEmployeeInfo = this.employeeInfoProvider.provideEmployeeInfo((Collection)Lists.newArrayList((Object[])new String[]{lastAssignee}));
                    bpmVerifyInfoVo2.setVerifyUserName((String)provideEmployeeInfo.get(lastAssignee));
                }
                bpmVerifyInfoVo2.setVerifyDate(null);
                bpmVerifyInfoVo2.setVerifyDesc("");
                bpmVerifyInfoVo2.setVerifyStatus(Integer.valueOf(0));
                bpmVerifyInfoVo2.setVerifyStatusName("");
            }
            bpmVerifyInfoVo2.setSort(Integer.valueOf(sort));
            bpmVerifyInfoSortVos.add(bpmVerifyInfoVo2);
            ++sort;
        }
        bpmVerifyInfoVos.clear();
        bpmVerifyInfoVos.addAll(bpmVerifyInfoSortVos);
        List<BpmVerifyInfoVo> taskInfo = this.findTaskInfo(bpmBusinessProcess);
        if (!ObjectUtils.isEmpty(taskInfo) && !finishFlag) {
            taskVo = taskInfo.get(0);
            taskVo.setSort(Integer.valueOf(sort));
            taskVo.setVerifyStatus(Integer.valueOf(99));
            taskVo.setVerifyStatusName("\u5904\u7406\u4e2d");
            bpmVerifyInfoVos.add(taskVo);
            List flowrunEntrustList = this.bpmFlowrunEntrustService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmFlowrunEntrust::getRuntaskid, (Object)taskVo.getId())).orderByDesc(BpmFlowrunEntrust::getId));
            if (!CollectionUtils.isEmpty((Collection)flowrunEntrustList)) {
                BpmFlowrunEntrust flowrunEntrust = (BpmFlowrunEntrust)flowrunEntrustList.get(0);
                String actual = flowrunEntrust.getActual();
                if (taskVo.getVerifyUserId().equals(actual)) {
                    String actualVerifyUserName = taskVo.getVerifyUserName();
                    String originalName = flowrunEntrust.getOriginalName();
                    taskVo.setVerifyUserName(actualVerifyUserName + " \u4ee3 " + originalName + " \u5ba1\u6279 ");
                }
            }
            ++sort;
            if (taskVo.getElementId().equals(ProcessNodeEnum.START_TASK_KEY.getDesc())) {
                taskVo = new BpmVerifyInfoVo();
                taskVo.setElementId(actHiTaskinst.getTaskDefKey());
                taskVo.setTaskName(actHiTaskinst.getName());
                taskVo.setVerifyStatus(Integer.valueOf(0));
                String lastAssignee = actHiTaskinst.getAssignee();
                Map provideEmployeeInfo = this.employeeInfoProvider.provideEmployeeInfo((Collection)Lists.newArrayList((Object[])new String[]{lastAssignee}));
                String lastVerifierName = (String)provideEmployeeInfo.get(lastAssignee);
                taskVo.setVerifyUserId(lastAssignee);
                taskVo.setVerifyUserName(lastVerifierName);
                String elementId = taskVo.getElementId();
                if (bpmVerifyInfoVos.stream().filter(a -> !StringUtils.isEmpty((CharSequence)a.getElementId())).noneMatch(bpmVerifyInfoVo -> bpmVerifyInfoVo.getElementId().equals(elementId))) {
                    bpmVerifyInfoVos.add(taskVo);
                }
                ++sort;
            }
        } else {
            taskVo = new BpmVerifyInfoVo();
            taskVo.setElementId(actHiTaskinst.getTaskDefKey());
        }
        if (!finishFlag && !noApproval.booleanValue()) {
            this.addBpmVerifyInfoVo(processNumber, sort, bpmVerifyInfoVos, actHiTaskinst.getProcDefId(), bpmBusinessProcess.getProcInstId(), taskVo);
        }
        Integer endVerifyStatus = 100;
        if (bpmBusinessProcess.getProcessState().intValue() == ProcessEnum.COMLETE_STATE.getCode()) {
            endVerifyStatus = 0;
        }
        bpmVerifyInfoVos.add(BpmVerifyInfoVo.builder().taskName("\u6d41\u7a0b\u7ed3\u675f").verifyStatus(endVerifyStatus).build());
        return bpmVerifyInfoVos;
    }

    @Override
    public String findCurrentNodeIds(String processNumber) {
        ActHiTaskinst prevTask;
        BpmBusinessProcess bpmBusinessProcess = (BpmBusinessProcess)((BpmBusinessProcessMapper)this.bpmBusinessProcessService.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().eq((Object)"BUSINESS_NUMBER", (Object)processNumber));
        if (ObjectUtils.isEmpty((Object)bpmBusinessProcess)) {
            return "";
        }
        String procInstId = bpmBusinessProcess.getProcInstId();
        List tasks = Optional.ofNullable(((BpmVerifyInfoMapper)this.getMapper()).findTaskInfor(procInstId)).orElse(Collections.emptyList());
        if (ObjectUtils.isEmpty(tasks)) {
            return "";
        }
        String elementId = ((BpmVerifyInfoVo)tasks.get(0)).getElementId();
        List<String> bpmnNodeIds = this.bpmVariableMapper.getNodeIdsByeElementId(processNumber, elementId);
        if (CollectionUtils.isEmpty(bpmnNodeIds) && (prevTask = this.processConstants.getPrevTask(elementId, procInstId)) != null) {
            String taskDefinitionKey = prevTask.getTaskDefKey();
            bpmnNodeIds = ((BpmVariableSignUpMapper)this.bpmVariableSignUpService.getMapper()).getSignUpPrevNodeIdsByeElementId(processNumber, taskDefinitionKey);
        }
        if (CollectionUtils.isEmpty(bpmnNodeIds)) {
            return "";
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", bpmnNodeIds);
        List bpmnNodes = this.bpmnNodeMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)bpmnNodes)) {
            return "";
        }
        List nodeCollect = bpmnNodes.stream().map(BpmnNode::getNodeId).collect(Collectors.toList());
        return String.join((CharSequence)",", nodeCollect);
    }

    @Override
    public void addVerifyInfo(BpmVerifyInfo verifyInfo) {
        BpmFlowrunEntrust entrustByTaskId = ((BpmFlowrunEntrustMapper)this.bpmFlowrunEntrustService.getMapper()).getEntrustByTaskId(verifyInfo.getVerifyUserId(), verifyInfo.getRunInfoId(), verifyInfo.getTaskId());
        if (entrustByTaskId != null) {
            verifyInfo.setOriginalId(entrustByTaskId.getOriginal());
        }
        ((BpmVerifyInfoMapper)this.getMapper()).insert(verifyInfo);
    }

    @Override
    public void addVerifyInfo(String businessId, String taskId, String remark, Integer businessType, Integer status) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        BpmVerifyInfo verifyInfo = new BpmVerifyInfo();
        verifyInfo.setBusinessId(businessId);
        verifyInfo.setId(null);
        verifyInfo.setBusinessType(businessType);
        verifyInfo.setVerifyDate(new Date());
        verifyInfo.setTaskName(task == null ? "" : task.getName());
        verifyInfo.setVerifyUserName(SecurityUtils.getLogInEmpName());
        verifyInfo.setVerifyUserId(SecurityUtils.getLogInEmpIdStr());
        verifyInfo.setVerifyDesc(Strings.isNullOrEmpty((String)remark) ? "\u540c\u610f" : remark);
        verifyInfo.setVerifyStatus(status);
        ((BpmVerifyInfoMapper)this.getMapper()).insert(verifyInfo);
    }

    @Override
    public List<BpmVerifyInfoVo> getBpmVerifyInfoVoList(List<BpmVerifyInfoVo> list, String procInstId) {
        ArrayList<BpmVerifyInfoVo> infoVoList = new ArrayList<BpmVerifyInfoVo>();
        infoVoList.addAll(list.stream().map(o -> {
            if (!ObjectUtils.isEmpty((Object)o.getOriginalId())) {
                if (!StringUtils.isEmpty((CharSequence)procInstId)) {
                    List bpmFlowrunEntrusts = this.bpmFlowrunEntrustService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"original", (Object)o.getOriginalId())).eq((Object)"runinfoid", (Object)procInstId));
                    if (!CollectionUtils.isEmpty((Collection)bpmFlowrunEntrusts)) {
                        o.setOriginalName(((BpmFlowrunEntrust)bpmFlowrunEntrusts.get(0)).getOriginalName());
                        o.setVerifyUserName(o.getVerifyUserName() + " \u4ee3 " + o.getOriginalName() + " \u5ba1\u6279");
                    }
                } else {
                    Map stringStringMap = this.bpmnEmployeeInfoProviderService.provideEmployeeInfo((Collection)Lists.newArrayList((Object[])new String[]{o.getOriginalId()}));
                    o.setOriginalName((String)stringStringMap.get(o.getOriginalId()));
                    o.setVerifyUserName(o.getVerifyUserName() + " \u4ee3 " + o.getOriginalName() + " \u5ba1\u6279");
                }
            }
            return o;
        }).collect(Collectors.toList()));
        return infoVoList;
    }

    private void addBpmVerifyInfoVo(String processNumber, Integer sort, List<BpmVerifyInfoVo> bpmVerifyInfoVos, String procDefId, String procInstId, BpmVerifyInfoVo taskVo) {
        ActivityImpl activity;
        Map properties;
        Object multiInstance;
        List<ActivityImpl> activitiList = this.activitiAdditionalInfoService.getActivitiList(procDefId);
        BpmVariable bpmVariable = (BpmVariable)this.bpmVariableService.getBaseMapper().selectOne((Wrapper)new QueryWrapper().eq((Object)"process_num", (Object)processNumber));
        if (ObjectUtils.isEmpty((Object)bpmVariable)) {
            return;
        }
        Map<String, List<BaseIdTranStruVo>> nodeApproveds = this.getNodeApproveds(bpmVariable.getId());
        List collect = activitiList.stream().filter(a -> a.getId().equals(taskVo.getElementId())).collect(Collectors.toList());
        if (!collect.isEmpty() && "sequential".equals(multiInstance = (properties = (activity = (ActivityImpl)collect.get(0)).getProperties()).get("multiInstance"))) {
            List<BaseIdTranStruVo> baseIdTranStruVos = nodeApproveds.get(taskVo.getElementId());
            List verifyInfoVos = bpmVerifyInfoVos.stream().filter(a -> taskVo.getElementId().equals(a.getElementId())).collect(Collectors.toList());
            ArrayList<BaseIdTranStruVo> idTranStruVos = new ArrayList<BaseIdTranStruVo>();
            if (!CollectionUtils.isEmpty(baseIdTranStruVos)) {
                for (BaseIdTranStruVo baseIdTranStruVo : baseIdTranStruVos) {
                    for (BpmVerifyInfoVo verifyInfoVo : verifyInfoVos) {
                        if (verifyInfoVo.getVerifyUserIds().contains(baseIdTranStruVo.getId())) continue;
                        idTranStruVos.add(baseIdTranStruVo);
                    }
                }
            }
            for (BaseIdTranStruVo idTranStruVo : idTranStruVos) {
                BpmVerifyInfoVo bpmVerifyInfoVo = BpmVerifyInfoVo.builder().verifyUserId(idTranStruVo.getId()).verifyUserIds((List)Lists.newArrayList((Object[])new String[]{idTranStruVo.getId()})).elementId(taskVo.getElementId()).taskName(taskVo.getTaskName()).verifyUserName(idTranStruVo.getName()).verifyStatus(Integer.valueOf(0)).sort(sort).build();
                bpmVerifyInfoVos.add(bpmVerifyInfoVo);
                Integer n = sort;
                Integer n2 = sort = Integer.valueOf(sort + 1);
            }
        }
        String[] elementIds = taskVo.getElementId().split(",");
        for (int i = 0; i < elementIds.length; ++i) {
            this.doAddBpmVerifyInfoVo(sort, elementIds[i], activitiList, nodeApproveds, bpmVerifyInfoVos, bpmVariable.getId(), i == elementIds.length - 1 && elementIds.length > 1);
        }
    }

    @Override
    public Map<String, String> getSignUpNodeCollectionNameMap(Long variableId) {
        HashMap signUpNodeCollectionNameMap = Maps.newHashMap();
        List bpmVariableSignUps = this.bpmVariableSignUpService.getBaseMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId));
        for (BpmVariableSignUp variableSignUp : bpmVariableSignUps) {
            List bpmnConfCommonElementVos;
            if (ObjectUtils.isEmpty((Object)variableSignUp.getSubElements()) || ObjectUtils.isEmpty((Object)(bpmnConfCommonElementVos = JSON.parseArray((String)variableSignUp.getSubElements(), BpmnConfCommonElementVo.class)))) continue;
            for (BpmnConfCommonElementVo bpmnConfCommonElementVo : bpmnConfCommonElementVos) {
                signUpNodeCollectionNameMap.put(bpmnConfCommonElementVo.getElementId(), bpmnConfCommonElementVo.getCollectionName());
            }
        }
        return signUpNodeCollectionNameMap;
    }

    private void doAddBpmVerifyInfoVo(Integer sort, String elementId, List<ActivityImpl> activitiList, Map<String, List<BaseIdTranStruVo>> nodeApproveds, List<BpmVerifyInfoVo> bpmVerifyInfoVos, Long variableId, boolean includeParallelGateway) {
        Object name;
        Object emplIdStr;
        boolean isCurrentParallelGateway;
        List<PvmActivity> nextElements = this.activitiAdditionalInfoService.getNextElementList(elementId, activitiList);
        boolean bl = isCurrentParallelGateway = nextElements.size() > 1;
        if (CollectionUtils.isEmpty(nextElements)) {
            return;
        }
        ArrayList<String> empIds = new ArrayList<String>();
        ArrayList emplNames = Lists.newArrayList();
        for (PvmActivity nextElement : nextElements) {
            List<BaseIdTranStruVo> baseIdTranStruVos = nodeApproveds.get(nextElement.getId());
            if (ObjectUtils.isEmpty(baseIdTranStruVos)) continue;
            for (BaseIdTranStruVo empBaseInfo : baseIdTranStruVos) {
                emplIdStr = empBaseInfo.getId();
                name = empBaseInfo.getName();
                empIds.add((String)emplIdStr);
                emplNames.add(name);
            }
        }
        String verifyUserName = "";
        verifyUserName = !CollectionUtils.isEmpty((Collection)emplNames) ? StringUtils.join((Iterable)emplNames, (String)",") : this.activitiAdditionalInfoService.getVerifyUserNameFromHis(nextElements.get(0).getId(), variableId);
        StringBuilder nameSb = new StringBuilder();
        StringBuilder elementIdSb = new StringBuilder();
        for (int i = 0; i < nextElements.size(); ++i) {
            PvmActivity currElement = nextElements.get(i);
            if (i != nextElements.size() - 1) {
                nameSb.append(currElement.getProperty("name")).append("||");
                elementIdSb.append(currElement.getId()).append(",");
                continue;
            }
            nameSb.append(currElement.getProperty("name"));
            elementIdSb.append(currElement.getId());
        }
        BpmVerifyInfoVo bpmVerifyInfoVo = BpmVerifyInfoVo.builder().elementId(elementIdSb.toString()).taskName(nameSb.toString()).verifyDesc("").verifyStatus(Integer.valueOf(0)).verifyUserIds(empIds).verifyUserName(verifyUserName).sort(sort).build();
        if (!ObjectUtils.isEmpty((Object)bpmVerifyInfoVo.getVerifyUserName()) && !bpmVerifyInfoVo.getTaskName().equals("EndEvent")) {
            boolean noneMatch = bpmVerifyInfoVos.stream().filter(a -> !StringUtils.isEmpty((CharSequence)a.getElementId())).noneMatch(vo -> vo.getElementId().equals(bpmVerifyInfoVo.getElementId()));
            if (noneMatch) {
                bpmVerifyInfoVos.add(bpmVerifyInfoVo);
            }
            emplIdStr = sort;
            sort = sort + 1;
            name = sort;
        }
        for (int i = 0; i < nextElements.size(); ++i) {
            PvmActivity nextNextElement;
            PvmActivity nextElement = nextElements.get(i);
            if (nextElements.size() > 1) {
                boolean bl2 = includeParallelGateway = isCurrentParallelGateway && i == nextElements.size() - 1;
            }
            if (ObjectUtils.isEmpty((Object)(nextNextElement = this.activitiAdditionalInfoService.getNextElement(nextElement.getId(), activitiList)))) continue;
            boolean isNextParallelGateway = ((ActivityImpl)nextNextElement).getActivityBehavior() instanceof ParallelGatewayActivityBehavior;
            if (!includeParallelGateway && isNextParallelGateway) continue;
            this.doAddBpmVerifyInfoVo(sort, nextElement.getId(), activitiList, nodeApproveds, bpmVerifyInfoVos, variableId, includeParallelGateway);
        }
    }

    public List<BpmVerifyInfoVo> findTaskInfo(BpmBusinessProcess bpmBusinessProcess) {
        String procInstId = bpmBusinessProcess.getProcInstId();
        List tasks = Optional.ofNullable(((BpmVerifyInfoMapper)this.getMapper()).findTaskInfor(procInstId)).orElse(Collections.emptyList());
        if (ObjectUtils.isEmpty(tasks)) {
            return Lists.newArrayList();
        }
        List verifyUserIds = tasks.stream().map(BpmVerifyInfoVo::getVerifyUserId).collect(Collectors.toList());
        Integer isOutSideProcess = bpmBusinessProcess.getIsOutSideProcess();
        Map<String, String> stringStringMap = null;
        stringStringMap = Objects.equals(isOutSideProcess, 1) ? tasks.stream().collect(Collectors.toMap(BpmVerifyInfoVo::getVerifyUserId, BpmVerifyInfoVo::getVerifyUserName, (k1, k2) -> k1)) : this.bpmnEmployeeInfoProviderService.provideEmployeeInfo(verifyUserIds);
        for (BpmVerifyInfoVo task : tasks) {
            String verifyUidStr = task.getVerifyUserId();
            String verifyUserName = stringStringMap.get(verifyUidStr);
            task.setVerifyUserName(verifyUserName);
        }
        ArrayList taskInfors = Lists.newArrayList();
        if (tasks.size() > 1) {
            String verifyUserName = StringUtils.join((Iterable)tasks.stream().map(BpmVerifyInfoVo::getVerifyUserName).collect(Collectors.toList()), (String)",");
            String taskName = "";
            List strs = tasks.stream().map(BpmVerifyInfoVo::getTaskName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(strs)) {
                taskName = String.join((CharSequence)"||", strs);
            }
            String elementId = tasks.stream().map(BpmVerifyInfoVo::getElementId).collect(Collectors.joining(","));
            taskInfors.add(BpmVerifyInfoVo.builder().verifyUserIds(verifyUserIds).verifyUserName(verifyUserName).taskName(taskName).elementId(elementId).build());
        } else {
            ((BpmVerifyInfoVo)tasks.get(0)).setVerifyUserIds(verifyUserIds);
            taskInfors.add(tasks.get(0));
        }
        return taskInfors;
    }

    private Map<String, List<BaseIdTranStruVo>> getNodeApproveds(Long variableId) {
        List bpmVariableMultiplayers;
        HashMap nodeApprovedsMap = Maps.newHashMap();
        List variableSingles = ((BpmVariableSingleMapper)this.bpmVariableSingleService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId));
        if (!variableSingles.isEmpty()) {
            for (BpmVariableSingle bpmVariableSingle : variableSingles) {
                nodeApprovedsMap.put(bpmVariableSingle.getElementId(), Lists.newArrayList((Object[])new BaseIdTranStruVo[]{BaseIdTranStruVo.builder().id(bpmVariableSingle.getAssignee()).name(bpmVariableSingle.getAssigneeName()).build()}));
            }
        }
        if (!(bpmVariableMultiplayers = ((BpmVariableMultiplayerMapper)this.bpmVariableMultiplayerService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId))).isEmpty()) {
            for (BpmVariableMultiplayer bpmVariableMultiplayer : bpmVariableMultiplayers) {
                List bpmVariableMultiplayerPersonnels = ((BpmVariableMultiplayerPersonnelMapper)this.bpmVariableMultiplayerPersonnelService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().eq((Object)"variable_multiplayer_id", (Object)bpmVariableMultiplayer.getId()));
                if (ObjectUtils.isEmpty((Object)bpmVariableMultiplayerPersonnels)) continue;
                nodeApprovedsMap.put(bpmVariableMultiplayer.getElementId(), bpmVariableMultiplayerPersonnels.stream().map(a -> BaseIdTranStruVo.builder().id(a.getAssignee()).name(a.getAssigneeName()).build()).collect(Collectors.toList()));
            }
        }
        return nodeApprovedsMap;
    }

    public List<BpmVerifyInfoVo> getBpmVerifyInfoVoList(List<BpmVerifyInfoVo> list) {
        return this.getBpmVerifyInfoVoList(list, null);
    }

    public List<BpmVerifyInfoVo> findVerifyInfo(BpmBusinessProcess bpmBusinessProcess) {
        Integer business_type = ProcesTypeEnum.getCodeByDesc((String)bpmBusinessProcess.getBusinessNumber().split("\\_")[0].toString());
        List<BpmVerifyInfoVo> bpmVerifyInfoVo = this.findTaskInfo(bpmBusinessProcess);
        List<BpmVerifyInfoVo> list = this.getBpmVerifyInfoVoList(((BpmVerifyInfoMapper)this.getMapper()).getVerifyInfo(BpmVerifyInfoVo.builder().businessId(bpmBusinessProcess.getBusinessId().toString()).businessType(business_type).build()));
        if (!ObjectUtils.isEmpty(bpmVerifyInfoVo)) {
            bpmVerifyInfoVo.addAll(list);
            return bpmVerifyInfoVo;
        }
        return list;
    }

    @Override
    public List<BpmVerifyInfoVo> verifyInfoList(BpmBusinessProcess bpmBusinessProcess) {
        List<BpmVerifyInfoVo> bpmVerifyInfoVo = Optional.ofNullable(this.findTaskInfo(bpmBusinessProcess)).orElse(Arrays.asList(new BpmVerifyInfoVo[0]));
        List<BpmVerifyInfoVo> list = this.getBpmVerifyInfoVoList(Optional.ofNullable(((BpmVerifyInfoMapper)this.getMapper()).getVerifyInfo(BpmVerifyInfoVo.builder().processCode(bpmBusinessProcess.getBusinessNumber()).build())).orElse(Arrays.asList(new BpmVerifyInfoVo[0])));
        if (!ObjectUtils.isEmpty(bpmVerifyInfoVo)) {
            bpmVerifyInfoVo.addAll(list);
            return bpmVerifyInfoVo;
        }
        return list;
    }

    @Override
    public List<BpmVerifyInfoVo> verifyInfoList(String processNumber) {
        return this.verifyInfoList(processNumber, null);
    }

    @Override
    public List<BpmVerifyInfoVo> verifyInfoList(String processNumber, String procInstId) {
        return this.getBpmVerifyInfoVoList(Optional.ofNullable(((BpmVerifyInfoMapper)this.getMapper()).getVerifyInfo(BpmVerifyInfoVo.builder().processCode(processNumber).build())).orElse(Arrays.asList(new BpmVerifyInfoVo[0])), procInstId);
    }
}

