/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.BpmnConfFlagsEnum;
import org.openoa.base.constant.enums.BpmnNodeParamTypeEnum;
import org.openoa.base.constant.enums.ButtonPageTypeEnum;
import org.openoa.base.constant.enums.ButtonTypeEnum;
import org.openoa.base.constant.enums.DeduplicationTypeEnum;
import org.openoa.base.constant.enums.EventTypeEnum;
import org.openoa.base.constant.enums.InformEnum;
import org.openoa.base.constant.enums.MessageSendTypeEnum;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.constant.enums.ViewPageTypeEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.BpmProcessAppApplication;
import org.openoa.base.entity.BpmProcessForward;
import org.openoa.base.entity.BpmVariable;
import org.openoa.base.entity.BpmnApproveRemind;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.entity.BpmnNode;
import org.openoa.base.entity.BpmnNodeButtonConf;
import org.openoa.base.entity.BpmnNodeLabel;
import org.openoa.base.entity.BpmnNodeLfFormdataFieldControl;
import org.openoa.base.entity.BpmnNodeSignUpConf;
import org.openoa.base.entity.BpmnTemplate;
import org.openoa.base.entity.BpmnViewPageButton;
import org.openoa.base.entity.InformationTemplate;
import org.openoa.base.entity.OutSideBpmBusinessParty;
import org.openoa.base.entity.OutSideBpmCallbackUrlConf;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.FormOperationAdaptor;
import org.openoa.base.service.BpmVariableService;
import org.openoa.base.service.ProcessorFactory;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.util.AssertUtil;
import org.openoa.base.util.BpmnUtils;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.PageUtils;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.util.StrUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BaseNumIdStruVo;
import org.openoa.base.vo.BpmVerifyInfoVo;
import org.openoa.base.vo.BpmnApproveRemindVo;
import org.openoa.base.vo.BpmnConfCommonButtonPropertyVo;
import org.openoa.base.vo.BpmnConfCommonVo;
import org.openoa.base.vo.BpmnConfViewPageButtonVo;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnNodeButtonConfBaseVo;
import org.openoa.base.vo.BpmnNodeLabelVO;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsExtendVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.base.vo.BpmnTemplateVo;
import org.openoa.base.vo.BpmnViewPageButtonBaseVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.base.vo.DIYProcessInfoDTO;
import org.openoa.base.vo.LFFieldControlVO;
import org.openoa.base.vo.NodeLabelConstants;
import org.openoa.base.vo.PreviewNode;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.common.adaptor.bpmnelementadp.BpmnNodeFormatImpl;
import org.openoa.common.adaptor.bpmnelementadp.BpmnOptionalDuplicatesAdaptor;
import org.openoa.common.adaptor.bpmnelementadp.BpmnOptionalDuplicatesImpl;
import org.openoa.common.formatter.BpmnPersonnelFormat;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.adp.formatter.BpmnRemoveConfFormatFactory;
import org.openoa.engine.bpmnconf.adp.formatter.BpmnStartFormatFactory;
import org.openoa.engine.bpmnconf.common.NodeAdditionalInfoServiceImpl;
import org.openoa.engine.bpmnconf.common.TaskMgmtServiceImpl;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.mapper.BpmnConfMapper;
import org.openoa.engine.bpmnconf.mapper.BpmnNodeMapper;
import org.openoa.engine.bpmnconf.service.biz.BpmVerifyInfoBizServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmnCreateBpmnAndStartImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmnDeduplicationFormatImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmnInsertVariablesImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmnViewPageButtonBizServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessNameBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnConfBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnConfNoticeTemplateBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnCreateBpmnAndStart;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnDeduplicationFormat;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnInsertVariables;
import org.openoa.engine.bpmnconf.service.interf.repository.ApplicationService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmNodeLabelsService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessAppApplicationService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessForwardService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnApproveRemindService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnConfService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnNodeButtonConfService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnNodeLfFormdataFieldControlService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnNodeService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnNodeSignUpConfService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnNodeToService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnTemplateService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnViewPageButtonService;
import org.openoa.engine.bpmnconf.service.interf.repository.InformationTemplateService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmBusinessPartyService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmCallbackUrlConfService;
import org.openoa.engine.factory.FormFactory;
import org.openoa.engine.factory.IAdaptorFactory;
import org.openoa.engine.utils.AFWrappers;
import org.openoa.engine.vo.BpmProcessAppApplicationVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class BpmnConfBizServiceImpl
implements BpmnConfBizService {
    private static final Logger log = LoggerFactory.getLogger(BpmnConfBizServiceImpl.class);
    @Autowired
    private BpmnNodeServiceImpl nodeService;
    @Autowired
    private FormFactory formFactory;
    @Autowired
    private BpmnRemoveConfFormatFactory bpmnRemoveConfFormatFactory;
    @Autowired
    private BpmnStartFormatFactory bpmnStartFormatFactory;
    @Autowired
    private BpmnPersonnelFormat bpmnPersonnelFormat;
    @Autowired
    private BpmVariableBizService bpmVariableBizService;
    @Autowired
    private BpmVerifyInfoBizServiceImpl bpmVerifyInfoBizService;
    @Autowired
    private BpmProcessForwardService processForwardService;
    @Autowired
    private NodeAdditionalInfoServiceImpl nodeAdditionalInfoService;
    private static final String linkMark = "_";
    @Autowired
    private BpmnNodeService bpmnNodeService;
    @Autowired
    private BpmnViewPageButtonService bpmnViewPageButtonService;
    @Autowired
    private BpmnNodeToService bpmnNodeToService;
    @Autowired
    private BpmnTemplateService bpmnTemplateService;
    @Autowired
    private InformationTemplateService informationTemplateService;
    @Autowired
    private BpmnNodeButtonConfService bpmnNodeButtonConfService;
    @Autowired
    private BpmnNodeSignUpConfService bpmnNodeSignUpConfService;
    @Autowired
    private BpmnApproveRemindService bpmnApproveRemindService;
    @Autowired
    private BpmnConfNoticeTemplateBizService bpmnConfNoticeTemplateBizService;
    @Autowired
    private BpmnViewPageButtonBizServiceImpl bpmnViewPageButtonBizService;
    @Autowired
    private BpmProcessNameBizService bpmProcessNameService;
    @Autowired
    private BpmnEmployeeInfoProviderService employeeInfoProvider;
    @Autowired
    @Lazy
    private OutSideBpmBusinessPartyService outSideBpmBusinessPartyService;
    @Autowired
    @Lazy
    private OutSideBpmCallbackUrlConfService outSideBpmCallbackUrlConfService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private IAdaptorFactory adaptorFactory;
    @Autowired
    private BpmnNodeLfFormdataFieldControlService nodeLfFormdataFieldControlService;
    @Autowired
    private BpmNodeLabelsService nodeLabelsService;
    @Autowired
    @Lazy
    private BpmProcessAppApplicationService bpmProcessAppApplicationService;
    @Autowired
    private TaskMgmtServiceImpl TaskMgmtService;

    @Override
    @Transactional
    public void edit(BpmnConfVo bpmnConfVo) {
        String bpmnName = bpmnConfVo.getBpmnName();
        String bpmnCode = this.getBpmnCode(bpmnName);
        String formCode = bpmnConfVo.getFormCode();
        BpmnConf bpmnConf = new BpmnConf();
        BeanUtils.copyProperties((Object)bpmnConfVo, (Object)bpmnConf);
        bpmnConf.setBpmnCode(bpmnCode);
        bpmnConf.setFormCode(formCode);
        bpmnConf.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
        bpmnConf.setCreateTime(new Date());
        bpmnConf.setUpdateUser(SecurityUtils.getLogInEmpNameSafe());
        bpmnConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
        bpmnConfVo.setUpdateTime(new Date());
        ((BpmnConfMapper)this.getMapper()).insert(bpmnConf);
        this.bpmnConfNoticeTemplateBizService.insert(bpmnCode);
        Long confId = bpmnConf.getId();
        if (confId == null) {
            throw new AFBizException(Strings.lenientFormat((String)"conf id for formcode:%s can not be null", (Object[])new Object[]{formCode}));
        }
        bpmnConfVo.setId(confId);
        this.bpmnViewPageButtonBizService.editBpmnViewPageButton(bpmnConfVo, confId);
        this.bpmnTemplateService.editBpmnTemplate(bpmnConfVo, confId);
        Integer isOutSideProcess = bpmnConfVo.getIsOutSideProcess();
        Integer isLowCodeFlow = bpmnConfVo.getIsLowCodeFlow();
        ProcessorFactory.executePreWriteProcessors((Object)bpmnConfVo);
        List confNodes = bpmnConfVo.getNodes();
        int hasStartUserChooseModules = 0;
        int hasCopy = 0;
        int hasLastNodeCopy = 0;
        for (BpmnNodeVo bpmnNodeVo : confNodes) {
            if (bpmnNodeVo.getNodeType().intValue() == NodeTypeEnum.NODE_TYPE_APPROVER.getCode().intValue() && ObjectUtils.isEmpty((Object)bpmnNodeVo.getNodeProperty())) {
                throw new AFBizException("apporver node has no property,can not be saved\uff01");
            }
            if (NodePropertyEnum.NODE_PROPERTY_CUSTOMIZE.getCode().equals(bpmnNodeVo.getNodeProperty())) {
                hasStartUserChooseModules = BpmnConfFlagsEnum.HAS_STARTUSER_CHOOSE_MODULES.getCode();
            }
            if (NodeTypeEnum.NODE_TYPE_COPY.getCode().equals(bpmnNodeVo.getNodeType())) {
                hasCopy = BpmnConfFlagsEnum.HAS_COPY.getCode();
            }
            bpmnNodeVo.setIsOutSideProcess(isOutSideProcess);
            bpmnNodeVo.setIsLowCodeFlow(isLowCodeFlow);
            bpmnNodeVo.setNodeProperty(Optional.ofNullable(bpmnNodeVo.getNodeProperty()).orElse(1));
            BpmnNode bpmnNode = new BpmnNode();
            BeanUtils.copyProperties((Object)bpmnNodeVo, (Object)bpmnNode);
            bpmnNode.setConfId(confId);
            bpmnNode.setCreateTime(new Date());
            bpmnNode.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
            bpmnNode.setTenantId(MultiTenantUtil.getCurrentTenantId());
            this.bpmnNodeService.getBaseMapper().insert((Object)bpmnNode);
            Long bpmnNodeId = bpmnNode.getId();
            if (bpmnNodeId == null) {
                throw new AFBizException("can not get bpmn node id!");
            }
            this.bpmnNodeToService.editNodeTo(bpmnNodeVo, bpmnNodeId);
            this.bpmnNodeButtonConfService.editButtons(bpmnNodeVo, bpmnNodeId);
            this.bpmnNodeSignUpConfService.editSignUpConf(bpmnNodeVo, bpmnNodeId);
            bpmnNodeVo.setId(bpmnNodeId);
            bpmnNodeVo.setConfId(confId);
            bpmnNodeVo.setFormCode(formCode);
            BpmnNodeAdpConfEnum bpmnNodeAdpConfEnum = NodeAdditionalInfoServiceImpl.getBpmnNodeAdpConfEnum(bpmnNodeVo);
            if (ObjectUtils.isEmpty((Object)((Object)bpmnNodeAdpConfEnum))) continue;
            this.bpmnTemplateService.editBpmnTemplate(bpmnNodeVo);
            this.bpmnApproveRemindService.editBpmnApproveRemind(bpmnNodeVo);
            BpmnNodeAdaptor bpmnNodeAdaptor = this.nodeAdditionalInfoService.getBpmnNodeAdaptor(bpmnNodeAdpConfEnum);
            bpmnNodeAdaptor.editBpmnNode(bpmnNodeVo);
            if (!NodeTypeEnum.NODE_TYPE_COPY.getCode().equals(bpmnNodeVo.getNodeType()) || !CollectionUtils.isEmpty((Collection)bpmnNodeVo.getNodeTo())) continue;
            hasLastNodeCopy = BpmnConfFlagsEnum.HAS_LAST_NODE_COPY.getCode();
        }
        ProcessorFactory.executePostProcessors((Object)bpmnConfVo);
        Integer extraFlags = bpmnConfVo.getExtraFlags();
        Integer currentFlags = hasStartUserChooseModules | hasCopy | hasLastNodeCopy;
        if (currentFlags != null && currentFlags > 0) {
            Integer binariedOr = BpmnConfFlagsEnum.binaryOr((Integer)extraFlags, (Integer)currentFlags);
            bpmnConfVo.setExtraFlags(binariedOr);
        }
        if (bpmnConfVo.getExtraFlags() != null) {
            BpmnConf postConf = new BpmnConf();
            postConf.setId(confId);
            postConf.setExtraFlags(bpmnConfVo.getExtraFlags());
            ((BpmnConfService)this.getService()).updateById(postConf);
        }
    }

    private String getBpmnCode(String bpmnName) {
        BpmnConf.validateBpmnName((String)bpmnName);
        String bpmnFirstLetters = StrUtils.getFirstLetters((String)bpmnName);
        String maxBpmnCode = this.getMaxBpmnCode(bpmnFirstLetters);
        if (!Strings.isNullOrEmpty((String)maxBpmnCode)) {
            return this.reCheckBpmnCode(bpmnFirstLetters, maxBpmnCode);
        }
        return this.reCheckBpmnCode(bpmnFirstLetters, bpmnFirstLetters);
    }

    private String getMaxBpmnCode(String bpmnCodeParts) {
        return ((BpmnConfMapper)this.getMapper()).getMaxBpmnCode(bpmnCodeParts);
    }

    private String reCheckBpmnCode(String bpmnCodeParts, String bpmnCode) {
        long count = ((BpmnConfMapper)this.getMapper()).selectCount((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmnConf::getBpmnCode, (Object)bpmnCode));
        if (count == 0L) {
            return bpmnCode;
        }
        String reJoinedBpmnCode = StrUtils.joinBpmnCode((String)bpmnCodeParts, (String)bpmnCode);
        return this.reCheckBpmnCode(bpmnCodeParts, reJoinedBpmnCode);
    }

    @Override
    public BpmnConf getBpmnConfByFormCode(String formCode) {
        return (BpmnConf)Optional.ofNullable(((BpmnConfService)this.getService()).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"form_code", (Object)formCode)).eq((Object)"effective_status", (Object)1))).orElse(new BpmnConf());
    }

    @Override
    public List<BpmnConf> getBpmnConfByFormCodeBatch(List<String> formCodes) {
        return ((BpmnConfService)this.getService()).list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"form_code", formCodes)).eq((Object)"effective_status", (Object)1));
    }

    @Override
    public void updateBpmnConfByCode(Integer appId, Integer bpmnType, Integer isAll, String bpmnCode) {
        ((BpmnConfService)this.getService()).update(BpmnConf.builder().appId(appId).bpmnType(bpmnType).isAll(isAll).build(), (Wrapper)new QueryWrapper().eq((Object)"bpmn_code", (Object)bpmnCode));
    }

    @Override
    public void startProcess(String bpmnCode, BpmnStartConditionsVo bpmnStartConditions) {
        BpmnConfVo bpmnConfVo = this.detail(bpmnCode);
        bpmnStartConditions.setPreview(false);
        BpmnConfVo confVo = this.getBpmnConfVo(bpmnStartConditions, bpmnConfVo);
        BpmnConfCommonVo bpmnConfCommonVo = BpmnConfCommonVo.builder().bpmnCode(confVo.getBpmnCode()).formCode(confVo.getFormCode()).bpmnName(confVo.getBpmnName()).processNum(bpmnStartConditions.getProcessNum()).processName(bpmnConfVo.getBpmnName()).processDesc(bpmnStartConditions.getProcessDesc()).templateVos(bpmnConfVo.getTemplateVos()).build();
        this.setViewPageButtons(bpmnConfVo, bpmnConfCommonVo);
        BpmnNodeFormatImpl bpmnNodeFormat = (BpmnNodeFormatImpl)SpringBeanUtils.getBean(BpmnNodeFormatImpl.class);
        bpmnConfCommonVo.setElementList(bpmnNodeFormat.getBpmnConfCommonElementVoList(bpmnConfCommonVo, confVo.getNodes(), bpmnStartConditions));
        BpmnInsertVariables bpmnInsertVariables = (BpmnInsertVariables)SpringBeanUtils.getBean(BpmnInsertVariablesImpl.class);
        if (Boolean.TRUE.equals(bpmnStartConditions.getIsMigration())) {
            this.bpmVariableBizService.deleteByProcessNumber(bpmnStartConditions.getProcessNum());
        }
        bpmnInsertVariables.insertVariables(bpmnConfCommonVo, bpmnStartConditions);
        BpmnCreateBpmnAndStart bpmnCreateBpmnAndStart = (BpmnCreateBpmnAndStart)SpringBeanUtils.getBean(BpmnCreateBpmnAndStartImpl.class);
        bpmnCreateBpmnAndStart.createBpmnAndStart(bpmnConfCommonVo, bpmnStartConditions);
    }

    @Override
    public PreviewNode previewNode(String params) {
        return this.getPreviewNode(params, false);
    }

    @Override
    public PreviewNode startPagePreviewNode(String params) {
        return this.getPreviewNode(params, true);
    }

    public PreviewNode taskPagePreviewNode(String params) {
        JSONObject jsonObject = JSONObject.parseObject((String)params);
        String processNumber = jsonObject.getString("processNumber");
        Boolean isLowCodeFlow = jsonObject.getBoolean("isLowCodeFlow");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"process_num", (Object)processNumber);
        BpmVariable bpmnVariable = (BpmVariable)((BpmVariableService)this.bpmVariableBizService.getService()).getOne((Wrapper)wrapper);
        String processStartConditions = bpmnVariable.getProcessStartConditions();
        JSONObject objectStart = JSON.parseObject((String)processStartConditions);
        objectStart.put((Object)"bpmnCode", (Object)bpmnVariable.getBpmnCode());
        objectStart.put((Object)"isLowCodeFlow", (Object)Boolean.TRUE.equals(isLowCodeFlow));
        objectStart.put((Object)"processNumber", (Object)processNumber);
        return this.getPreviewNode(objectStart.toString(), false);
    }

    @Override
    public List<BpmVerifyInfoVo> appStartPagePreviewNode(String params) {
        ArrayList bpmVerifyInfoVos = Lists.newArrayList();
        bpmVerifyInfoVos.add(BpmVerifyInfoVo.builder().taskName("\u53d1\u8d77").build());
        PreviewNode previewNode = this.getPreviewNode(params, true);
        if (!ObjectUtils.isEmpty((Object)previewNode.getBpmnNodeList())) {
            List bpmnNodeList = previewNode.getBpmnNodeList();
            BpmnNodeVo startNode = bpmnNodeList.stream().filter(o -> o.getNodeType().equals(NodeTypeEnum.NODE_TYPE_START.getCode())).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)startNode)) {
                throw new AFBizException("can't find out the start node\uff01");
            }
            this.addBpmVerifyInfoVo(startNode, bpmnNodeList, bpmVerifyInfoVos);
        }
        bpmVerifyInfoVos.add(BpmVerifyInfoVo.builder().taskName("\u6d41\u7a0b\u7ed3\u675f").build());
        return bpmVerifyInfoVos;
    }

    @Override
    public boolean migrationCheckConditionsChange(BusinessDataVo vo) {
        block4: {
            BpmnConf bpmnConf = (BpmnConf)((BpmnConfService)this.getService()).getOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_code", (Object)vo.getBpmnCode()));
            if (bpmnConf == null) {
                throw new AFBizException("\u672a\u627e\u5230\u5bf9\u5e94\u7684 bpmnConf \u8bb0\u5f55");
            }
            BpmnConfVo bpmnConfVo = new BpmnConfVo();
            BeanUtils.copyProperties((Object)bpmnConf, (Object)bpmnConfVo);
            FormOperationAdaptor formAdapter = this.formFactory.getFormAdaptor(vo);
            BpmnStartConditionsVo bpmnStartConditionsVo = formAdapter.launchParameters(vo);
            bpmnStartConditionsVo.setPreview(true);
            bpmnStartConditionsVo.setProcessNum(vo.getProcessNumber());
            bpmnStartConditionsVo.setIsMigration(Boolean.valueOf(true));
            List bpmnNodes = ((BpmnNodeMapper)this.nodeService.getBaseMapper()).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"conf_id", (Object)bpmnConf.getId())).eq((Object)"is_del", (Object)0));
            Map<Long, List<String>> bpmnNodeToMap = this.nodeAdditionalInfoService.getBpmnNodeToMap(bpmnNodes.stream().map(BpmnNode::getId).collect(Collectors.toList()));
            List bpmnNodeVoList = bpmnNodes.stream().map(bpmnNode -> {
                BpmnNodeVo bpmnNodeVo = new BpmnNodeVo();
                BeanUtils.copyProperties((Object)bpmnNode, (Object)bpmnNodeVo);
                List nodeToIds = (List)bpmnNodeToMap.get(bpmnNode.getId());
                bpmnNodeVo.setNodeTo(nodeToIds);
                BpmnNodeAdaptor bpmnNodeAdaptor = this.nodeAdditionalInfoService.getBpmnNodeAdaptor(NodeAdditionalInfoServiceImpl.getBpmnNodeAdpConfEnum(bpmnNodeVo));
                if (bpmnNodeAdaptor == null) {
                    return bpmnNodeVo;
                }
                bpmnNodeAdaptor.formatToBpmnNodeVo(bpmnNodeVo);
                return bpmnNodeVo;
            }).collect(Collectors.toList());
            bpmnConfVo.setNodes(bpmnNodeVoList);
            try {
                this.bpmnStartFormatFactory.formatBpmnConf(bpmnConfVo, bpmnStartConditionsVo);
            }
            catch (Exception ex) {
                if (!(ex instanceof AFBizException)) break block4;
                String code = ((AFBizException)((Object)ex)).getCode();
                if ("condition_changed".equals(code)) {
                    return true;
                }
                throw ex;
            }
        }
        return false;
    }

    @Override
    public List<BpmnNodeVo> setNodeFrom(List<BpmnNodeVo> nodeList) {
        HashMap<String, BpmnNodeVo> map = new HashMap<String, BpmnNodeVo>(nodeList.size());
        BpmnNodeVo startNode = BpmnConfBizServiceImpl.getNodeMapAndStartNode(nodeList, map);
        ArrayList<BpmnNodeVo> resultList = new ArrayList<BpmnNodeVo>();
        BpmnNodeVo lastNode = new BpmnNodeVo();
        lastNode.setNodeId("");
        BpmnNodeVo nowNode = startNode;
        if (nowNode != null) {
            while (true) {
                if (BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE.getCode().equals(nowNode.getParams().getParamType())) {
                    nowNode.getParams().setAssigneeList(Arrays.asList(nowNode.getParams().getAssignee()));
                }
                nowNode.setNodePropertyName(NodePropertyEnum.getDescByCode((Integer)nowNode.getNodeProperty()));
                if (StringUtils.isBlank((CharSequence)nowNode.getParams().getNodeTo())) {
                    nowNode.setNodeFrom(lastNode.getNodeId());
                    resultList.add(nowNode);
                    break;
                }
                if (resultList.size() > nodeList.size()) {
                    log.info("error occur while set nodeFrom info,nodeList:{}", (Object)JSON.toJSONString(nodeList));
                    throw new AFBizException("999", "nodeId\u6570\u636e\u9519\u8bef");
                }
                nowNode.setNodeFrom(lastNode.getNodeId());
                resultList.add(nowNode);
                lastNode = nowNode;
                nowNode = (BpmnNodeVo)map.get(nowNode.getParams().getNodeTo());
            }
        }
        return resultList;
    }

    @Override
    public List<BpmnNodeVo> setNodeFromV2(List<BpmnNodeVo> nodeList) {
        HashMap<String, BpmnNodeVo> map = new HashMap<String, BpmnNodeVo>(nodeList.size());
        BpmnNodeVo startNode = BpmnConfBizServiceImpl.getNodeMapAndStartNode(nodeList, map);
        ArrayList<BpmnNodeVo> resultList = new ArrayList<BpmnNodeVo>();
        BpmnNodeVo lastNode = new BpmnNodeVo();
        lastNode.setNodeId("");
        BpmnNodeVo nowNode = startNode;
        if (nowNode != null) {
            while (true) {
                if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nowNode.getNodeType())) {
                    BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)nowNode, nodeList);
                    this.treatParallelGateWayRecursively(nowNode, lastNode, aggregationNode, map, resultList, new HashSet<String>());
                    nowNode = (BpmnNodeVo)map.get(aggregationNode.getParams().getNodeTo());
                    lastNode = aggregationNode;
                }
                if (nowNode == null) break;
                if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nowNode.getNodeType())) continue;
                if (BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE.getCode().equals(nowNode.getParams().getParamType())) {
                    nowNode.getParams().setAssigneeList(Collections.singletonList(nowNode.getParams().getAssignee()));
                }
                nowNode.setNodePropertyName(NodePropertyEnum.getDescByCode((Integer)nowNode.getNodeProperty()));
                if (StringUtils.isBlank((CharSequence)nowNode.getParams().getNodeTo())) {
                    nowNode.setNodeFrom(lastNode.getNodeId());
                    resultList.add(nowNode);
                    break;
                }
                if (resultList.size() > nodeList.size()) {
                    log.info("error occur while set nodeFrom info,nodeList:{}", (Object)JSON.toJSONString(nodeList));
                    throw new AFBizException("999", "nodeId\u6570\u636e\u9519\u8bef");
                }
                nowNode.setNodeFrom(lastNode.getNodeId());
                resultList.add(nowNode);
                lastNode = nowNode;
                nowNode = (BpmnNodeVo)map.get(nowNode.getParams().getNodeTo());
            }
        }
        return resultList;
    }

    @Override
    public List<BpmnConf> getIsAllConfs() {
        return ((BpmnConfService)this.getService()).getBaseMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_all", (Object)1)).eq((Object)"effective_status", (Object)1)).eq((Object)"is_del", (Object)0));
    }

    @Override
    public BpmnConfVo detail(long id) {
        BpmnConf bpmnConf = (BpmnConf)((BpmnConfMapper)this.getMapper()).selectById(Long.valueOf(id));
        return this.formatConfVo(this.getBpmnConfVo(bpmnConf));
    }

    @Override
    public BpmnConfVo detail(String bpmnCode) {
        BpmnConf bpmnConf = (BpmnConf)((BpmnConfMapper)this.getMapper()).selectOne((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmnConf::getBpmnCode, (Object)bpmnCode));
        return this.getBpmnConfVo(bpmnConf);
    }

    @Override
    public BpmnConfVo detailByFormCode(String formCode) {
        BpmnConf bpmnConf = (BpmnConf)((BpmnConfMapper)this.getMapper()).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"form_code", (Object)formCode)).eq((Object)"effective_status", (Object)1));
        if (bpmnConf == null) {
            throw new AFBizException("can not get a bpmnConf by provided formCode");
        }
        return this.getBpmnConfVo(bpmnConf);
    }

    @Override
    public void setBpmnTemplateVos(BpmnConfVo bpmnConfVo) {
        bpmnConfVo.setTemplateVos(this.bpmnTemplateService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmnTemplate::getFormCode, (Object)bpmnConfVo.getFormCode())).isNull(BpmnTemplate::getNodeId)).stream().map(o -> {
            BpmnTemplateVo vo = new BpmnTemplateVo();
            this.buildBpmnTemplateVo((BpmnTemplate)o, vo);
            return vo;
        }).collect(Collectors.toList()));
    }

    @Override
    public void effectiveBpmnConf(Integer id) {
        BpmnConf bpmnConf = (BpmnConf)((BpmnConfMapper)this.getMapper()).selectById(id);
        AssertUtil.throwsIfEmpty((Object)bpmnConf, (String)"\u672a\u80fd\u6839\u636eid:\u67e5\u8be2\u5230\u6307\u5b9a\u914d\u7f6e!", (List)Lists.newArrayList((Object[])new Integer[]{id}));
        BpmnConf confInDb = (BpmnConf)((BpmnConfMapper)this.getMapper()).selectOne((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmnConf::getFormCode, (Object)bpmnConf.getFormCode())).eq(BpmnConf::getEffectiveStatus, (Object)1));
        if (!ObjectUtils.isEmpty((Object)confInDb)) {
            confInDb.setEffectiveStatus(Integer.valueOf(0));
            ((BpmnConfService)this.getService()).updateById(confInDb);
        } else {
            confInDb = new BpmnConf();
        }
        ((BpmnConfService)this.getService()).updateById(BpmnConf.builder().id(Long.valueOf(id.longValue())).appId(confInDb.getAppId()).bpmnType(confInDb.getBpmnType()).isAll(this.getIsAll(bpmnConf, confInDb)).effectiveStatus(Integer.valueOf(1)).build());
        this.bpmProcessNameService.editProcessName(bpmnConf);
    }

    @Override
    public ResultAndPage<BpmnConfVo> selectPage(PageDto pageDto, BpmnConfVo vo) {
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto);
        List<BpmnConfVo> bpmnConfVos = ((BpmnConfMapper)this.getMapper()).selectPageList(page, vo);
        if (bpmnConfVos == null) {
            return PageUtils.getResultAndPage((Page)page);
        }
        if (vo.getIsOutSideProcess() == 1) {
            List<BpmProcessAppApplication> bizAppList = this.bpmProcessAppApplicationService.selectApplicationList();
            Map<String, String> bizAppMap = bizAppList.stream().collect(Collectors.toMap(BpmProcessAppApplication::getProcessKey, BpmProcessAppApplication::getTitle));
            for (BpmnConfVo record : bpmnConfVos) {
                if (record.getIsOutSideProcess() != 1) continue;
                record.setFormCodeDisplayName(bizAppMap.get(record.getFormCode()));
            }
        }
        if (vo.getIsOutSideProcess() == 0) {
            List<DIYProcessInfoDTO> diyFormCodeList = this.TaskMgmtService.viewProcessInfo(null);
            Map<String, String> diyFormCodes = diyFormCodeList.stream().collect(Collectors.toMap(DIYProcessInfoDTO::getKey, DIYProcessInfoDTO::getValue));
            for (BpmnConfVo record : bpmnConfVos) {
                if (record.getIsLowCodeFlow() != 0 || record.getIsOutSideProcess() != 0) continue;
                record.setFormCodeDisplayName(diyFormCodes.get(record.getFormCode()));
            }
        }
        page.setRecords(bpmnConfVos.stream().peek(o -> o.setDeduplicationTypeName(DeduplicationTypeEnum.getDescByCode((Integer)o.getDeduplicationType()))).collect(Collectors.toList()));
        return PageUtils.getResultAndPage((Page)page);
    }

    private PreviewNode getPreviewNode(String params, Boolean isStartPagePreview) {
        String startUserId;
        BusinessDataVo dataVo = (BusinessDataVo)JSON.parseObject((String)params, BusinessDataVo.class);
        BpmnConfVo detail = isStartPagePreview != false ? this.detailByFormCode(dataVo.getFormCode()) : this.detail(dataVo.getBpmnCode());
        JSONObject object = JSON.parseObject((String)params);
        object.put((Object)"formCode", (Object)detail.getFormCode());
        BusinessDataVo vo = this.formFactory.dataFormConversion(JSON.toJSONString((Object)object), null);
        vo.setIsOutSideAccessProc(Boolean.valueOf(Objects.equals(1, detail.getIsOutSideProcess())));
        vo.setIsLowCodeFlow(detail.getIsLowCodeFlow());
        vo.setBpmnConfVo(detail);
        vo.setIsStartPagePreview(isStartPagePreview);
        BpmnStartConditionsExtendVo bpmnStartConditionsExtendVo = new BpmnStartConditionsExtendVo();
        bpmnStartConditionsExtendVo.setLowCodeFlow(true);
        if (isStartPagePreview.booleanValue()) {
            if (dataVo.getIsOutSideAccessProc().booleanValue()) {
                startUserId = dataVo.getStartUserId();
            } else {
                startUserId = SecurityUtils.getLogInEmpIdStr();
                vo.setStartUserId(startUserId);
            }
        } else {
            startUserId = vo.getStartUserId();
            if (ObjectUtils.isEmpty((Object)startUserId)) {
                vo.setStartUserId(SecurityUtils.getLogInEmpNameSafe());
            }
        }
        if (!ObjectUtils.isEmpty((Object)startUserId)) {
            bpmnStartConditionsExtendVo.setStartUserId(startUserId);
        }
        BpmnStartConditionsVo bpmnStartConditionsVo = new BpmnStartConditionsVo();
        if (dataVo.getIsOutSideAccessProc().booleanValue()) {
            bpmnStartConditionsVo.setTemplateMarkIds(dataVo.getTemplateMarkIds());
            bpmnStartConditionsVo.setOutSideType(dataVo.getOutSideType());
            bpmnStartConditionsVo.setEmbedNodes(dataVo.getEmbedNodes());
            bpmnStartConditionsVo.setIsOutSideAccessProc(Boolean.valueOf(true));
            bpmnStartConditionsVo.setStartUserId(dataVo.getStartUserId());
        } else {
            bpmnStartConditionsVo = this.formFactory.getFormAdaptor(vo).previewSetCondition(vo);
        }
        BeanUtils.copyProperties((Object)bpmnStartConditionsExtendVo, (Object)bpmnStartConditionsVo, (String[])StrUtils.getNullPropertyNames((Object)bpmnStartConditionsExtendVo));
        bpmnStartConditionsVo.setApproversList(dataVo.getApproversList());
        bpmnStartConditionsVo.setPreview(true);
        BpmnConfVo bpmnConfVo = this.getBpmnConfVo(bpmnStartConditionsVo, detail);
        PreviewNode previewNode = new PreviewNode();
        previewNode.setBpmnName(detail.getBpmnName());
        previewNode.setFormCode(detail.getFormCode());
        previewNode.setBpmnNodeList(this.setNodeFromV2(bpmnConfVo.getNodes()));
        previewNode.setDeduplicationType(bpmnConfVo.getDeduplicationType());
        previewNode.setDeduplicationTypeName(DeduplicationTypeEnum.getDescByCode((Integer)bpmnConfVo.getDeduplicationType()));
        String currentNodeIdStr = this.bpmVerifyInfoBizService.findCurrentNodeIds(vo.getProcessNumber());
        previewNode.setCurrentNodeId(currentNodeIdStr);
        ArrayList currentNodeIds = Lists.newArrayList((Object[])currentNodeIdStr.split(","));
        List bpmnNodeList = previewNode.getBpmnNodeList();
        Map<String, BpmnNodeVo> bpmnNodeVoMap = bpmnNodeList.stream().collect(Collectors.toMap(BpmnNodeVo::getNodeId, b -> b, (v1, v2) -> v1));
        ArrayList<String> nodeToResults = new ArrayList<String>();
        this.processNodeToRecursively(currentNodeIds, bpmnNodeVoMap, nodeToResults);
        previewNode.setAfterNodeIds(nodeToResults);
        ArrayList nodeFromResults = new ArrayList();
        Set<String> allNodeIds = bpmnNodeVoMap.keySet();
        allNodeIds.stream().filter(o -> !nodeToResults.contains(o) && !currentNodeIds.contains(o)).forEach(nodeFromResults::add);
        previewNode.setBeforeNodeIds(nodeFromResults);
        return previewNode;
    }

    private void addBpmVerifyInfoVo(BpmnNodeVo bpmnNodeVo, List<BpmnNodeVo> bpmnNodeList, List<BpmVerifyInfoVo> bpmVerifyInfoVos) {
        BpmnNodeVo nextBpmnNodeVo;
        Map<String, String> verifyMap = this.getVerifyMap(bpmnNodeVo);
        bpmVerifyInfoVos.add(BpmVerifyInfoVo.builder().taskName(verifyMap.get("taskName")).verifyUserName(verifyMap.get("verifyUserName")).build());
        if (!ObjectUtils.isEmpty((Object)bpmnNodeVo.getNodeTo()) && !ObjectUtils.isEmpty((Object)(nextBpmnNodeVo = (BpmnNodeVo)bpmnNodeList.stream().filter(o -> o.getNodeFrom().equals(bpmnNodeVo.getNodeId())).findFirst().orElse(null)))) {
            this.addBpmVerifyInfoVo(nextBpmnNodeVo, bpmnNodeList, bpmVerifyInfoVos);
        }
    }

    private Map<String, String> getVerifyMap(BpmnNodeVo bpmnNodeVo) {
        HashMap verifyMap = Maps.newHashMap();
        String verifyUserName = "";
        String taskName = bpmnNodeVo.getNodePropertyName();
        if (bpmnNodeVo.getParams().getParamType().equals(BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE.getCode())) {
            verifyUserName = bpmnNodeVo.getParams().getAssignee().getAssigneeName();
            taskName = Optional.ofNullable(taskName).orElse(bpmnNodeVo.getParams().getAssignee().getElementName());
        } else if (bpmnNodeVo.getParams().getParamType().equals(BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_MULTIPLAYER.getCode()) || bpmnNodeVo.getParams().getParamType().equals(BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_MULTIPLAYER_SORT.getCode())) {
            List assigneeList = bpmnNodeVo.getParams().getAssigneeList();
            verifyUserName = StringUtils.join((Iterable)assigneeList.stream().map(BpmnNodeParamsAssigneeVo::getAssigneeName).collect(Collectors.toList()), (String)",");
            taskName = Optional.ofNullable(taskName).orElse(StringUtils.join((Iterable)assigneeList.stream().map(BpmnNodeParamsAssigneeVo::getElementName).distinct().collect(Collectors.toList()), (String)","));
        }
        verifyMap.put("verifyUserName", verifyUserName);
        verifyMap.put("taskName", taskName);
        return verifyMap;
    }

    private void processNodeToRecursively(List<String> currentNodeIds, Map<String, BpmnNodeVo> bpmnNodeVoMap, List<String> results) {
        if (currentNodeIds.isEmpty()) {
            return;
        }
        for (String currentNodeId : currentNodeIds) {
            List nodeTo;
            BpmnNodeVo bpmnNodeVo = bpmnNodeVoMap.get(currentNodeId);
            if (bpmnNodeVo == null || CollectionUtils.isEmpty((Collection)(nodeTo = bpmnNodeVo.getNodeTo()))) continue;
            results.addAll(nodeTo);
            this.processNodeToRecursively(nodeTo, bpmnNodeVoMap, results);
        }
    }

    private void treatParallelGateWayRecursively(BpmnNodeVo outerMostParallelGatewayNode, BpmnNodeVo itsPrevNode, BpmnNodeVo itsAggregationNode, Map<String, BpmnNodeVo> mapNodes, List<BpmnNodeVo> results, Set<String> alreadyProcessNodeIds) {
        String aggregationNodeNodeId = itsAggregationNode.getNodeId();
        List nodeTos = outerMostParallelGatewayNode.getNodeTo();
        outerMostParallelGatewayNode.setNodeFrom(itsPrevNode.getNodeId());
        itsAggregationNode.setNodeFrom(outerMostParallelGatewayNode.getNodeId());
        results.add(outerMostParallelGatewayNode);
        results.add(itsAggregationNode);
        alreadyProcessNodeIds.add(outerMostParallelGatewayNode.getNodeId());
        alreadyProcessNodeIds.add(itsAggregationNode.getNodeId());
        block0: for (String nodeTo : nodeTos) {
            BpmnNodeVo currentNodeVo;
            BpmnNodeVo prevNode = outerMostParallelGatewayNode;
            BpmnNodeVo nodeVo = currentNodeVo = mapNodes.get(nodeTo);
            while (nodeVo != null && !nodeVo.getNodeId().equals(aggregationNodeNodeId)) {
                if (!alreadyProcessNodeIds.contains(nodeVo.getNodeId())) {
                    if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nodeVo.getNodeType())) {
                        BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)nodeVo, mapNodes.values());
                        this.treatParallelGateWayRecursively(nodeVo, prevNode, aggregationNode, mapNodes, results, alreadyProcessNodeIds);
                    }
                    if (BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE.getCode().equals(nodeVo.getParams().getParamType())) {
                        nodeVo.getParams().setAssigneeList(Collections.singletonList(nodeVo.getParams().getAssignee()));
                    }
                    nodeVo.setNodePropertyName(NodePropertyEnum.getDescByCode((Integer)nodeVo.getNodeProperty()));
                    if (StringUtils.isBlank((CharSequence)nodeVo.getParams().getNodeTo())) {
                        nodeVo.setNodeFrom(prevNode.getNodeId());
                        results.add(nodeVo);
                        alreadyProcessNodeIds.add(nodeVo.getNodeId());
                        continue block0;
                    }
                    if (results.size() > mapNodes.values().size()) {
                        log.info("error occur while set nodeFrom info,nodeList:{}", (Object)JSON.toJSONString(mapNodes.values()));
                        throw new AFBizException("999", "nodeId\u6570\u636e\u9519\u8bef");
                    }
                    nodeVo.setNodeFrom(prevNode.getNodeId());
                    results.add(nodeVo);
                    alreadyProcessNodeIds.add(nodeVo.getNodeId());
                    prevNode = nodeVo;
                }
                nodeVo = mapNodes.get(nodeVo.getParams().getNodeTo());
            }
        }
    }

    private static BpmnNodeVo getNodeMapAndStartNode(List<BpmnNodeVo> nodeList, Map<String, BpmnNodeVo> nodeIdMapNode) {
        BpmnNodeVo startNode = null;
        boolean existEnd = false;
        for (BpmnNodeVo bpmnNodeVo : nodeList) {
            nodeIdMapNode.put(bpmnNodeVo.getNodeId(), bpmnNodeVo);
            if (NodeTypeEnum.NODE_TYPE_START.getCode().equals(bpmnNodeVo.getNodeType())) {
                if (startNode == null) {
                    startNode = bpmnNodeVo;
                } else {
                    log.info("has more than one start up user while previewing the process,nodeId:{}", (Object)bpmnNodeVo.getNodeId());
                    throw new AFBizException("999", "has more than 1 start up node");
                }
            }
            if (bpmnNodeVo.getParams() != null && !StringUtils.isBlank((CharSequence)bpmnNodeVo.getParams().getNodeTo())) continue;
            existEnd = true;
        }
        if (!existEnd) {
            log.info("has no end node while previewing the process,nodeList:{}", (Object)JSON.toJSONString(nodeList));
            throw new AFBizException("has not end node while previewing the process");
        }
        return startNode;
    }

    private BpmnConfVo getBpmnConfVo(BpmnStartConditionsVo bpmnStartConditions, BpmnConfVo bpmnConfVo) {
        this.bpmnStartFormatFactory.formatBpmnConf(bpmnConfVo, bpmnStartConditions);
        this.bpmnPersonnelFormat.formatPersonnelsConf(bpmnConfVo, bpmnStartConditions);
        if (!bpmnConfVo.getDeduplicationType().equals(DeduplicationTypeEnum.DEDUPLICATION_TYPE_NULL.getCode())) {
            BpmnDeduplicationFormat bpmnDeduplicationFormat = (BpmnDeduplicationFormat)SpringBeanUtils.getBean(BpmnDeduplicationFormatImpl.class);
            if (bpmnConfVo.getDeduplicationType().equals(DeduplicationTypeEnum.DEDUPLICATION_TYPE_FORWARD.getCode())) {
                bpmnDeduplicationFormat.forwardDeduplication(bpmnConfVo, bpmnStartConditions);
            } else if (bpmnConfVo.getDeduplicationType().equals(DeduplicationTypeEnum.DEDUPLICATION_TYPE_BACKWARD.getCode())) {
                bpmnDeduplicationFormat.backwardDeduplication(bpmnConfVo, bpmnStartConditions);
            }
        }
        BpmnOptionalDuplicatesAdaptor bpmnOptionalDuplicates = (BpmnOptionalDuplicatesAdaptor)SpringBeanUtils.getBean(BpmnOptionalDuplicatesImpl.class);
        bpmnOptionalDuplicates.optionalDuplicates(bpmnConfVo, bpmnStartConditions);
        this.bpmnRemoveConfFormatFactory.removeBpmnConf(bpmnConfVo, bpmnStartConditions);
        if (BpmnConfFlagsEnum.hasFlag((Integer)bpmnConfVo.getExtraFlags(), (BpmnConfFlagsEnum)BpmnConfFlagsEnum.HAS_COPY)) {
            for (BpmnNodeVo node : bpmnConfVo.getNodes()) {
                if (NodeTypeEnum.NODE_TYPE_COPY.getCode().equals(node.getNodeType()) || CollectionUtils.isEmpty((Collection)node.getEmpToForwardList())) continue;
                List empToForwardList = node.getEmpToForwardList();
                ArrayList<BpmProcessForward> processForwardList = new ArrayList<BpmProcessForward>(node.getEmpToForwardList().size());
                boolean lastNodeForward = node.isLastNodeForward();
                for (BaseIdTranStruVo baseIdTranStruVo : empToForwardList) {
                    BpmProcessForward bpmProcessForward = BpmProcessForward.builder().createTime(new Date()).createUserId(SecurityUtils.getLogInEmpId()).forwardUserId(baseIdTranStruVo.getId()).ForwardUserName(baseIdTranStruVo.getName()).processNumber(bpmnStartConditions.getProcessNum()).nodeId(String.valueOf(node.getId())).isDel(Integer.valueOf(1)).build();
                    if (lastNodeForward) {
                        bpmProcessForward.setNodeId("af_syslabel_lastnode_copy");
                    }
                    processForwardList.add(bpmProcessForward);
                }
                this.processForwardService.saveBatch(processForwardList);
            }
        }
        return bpmnConfVo;
    }

    private BpmnConfVo formatConfVo(BpmnConfVo confVo) {
        if (confVo == null) {
            throw new AFBizException("has not confVo");
        }
        List nodes = confVo.getNodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            throw new AFBizException("confVo has empty nodes");
        }
        for (BpmnNodeVo node : nodes) {
            BpmnNodePropertysVo property = node.getProperty();
            if (property == null) continue;
            property.setConditionsConf(null);
        }
        return confVo;
    }

    private BpmnConfVo getBpmnConfVo(BpmnConf bpmnConf) {
        boolean isLowCodeFlow;
        if (ObjectUtils.isEmpty((Object)bpmnConf)) {
            return new BpmnConfVo();
        }
        BpmnConfVo bpmnConfVo = new BpmnConfVo();
        BeanUtils.copyProperties((Object)bpmnConf, (Object)bpmnConfVo);
        String conditionsUrl = "";
        if (bpmnConfVo.getIsOutSideProcess() != null && bpmnConf.getIsOutSideProcess() == 1) {
            OutSideBpmCallbackUrlConf outSideBpmCallbackUrlConf = this.outSideBpmCallbackUrlConfService.getOutSideBpmCallbackUrlConf(bpmnConf.getId(), bpmnConf.getBusinessPartyId());
            if (outSideBpmCallbackUrlConf != null) {
                bpmnConfVo.setBpmConfCallbackUrl(outSideBpmCallbackUrlConf.getBpmConfCallbackUrl());
                bpmnConfVo.setBpmFlowCallbackUrl(outSideBpmCallbackUrlConf.getBpmFlowCallbackUrl());
            }
            OutSideBpmBusinessParty outSideBpmBusinessParty = (OutSideBpmBusinessParty)this.outSideBpmBusinessPartyService.getById(bpmnConf.getBusinessPartyId());
            bpmnConfVo.setBusinessPartyName(outSideBpmBusinessParty.getName());
            bpmnConfVo.setBusinessPartyMark(outSideBpmBusinessParty.getBusinessPartyMark());
            bpmnConfVo.setType(Integer.valueOf(2));
            BpmProcessAppApplicationVo applicationUrl = this.applicationService.getApplicationUrl(outSideBpmBusinessParty.getBusinessPartyMark(), bpmnConfVo.getFormCode());
            if (applicationUrl != null) {
                bpmnConfVo.setViewUrl(applicationUrl.getLookUrl());
                bpmnConfVo.setSubmitUrl(applicationUrl.getSubmitUrl());
                bpmnConfVo.setConditionsUrl(applicationUrl.getConditionUrl());
                bpmnConfVo.setAppId(applicationUrl.getId());
                conditionsUrl = applicationUrl.getConditionUrl();
            }
        }
        ProcessorFactory.executePreReadProcessors((Object)bpmnConfVo);
        List bpmnNodes = this.bpmnNodeService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmnNode::getConfId, (Object)bpmnConf.getId())).eq(BpmnNode::getIsDel, (Object)0));
        boolean isOutSideProcess = bpmnConf.getIsOutSideProcess() != null && bpmnConf.getIsOutSideProcess() == 1;
        boolean bl = isLowCodeFlow = bpmnConf.getIsLowCodeFlow() != null && bpmnConf.getIsLowCodeFlow() == 1;
        if (isOutSideProcess || isLowCodeFlow || bpmnConf.getExtraFlags() != null) {
            for (BpmnNode bpmnNode : bpmnNodes) {
                bpmnNode.setIsOutSideProcess(bpmnConf.getIsOutSideProcess());
                bpmnNode.setIsLowCodeFlow(bpmnConf.getIsLowCodeFlow());
                bpmnNode.setExtraFlags(bpmnConf.getExtraFlags());
            }
        }
        bpmnConfVo.setNodes(this.getBpmnNodeVoList(bpmnNodes, conditionsUrl));
        if (!ObjectUtils.isEmpty((Object)bpmnConfVo.getNodes())) {
            Object id2NodeMap = null;
            for (BpmnNodeVo node : bpmnConfVo.getNodes()) {
                node.setFormCode(bpmnConfVo.getFormCode());
                if (!NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(node.getNodeType())) continue;
                BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)node, (Collection)bpmnConfVo.getNodes());
                if (aggregationNode == null) {
                    throw new AFBizException("can not find parallel gateway's aggregation node!");
                }
                aggregationNode.setAggregationNode(true);
                aggregationNode.setDeduplicationExclude(true);
            }
        }
        this.setViewPageButton(bpmnConfVo);
        this.setBpmnTemplateVos(bpmnConfVo);
        return bpmnConfVo;
    }

    private void buildBpmnTemplateVo(BpmnTemplate entity, BpmnTemplateVo vo) {
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        vo.setEventValue(EventTypeEnum.getDescByByCode((Integer)vo.getEvent()));
        if (!ObjectUtils.isEmpty((Object)vo.getInforms())) {
            vo.setInformIdList(Arrays.stream(vo.getInforms().split(",")).collect(Collectors.toList()));
            vo.setInformList(vo.getInformIdList().stream().map(o -> BaseIdTranStruVo.builder().id(o).name(InformEnum.getDescByByCode((Integer)Integer.parseInt(o))).build()).collect(Collectors.toList()));
        }
        if (!ObjectUtils.isEmpty((Object)vo.getEmps())) {
            vo.setEmpIdList(Arrays.stream(vo.getEmps().split(",")).collect(Collectors.toList()));
            Map employeeInfo = this.employeeInfoProvider.provideEmployeeInfo((Collection)vo.getEmpIdList());
            vo.setEmpList(vo.getEmpIdList().stream().map(o -> BaseIdTranStruVo.builder().id(o).name((String)employeeInfo.get(o)).build()).collect(Collectors.toList()));
        }
        if (!StringUtils.isEmpty((CharSequence)entity.getMessageSendType())) {
            String[] messageSendTypesStr = entity.getMessageSendType().split(",");
            List messageSendTypes = Arrays.stream(messageSendTypesStr).map(a -> BaseNumIdStruVo.builder().id(Long.valueOf(Long.parseLong(a))).name(MessageSendTypeEnum.getEnumByCode((Integer)Integer.parseInt(a)).getDesc()).active(Boolean.valueOf(true)).build()).collect(Collectors.toList());
            vo.setMessageSendTypeList(messageSendTypes);
        }
        vo.setTemplateName(((InformationTemplate)Optional.ofNullable(this.informationTemplateService.getBaseMapper().selectById((Serializable)vo.getTemplateId())).orElse(new InformationTemplate())).getName());
    }

    private void setViewPageButton(BpmnConfVo bpmnConfVo) {
        List bpmnViewPageButtons = this.bpmnViewPageButtonService.getBaseMapper().selectList((Wrapper)Wrappers.lambdaQuery().eq(BpmnViewPageButton::getConfId, (Object)bpmnConfVo.getId()));
        BpmnViewPageButtonBaseVo bpmnViewPageButtonBaseVo = new BpmnViewPageButtonBaseVo();
        bpmnViewPageButtonBaseVo.setViewPageStart(this.getViewPageButtonsByType(bpmnViewPageButtons, ViewPageTypeEnum.VIEW_PAGE_TYPE_START));
        bpmnViewPageButtonBaseVo.setViewPageOther(this.getViewPageButtonsByType(bpmnViewPageButtons, ViewPageTypeEnum.VIEW_PAGE_TYPE_OTHER));
        bpmnConfVo.setViewPageButtons(bpmnViewPageButtonBaseVo);
    }

    private List<Integer> getViewPageButtonsByType(List<BpmnViewPageButton> bpmnViewPageButtons, ViewPageTypeEnum viewPageTypeEnum) {
        return bpmnViewPageButtons.stream().filter(o -> o.getViewType().intValue() == viewPageTypeEnum.getCode().intValue()).collect(Collectors.toList()).stream().map(BpmnViewPageButton::getButtonType).collect(Collectors.toList());
    }

    private List<BpmnNodeVo> getBpmnNodeVoList(List<BpmnNode> bpmnNodeList, String conditionsUrl) {
        List<Long> idList = bpmnNodeList.stream().map(BpmnNode::getId).collect(Collectors.toList());
        Map<Long, List<String>> bpmnNodeToMap = this.nodeAdditionalInfoService.getBpmnNodeToMap(idList);
        Map<Long, List<BpmnNodeButtonConf>> bpmnNodeButtonConfMap = this.getBpmnNodeButtonConfMap(idList);
        Map<Long, BpmnNodeSignUpConf> bpmnNodeSignUpConfMap = this.getBpmnNodeSignUpConfMap(idList);
        Map<Long, List<BpmnTemplateVo>> bpmnTemplateVoMap = this.getBpmnTemplateVoMap(idList);
        Map<Long, BpmnApproveRemindVo> bpmnApproveRemindVoMap = this.getBpmnApproveRemindVoMap(idList);
        HashMap<Long, List<BpmnNodeLabel>> bpmnNodeLabelsVoMap = new HashMap();
        Integer isLowCodeFlow = bpmnNodeList.get(0).getIsLowCodeFlow();
        Integer extraFlags = bpmnNodeList.get(0).getExtraFlags();
        boolean hasNodeLabels = BpmnConfFlagsEnum.hasFlag((Integer)extraFlags, (BpmnConfFlagsEnum)BpmnConfFlagsEnum.HAS_NODE_LABELS);
        if (hasNodeLabels) {
            bpmnNodeLabelsVoMap = this.getBpmnNodeLabelsVoMap(idList);
        }
        Map<Long, List<BpmnNodeLfFormdataFieldControl>> bpmnNodeFieldControlConfMap = isLowCodeFlow != null && isLowCodeFlow == 1 ? this.getBpmnNodeFieldControlConfMap(idList) : null;
        HashMap<Long, List<BpmnNodeLabel>> finalBpmnNodeLabelsVoMap = bpmnNodeLabelsVoMap;
        ArrayList<BpmnNodeVo> bpmnNodeVoList = new ArrayList<BpmnNodeVo>(bpmnNodeList.size());
        for (BpmnNode bpmnNode : bpmnNodeList) {
            BpmnNodeVo bpmnNodeVo = this.getBpmnNodeVo(bpmnNode, bpmnNodeToMap, bpmnNodeButtonConfMap, bpmnNodeSignUpConfMap, bpmnTemplateVoMap, bpmnApproveRemindVoMap, bpmnNodeFieldControlConfMap, conditionsUrl, finalBpmnNodeLabelsVoMap);
            bpmnNodeVoList.add(bpmnNodeVo);
            if (!Boolean.TRUE.equals(bpmnNodeVo.getIsDynamicCondition())) continue;
            BpmnNode prevNode = bpmnNodeList.stream().filter(o -> bpmnNodeVo.getNodeFrom().equals(o.getNodeId())).findFirst().orElse(null);
            if (prevNode != null) {
                ArrayList<Object> nodes = new ArrayList<Object>();
                nodes.add(prevNode);
                ArrayList<Long> dynamicLabelNodeIds = new ArrayList<Long>();
                if (NodeTypeEnum.NODE_TYPE_GATEWAY.getCode().equals(prevNode.getNodeType())) {
                    for (Map.Entry<Long, List<String>> entry : bpmnNodeToMap.entrySet()) {
                        Long nodeId = entry.getKey();
                        List<String> nodeTos = entry.getValue();
                        if (CollectionUtils.isEmpty(nodeTos) || !nodeTos.contains(prevNode.getNodeId()) && !nodeTos.contains(bpmnNodeVo.getNodeId())) continue;
                        dynamicLabelNodeIds.add(nodeId);
                    }
                }
                if (!CollectionUtils.isEmpty(dynamicLabelNodeIds)) {
                    List dynamicLabelNodes = bpmnNodeList.stream().filter(a -> dynamicLabelNodeIds.contains(a.getId())).collect(Collectors.toList());
                    nodes.addAll(dynamicLabelNodes);
                }
                for (BpmnNode bpmnNode2 : nodes) {
                    ArrayList<BpmnNodeLabelVO> labelList = bpmnNode2.getLabelList();
                    if (CollectionUtils.isEmpty((Collection)labelList)) {
                        labelList = new ArrayList<BpmnNodeLabelVO>();
                        labelList.add(NodeLabelConstants.dynamicCondition);
                        bpmnNode2.setLabelList(labelList);
                        continue;
                    }
                    bpmnNode2.getLabelList().add(NodeLabelConstants.dynamicCondition);
                }
                continue;
            }
            log.warn("can not find prev node for node:%s");
        }
        return bpmnNodeVoList;
    }

    private Map<Long, List<BpmnTemplateVo>> getBpmnTemplateVoMap(List<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return new HashMap<Long, List<BpmnTemplateVo>>();
        }
        return this.bpmnTemplateService.getBaseMapper().selectList((Wrapper)AFWrappers.lambdaTenantQuery().in(BpmnTemplate::getNodeId, ids)).stream().collect(Collectors.toMap(BpmnTemplate::getNodeId, o -> {
            BpmnTemplateVo vo = new BpmnTemplateVo();
            this.buildBpmnTemplateVo((BpmnTemplate)o, vo);
            return new ArrayList<BpmnTemplateVo>(Collections.singletonList(vo));
        }, (a, b) -> {
            a.addAll(b);
            return a;
        }));
    }

    private Map<Long, BpmnApproveRemindVo> getBpmnApproveRemindVoMap(List<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return new HashMap<Long, BpmnApproveRemindVo>();
        }
        return this.bpmnApproveRemindService.getBaseMapper().selectList((Wrapper)AFWrappers.lambdaTenantQuery().in(BpmnApproveRemind::getNodeId, ids)).stream().collect(Collectors.toMap(BpmnApproveRemind::getNodeId, o -> {
            BpmnApproveRemindVo vo = new BpmnApproveRemindVo();
            vo.setIsInuse(Boolean.valueOf(false));
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setTemplateName(((InformationTemplate)Optional.ofNullable(this.informationTemplateService.getBaseMapper().selectById((Serializable)vo.getTemplateId())).orElse(new InformationTemplate())).getName());
            if (!ObjectUtils.isEmpty((Object)vo.getDays())) {
                vo.setDayList(Arrays.stream(vo.getDays().split(",")).map(Integer::parseInt).collect(Collectors.toList()));
            }
            if (!ObjectUtils.isEmpty((Object)vo.getTemplateId()) && !ObjectUtils.isEmpty((Object)vo.getDays())) {
                vo.setIsInuse(Boolean.valueOf(true));
            }
            return vo;
        }, (a, b) -> a));
    }

    private Map<Long, List<BpmnNodeLabel>> getBpmnNodeLabelsVoMap(List<Long> ids) {
        List nodeLabels = this.nodeLabelsService.list((Wrapper)AFWrappers.lambdaTenantQuery().in(BpmnNodeLabel::getNodeId, ids));
        return nodeLabels.stream().collect(Collectors.groupingBy(BpmnNodeLabel::getNodeId));
    }

    private Map<Long, BpmnNodeSignUpConf> getBpmnNodeSignUpConfMap(List<Long> idList) {
        return this.bpmnNodeSignUpConfService.getBaseMapper().selectList((Wrapper)AFWrappers.lambdaTenantQuery().in(BpmnNodeSignUpConf::getBpmnNodeId, idList)).stream().collect(Collectors.toMap(BpmnNodeSignUpConf::getBpmnNodeId, o -> o));
    }

    private Map<Long, List<BpmnNodeButtonConf>> getBpmnNodeButtonConfMap(List<Long> idList) {
        return this.bpmnNodeButtonConfService.getBaseMapper().selectList((Wrapper)AFWrappers.lambdaTenantQuery().in(BpmnNodeButtonConf::getBpmnNodeId, idList)).stream().collect(Collectors.toMap(BpmnNodeButtonConf::getBpmnNodeId, v -> Lists.newArrayList(Collections.singletonList(v)), (a, b) -> {
            a.addAll(b);
            return a;
        }));
    }

    private Map<Long, List<BpmnNodeLfFormdataFieldControl>> getBpmnNodeFieldControlConfMap(List<Long> idList) {
        return this.nodeLfFormdataFieldControlService.list((Wrapper)AFWrappers.lambdaTenantQuery().in(BpmnNodeLfFormdataFieldControl::getNodeId, idList)).stream().collect(Collectors.toMap(BpmnNodeLfFormdataFieldControl::getNodeId, xva$0 -> Lists.newArrayList((Object[])new BpmnNodeLfFormdataFieldControl[]{xva$0}), (a, b) -> {
            a.addAll(b);
            return a;
        }));
    }

    private BpmnNodeVo getBpmnNodeVo(BpmnNode bpmnNode, Map<Long, List<String>> bpmnNodeToMap, Map<Long, List<BpmnNodeButtonConf>> bpmnNodeButtonConfMap, Map<Long, BpmnNodeSignUpConf> bpmnNodeSignUpConfMap, Map<Long, List<BpmnTemplateVo>> bpmnTemplateVoMap, Map<Long, BpmnApproveRemindVo> bpmnApproveRemindVoMap, Map<Long, List<BpmnNodeLfFormdataFieldControl>> lfFieldControlMap, String conditionsUrl, Map<Long, List<BpmnNodeLabel>> bpmnNodeLabelsVoMap) {
        BpmnNodeVo bpmnNodeVo = new BpmnNodeVo();
        BeanUtils.copyProperties((Object)bpmnNode, (Object)bpmnNodeVo);
        bpmnNodeVo.setNodeTo(bpmnNodeToMap.get(bpmnNode.getId()));
        this.setButtons(bpmnNodeVo, bpmnNodeButtonConfMap.get(bpmnNode.getId()));
        bpmnNodeVo.setNodePropertyName(NodePropertyEnum.getDescByCode((Integer)bpmnNodeVo.getNodeProperty()));
        bpmnNodeVo.setTemplateVos(bpmnTemplateVoMap.get(bpmnNode.getId()));
        bpmnNodeVo.setApproveRemindVo(bpmnApproveRemindVoMap.get(bpmnNode.getId()));
        BpmnNodeAdpConfEnum bpmnNodeAdpConfEnum = NodeAdditionalInfoServiceImpl.getBpmnNodeAdpConfEnum(bpmnNodeVo);
        if (ObjectUtils.isEmpty((Object)((Object)bpmnNodeAdpConfEnum))) {
            return bpmnNodeVo;
        }
        BpmnNodeAdaptor bpmnNodeAdaptor = this.getBpmnNodeAdaptor(bpmnNodeAdpConfEnum);
        bpmnNodeAdaptor.formatToBpmnNodeVo(bpmnNodeVo);
        if (NodeTypeEnum.NODE_TYPE_OUT_SIDE_CONDITIONS.getCode().equals(bpmnNode.getNodeType())) {
            bpmnNodeVo.setNodeType(NodeTypeEnum.NODE_TYPE_CONDITIONS.getCode());
        }
        this.setBpmnNodeSignUpConf(bpmnNode, bpmnNodeSignUpConfMap, bpmnNodeVo);
        this.setFieldControlVOs(bpmnNode, lfFieldControlMap, bpmnNodeVo);
        List<BpmnNodeLabel> nodeLabels = bpmnNodeLabelsVoMap.get(bpmnNode.getId());
        if (!CollectionUtils.isEmpty(nodeLabels)) {
            List labelVOList = nodeLabels.stream().map(a -> new BpmnNodeLabelVO(a.getLabelValue(), a.getLabelName())).collect(Collectors.toList());
            bpmnNodeVo.setLabelList(labelVOList);
        }
        return bpmnNodeVo;
    }

    private BpmnNodeAdaptor getBpmnNodeAdaptor(BpmnNodeAdpConfEnum bpmnNodeAdpConfEnum) {
        return this.adaptorFactory.getBpmnNodeAdaptor(bpmnNodeAdpConfEnum);
    }

    private void setButtons(BpmnNodeVo bpmnNodeVo, List<BpmnNodeButtonConf> bpmnNodeButtonConfs) {
        if (!ObjectUtils.isEmpty(bpmnNodeButtonConfs)) {
            BpmnNodeButtonConfBaseVo buttons = new BpmnNodeButtonConfBaseVo();
            buttons.setStartPage(this.getButtons(bpmnNodeButtonConfs, ButtonPageTypeEnum.INITIATE));
            buttons.setApprovalPage(this.getButtons(bpmnNodeButtonConfs, ButtonPageTypeEnum.AUDIT));
            bpmnNodeVo.setButtons(buttons);
        }
    }

    private List<Integer> getButtons(List<BpmnNodeButtonConf> bpmnNodeButtonConfs, ButtonPageTypeEnum buttonPageTypeEnum) {
        return bpmnNodeButtonConfs.stream().filter(o -> o.getButtonPageType().intValue() == buttonPageTypeEnum.getCode()).map(BpmnNodeButtonConf::getButtonType).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
    }

    private void setBpmnNodeSignUpConf(BpmnNode bpmnNode, Map<Long, BpmnNodeSignUpConf> bpmnNodeSignUpConfMap, BpmnNodeVo bpmnNodeVo) {
        if (bpmnNode.getIsSignUp() != 1) {
            return;
        }
        BpmnNodeSignUpConf bpmnNodeSignUpConf = bpmnNodeSignUpConfMap.get(bpmnNode.getId());
        if (ObjectUtils.isEmpty((Object)bpmnNodeSignUpConf)) {
            return;
        }
        BpmnNodePropertysVo propertysVo = bpmnNodeVo.getProperty();
        if (ObjectUtils.isEmpty((Object)propertysVo)) {
            propertysVo = new BpmnNodePropertysVo();
        }
        propertysVo.setAfterSignUpWay(bpmnNodeSignUpConf.getAfterSignUpWay());
        propertysVo.setSignUpType(bpmnNodeSignUpConf.getSignUpType());
        bpmnNodeVo.setProperty(propertysVo);
    }

    private void setFieldControlVOs(BpmnNode bpmnNode, Map<Long, List<BpmnNodeLfFormdataFieldControl>> fieldControlMap, BpmnNodeVo nodeVo) {
        boolean isLowFlow = Objects.equals(bpmnNode.getIsLowCodeFlow(), 1);
        if (!isLowFlow) {
            return;
        }
        if (CollectionUtils.isEmpty(fieldControlMap)) {
            return;
        }
        List<BpmnNodeLfFormdataFieldControl> fieldControls = fieldControlMap.get(bpmnNode.getId());
        if (CollectionUtils.isEmpty(fieldControls)) {
            return;
        }
        ArrayList<LFFieldControlVO> fieldControlVOS = new ArrayList<LFFieldControlVO>();
        for (BpmnNodeLfFormdataFieldControl fieldControl : fieldControls) {
            LFFieldControlVO lfFieldControlVO = new LFFieldControlVO();
            lfFieldControlVO.setFieldId(fieldControl.getFieldId());
            lfFieldControlVO.setFieldName(fieldControl.getFieldName());
            lfFieldControlVO.setPerm(fieldControl.getPerm());
            fieldControlVOS.add(lfFieldControlVO);
        }
        nodeVo.setLfFieldControlVOs(fieldControlVOS);
    }

    private Integer getIsAll(BpmnConf bpmnConf, BpmnConf beforeBpmnConf) {
        if (bpmnConf.getIsOutSideProcess() == 1) {
            return 1;
        }
        if (!ObjectUtils.isEmpty((Object)beforeBpmnConf.getIsAll())) {
            return beforeBpmnConf.getIsAll();
        }
        return 0;
    }

    private String formatOutSideFormCode(BpmnConfVo bpmnConfVo) {
        String formCode = bpmnConfVo.getFormCode();
        return formCode.substring(formCode.indexOf(linkMark) + 1);
    }

    private void setViewPageButtons(BpmnConfVo bpmnConfVo, BpmnConfCommonVo bpmnConfCommonVo) {
        bpmnConfCommonVo.setViewPageButtons(BpmnConfViewPageButtonVo.builder().viewPageStart(bpmnConfVo.getViewPageButtons().getViewPageStart().stream().map(o -> BpmnConfCommonButtonPropertyVo.builder().buttonType(o).buttonName(ButtonTypeEnum.getDescByCode((Integer)o)).build()).collect(Collectors.toList())).viewPageOther(bpmnConfVo.getViewPageButtons().getViewPageOther().stream().map(o -> BpmnConfCommonButtonPropertyVo.builder().buttonType(o).buttonName(ButtonTypeEnum.getDescByCode((Integer)o)).build()).collect(Collectors.toList())).build());
    }
}

