/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BpmnConfCommonVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.common.service.ProcessModelServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnBizCustomService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnCreateBpmnAndStart;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessForwardService;
import org.openoa.engine.utils.AFWrappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class BpmnCreateBpmnAndStartImpl
implements BpmnCreateBpmnAndStart {
    private static final Logger log = LoggerFactory.getLogger(BpmnCreateBpmnAndStartImpl.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private BpmProcessForwardService processForwardService;
    @Autowired
    private ProcessModelServiceImpl processModelService;

    @Override
    public void createBpmnAndStart(BpmnConfCommonVo bpmnConfCommonVo, BpmnStartConditionsVo bpmnStartConditions) {
        List tasks;
        String procInstId;
        HashMap startParamMap = Maps.newHashMap();
        startParamMap.put("entryId", bpmnStartConditions.getEntryId());
        startParamMap.put("businessId", bpmnStartConditions.getBusinessId());
        startParamMap.put("bpmnCode", bpmnConfCommonVo.getBpmnCode());
        startParamMap.put("formCode", bpmnConfCommonVo.getFormCode());
        startParamMap.put("processNumber", bpmnConfCommonVo.getProcessNum());
        Authentication.setAuthenticatedUserId((String)bpmnStartConditions.getStartUserId());
        BpmnModel model = new BpmnModel();
        this.processModelService.execute(bpmnConfCommonVo, bpmnStartConditions, (Map)startParamMap, model);
        this.repositoryService.createDeployment().tenantId(MultiTenantUtil.getCurrentTenantId()).addBpmnModel(StringUtils.join((Object[])new String[]{bpmnConfCommonVo.getProcessNum(), ".bpmn"}), model).name(StringUtils.join((Object[])new String[]{bpmnConfCommonVo.getProcessNum(), " deployment"})).deploy();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKeyAndTenantId(bpmnConfCommonVo.getProcessNum(), bpmnStartConditions.getEntryId(), (Map)startParamMap, MultiTenantUtil.getCurrentTenantId());
        BpmBusinessProcess bpmBusinessProcess = (BpmBusinessProcess)this.bpmBusinessProcessService.getBaseMapper().selectOne((Wrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)bpmnStartConditions.getEntryId()));
        if (Boolean.TRUE.equals(bpmnStartConditions.getIsMigration())) {
            bpmBusinessProcess = (BpmBusinessProcess)this.bpmBusinessProcessService.getBaseMapper().selectOne((Wrapper)AFWrappers.lambdaTenantQuery().eq(BpmBusinessProcess::getBusinessNumber, (Object)bpmnStartConditions.getProcessNum()));
            procInstId = bpmBusinessProcess.getProcInstId();
            this.runtimeService.deleteProcessInstance(procInstId, "migration");
        }
        if (!ObjectUtils.isEmpty((Object)bpmBusinessProcess) && bpmBusinessProcess.getId() != null) {
            this.bpmBusinessProcessService.updateById((Object)BpmBusinessProcess.builder().id(bpmBusinessProcess.getId()).procInstId(processInstance.getId()).build());
            procInstId = processInstance.getId();
            String string = bpmBusinessProcess.getBusinessNumber();
        }
        if (!ObjectUtils.isEmpty((Object)(tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).taskTenantId(MultiTenantUtil.getCurrentTenantId())).list()))) {
            Task task = (Task)tasks.get(0);
            HashMap<String, String> varMap = new HashMap<String, String>();
            varMap.put("assigneeName", SecurityUtils.getLogInEmpName());
            this.taskService.complete(task.getId(), varMap);
            Collection beans = SpringBeanUtils.getBeans(BpmnBizCustomService.class);
            if (!ObjectUtils.isEmpty((Object)beans)) {
                for (BpmnBizCustomService bean : beans) {
                    bean.execute(task);
                }
            }
        }
    }
}

