/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodeParamsVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnDeduplicationFormat;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class BpmnDeduplicationFormatImpl
implements BpmnDeduplicationFormat {
    @Override
    public BpmnConfVo forwardDeduplication(BpmnConfVo bpmnConfVo, BpmnStartConditionsVo bpmnStartConditions) {
        String startNodeId = null;
        HashMap mapNodes = Maps.newHashMap();
        boolean containsParallelGateway = false;
        for (BpmnNodeVo vo : bpmnConfVo.getNodes()) {
            mapNodes.put(vo.getNodeId(), vo);
            if (!ObjectUtils.isEmpty((Object)vo.getNodeType()) && vo.getNodeType().equals(NodeTypeEnum.NODE_TYPE_START.getCode())) {
                startNodeId = vo.getNodeId();
            }
            if (!NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(vo.getNodeType()) && (!NodeTypeEnum.NODE_TYPE_GATEWAY.getCode().equals(vo.getNodeType()) || !Boolean.TRUE.equals(vo.getIsParallel()))) continue;
            containsParallelGateway = true;
            break;
        }
        if (containsParallelGateway) {
            return this.backwardDeduplication(bpmnConfVo, bpmnStartConditions);
        }
        String initiator = ((BpmnNodeVo)mapNodes.get(startNodeId)).getParams().getAssignee().getAssignee();
        BpmnNodeVo bpmnNodeVo = (BpmnNodeVo)mapNodes.get(startNodeId);
        ArrayList<BpmnNodeVo> nodeVoList = new ArrayList<BpmnNodeVo>();
        while (!ObjectUtils.isEmpty((Object)bpmnNodeVo.getParams().getNodeTo())) {
            if ((bpmnNodeVo = (BpmnNodeVo)mapNodes.get(bpmnNodeVo.getParams().getNodeTo())).getParams().getParamType().equals(1)) {
                this.singlePlayerNodeDeduplication(bpmnNodeVo, new HashSet<String>(), new ArrayList<String>(Collections.singletonList(initiator)));
                nodeVoList.add(bpmnNodeVo);
                continue;
            }
            if (!bpmnNodeVo.getParams().getParamType().equals(2)) continue;
            this.multiPlayerNodeDeduplication(bpmnNodeVo, new HashSet<String>(), new ArrayList<String>(Collections.singletonList(initiator)), false);
            nodeVoList.add(bpmnNodeVo);
        }
        Collections.reverse(nodeVoList);
        ArrayList<String> approverList = new ArrayList<String>();
        for (BpmnNodeVo bpmnNode : nodeVoList) {
            if (bpmnNode.getParams().getParamType().equals(1)) {
                this.singlePlayerNodeDeduplication(bpmnNode, new HashSet<String>(), approverList);
                continue;
            }
            if (!bpmnNode.getParams().getParamType().equals(2)) continue;
            Collections.reverse(bpmnNode.getParams().getAssigneeList());
            this.multiPlayerNodeDeduplication(bpmnNode, new HashSet<String>(), approverList, true);
            Collections.reverse(bpmnNode.getParams().getAssigneeList());
        }
        return bpmnConfVo;
    }

    @Override
    public BpmnConfVo backwardDeduplication(BpmnConfVo bpmnConfVo, BpmnStartConditionsVo bpmnStartConditions) {
        ArrayList<String> approverList = new ArrayList<String>();
        String startNodeId = null;
        HashMap<String, BpmnNodeVo> mapNodes = new HashMap<String, BpmnNodeVo>();
        for (BpmnNodeVo vo : bpmnConfVo.getNodes()) {
            mapNodes.put(vo.getNodeId(), vo);
            if (ObjectUtils.isEmpty((Object)vo.getNodeType()) || !vo.getNodeType().equals(NodeTypeEnum.NODE_TYPE_START.getCode())) continue;
            startNodeId = vo.getNodeId();
        }
        String initiator = ((BpmnNodeVo)mapNodes.get(startNodeId)).getParams().getAssignee().getAssignee();
        approverList.add(initiator);
        BpmnNodeVo bpmnNodeVo = (BpmnNodeVo)mapNodes.get(startNodeId);
        this.processNodeRecursively(bpmnNodeVo, new HashSet<String>(), mapNodes, approverList);
        return bpmnConfVo;
    }

    private void processNodeRecursively(BpmnNodeVo bpmnNodeVo, Set<String> alreadyProcessedNodes, Map<String, BpmnNodeVo> mapNodes, List<String> approverList) {
        String nodeTo;
        String nextId = null;
        do {
            if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(bpmnNodeVo.getNodeType())) {
                List parallelNodeToIds = bpmnNodeVo.getNodeTo();
                for (String parallelNodeToId : parallelNodeToIds) {
                    BpmnNodeVo parallelNodeTo = mapNodes.get(parallelNodeToId);
                    if (parallelNodeTo == null) continue;
                    this.processNodeRecursively(parallelNodeTo, alreadyProcessedNodes, mapNodes, approverList);
                }
            }
            if (bpmnNodeVo.getParams().getParamType() != null && bpmnNodeVo.getParams().getParamType().equals(1)) {
                this.singlePlayerNodeDeduplication(bpmnNodeVo, alreadyProcessedNodes, approverList);
            } else if (bpmnNodeVo.getParams().getParamType() != null && bpmnNodeVo.getParams().getParamType().equals(2)) {
                this.multiPlayerNodeDeduplication(bpmnNodeVo, alreadyProcessedNodes, approverList, true);
            }
            nodeTo = this.getNodeTo(bpmnNodeVo);
            if (!Strings.isNullOrEmpty((String)nodeTo)) continue;
            return;
        } while (!StringUtils.isEmpty((CharSequence)(nextId = (bpmnNodeVo = this.getNextNodeVo(mapNodes.values(), nodeTo)).getNodeId())));
    }

    private BpmnNodeVo getNextNodeVo(Collection<BpmnNodeVo> nodes, String nodeTo) {
        List nextNodeVo = nodes.stream().filter(o -> o.getNodeId().equals(nodeTo)).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(nextNodeVo)) {
            throw new AFBizException("\u672a\u627e\u5230\u4e0b\u4e00\u8282\u70b9\u6d41\u7a0b\u53d1\u8d77\u5931\u8d25");
        }
        return (BpmnNodeVo)nextNodeVo.get(0);
    }

    private String getNodeTo(BpmnNodeVo nodeVo) {
        return Optional.ofNullable(nodeVo.getParams()).map(BpmnNodeParamsVo::getNodeTo).orElse(null);
    }

    private void singlePlayerNodeDeduplication(BpmnNodeVo bpmnNodeVo, Set<String> alreadyProcessedNods, List<String> approverList) {
        if (bpmnNodeVo.isDeduplicationExclude() || alreadyProcessedNods.contains(bpmnNodeVo.getNodeId())) {
            return;
        }
        if (bpmnNodeVo.getParams().getIsNodeDeduplication() == 1) {
            return;
        }
        BpmnNodeParamsAssigneeVo assignee = bpmnNodeVo.getParams().getAssignee();
        if (approverList.contains(assignee.getAssignee())) {
            assignee.setIsDeduplication(Integer.valueOf(1));
            bpmnNodeVo.getParams().setIsNodeDeduplication(1);
        } else {
            approverList.add(assignee.getAssignee());
        }
        alreadyProcessedNods.add(bpmnNodeVo.getNodeId());
    }

    private void multiPlayerNodeDeduplication(BpmnNodeVo bpmnNodeVo, Set<String> alreadyProcessedNods, List<String> approverList, Boolean flag) {
        if (bpmnNodeVo.isDeduplicationExclude() || alreadyProcessedNods.contains(bpmnNodeVo.getNodeId())) {
            return;
        }
        if (bpmnNodeVo.getParams().getIsNodeDeduplication() == 1) {
            return;
        }
        List assigneeList = bpmnNodeVo.getParams().getAssigneeList();
        int isNodeDeduplication = 1;
        for (BpmnNodeParamsAssigneeVo assignee : assigneeList) {
            if (assignee.getIsDeduplication().equals(1)) continue;
            if (approverList.contains(assignee.getAssignee())) {
                assignee.setIsDeduplication(Integer.valueOf(1));
                continue;
            }
            if (flag.booleanValue()) {
                approverList.add(assignee.getAssignee());
            }
            isNodeDeduplication = 0;
        }
        bpmnNodeVo.getParams().setIsNodeDeduplication(isNodeDeduplication);
        alreadyProcessedNods.add(bpmnNodeVo.getNodeId());
    }
}

