/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.alibaba.fastjson2.JSON;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.ButtonPageTypeEnum;
import org.openoa.base.constant.enums.ElementTypeEnum;
import org.openoa.base.constant.enums.ViewPageTypeEnum;
import org.openoa.base.entity.BpmVariable;
import org.openoa.base.entity.BpmVariableButton;
import org.openoa.base.entity.BpmVariableSequenceFlow;
import org.openoa.base.entity.BpmVariableSignUp;
import org.openoa.base.entity.BpmVariableViewPageButton;
import org.openoa.base.service.BpmVariableService;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.base.vo.BpmnConfCommonVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.common.adaptor.BpmnInsertVariableSubs;
import org.openoa.common.constant.enus.ElementPropertyEnum;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableMessageBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnInsertVariables;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmVariableButtonService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmVariableSequenceFlowService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmVariableSignUpService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmVariableViewPageButtonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BpmnInsertVariablesImpl
implements BpmnInsertVariables {
    private static final Logger log = LoggerFactory.getLogger(BpmnInsertVariablesImpl.class);
    @Autowired
    private BpmVariableService bpmVariableService;
    @Autowired
    private BpmVariableViewPageButtonService bpmVariableViewPageButtonService;
    @Autowired
    private BpmVariableButtonService bpmVariableButtonService;
    @Autowired
    private BpmVariableSequenceFlowService bpmVariableSequenceFlowService;
    @Autowired
    private BpmVariableSignUpService bpmVariableSignUpService;
    @Autowired
    private BpmVariableMessageBizService bpmVariableMessageBizService;

    @Override
    public void insertVariables(BpmnConfCommonVo bpmnConfCommonVo, BpmnStartConditionsVo bpmnStartConditions) {
        BpmVariable bpmVariable = BpmVariable.builder().bpmnCode(bpmnConfCommonVo.getBpmnCode()).processNum(bpmnConfCommonVo.getProcessNum()).processName(bpmnConfCommonVo.getProcessName()).processDesc(bpmnConfCommonVo.getProcessDesc()).processStartConditions(JSON.toJSONString((Object)bpmnStartConditions)).createUser(SecurityUtils.getLogInEmpIdSafe()).tenantId(MultiTenantUtil.getCurrentTenantId()).createTime(new Date()).build();
        this.bpmVariableService.getBaseMapper().insert((Object)bpmVariable);
        Long variableId = Optional.ofNullable(bpmVariable.getId()).orElse(0L);
        this.insertViewPageButton(bpmnConfCommonVo, variableId);
        ArrayListMultimap signUpMultimap = ArrayListMultimap.create();
        List elementList = bpmnConfCommonVo.getElementList();
        for (BpmnConfCommonElementVo elementVo : elementList) {
            Integer elementType = elementVo.getElementType();
            Integer elementProperty = elementVo.getElementProperty();
            if (elementType.equals(ElementTypeEnum.ELEMENT_TYPE_USER_TASK.getCode())) {
                BpmnInsertVariableSubs bean;
                Class bpmnInsertVariableSubs = ElementPropertyEnum.getVariableSubClsByCode((Integer)elementProperty);
                if (!ObjectUtils.isEmpty((Object)bpmnInsertVariableSubs) && !ObjectUtils.isEmpty((Object)(bean = (BpmnInsertVariableSubs)SpringBeanUtils.getBean((Class)bpmnInsertVariableSubs)))) {
                    bean.insertVariableSubs(elementVo, variableId);
                }
                if (elementVo.getIsSignUp() == 1) {
                    signUpMultimap.put((Object)elementVo.getElementId(), (Object)new BpmnConfCommonElementVo());
                }
                if (elementVo.getIsSignUpSubElement() == 1) {
                    signUpMultimap.put((Object)elementVo.getSignUpElementId(), (Object)elementVo);
                }
                this.insertElementButton(variableId, elementVo, elementVo.getElementId());
                continue;
            }
            if (!elementType.equals(ElementTypeEnum.ELEMENT_TYPE_SEQUENCE_FLOW.getCode())) continue;
            this.bpmVariableSequenceFlowService.getBaseMapper().insert((Object)BpmVariableSequenceFlow.builder().variableId(variableId).elementId(elementVo.getElementId()).elementName(elementVo.getElementName()).elementFromId(elementVo.getFlowFrom()).elementToId(elementVo.getFlowTo()).sequenceFlowType(Integer.valueOf(1)).tenantId(MultiTenantUtil.getCurrentTenantId()).build());
        }
        this.insertSignUp(variableId, (Multimap<String, BpmnConfCommonElementVo>)signUpMultimap, elementList);
        this.bpmVariableMessageBizService.insertVariableMessage(variableId, bpmnConfCommonVo);
    }

    private void insertSignUp(Long variableId, Multimap<String, BpmnConfCommonElementVo> signUpMultimap, List<BpmnConfCommonElementVo> elementList) {
        if (!signUpMultimap.isEmpty()) {
            ArrayList bpmVariableSignUps = Lists.newArrayList();
            for (String key : signUpMultimap.keySet()) {
                BpmnConfCommonElementVo elementVo = elementList.stream().filter(o -> o.getElementId().equals(key)).findFirst().orElse(new BpmnConfCommonElementVo());
                List subElements = signUpMultimap.get((Object)key).stream().filter(o -> !ObjectUtils.isEmpty((Object)o) && !ObjectUtils.isEmpty((Object)o.getElementId())).collect(Collectors.toList());
                bpmVariableSignUps.add(BpmVariableSignUp.builder().variableId(variableId).afterSignUpWay(elementVo.getAfterSignUpWay()).elementId(key).nodeId(elementVo.getNodeId()).subElements(JSON.toJSONString(subElements)).tenantId(MultiTenantUtil.getCurrentTenantId()).build());
            }
            this.bpmVariableSignUpService.saveBatch(bpmVariableSignUps);
        }
    }

    private void insertElementButton(Long variableId, BpmnConfCommonElementVo elementVo, String elementId) {
        if (!ObjectUtils.isEmpty((Object)elementVo.getButtons().getStartPage())) {
            this.bpmVariableButtonService.saveBatch(elementVo.getButtons().getStartPage().stream().map(o -> BpmVariableButton.builder().variableId(variableId).elementId(elementId).buttonPageType(Integer.valueOf(ButtonPageTypeEnum.INITIATE.getCode())).buttonType(o.getButtonType()).buttonName(o.getButtonName()).build()).collect(Collectors.toList()));
        }
        if (!ObjectUtils.isEmpty((Object)elementVo.getButtons().getApprovalPage())) {
            this.bpmVariableButtonService.saveBatch(elementVo.getButtons().getApprovalPage().stream().map(o -> BpmVariableButton.builder().variableId(variableId).elementId(elementId).buttonPageType(Integer.valueOf(ButtonPageTypeEnum.AUDIT.getCode())).buttonType(o.getButtonType()).buttonName(o.getButtonName()).build()).collect(Collectors.toList()));
        }
    }

    private void insertViewPageButton(BpmnConfCommonVo bpmnConfCommonVo, Long variableId) {
        if (!ObjectUtils.isEmpty((Object)bpmnConfCommonVo.getViewPageButtons().getViewPageStart())) {
            this.bpmVariableViewPageButtonService.saveBatch(bpmnConfCommonVo.getViewPageButtons().getViewPageStart().stream().map(o -> BpmVariableViewPageButton.builder().variableId(variableId).viewType(ViewPageTypeEnum.VIEW_PAGE_TYPE_START.getCode()).buttonType(o.getButtonType()).buttonName(o.getButtonName()).tenantId(MultiTenantUtil.getCurrentTenantId()).build()).collect(Collectors.toList()));
        }
        if (!ObjectUtils.isEmpty((Object)bpmnConfCommonVo.getViewPageButtons().getViewPageOther())) {
            this.bpmVariableViewPageButtonService.saveBatch(bpmnConfCommonVo.getViewPageButtons().getViewPageOther().stream().map(o -> BpmVariableViewPageButton.builder().variableId(variableId).viewType(ViewPageTypeEnum.VIEW_PAGE_TYPE_OTHER.getCode()).buttonType(o.getButtonType()).buttonName(o.getButtonName()).tenantId(MultiTenantUtil.getCurrentTenantId()).build()).collect(Collectors.toList()));
        }
    }
}

