/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.alibaba.fastjson2.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.MsgProcessEventEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmVerifyInfo;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.common.entity.BpmVariableMultiplayer;
import org.openoa.common.mapper.BpmVariableMultiplayerMapper;
import org.openoa.common.service.BpmVariableMultiplayerServiceImpl;
import org.openoa.engine.bpmnconf.common.ActivitiAdditionalInfoServiceImpl;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.biz.ProcessApprovalServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.TripleConsumer;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmVerifyInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BpmnProcessMigrationServiceImpl {
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessApprovalServiceImpl processApprovalService;
    @Autowired
    private ActivitiAdditionalInfoServiceImpl additionalInfoService;
    @Autowired
    private TaskMgmtMapper taskMgmtMapper;
    @Autowired
    private BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private BpmVerifyInfoService bpmVerifyInfoService;
    @Autowired
    private BpmVariableMultiplayerServiceImpl bpmVariableMultiplayerService;

    public void migrateAndJumpToCurrent(Task currentTask, BpmBusinessProcess bpmBusinessProcess, BusinessDataVo vo, TripleConsumer<BusinessDataVo, Task, BpmBusinessProcess> tripleConsumer) {
        String currentTaskDefKey = currentTask.getTaskDefinitionKey();
        String currentComment = vo.getApprovalComment();
        BusinessDataVo submitVo = (BusinessDataVo)JSON.to(BusinessDataVo.class, (Object)vo);
        submitVo.setIsMigration(Boolean.valueOf(true));
        submitVo.setStartUserId(bpmBusinessProcess.getCreateUser());
        submitVo.setBpmnCode(bpmBusinessProcess.getVersion());
        submitVo.setOperationType(MsgProcessEventEnum.PROCESS_SUBMIT.getCode());
        this.processApprovalService.buttonsOperation(JSON.toJSONString((Object)submitVo), submitVo.getFormCode());
        bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(vo.getProcessNumber());
        String procDefIdByInstId = this.taskMgmtMapper.findProcDefIdByInstId(bpmBusinessProcess.getProcInstId());
        if (StringUtils.isBlank((CharSequence)procDefIdByInstId)) {
            throw new AFBizException("\u672a\u80fd\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\u67e5\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49id,\u8bf7\u68c0\u67e5\u903b\u8f91!");
        }
        List<ActivityImpl> activitiList = this.additionalInfoService.getActivitiList(procDefIdByInstId);
        boolean currentExecuted = false;
        for (ActivityImpl activity : activitiList) {
            if (currentExecuted) break;
            String id = activity.getId();
            List tsks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(bpmBusinessProcess.getProcInstId())).taskDefinitionKey(activity.getId())).taskTenantId(MultiTenantUtil.getCurrentTenantId())).list();
            Map<Object, Object> verifyInfoMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)tsks)) {
                List bpmVariableMultiplayerList;
                List taskNames;
                verifyInfoMap = this.bpmVerifyInfoService.getByProcInstIdAndTaskDefKey(bpmBusinessProcess.getBusinessNumber(), id);
                if (tsks.size() > 1 && (taskNames = tsks.stream().map(TaskInfo::getName).distinct().collect(Collectors.toList())).size() == 1 && !CollectionUtils.isEmpty((Collection)(bpmVariableMultiplayerList = ((BpmVariableMultiplayerMapper)this.bpmVariableMultiplayerService.getBaseMapper()).isMoreNode(bpmBusinessProcess.getBusinessNumber(), ((Task)tsks.get(0)).getTaskDefinitionKey()))) && ((BpmVariableMultiplayer)bpmVariableMultiplayerList.get(0)).getSignType() == 2) {
                    if (currentTaskDefKey.equals(id)) {
                        tsks = tsks.stream().filter(a -> a.getAssignee().equals(currentTask.getAssignee())).collect(Collectors.toList());
                    } else {
                        List verifyUserIds = verifyInfoMap.values().stream().map(BpmVerifyInfo::getVerifyUserId).collect(Collectors.toList());
                        tsks = tsks.stream().filter(a -> verifyUserIds.contains(a.getAssignee())).collect(Collectors.toList());
                    }
                }
                for (Task tsk : tsks) {
                    if (!CollectionUtils.isEmpty(verifyInfoMap)) {
                        BpmVerifyInfo bpmVerifyInfo = (BpmVerifyInfo)verifyInfoMap.get(tsk.getTaskDefinitionKey() + tsk.getAssignee());
                        vo.setStartUserId(tsk.getAssignee());
                        if (bpmVerifyInfo != null) {
                            if (!StringUtils.isEmpty((CharSequence)tsk.getAssigneeName())) {
                                vo.setStartUserName(tsk.getAssigneeName());
                            } else {
                                vo.setStartUserName(bpmVerifyInfo.getVerifyUserName());
                            }
                            vo.setApprovalComment("currentUserAlreadyProcessed");
                        } else {
                            if (!StringUtils.isEmpty((CharSequence)tsk.getAssigneeName())) {
                                vo.setStartUserName(tsk.getAssigneeName());
                            }
                            if (currentTaskDefKey.equals(tsk.getTaskDefinitionKey())) {
                                vo.setApprovalComment(currentComment);
                            }
                        }
                    } else {
                        vo.setStartUserName(tsk.getAssigneeName());
                        if (currentTaskDefKey.equals(tsk.getTaskDefinitionKey())) {
                            vo.setApprovalComment(currentComment);
                        }
                    }
                    tripleConsumer.accept(vo, tsk, bpmBusinessProcess);
                }
            }
            if (!currentTaskDefKey.equals(id)) continue;
            currentExecuted = true;
        }
    }
}

