/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.BpmnConfFlagsEnum;
import org.openoa.base.constant.enums.ProcessNoticeEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.BpmProcessNotice;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.entity.DictData;
import org.openoa.base.util.PageUtils;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseKeyValueStruVo;
import org.openoa.base.vo.BaseNumIdStruVo;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.base.vo.TaskMgmtVO;
import org.openoa.engine.bpmnconf.mapper.DicDataMapper;
import org.openoa.engine.bpmnconf.mapper.DictMainMapper;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnConfBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.LowCodeFlowBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessNoticeService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnConfService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DictServiceImpl
implements LowCodeFlowBizService {
    @Autowired
    private DictMainMapper dictMainMapper;
    @Autowired
    private DicDataMapper dicDataMapper;
    @Autowired
    private BpmnConfBizService bpmnConfBizService;
    @Autowired
    private BpmProcessNoticeService bpmProcessNoticeService;

    @Override
    public List<BaseKeyValueStruVo> getLowCodeFlowFormCodes() {
        List<DictData> lowcodeList = this.getDictItemsByType("lowcodeflow");
        ArrayList<BaseKeyValueStruVo> results = new ArrayList<BaseKeyValueStruVo>();
        for (DictData item : lowcodeList) {
            results.add(BaseKeyValueStruVo.builder().key(item.getValue()).value(item.getLabel()).type("LF").remark(item.getRemark()).build());
        }
        return results;
    }

    @Override
    public ResultAndPage<BaseKeyValueStruVo> selectLFFormCodePageList(PageDto pageDto, TaskMgmtVO taskMgmtVO) {
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto);
        List<DictData> dictDataList = this.dicDataMapper.selectLFFormCodePageList(page, taskMgmtVO);
        return this.handleLFFormCodePageList(page, dictDataList);
    }

    @Override
    public ResultAndPage<BaseKeyValueStruVo> selectLFActiveFormCodePageList(PageDto pageDto, TaskMgmtVO taskMgmtVO) {
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto);
        List<DictData> dictDataList = this.dicDataMapper.selectLFActiveFormCodePageList(page, taskMgmtVO);
        return this.handleLFFormCodePageList(page, dictDataList);
    }

    @Override
    public Integer addFormCode(BaseKeyValueStruVo vo) {
        Integer result = 0;
        LambdaQueryWrapper qryByValue = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictData::getValue, (Object)vo.getKey());
        List dictData = this.dicDataMapper.selectList((Wrapper)qryByValue);
        if (dictData.isEmpty()) {
            DictData entity = new DictData();
            entity.setDictType("lowcodeflow");
            entity.setValue(vo.getKey());
            entity.setLabel(vo.getValue());
            entity.setRemark(vo.getRemark());
            entity.setIsDefault("N");
            entity.setIsDel(Integer.valueOf(0));
            entity.setCreateUser(SecurityUtils.getLogInEmpName());
            entity.setCreateTime(new Date());
            result = this.dicDataMapper.insert(entity);
        }
        return result;
    }

    private List<DictData> getDictItemsByType(String dictType) {
        LambdaQueryWrapper qryByDictType = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictData::getDictType, (Object)dictType);
        List dictData = this.dicDataMapper.selectList((Wrapper)qryByDictType);
        dictData.sort(Comparator.comparing(DictData::getCreateTime).reversed());
        return dictData;
    }

    private ResultAndPage<BaseKeyValueStruVo> handleLFFormCodePageList(Page page, List<DictData> dictlist) {
        if (dictlist == null) {
            return PageUtils.getResultAndPage((Page)page);
        }
        ArrayList<BaseKeyValueStruVo> results = new ArrayList<BaseKeyValueStruVo>();
        for (DictData item : dictlist) {
            results.add(BaseKeyValueStruVo.builder().key(item.getValue()).value(item.getLabel()).createTime(item.getCreateTime()).type("LF").remark(item.getRemark()).build());
        }
        List<String> formCodes = results.stream().map(BaseKeyValueStruVo::getKey).collect(Collectors.toList());
        if (!formCodes.isEmpty()) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{BpmnConf::getFormCode, BpmnConf::getExtraFlags}).in(BpmnConf::getFormCode, formCodes)).eq(BpmnConf::getEffectiveStatus, (Object)1);
            List bpmnConfs = ((BpmnConfService)this.bpmnConfBizService.getService()).list((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)bpmnConfs)) {
                Map<String, Integer> formCode2Flags = bpmnConfs.stream().filter(a -> a.getExtraFlags() != null).collect(Collectors.toMap(BpmnConf::getFormCode, BpmnConf::getExtraFlags, (v1, v2) -> v1));
                Map<String, List<BpmProcessNotice>> processNoticeMap = this.bpmProcessNoticeService.processNoticeMap(formCodes);
                for (BaseKeyValueStruVo lfDto : results) {
                    String formCode;
                    List<BpmProcessNotice> bpmProcessNotices;
                    Integer flags = formCode2Flags.get(lfDto.getKey());
                    if (flags != null) {
                        boolean hasStartUserChooseModules = BpmnConfFlagsEnum.hasFlag((Integer)flags, (BpmnConfFlagsEnum)BpmnConfFlagsEnum.HAS_STARTUSER_CHOOSE_MODULES);
                        lfDto.setHasStarUserChooseModule(Boolean.valueOf(hasStartUserChooseModules));
                    }
                    if (!CollectionUtils.isEmpty(bpmProcessNotices = processNoticeMap.get(formCode = lfDto.getKey()))) {
                        ArrayList<BaseNumIdStruVo> processNotices = new ArrayList<BaseNumIdStruVo>();
                        for (ProcessNoticeEnum value : ProcessNoticeEnum.values()) {
                            Integer type = value.getCode();
                            String descByCode = value.getDesc();
                            BaseNumIdStruVo struVo = new BaseNumIdStruVo();
                            struVo.setId(Long.valueOf(type.longValue()));
                            struVo.setName(descByCode);
                            for (BpmProcessNotice bpmProcessNotice : bpmProcessNotices) {
                                if (!Objects.equals(value.getCode(), bpmProcessNotice.getType())) continue;
                                struVo.setActive(Boolean.valueOf(true));
                            }
                            processNotices.add(struVo);
                        }
                        lfDto.setProcessNotices(processNotices);
                    }
                    BpmnConfVo confVo = new BpmnConfVo();
                    confVo.setFormCode(formCode);
                    this.bpmnConfBizService.setBpmnTemplateVos(confVo);
                    lfDto.setTemplateVos(confVo.getTemplateVos());
                }
            }
        }
        page.setRecords(results);
        return PageUtils.getResultAndPage((Page)page);
    }
}

