/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openoa.base.entity.UserMessage;
import org.openoa.base.entity.UserMessageStatus;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.util.MailUtils;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseMsgInfo;
import org.openoa.base.vo.MailInfo;
import org.openoa.base.vo.MessageInfo;
import org.openoa.engine.bpmnconf.service.interf.repository.UserMessageService;
import org.openoa.engine.bpmnconf.service.interf.repository.UserMessageStatusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class MessageServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    private BpmnEmployeeInfoProviderService bpmnEmployeeInfoProviderService;
    @Autowired
    private UserMessageService userMessageService;
    @Autowired
    private UserMessageStatusService userMessageStatusService;
    @Autowired
    private MailUtils mailUtils;

    @Async
    public void sendMail(MailInfo mailInfo, String userId) {
        UserMessageStatus userMessageStatus = this.getUserMessageStatus(userId);
        if (userMessageStatus == null) {
            this.mailUtils.doSendMail(mailInfo);
            return;
        }
        if (Boolean.TRUE.equals(userMessageStatus.getMailStatus())) {
            this.mailUtils.doSendMail(mailInfo);
        }
    }

    @Async
    public void sendMailBatch(Map<String, MailInfo> map) {
        ArrayList mailInfos = Lists.newArrayList();
        for (Map.Entry<String, MailInfo> entry : map.entrySet()) {
            UserMessageStatus userMessageStatus = this.getUserMessageStatus(entry.getKey());
            if (userMessageStatus == null) {
                mailInfos.add(entry.getValue());
                continue;
            }
            if (!Boolean.TRUE.equals(userMessageStatus.getMailStatus())) continue;
            mailInfos.add(entry.getValue());
        }
        if (!CollectionUtils.isEmpty((Collection)mailInfos)) {
            this.mailUtils.doSendMailBatch((List)mailInfos);
        }
    }

    @Async
    public void sendSms(MessageInfo messageInfo, String userId) {
        UserMessageStatus userMessageStatus = this.getUserMessageStatus(userId);
    }

    @Async
    public void sendSmsBatch(Map<String, MessageInfo> map) {
        ArrayList messageInfos = Lists.newArrayList();
        for (Map.Entry<String, MessageInfo> entry : map.entrySet()) {
            UserMessageStatus userMessageStatus = this.getUserMessageStatus(entry.getKey());
        }
    }

    @Async
    public void sendAppPush(BaseMsgInfo baseMsgInfo, String userId) {
        this.doSendAppPush(baseMsgInfo, userId);
    }

    @Async
    public void sendAppPushBatch(Map<String, BaseMsgInfo> map) {
        for (Map.Entry<String, BaseMsgInfo> entry : map.entrySet()) {
            this.doSendAppPush(entry.getValue(), entry.getKey());
        }
    }

    @Async
    public void insertUserMessage(UserMessage userMessage) {
        if (ObjectUtils.isEmpty((Object)userMessage.getUserId())) {
            return;
        }
        userMessage.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
        userMessage.setCreateTime(new Date());
        userMessage.setUpdateUser(SecurityUtils.getLogInEmpNameSafe());
        userMessage.setUpdateTime(new Date());
        this.userMessageService.insertMessage(userMessage);
    }

    @Async
    public void insertUserMessageBatch(List<UserMessage> userMessages) {
        for (UserMessage userMessage : userMessages) {
            if (ObjectUtils.isEmpty((Object)userMessage.getUserId())) continue;
            userMessage.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
            userMessage.setCreateTime(new Date());
            userMessage.setUpdateUser(SecurityUtils.getLogInEmpNameSafe());
            userMessage.setUpdateTime(new Date());
        }
        this.userMessageService.saveBatch(userMessages);
    }

    private void doSendAppPush(BaseMsgInfo baseMsgInfo, String userId) {
        baseMsgInfo.setUsername(this.getUsernameByUserId(userId));
        UserMessageStatus userMessageStatus = this.getUserMessageStatus(userId);
    }

    private UserMessageStatus getUserMessageStatus(String userId) {
        return (UserMessageStatus)this.userMessageStatusService.getBaseMapper().selectOne((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId));
    }

    private String getUsernameByUserId(String userId) {
        Map employeeInfo = this.bpmnEmployeeInfoProviderService.provideEmployeeInfo((Collection)Lists.newArrayList((Object[])new String[]{String.valueOf(userId)}));
        return (String)employeeInfo.get(String.valueOf(userId));
    }
}

