/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateTask;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.ProcessEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmManualNotify;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.OperationResp;
import org.openoa.base.vo.SendParam;
import org.openoa.base.vo.TaskMgmtVO;
import org.openoa.base.vo.UrlParams;
import org.openoa.engine.bpmnconf.common.ProcessConstants;
import org.openoa.engine.bpmnconf.mapper.BpmBusinessProcessMapper;
import org.openoa.engine.bpmnconf.mapper.BpmFlowrunEntrustMapper;
import org.openoa.engine.bpmnconf.mapper.BpmManualNotifyMapper;
import org.openoa.engine.bpmnconf.mapper.BpmTaskconfigMapper;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmTaskconfigService;
import org.openoa.engine.utils.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class NotifyServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(NotifyServiceImpl.class);
    @Autowired
    private BpmManualNotifyMapper bpmManualNotifyMapper;
    @Autowired
    private TaskMgmtMapper taskMgmtMapper;
    @Autowired
    private ProcessConstants processConstants;
    @Autowired
    private TaskService taskService;
    @Autowired
    private AfUserService employeeService;
    @Autowired
    private BpmFlowrunEntrustMapper bpmFlowrunEntrustMapper;
    @Autowired
    private BpmTaskconfigMapper bpmTaskconfigMapper;
    @Autowired
    private BpmBusinessProcessMapper bpmBusinessProcessMapper;
    @Autowired
    private BpmTaskconfigService bpmTaskconfigService;
    private static final long ALLOWED = 7200L;
    private static final String PROC_TO_DO = "/main/tab?tabKey=examine&menuCode=approval&subMenuCode=pending";

    public void endNotify(String entryId) {
        try {
            TaskMgmtVO taskMgmtVO = this.taskMgmtMapper.findByEntryId(entryId);
            BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessMapper.findBpmBusinessProcess(BpmBusinessProcess.builder().entryId(entryId).build());
            String procDefId = taskMgmtVO.getProcessName().split(":")[0];
            String processName = this.taskMgmtMapper.getProcessName(procDefId);
            String code = taskMgmtVO.getProcessNumber().split("_")[0];
            String title = "\u60a8\u7684" + processName + bpmBusinessProcess.getBusinessNumber() + "\u5df2\u5b8c\u6210\u3002";
            UrlParams urlParams = new UrlParams();
            urlParams.setBusinessId(entryId.split(":")[1]);
            urlParams.setCode(code);
            Map<String, Object> map = this.bpmTaskconfigMapper.findByAppRoute(procDefId, null, "test");
            String appUrl = StringUtils.join((Object[])new String[]{this.processConstants.getMapValue(map, "routeUrl"), entryId.split(":")[1]});
            SendParam sendParam = SendParam.builder().appUrl(appUrl).userId(taskMgmtVO.getApplyUser()).urlParams(urlParams).params("check").title(title).content(title).build();
            MessageUtils.sendMessage(sendParam);
        }
        catch (Exception e) {
            log.error("process finish notice error", (Throwable)e);
        }
    }

    public void cancelNotify(String entryId) {
        try {
            TaskMgmtVO taskMgmtVO = this.taskMgmtMapper.findByEntryId(entryId);
            BaseIdTranStruVo startUser = this.employeeService.getById(taskMgmtVO.getApplyUser());
            String procDefId = taskMgmtVO.getProcessName().split(":")[0];
            String processName = this.taskMgmtMapper.getProcessName(procDefId);
            String code = taskMgmtVO.getProcessNumber().split("_")[0];
            BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessMapper.findBpmBusinessProcess(BpmBusinessProcess.builder().entryId(entryId).build());
            String title = "\u60a8\u53c2\u4e0e\u7684" + processName + bpmBusinessProcess.getBusinessNumber() + "\u5df2\u88ab" + startUser.getName() + "\u64a4\u9500\u3002";
            UrlParams urlParams = new UrlParams();
            urlParams.setBusinessId(entryId.split(":")[1]);
            urlParams.setCode(code);
            Map<String, Object> map = this.bpmTaskconfigMapper.findByAppRoute(procDefId, null, "test");
            String appUrl = StringUtils.join((Object[])new String[]{this.processConstants.getMapValue(map, "routeUrl"), entryId.split(":")[1]});
            List<String> assignees = this.taskMgmtMapper.getAssigneesByEntryId(entryId);
            if (!ObjectUtils.isEmpty(assignees)) {
                for (String o : assignees) {
                    if (Strings.isNullOrEmpty((String)o) || o.equals(ProcessEnum.PROC_MAN.getDesc())) continue;
                    SendParam sendParam = SendParam.builder().params("check").appUrl(appUrl).urlParams(urlParams).userId(o).title(title).content(title).build();
                    MessageUtils.sendMessage(sendParam);
                }
            }
        }
        catch (Exception e) {
            log.error("\u64a4\u9500\u901a\u77e5\u51fa\u9519", (Throwable)e);
        }
    }

    public String notifyByHand(String code, Long businessId) {
        String rst = "\u63d0\u9192\u6210\u529f";
        BpmManualNotify bpmManualNotify = BpmManualNotify.builder().code(code).businessId(businessId).build();
        List list = this.bpmManualNotifyMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"code", (Object)code)).eq((Object)"business_id", (Object)businessId));
        String entryId = this.taskMgmtMapper.getEntryId(code, businessId);
        if (ObjectUtils.isEmpty((Object)list)) {
            this.manualNotifyHelper(entryId);
            this.bpmManualNotifyMapper.insert(bpmManualNotify);
        } else {
            BpmManualNotify existedNotify = (BpmManualNotify)list.get(0);
            Date lastTime = existedNotify.getLastTime();
            Date now = new Date();
            long offset = (now.getTime() - lastTime.getTime()) / 1000L;
            if (offset < 7200L) {
                long deviation = 7200L - offset;
                long hour = deviation % 86400L / 3600L;
                long minute = deviation % 3600L / 60L;
                rst = "\u8bf7\u4e8e" + hour + "\u5c0f\u65f6" + minute + "\u5206\u949f\u540e\u518d\u63d0\u9192!";
                throw new AFBizException(OperationResp.FAILURE.getCode(), rst);
            }
            this.manualNotifyHelper(entryId);
            existedNotify.setLastTime(new Date());
            this.bpmManualNotifyMapper.updateById(existedNotify);
        }
        return rst;
    }

    public void manualNotifyHelper(String entryId) {
        try {
            String startUser = SecurityUtils.getLogInEmpNameSafe();
            BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessMapper.findBpmBusinessProcess(BpmBusinessProcess.builder().entryId(entryId).build());
            String processNumber = bpmBusinessProcess.getBusinessNumber();
            String procDefId = bpmBusinessProcess.getProcessinessKey();
            String processName = this.taskMgmtMapper.getProcessName(procDefId);
            String title = startUser + "\u63d0\u9192\u60a8\u5c3d\u5feb\u5904\u7406" + processName + processNumber + "\u3002";
            List<TaskMgmtVO> currentAssignees = this.taskMgmtMapper.getCurrentAssignee(entryId);
            if (ObjectUtils.isEmpty(currentAssignees)) {
                throw new AFBizException(OperationResp.FAILURE.getCode(), "\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u65e0\u5904\u7406\u4eba\uff01");
            }
            currentAssignees.forEach(o -> {
                if (Strings.isNullOrEmpty((String)o.getOriginalName()) || o.getOriginalName().equals(ProcessEnum.PROC_MAN.getDesc())) {
                    throw new AFBizException(OperationResp.FAILURE.getCode(), "\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u65e0\u5904\u7406\u4eba\uff01");
                }
                SendParam sendParam = SendParam.builder().userId(o.getOriginalName()).title(title).appUrl(PROC_TO_DO).content(title).params("myTask").urlParams(new UrlParams()).build();
                MessageUtils.sendMessage(sendParam);
            });
        }
        catch (Exception e) {
            log.error("manual notice error", (Throwable)e);
        }
    }

    public String getUrl(BpmBusinessProcess bpmBusinessProcess, DelegateTask task) {
        String processCode = bpmBusinessProcess.getBusinessNumber().split("_")[0];
        String url = "";
        if (ObjectUtils.isEmpty((Object)task)) {
            url = "/user/workflow/Upcoming/apply/" + processCode + "/" + bpmBusinessProcess.getBusinessId();
        } else {
            Map<String, Object> map = this.bpmTaskconfigService.findTaskNodeType(task.getTaskDefinitionKey());
            url = "/user/workflow/Upcoming/check/" + processCode + "/" + bpmBusinessProcess.getBusinessId() + "/" + this.processConstants.getMapValue(map, "nodeType") + "/" + task.getId();
        }
        log.info("**************\u7ec4\u88c5\u8fde\u63a5\uff1a" + url + "*********************");
        return url;
    }

    public void notifyCurrent(String assignee, String entryId, DelegateTask task) {
        try {
            BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessMapper.findBpmBusinessProcess(BpmBusinessProcess.builder().entryId(entryId).build());
            String procDefId = bpmBusinessProcess.getProcessinessKey();
            String processNumber = bpmBusinessProcess.getBusinessNumber();
            String processName = this.taskMgmtMapper.getProcessName(procDefId);
            SendParam sendParam = new SendParam();
            UrlParams urlParams = new UrlParams();
            if (Strings.isNullOrEmpty((String)assignee) || assignee.equals(ProcessEnum.PROC_MAN.getDesc())) {
                Map map = null;
                Integer procType = Optional.ofNullable(this.taskMgmtMapper.getProcType(procDefId)).orElse(-1);
                List assignees = (List)map.get(procType);
                if (ObjectUtils.isEmpty((Object)assignees)) {
                    log.error("current has no admin\uff01");
                } else {
                    ArrayList<SendParam> sendParamList = new ArrayList<SendParam>();
                    assignees.forEach(o -> {
                        SendParam send = new SendParam();
                        String title = processName + processNumber + "\u65e0\u4eba\u5904\u7406\uff0c\u8bf7\u81f3\u6d41\u7a0b\u7ba1\u7406\u4e2d\u8fdb\u884c\u5e72\u9884\u3002";
                        send.setTitle("\u60a8\u67091\u4e2a" + processName + processNumber + "\u65e0\u4eba\u5904\u7406\uff0c\u8bf7\u81f3\u6d41\u7a0b\u7ba1\u7406\u4e2d\u8fdb\u884c\u5e72\u9884\u3002");
                        send.setContent(title);
                        send.setParams("workflowList");
                        send.setUrlParams(urlParams);
                        send.setUrl("/manage/setting/work-process/process-manage");
                        send.setUserId(o.toString());
                        send.setNode(task.getId());
                        sendParamList.add(send);
                    });
                    MessageUtils.sendMessageBatch(sendParamList);
                }
            } else {
                String url = this.getUrl(bpmBusinessProcess, task);
                sendParam.setUserId(assignee);
                sendParam.setTitle("\u60a8\u67091\u4e2a" + bpmBusinessProcess.getDescription() + "\u9700\u8981\u5904\u7406\u3002");
                sendParam.setContent("\u60a8\u67091\u4e2a" + processName + processNumber + bpmBusinessProcess.getDescription() + "\u9700\u8981\u5904\u7406\u3002");
                sendParam.setUrl(url);
                if (!ObjectUtils.isEmpty((Object)task)) {
                    sendParam.setNode(task.getId());
                }
                sendParam.setAppUrl(PROC_TO_DO);
                sendParam.setParams("myTask");
                sendParam.setUrlParams(urlParams);
                MessageUtils.sendMessage(sendParam);
            }
        }
        catch (Exception e) {
            log.error("sent notification error", (Throwable)e);
        }
    }

    public void passNotify(String procInstId, String entryId) {
        try {
            List<Integer> bpmFlowrunEntrusts = this.bpmFlowrunEntrustMapper.getCirculated(procInstId);
            if (ObjectUtils.isEmpty(bpmFlowrunEntrusts)) {
                return;
            }
            BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessMapper.findBpmBusinessProcess(BpmBusinessProcess.builder().entryId(entryId).build());
            String procDefId = bpmBusinessProcess.getProcessinessKey();
            String processNumber = bpmBusinessProcess.getBusinessNumber();
            String processName = this.taskMgmtMapper.getProcessName(procDefId);
            String code = processNumber.split("_")[0];
            String title = "\u60a8\u5173\u6ce8\u7684" + processName + processNumber + "\u5df2\u6709\u65b0\u7684\u8fdb\u5c55\u3002";
            UrlParams urlParams = new UrlParams();
            urlParams.setBusinessId(entryId.split(":")[1]);
            urlParams.setCode(code);
            Map<String, Object> map = this.bpmTaskconfigMapper.findByAppRoute(procDefId, null, "test");
            String appUrl = StringUtils.join((Object[])new String[]{this.processConstants.getMapValue(map, "routeUrl"), entryId.split(":")[0]});
            bpmFlowrunEntrusts.forEach(o -> {
                SendParam sendParam = SendParam.builder().userId(o.toString()).params("check").appUrl(appUrl).urlParams(urlParams).title(title).content(title).build();
                MessageUtils.sendMessage(sendParam);
            });
        }
        catch (Exception e) {
            log.error("\u6d41\u8f6c\u901a\u77e5\u51fa\u9519", (Throwable)e);
        }
    }
}

