/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.openoa.base.constant.enums.ButtonTypeEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.entity.Employee;
import org.openoa.base.entity.OutSideBpmAccessBusiness;
import org.openoa.base.entity.OutSideBpmBusinessParty;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.mapper.UserMapper;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.util.DateUtil;
import org.openoa.base.util.PageUtils;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmVerifyInfoVo;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodeParamsVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.base.vo.OutSideBpmAccessEmbedNodeVo;
import org.openoa.base.vo.PreviewNode;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.mapper.BpmnConfMapper;
import org.openoa.engine.bpmnconf.mapper.OutSideBpmAccessBusinessMapper;
import org.openoa.engine.bpmnconf.service.biz.ButtonOperationServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVerifyInfoBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnConfBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.OutSideBpmAccessBusinessBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnConfService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmAccessBusinessService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmBusinessPartyService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmConditionsTemplateService;
import org.openoa.engine.lowflow.vo.UDLFApplyVo;
import org.openoa.engine.vo.OutSideBpmAccessBusinessVo;
import org.openoa.engine.vo.OutSideBpmAccessProcessRecordVo;
import org.openoa.engine.vo.OutSideBpmAccessRespVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutSideBpmAccessBusinessBizServiceImpl
implements OutSideBpmAccessBusinessBizService {
    @Autowired
    private OutSideBpmAccessBusinessMapper outSideBpmAccessBusinessMapper;
    @Autowired
    private OutSideBpmBusinessPartyService outSideBpmBusinessPartyService;
    @Autowired
    private ButtonOperationServiceImpl processApprovalService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private BpmVerifyInfoBizService bpmVerifyInfoNewService;
    @Autowired
    @Lazy
    private BpmnConfBizService bpmnConfCommonService;
    @Autowired
    private BpmnConfService bpmnConfService;
    @Autowired
    private OutSideBpmConditionsTemplateService outSideBpmConditionsTemplateService;
    @Autowired
    private BpmnEmployeeInfoProviderService bpmnEmployeeInfoProviderService;

    @Override
    public OutSideBpmAccessRespVo accessBusinessStart(OutSideBpmAccessBusinessVo vo) {
        OutSideBpmAccessBusiness outSideBpmAccessBusiness = (OutSideBpmAccessBusiness)((OutSideBpmAccessBusinessMapper)this.getMapper()).selectById(vo.getId());
        if (outSideBpmAccessBusiness != null) {
            BeanUtils.copyProperties((Object)vo, (Object)outSideBpmAccessBusiness);
            outSideBpmAccessBusiness.setUpdateUser(SecurityUtils.getLogInEmpId());
            outSideBpmAccessBusiness.setUpdateTime(new Date());
            ((OutSideBpmAccessBusinessService)this.getService()).updateById(outSideBpmAccessBusiness);
        } else {
            String formCode = vo.getFormCode();
            Wrapper qryWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"form_code", (Object)formCode)).eq((Object)"effective_status", (Object)1)).eq((Object)"is_del", (Object)0);
            BpmnConf effectiveConfByFormCode = (BpmnConf)this.bpmnConfService.getOne(qryWrapper);
            if (effectiveConfByFormCode == null) {
                throw new AFBizException(String.format("\u672a\u80fd\u6839\u636e\u6d41\u7a0b\u7f16\u53f7%s\u627e\u5230\u6709\u6548\u7684\u6d41\u7a0b\u914d\u7f6e,\u8bf7\u68c0\u67e5\u540c\u4e1a\u5165\u53c2", formCode));
            }
            vo.setBpmnConfId(effectiveConfByFormCode.getId());
            outSideBpmAccessBusiness = new OutSideBpmAccessBusiness();
            BeanUtils.copyProperties((Object)vo, (Object)outSideBpmAccessBusiness);
            if (!CollectionUtils.isEmpty(vo.getTemplateMarks())) {
                String templateMarksJoin = String.join((CharSequence)",", vo.getTemplateMarks());
                outSideBpmAccessBusiness.setTemplateMark(templateMarksJoin);
            }
            outSideBpmAccessBusiness.setBusinessPartyId(effectiveConfByFormCode.getBusinessPartyId());
            outSideBpmAccessBusiness.setCreateUser(SecurityUtils.getLogInEmpIdSafe());
            outSideBpmAccessBusiness.setCreateTime(new Date());
            outSideBpmAccessBusiness.setUpdateUser(SecurityUtils.getLogInEmpIdSafe());
            outSideBpmAccessBusiness.setUpdateTime(new Date());
            ((OutSideBpmAccessBusinessService)this.getService()).save(outSideBpmAccessBusiness);
        }
        BusinessDataVo businessDataVo = new BusinessDataVo();
        if (vo.getIsLowCodeFlow() != null && Boolean.TRUE.equals(vo.getIsLowCodeFlow())) {
            businessDataVo = new UDLFApplyVo();
            ((UDLFApplyVo)businessDataVo).setLfFields(vo.getLfFields());
        }
        businessDataVo.setFormCode(vo.getFormCode());
        businessDataVo.setOperationType(ButtonTypeEnum.BUTTON_TYPE_SUBMIT.getCode());
        businessDataVo.setBusinessId(outSideBpmAccessBusiness.getId().toString());
        businessDataVo.setOutSideType(Integer.valueOf(2));
        businessDataVo.setApproversList(vo.getApproversList());
        businessDataVo.setIsLowCodeFlow(Integer.valueOf(Boolean.TRUE.equals(vo.getIsLowCodeFlow()) ? 1 : 0));
        if (StringUtil.isEmpty((CharSequence)vo.getUserId())) {
            throw new AFBizException("\u53d1\u8d77\u4eba\u7528\u6237\u540d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u8d77\u6d41\u7a0b\uff01");
        }
        businessDataVo.setStartUserId(SecurityUtils.getLogInEmpIdSafe());
        businessDataVo.setStartUserName(SecurityUtils.getLogInEmpNameSafe());
        businessDataVo.setEmpId(SecurityUtils.getLogInEmpIdSafe());
        businessDataVo.setSubmitUser(SecurityUtils.getLogInEmpNameSafe());
        businessDataVo.setEmbedNodes(this.reSetEmbedNodes(vo.getEmbedNodes()));
        this.processApprovalService.buttonsOperationTransactional(businessDataVo);
        OutSideBpmAccessBusiness outSideBpmAccessBusinessResult = (OutSideBpmAccessBusiness)((OutSideBpmAccessBusinessMapper)this.getMapper()).selectById(outSideBpmAccessBusiness.getId());
        return OutSideBpmAccessRespVo.builder().processNumber(outSideBpmAccessBusinessResult.getProcessNumber()).businessId(outSideBpmAccessBusinessResult.getId().toString()).processRecord(this.getProcessRecord(outSideBpmAccessBusinessResult.getProcessNumber())).build();
    }

    @Override
    public ResultAndPage<BpmnConfVo> selectOutSideFormCodePageList(PageDto pageDto, BpmnConfVo vo) {
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto);
        List<BpmnConfVo> bpmnConfVos = ((BpmnConfMapper)this.bpmnConfService.getMapper()).selectOutSideFormCodeList(page, vo);
        if (bpmnConfVos == null) {
            return PageUtils.getResultAndPage((Page)page);
        }
        page.setRecords(bpmnConfVos);
        return PageUtils.getResultAndPage((Page)page);
    }

    @Override
    public List<OutSideBpmAccessProcessRecordVo> outSideProcessRecord(String processNumber) {
        return this.getProcessRecord(processNumber);
    }

    @Override
    public List<OutSideBpmAccessProcessRecordVo> accessBusinessPreview(OutSideBpmAccessBusinessVo vo) {
        PreviewNode previewNode;
        Employee employee;
        if (StringUtil.isEmpty((CharSequence)vo.getBusinessPartyMark())) {
            throw new AFBizException("\u4e1a\u52a1\u65b9\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u8d77\u6d41\u7a0b\uff01");
        }
        OutSideBpmBusinessParty outSideBpmBusinessParty = (OutSideBpmBusinessParty)this.outSideBpmBusinessPartyService.getOne((Wrapper)new QueryWrapper().eq((Object)"business_party_mark", (Object)vo.getBusinessPartyMark()));
        if (outSideBpmBusinessParty == null) {
            throw new AFBizException("\u4e1a\u52a1\u65b9\u4e0d\u5408\u6cd5\uff0c\u65e0\u6cd5\u9884\u89c8\u6d41\u7a0b");
        }
        if (StringUtil.isEmpty((CharSequence)vo.getUserId())) {
            throw new AFBizException("\u53d1\u8d77\u4eba\u7528\u6237\u540d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u9884\u89c8\u6d41\u7a0b\uff01");
        }
        Employee employee2 = employee = !StringUtils.isEmpty((CharSequence)vo.getUserName()) ? Employee.builder().id(vo.getUserId()).username(vo.getUserName()).build() : this.getEmployeeByUserId(vo.getUserId());
        if (employee == null) {
            throw new AFBizException("\u53d1\u8d77\u4eba\u4e0d\u5408\u6cd5\uff0c\u65e0\u6cd5\u9884\u89c8\u6d41\u7a0b");
        }
        List outSideBpmConditionsTemplates = null;
        if (!CollectionUtils.isEmpty(vo.getTemplateMarks()) && (outSideBpmConditionsTemplates = this.outSideBpmConditionsTemplateService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_del", (Object)0)).eq((Object)"business_party_id", (Object)outSideBpmBusinessParty.getId())).in((Object)"template_mark", vo.getTemplateMarks()))) == null) {
            throw new AFBizException("\u6a21\u677f\u4fe1\u606f\u4e0d\u5408\u6cd5\uff0c\u65e0\u6cd5\u9884\u89c8\u6d41\u7a0b");
        }
        BusinessDataVo dataVo = BusinessDataVo.builder().isOutSideAccessProc(Boolean.valueOf(true)).formCode(vo.getFormCode()).startUserId(employee.getId()).startUserName(employee.getUsername()).templateMarks(vo.getTemplateMarks()).embedNodes(this.reSetEmbedNodes(vo.getEmbedNodes())).build();
        if (!CollectionUtils.isEmpty((Collection)outSideBpmConditionsTemplates)) {
            List templateIds = outSideBpmConditionsTemplates.stream().filter(a -> a.getId() != null).map(a -> a.getId().intValue()).collect(Collectors.toList());
            dataVo.setTemplateMarkIds(templateIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(previewNode = this.bpmnConfCommonService.startPagePreviewNode(JSON.toJSONString((Object)dataVo))).getBpmnNodeList())) {
            ArrayList previewList = Lists.newArrayList();
            BpmnNodeVo bpmnNodeVo = previewNode.getBpmnNodeList().stream().filter(o -> o.getNodeType().equals(1)).findFirst().orElse(null);
            if (bpmnNodeVo == null) {
                return Collections.EMPTY_LIST;
            }
            this.setPreviewList(previewNode.getBpmnNodeList(), previewList, bpmnNodeVo);
            return previewList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void processBreak(OutSideBpmAccessBusinessVo vo) {
        if (StringUtil.isEmpty((CharSequence)vo.getFormCode())) {
            throw new AFBizException("\u8868\u5355\u7f16\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ec8\u6b62\u6d41\u7a0b");
        }
        if (StringUtil.isEmpty((CharSequence)vo.getProcessNumber())) {
            throw new AFBizException("\u6d41\u7a0b\u7f16\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ec8\u6b62\u6d41\u7a0b");
        }
        BusinessDataVo businessDataVo = new BusinessDataVo();
        businessDataVo.setFormCode(vo.getFormCode());
        businessDataVo.setProcessNumber(vo.getProcessNumber());
        businessDataVo.setOperationType(ButtonTypeEnum.BUTTON_TYPE_ABANDONED.getCode());
        businessDataVo.setApprovalComment(vo.getProcessBreakDesc());
        businessDataVo.setIsOutSideAccessProc(Boolean.valueOf(true));
        businessDataVo.setOutSideType(Integer.valueOf(1));
        if (!StringUtil.isEmpty((CharSequence)vo.getProcessBreakUserId())) {
            HashMap objectMap = Maps.newHashMap();
            vo.setUserId(vo.getProcessBreakUserId());
            Employee employee = this.getEmployeeByUserId(vo.getUserId());
            if (employee != null) {
                objectMap.put("employeeId", employee.getId());
                objectMap.put("employeeName", employee.getUsername());
                businessDataVo.setObjectMap((Map)objectMap);
                businessDataVo.setStartUserId(employee.getId().toString());
            }
        }
        this.processApprovalService.buttonsOperationTransactional(businessDataVo);
    }

    private List<OutSideBpmAccessEmbedNodeVo> reSetEmbedNodes(List<OutSideBpmAccessEmbedNodeVo> embedNodes) {
        if (CollectionUtils.isEmpty(embedNodes)) {
            return embedNodes;
        }
        return embedNodes;
    }

    private void setPreviewList(List<BpmnNodeVo> bpmnNodeVos, List<OutSideBpmAccessProcessRecordVo> previewList, BpmnNodeVo bpmnNodeVo) {
        BpmnNodeVo nextBpmnNodeVo;
        BpmnNodeParamsVo params = bpmnNodeVo.getParams();
        Integer paramType = params.getParamType();
        String approvalUserName = "";
        String nodeName = "";
        if (paramType.equals(1)) {
            BpmnNodeParamsAssigneeVo assignee = params.getAssignee();
            approvalUserName = assignee.getAssigneeName();
            nodeName = assignee.getElementName();
        } else {
            List assigneeList = params.getAssigneeList();
            if (!CollectionUtils.isEmpty((Collection)assigneeList)) {
                approvalUserName = StringUtils.join((Iterable)assigneeList.stream().map(BpmnNodeParamsAssigneeVo::getAssigneeName).collect(Collectors.toList()), (String)",");
                nodeName = ((BpmnNodeParamsAssigneeVo)assigneeList.get(0)).getElementName();
            }
        }
        previewList.add(OutSideBpmAccessProcessRecordVo.builder().nodeName(nodeName).approvalUserName(approvalUserName).build());
        if (params.getNodeTo() != null && (nextBpmnNodeVo = (BpmnNodeVo)bpmnNodeVos.stream().filter(o -> o.getNodeId().equals(params.getNodeTo())).findFirst().orElse(null)) != null) {
            this.setPreviewList(bpmnNodeVos, previewList, nextBpmnNodeVo);
        }
    }

    private Employee getEmployeeByUserId(String userName) {
        Map stringStringMap = this.bpmnEmployeeInfoProviderService.provideEmployeeInfo((Collection)Lists.newArrayList((Object[])new String[]{userName}));
        if (stringStringMap.isEmpty()) {
            return null;
        }
        Employee employee = new Employee();
        employee.setId(userName);
        employee.setUsername((String)stringStringMap.get(userName));
        return employee;
    }

    private List<OutSideBpmAccessProcessRecordVo> getProcessRecord(String processNumber) {
        List<BpmVerifyInfoVo> bpmVerifyInfoVos = this.bpmVerifyInfoNewService.getBpmVerifyInfoVos(processNumber, false);
        return bpmVerifyInfoVos.stream().map(o -> OutSideBpmAccessProcessRecordVo.builder().nodeName(o.getTaskName()).approvalTime(Optional.ofNullable(o.getVerifyDate()).map(arg_0 -> ((FastDateFormat)DateUtil.SDF_DATETIME_PATTERN).format(arg_0)).orElse("")).approvalStatus(o.getVerifyStatus()).approvalStatusName(o.getVerifyStatusName()).approvalUserName(o.getVerifyUserName()).approvalUserId(o.getVerifyUserId() == null ? StringUtils.join((Iterable)o.getVerifyUserIds(), (String)",") : o.getVerifyUserId()).build()).collect(Collectors.toList());
    }
}

