/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.openoa.base.entity.OutSideBpmBusinessParty;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.OutSideBpmProcesses;
import org.openoa.engine.bpmnconf.mapper.OutSideBpmBusinessPartyMapper;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmBusinessPartyServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnConfService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmAdminPersonnelService;
import org.openoa.engine.vo.GenericEmployee;
import org.openoa.engine.vo.OutSideBpmBusinessPartyVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutSideBpmBaseServiceImpl {
    @Autowired
    @Lazy
    private OutSideBpmBusinessPartyServiceImpl outSideBpmBusinessPartyService;
    @Autowired
    private OutSideBpmAdminPersonnelService outSideBpmAdminPersonnelService;
    @Autowired
    @Lazy
    private BpmnConfService bpmnConfService;

    public List<OutSideBpmBusinessPartyVo> getEmplBusinessPartys(String name, String ... permCodes) {
        GenericEmployee loginedEmployee = GenericEmployee.builder().userId(SecurityUtils.getLogInEmpId()).username(SecurityUtils.getLogInEmpName()).build();
        List<OutSideBpmBusinessParty> outSideBpmBusinessPartys = Lists.newArrayList();
        if (loginedEmployee.getPermissions().contains("3060101")) {
            outSideBpmBusinessPartys = ((OutSideBpmBusinessPartyMapper)this.outSideBpmBusinessPartyService.getBaseMapper()).selectList((Wrapper)new QueryWrapper());
        } else {
            List<Integer> businessPartyIds = this.outSideBpmAdminPersonnelService.getBusinessPartyIdByEmployeeId(loginedEmployee.getUserId(), permCodes);
            if (!CollectionUtils.isEmpty(businessPartyIds)) {
                outSideBpmBusinessPartys = ((OutSideBpmBusinessPartyMapper)this.outSideBpmBusinessPartyService.getBaseMapper()).selectBatchIds(businessPartyIds);
            } else {
                outSideBpmBusinessPartys.add(OutSideBpmBusinessParty.builder().id(Long.valueOf(-1L)).build());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)outSideBpmBusinessPartys)) {
            List<OutSideBpmBusinessPartyVo> outSideBpmBusinessPartyVos = outSideBpmBusinessPartys.stream().map(o -> OutSideBpmBusinessPartyVo.builder().id(o.getId()).name(o.getName()).businessPartyMark(o.getBusinessPartyMark()).type(o.getType()).build()).collect(Collectors.toList());
            if (!StringUtil.isEmpty((CharSequence)name)) {
                outSideBpmBusinessPartyVos = outSideBpmBusinessPartyVos.stream().filter(o -> o.getName().contains(name)).collect(Collectors.toList());
            }
            return outSideBpmBusinessPartyVos;
        }
        return Collections.EMPTY_LIST;
    }

    public List<OutSideBpmProcesses> getProcessesByBusinessParty(Integer businessPartyId, String name) {
        List bpmnConfs;
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"business_party_id", (Object)businessPartyId)).eq((Object)"effective_status", (Object)1);
        if (!StringUtil.isEmpty((CharSequence)name)) {
            wrapper.like((Object)"bpmn_name", (Object)name);
        }
        if (!CollectionUtils.isEmpty((Collection)(bpmnConfs = this.bpmnConfService.getBaseMapper().selectList((Wrapper)wrapper)))) {
            return bpmnConfs.stream().map(o -> OutSideBpmProcesses.builder().id(Integer.valueOf(o.getId().intValue())).name(o.getBpmnName()).formCode(o.getFormCode()).build()).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }
}

