/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.AdminPersonnelTypeEnum;
import org.openoa.base.constant.enums.BusinessPartyTypeEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.Employee;
import org.openoa.base.entity.OutSideBpmAdminPersonnel;
import org.openoa.base.entity.OutSideBpmBusinessParty;
import org.openoa.base.entity.OutSideBpmCallbackUrlConf;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.PageUtils;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.mapper.OutSideBpmCallbackUrlConfMapper;
import org.openoa.engine.bpmnconf.service.biz.OutSideBpmBaseServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.OutSideBpmCallbackUrlConfBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmAdminPersonnelService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmBusinessPartyService;
import org.openoa.engine.vo.OutSideBpmBusinessPartyVo;
import org.openoa.engine.vo.OutSideBpmCallbackUrlConfVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutSideBpmCallbackUrlConfBizServiceImpl
implements OutSideBpmCallbackUrlConfBizService {
    @Autowired
    private OutSideBpmBusinessPartyService outSideBpmBusinessPartyService;
    @Autowired
    private OutSideBpmAdminPersonnelService outSideBpmAdminPersonnelService;
    @Autowired
    private OutSideBpmBaseServiceImpl outSideBpmBaseService;
    @Autowired
    private AfUserService employeeService;

    @Override
    public ResultAndPage<OutSideBpmCallbackUrlConfVo> listPage(PageDto pageDto, OutSideBpmCallbackUrlConfVo vo) {
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto);
        List<OutSideBpmBusinessPartyVo> emplBusinessPartys = this.outSideBpmBaseService.getEmplBusinessPartys("", AdminPersonnelTypeEnum.ADMIN_PERSONNEL_TYPE_INTERFACE.getPermCode());
        vo.setBusinessPartyIds(emplBusinessPartys.stream().map(OutSideBpmBusinessPartyVo::getId).collect(Collectors.toList()));
        List<OutSideBpmCallbackUrlConfVo> records = ((OutSideBpmCallbackUrlConfMapper)this.getMapper()).selectPageList(page, vo);
        if (CollectionUtils.isEmpty(records)) {
            return PageUtils.getResultAndPage((Page)page);
        }
        List businessPartyIds = records.stream().map(OutSideBpmCallbackUrlConfVo::getBusinessPartyId).distinct().collect(Collectors.toList());
        Map<Long, OutSideBpmBusinessParty> bpmBusinessPartyMap = this.outSideBpmBusinessPartyService.getBaseMapper().selectBatchIds(businessPartyIds).stream().collect(Collectors.toMap(OutSideBpmBusinessParty::getId, o -> o));
        page.setRecords(records.stream().map(o -> this.reBuildVo((OutSideBpmCallbackUrlConfVo)o, (OutSideBpmBusinessParty)bpmBusinessPartyMap.get(o.getBusinessPartyId()))).collect(Collectors.toList()));
        return PageUtils.getResultAndPage((Page)page);
    }

    @Override
    public OutSideBpmCallbackUrlConfVo detail(Integer id) {
        OutSideBpmCallbackUrlConf outSideBpmCallbackUrlConf = (OutSideBpmCallbackUrlConf)((OutSideBpmCallbackUrlConfMapper)this.getMapper()).selectById(id);
        OutSideBpmCallbackUrlConfVo vo = new OutSideBpmCallbackUrlConfVo();
        BeanUtils.copyProperties((Object)outSideBpmCallbackUrlConf, (Object)vo);
        OutSideBpmBusinessParty outSideBpmBusinessParty = (OutSideBpmBusinessParty)this.outSideBpmBusinessPartyService.getBaseMapper().selectById((Serializable)vo.getBusinessPartyId());
        return this.reBuildVo(vo, outSideBpmBusinessParty);
    }

    private OutSideBpmCallbackUrlConfVo reBuildVo(OutSideBpmCallbackUrlConfVo outSideBpmCallbackUrlConfVo, OutSideBpmBusinessParty outSideBpmBusinessParty) {
        if (outSideBpmCallbackUrlConfVo.getStatus() != null) {
            if (outSideBpmCallbackUrlConfVo.getStatus() == 1) {
                outSideBpmCallbackUrlConfVo.setStatusName("\u542f\u7528");
            } else if (outSideBpmCallbackUrlConfVo.getStatus() == 2) {
                outSideBpmCallbackUrlConfVo.setStatusName("\u5c01\u5b58");
            }
        }
        if (outSideBpmBusinessParty != null) {
            outSideBpmCallbackUrlConfVo.setBusinessPartyName(outSideBpmBusinessParty.getName());
            outSideBpmCallbackUrlConfVo.setAccessType(outSideBpmBusinessParty.getType());
            outSideBpmCallbackUrlConfVo.setAccessTypeName(BusinessPartyTypeEnum.getDescByCode((Integer)outSideBpmBusinessParty.getType()));
            List outSideBpmAdminPersonnels = this.outSideBpmAdminPersonnelService.getBaseMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"business_party_id", (Object)outSideBpmBusinessParty.getId())).eq((Object)"type", (Object)AdminPersonnelTypeEnum.ADMIN_PERSONNEL_TYPE_INTERFACE.getCode()));
            if (!CollectionUtils.isEmpty((Collection)outSideBpmAdminPersonnels)) {
                List employees = this.employeeService.getEmployeeDetailByIds((Collection)outSideBpmAdminPersonnels.stream().map(OutSideBpmAdminPersonnel::getEmployeeId).collect(Collectors.toList()));
                outSideBpmCallbackUrlConfVo.setInterfaceAdmins(employees.stream().map(o -> Employee.builder().id(o.getId()).username(o.getUsername()).build()).collect(Collectors.toList()));
            }
        }
        return outSideBpmCallbackUrlConfVo;
    }
}

