/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.openoa.base.constant.enums.AdminPersonnelTypeEnum;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.BpmProcessAppApplication;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.entity.BpmnNode;
import org.openoa.base.entity.BpmnNodeConditionsConf;
import org.openoa.base.entity.BpmnNodeConditionsParamConf;
import org.openoa.base.entity.Employee;
import org.openoa.base.entity.OutSideBpmBusinessParty;
import org.openoa.base.entity.OutSideBpmConditionsTemplate;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.PageUtils;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.constant.enus.ConditionTypeEnum;
import org.openoa.engine.bpmnconf.mapper.OutSideBpmConditionsTemplateMapper;
import org.openoa.engine.bpmnconf.service.biz.OutSideBpmBaseServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.OutSideBpmConditionsTemplateBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessAppApplicationService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnConfService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnNodeConditionsConfService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnNodeConditionsParamConfService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnNodeService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmBusinessPartyService;
import org.openoa.engine.bpmnconf.service.interf.repository.OutSideBpmConditionsTemplateService;
import org.openoa.engine.vo.OutSideBpmBusinessPartyVo;
import org.openoa.engine.vo.OutSideBpmConditionsTemplateVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutSideBpmConditionsTemplateBizServiceImpl
implements OutSideBpmConditionsTemplateBizService {
    @Autowired
    private OutSideBpmBusinessPartyService outSideBpmBusinessPartyService;
    @Autowired
    private OutSideBpmBaseServiceImpl outSideBpmBaseService;
    @Autowired
    private AfUserService employeeService;
    @Autowired
    @Lazy
    private BpmnConfService bpmnConfService;
    @Autowired
    private BpmnNodeService bpmnNodeService;
    @Autowired
    private BpmnNodeConditionsConfService bpmnNodeConditionsConfService;
    @Autowired
    private BpmnNodeConditionsParamConfService bpmnNodeConditionsParamConfService;
    @Autowired
    private BpmProcessAppApplicationService bpmProcessAppApplicationService;

    @Override
    public ResultAndPage<OutSideBpmConditionsTemplateVo> listPage(PageDto pageDto, OutSideBpmConditionsTemplateVo vo) {
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto);
        List<OutSideBpmBusinessPartyVo> emplBusinessPartys = this.outSideBpmBaseService.getEmplBusinessPartys("", AdminPersonnelTypeEnum.ADMIN_PERSONNEL_TYPE_TEMPLATE.getPermCode());
        vo.setBusinessPartyIds(emplBusinessPartys.stream().map(OutSideBpmBusinessPartyVo::getId).collect(Collectors.toList()));
        List<OutSideBpmConditionsTemplateVo> outSideBpmConditionsTemplateVos = ((OutSideBpmConditionsTemplateMapper)this.getMapper()).selectPageList(page, vo);
        if (CollectionUtils.isEmpty(outSideBpmConditionsTemplateVos)) {
            return PageUtils.getResultAndPage((Page)page);
        }
        Map<Long, OutSideBpmBusinessParty> outSideBpmBusinessPartyMap = this.outSideBpmBusinessPartyService.getBaseMapper().selectBatchIds((Collection)outSideBpmConditionsTemplateVos.stream().map(OutSideBpmConditionsTemplateVo::getBusinessPartyId).collect(Collectors.toList())).stream().collect(Collectors.toMap(OutSideBpmBusinessParty::getId, o -> o));
        Map<String, Employee> employeeMap = this.employeeService.getEmployeeDetailByIds((Collection)outSideBpmConditionsTemplateVos.stream().map(OutSideBpmConditionsTemplateVo::getCreateUserId).distinct().collect(Collectors.toList())).stream().collect(Collectors.toMap(Employee::getId, o -> o));
        for (OutSideBpmConditionsTemplateVo outSideBpmConditionsTemplateVo : outSideBpmConditionsTemplateVos) {
            BpmProcessAppApplication bpmProcessAppApplication;
            Employee employee;
            OutSideBpmBusinessParty outSideBpmBusinessParty = outSideBpmBusinessPartyMap.get(outSideBpmConditionsTemplateVo.getBusinessPartyId());
            if (outSideBpmBusinessParty != null) {
                outSideBpmConditionsTemplateVo.setBusinessPartyMark(outSideBpmBusinessParty.getBusinessPartyMark());
                outSideBpmConditionsTemplateVo.setBusinessPartyName(outSideBpmBusinessParty.getName());
            }
            if ((employee = employeeMap.get(outSideBpmConditionsTemplateVo.getCreateUserId())) != null) {
                outSideBpmConditionsTemplateVo.setCreateUserName(employee.getUsername());
            }
            if (outSideBpmConditionsTemplateVo.getApplicationId() == null || outSideBpmConditionsTemplateVo.getApplicationId().equals(0) || (bpmProcessAppApplication = (BpmProcessAppApplication)this.bpmProcessAppApplicationService.getById(outSideBpmConditionsTemplateVo.getApplicationId())) == null) continue;
            outSideBpmConditionsTemplateVo.setApplicationFormCode(bpmProcessAppApplication.getProcessKey());
            outSideBpmConditionsTemplateVo.setApplicationName(bpmProcessAppApplication.getTitle());
        }
        page.setRecords(outSideBpmConditionsTemplateVos);
        return PageUtils.getResultAndPage((Page)page);
    }

    @Override
    public List<OutSideBpmConditionsTemplateVo> selectListByPartMark(String businessPartyMark) {
        List outSideBpmConditionsTemplates;
        OutSideBpmBusinessParty outSideBpmBusinessParty = (OutSideBpmBusinessParty)this.outSideBpmBusinessPartyService.getBaseMapper().selectOne((Wrapper)new QueryWrapper().eq((Object)"business_party_mark", (Object)businessPartyMark));
        if (outSideBpmBusinessParty != null && !CollectionUtils.isEmpty((Collection)(outSideBpmConditionsTemplates = ((OutSideBpmConditionsTemplateService)this.getService()).list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_del", (Object)0)).eq((Object)"business_party_id", (Object)outSideBpmBusinessParty.getId()))))) {
            HashSet applicationIds = Sets.newHashSet();
            ArrayListMultimap conditionsTemplateMultimap = ArrayListMultimap.create();
            for (OutSideBpmConditionsTemplate outSideBpmConditionsTemplate : outSideBpmConditionsTemplates) {
                if (outSideBpmConditionsTemplate.getApplicationId().equals(0)) continue;
                conditionsTemplateMultimap.put((Object)outSideBpmConditionsTemplate.getApplicationId(), (Object)outSideBpmConditionsTemplate);
                applicationIds.add(outSideBpmConditionsTemplate.getApplicationId());
            }
            if (CollectionUtils.isEmpty((Collection)applicationIds)) {
                return Collections.EMPTY_LIST;
            }
            Map<Integer, BpmProcessAppApplication> applicationMap = this.bpmProcessAppApplicationService.getBaseMapper().selectBatchIds(new ArrayList(applicationIds)).stream().collect(Collectors.toMap(BpmProcessAppApplication::getId, o -> o));
            ArrayList returnList = Lists.newArrayList();
            for (Integer key : conditionsTemplateMultimap.keySet()) {
                Collection outSideBpmConditionsTemplatesList = conditionsTemplateMultimap.get((Object)key);
                BpmProcessAppApplication bpmProcessAppApplication = Optional.ofNullable(applicationMap.get(key)).orElse(new BpmProcessAppApplication());
                returnList.add(OutSideBpmConditionsTemplateVo.builder().applicationFormCode(bpmProcessAppApplication.getProcessKey()).applicationName(bpmProcessAppApplication.getTitle()).templates(outSideBpmConditionsTemplatesList.stream().map(o -> OutSideBpmConditionsTemplateVo.builder().templateMark(o.getTemplateMark()).templateName(o.getTemplateName()).build()).collect(Collectors.toList())).build());
            }
            return returnList.stream().filter(o -> !StringUtil.isEmpty((CharSequence)o.getApplicationName())).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public OutSideBpmConditionsTemplateVo detail(Integer id) {
        OutSideBpmConditionsTemplate outSideBpmConditionsTemplate = (OutSideBpmConditionsTemplate)((OutSideBpmConditionsTemplateMapper)this.getMapper()).selectById(id);
        OutSideBpmConditionsTemplateVo vo = new OutSideBpmConditionsTemplateVo();
        BeanUtils.copyProperties((Object)outSideBpmConditionsTemplate, (Object)vo);
        OutSideBpmBusinessParty outSideBpmBusinessParty = (OutSideBpmBusinessParty)this.outSideBpmBusinessPartyService.getBaseMapper().selectById((Serializable)vo.getBusinessPartyId());
        vo.setBusinessPartyMark(outSideBpmBusinessParty.getBusinessPartyMark());
        vo.setBusinessPartyName(outSideBpmBusinessParty.getName());
        vo.setIsUsed(this.templateIsUsed(id, outSideBpmBusinessParty));
        if (outSideBpmConditionsTemplate.getApplicationId() != null) {
            BpmProcessAppApplication bpmProcessAppApplication = (BpmProcessAppApplication)this.bpmProcessAppApplicationService.getBaseMapper().selectById((Serializable)outSideBpmConditionsTemplate.getApplicationId());
            vo.setApplicationFormCode(bpmProcessAppApplication.getProcessKey());
            vo.setApplicationName(bpmProcessAppApplication.getTitle());
        }
        return vo;
    }

    @Override
    public void delete(Integer id) {
        OutSideBpmConditionsTemplate outSideBpmConditionsTemplate = (OutSideBpmConditionsTemplate)((OutSideBpmConditionsTemplateService)this.getService()).getById(id);
        OutSideBpmBusinessParty outSideBpmBusinessParty = (OutSideBpmBusinessParty)this.outSideBpmBusinessPartyService.getById(outSideBpmConditionsTemplate.getBusinessPartyId());
        if (this.templateIsUsed(id, outSideBpmBusinessParty).booleanValue()) {
            throw new AFBizException("\u5ba1\u6279\u6d41\u7a0b\u4e2d\u6b63\u4f7f\u7528\u6b64\u6761\u4ef6\u6a21\u677f\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        ((OutSideBpmConditionsTemplateService)this.getService()).updateById(OutSideBpmConditionsTemplate.builder().id(Long.valueOf(id.longValue())).isDel(Integer.valueOf(1)).build());
    }

    private Boolean templateIsUsed(Integer id, OutSideBpmBusinessParty outSideBpmBusinessParty) {
        List bpmnNodeConditionsConfs;
        List bpmnNodes;
        List bpmnConfs = this.bpmnConfService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"business_party_id", (Object)outSideBpmBusinessParty.getId())).eq((Object)"is_del", (Object)0)).eq((Object)"effective_status", (Object)1));
        if (!(CollectionUtils.isEmpty((Collection)bpmnConfs) || CollectionUtils.isEmpty((Collection)(bpmnNodes = this.bpmnNodeService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"conf_id", (Collection)bpmnConfs.stream().map(BpmnConf::getId).collect(Collectors.toList()))).in((Object)"node_type", (Collection)Lists.newArrayList((Object[])new Integer[]{NodeTypeEnum.NODE_TYPE_CONDITIONS.getCode(), NodeTypeEnum.NODE_TYPE_OUT_SIDE_CONDITIONS.getCode()}))))) || CollectionUtils.isEmpty((Collection)(bpmnNodeConditionsConfs = this.bpmnNodeConditionsConfService.list((Wrapper)new QueryWrapper().in((Object)"bpmn_node_id", (Collection)bpmnNodes.stream().map(BpmnNode::getId).collect(Collectors.toList()))))))) {
            ConditionTypeEnum conditionTemplatemark = ConditionTypeEnum.CONDITION_TEMPLATEMARK;
            List bpmnNodeConditionsParamConfs = this.bpmnNodeConditionsParamConfService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"bpmn_node_conditions_id", (Collection)bpmnNodeConditionsConfs.stream().map(BpmnNodeConditionsConf::getId).collect(Collectors.toList()))).eq((Object)"condition_param_type", (Object)conditionTemplatemark.getCode()));
            if (!CollectionUtils.isEmpty((Collection)bpmnNodeConditionsParamConfs)) {
                ArrayList usedTempList = Lists.newArrayList();
                for (BpmnNodeConditionsParamConf bpmnNodeConditionsParamConf : bpmnNodeConditionsParamConfs) {
                    List confTempList = JSON.parseArray((String)bpmnNodeConditionsParamConf.getConditionParamJsom(), conditionTemplatemark.getFieldCls());
                    usedTempList.addAll(confTempList);
                }
                if (usedTempList.contains(id)) {
                    return true;
                }
            }
        }
        return false;
    }
}

