/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.TaskQuery;
import org.openoa.base.constant.enums.ButtonPageTypeEnum;
import org.openoa.base.constant.enums.ProcessButtonEnum;
import org.openoa.base.constant.enums.ProcessNodeEnum;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.constant.enums.ProcessStateEnum;
import org.openoa.base.constant.enums.ProcessTypeEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.interf.FormOperationAdaptor;
import org.openoa.base.util.PageUtils;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmProcessVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.base.vo.ProcessActionButtonVo;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.base.vo.TaskMgmtVO;
import org.openoa.engine.bpmnconf.common.ConfigFlowButtonContans;
import org.openoa.engine.bpmnconf.common.ProcessBusinessContans;
import org.openoa.engine.bpmnconf.mapper.ProcessApprovalMapper;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessForwardBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableSignUpBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnConfBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessNameRelevancyService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessNameService;
import org.openoa.engine.factory.ButtonPreOperationService;
import org.openoa.engine.factory.FormFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ProcessApprovalServiceImpl
extends ServiceImpl<ProcessApprovalMapper, TaskMgmtVO> {
    private static final Logger log = LoggerFactory.getLogger(ProcessApprovalServiceImpl.class);
    @Autowired
    private ButtonPreOperationService buttonPreOperationService;
    @Autowired
    private BpmProcessNameRelevancyService processNameRelevancyService;
    @Autowired
    private TaskMgmtMapper taskMgmtMapper;
    @Autowired
    private BpmnConfBizService bpmnConfCommonService;
    @Autowired
    private BpmProcessForwardBizService processForwardBizService;
    @Autowired
    private BpmProcessNameService bpmProcessNameService;
    @Autowired
    private FormFactory formFactory;
    @Autowired
    private BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private ProcessBusinessContans businessContans;
    @Autowired
    private ConfigFlowButtonContans configFlowButtonContans;
    @Autowired
    private BpmVariableSignUpBizService bpmVariableSignUpBizService;
    @Autowired
    private TaskService taskService;

    public BusinessDataVo buttonsOperation(String params, String formCode) {
        BusinessDataVo vo = this.buttonPreOperationService.buttonsPreOperation(params, formCode);
        return vo;
    }

    public ResultAndPage<TaskMgmtVO> findPcProcessList(PageDto pageDto, TaskMgmtVO vo) throws AFBizException {
        LinkedHashMap orderFieldMap = Maps.newLinkedHashMap();
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto, (LinkedHashMap)orderFieldMap);
        vo.setApplyUser(SecurityUtils.getLogInEmpIdStr());
        switch (vo.getType()) {
            case 1: {
                break;
            }
            case 2: {
                page.setRecords(((ProcessApprovalMapper)this.getBaseMapper()).viewPcProcessList(page, vo));
                break;
            }
            case 3: {
                if (!ObjectUtils.isEmpty((Object)vo.getProcessType())) {
                    vo.setProcessKeyList(this.processNameRelevancyService.processKeyList(Long.parseLong(vo.getProcessType())));
                }
                page.setRecords(((ProcessApprovalMapper)this.getBaseMapper()).viewPcpNewlyBuildList(page, vo));
                break;
            }
            case 4: {
                if (!ObjectUtils.isEmpty((Object)vo.getProcessType())) {
                    vo.setProcessKeyList(this.processNameRelevancyService.processKeyList(Long.parseLong(vo.getProcessType())));
                }
                page.setRecords(((ProcessApprovalMapper)this.getBaseMapper()).viewPcAlreadyDoneList(page, vo));
                break;
            }
            case 5: {
                if (!ObjectUtils.isEmpty((Object)vo.getProcessType())) {
                    vo.setProcessKeyList(this.processNameRelevancyService.processKeyList(Long.parseLong(vo.getProcessType())));
                }
                page.setRecords(((ProcessApprovalMapper)this.getBaseMapper()).viewPcToDoList(page, vo));
                break;
            }
            case 6: {
                page.setRecords(((ProcessApprovalMapper)this.getBaseMapper()).allProcessList(page, vo));
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                page.setRecords(((ProcessApprovalMapper)this.getBaseMapper()).allProcessList(page, vo));
                break;
            }
            case 9: {
                page.setRecords(((ProcessApprovalMapper)this.baseMapper).viewPcForwardList((Page<TaskMgmtVO>)page, vo));
            }
        }
        if (!ObjectUtils.isEmpty((Object)page.getRecords())) {
            if (vo.getType().equals(ProcessTypeEnum.ENTRUST_TYPE.getCode()) || vo.getType().equals(ProcessTypeEnum.ADMIN_TYPE.getCode())) {
                this.processForwardBizService.loadProcessForward(SecurityUtils.getLogInEmpId());
                this.processForwardBizService.loadTask(SecurityUtils.getLogInEmpId());
            }
            this.getPcProcessData((Page<TaskMgmtVO>)page, vo.getType());
        }
        return PageUtils.getResultAndPage((Page)page);
    }

    private void getPcProcessData(Page<TaskMgmtVO> page, Integer type) {
        List<String> formCodes = page.getRecords().stream().map(TaskMgmtVO::getProcessKey).distinct().collect(Collectors.toList());
        List<BpmnConf> bpmnConfs = this.bpmnConfCommonService.getBpmnConfByFormCodeBatch(formCodes);
        Map<Object, Object> bpmnConfMap = new HashMap();
        if (!ObjectUtils.isEmpty(bpmnConfs)) {
            bpmnConfMap = bpmnConfs.stream().collect(Collectors.toMap(BpmnConf::getFormCode, o -> o, (k1, k2) -> k2));
            for (TaskMgmtVO record : page.getRecords()) {
                BpmProcessVo bpmProcessVo;
                BpmnConf bpmnConf = (BpmnConf)bpmnConfMap.get(record.getProcessKey());
                if (bpmnConf != null) {
                    record.setIsOutSideProcess(Boolean.valueOf(Objects.equals(1, bpmnConf.getIsOutSideProcess())));
                    record.setIsLowCodeFlow(Boolean.valueOf(Objects.equals(1, bpmnConf.getIsLowCodeFlow())));
                    record.setConfId(bpmnConf.getId());
                }
                Integer applyUserId = record.getApplyUserId();
                record.setActualName(SecurityUtils.getLogInEmpName());
                record.setTaskState(ProcessStateEnum.getDescByCode((Integer)record.getProcessState()));
                if (type.equals(ProcessTypeEnum.ENTRUST_TYPE.getCode())) {
                    record.setIsForward(Boolean.valueOf(this.processForwardBizService.isForward(record.getProcessInstanceId())));
                    if (!ObjectUtils.isEmpty((Object)record.getTaskName())) {
                        record.setIsBatchSubmit(this.isOperatable(TaskMgmtVO.builder().processKey(record.getProcessKey()).taskName(record.getTaskName()).type(Integer.valueOf(ProcessButtonEnum.VIEW_TYPE.getCode())).build()));
                        record.setNodeType(ProcessNodeEnum.getCodeByDesc((String)record.getTaskName()));
                    }
                }
                if (type.equals(ProcessTypeEnum.ADMIN_TYPE.getCode()) && !ObjectUtils.isEmpty((Object)record.getTaskName())) {
                    record.setNodeType(ProcessNodeEnum.getCodeByDesc((String)record.getTaskName()));
                }
                if (ObjectUtils.isEmpty((Object)record.getProcessKey()) || ObjectUtils.isEmpty((Object)(bpmProcessVo = this.bpmProcessNameService.get(record.getProcessKey())).getProcessKey())) continue;
                record.setProcessTypeName(bpmProcessVo.getProcessName());
                record.setProcessCode(bpmProcessVo.getProcessKey());
            }
        }
    }

    public BusinessDataVo getBusinessInfo(String params, String formCode) {
        BusinessDataVo vo = this.formFactory.dataFormConversion(params, formCode);
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(vo.getProcessNumber());
        if (ObjectUtils.isEmpty((Object)bpmBusinessProcess)) {
            throw new AFBizException(String.format("processNumber%s,its data not in existence!", vo.getProcessNumber()));
        }
        vo.setBusinessId(bpmBusinessProcess.getBusinessId());
        BusinessDataVo businessDataVo = null;
        if (!vo.getIsOutSideAccessProc().booleanValue() || Objects.equals(vo.getIsLowCodeFlow(), 1)) {
            FormOperationAdaptor formAdaptor = this.formFactory.getFormAdaptor(vo);
            businessDataVo = formAdaptor.queryData(vo);
        } else {
            businessDataVo = vo;
        }
        businessDataVo.setBusinessId(bpmBusinessProcess.getBusinessId());
        businessDataVo.setFormCode(vo.getFormCode());
        businessDataVo.setProcessNumber(vo.getProcessNumber());
        businessDataVo.setProcessRecordInfo(this.businessContans.processInfo(bpmBusinessProcess));
        businessDataVo.setProcessKey(bpmBusinessProcess.getBusinessNumber());
        businessDataVo.setProcessState(Boolean.valueOf(!bpmBusinessProcess.getProcessState().equals(ProcessStateEnum.END_STATE.getCode()) && !bpmBusinessProcess.getProcessState().equals(ProcessStateEnum.REJECT_STATE.getCode())));
        boolean flag = businessDataVo.getProcessRecordInfo().getStartUserId().equals(SecurityUtils.getLogInEmpIdStr());
        boolean isJurisdiction = false;
        businessDataVo.getProcessRecordInfo().setPcButtons(this.configFlowButtonContans.getButtons(bpmBusinessProcess.getBusinessNumber(), businessDataVo.getProcessRecordInfo().getNodeId(), isJurisdiction, flag));
        String nodeId = businessDataVo.getProcessRecordInfo().getNodeId();
        Boolean nodeIsSignUp = this.bpmVariableSignUpBizService.checkNodeIsSignUp(vo.getProcessNumber(), nodeId);
        businessDataVo.setIsSignUpNode(nodeIsSignUp);
        if (nodeIsSignUp.booleanValue()) {
            this.addApproverButton(businessDataVo);
        }
        return businessDataVo;
    }

    public TaskMgmtVO processStatistics() {
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().taskAssignee(SecurityUtils.getLogInEmpIdStr())).list();
        return TaskMgmtVO.builder().todoCount(Integer.valueOf(taskList.size())).doneTodayCount(((ProcessApprovalMapper)this.getBaseMapper()).doneTodayProcess(SecurityUtils.getLogInEmpIdStr())).doneCreateCount(((ProcessApprovalMapper)this.getBaseMapper()).doneCreateProcess(SecurityUtils.getLogInEmpIdStr())).title(null).build();
    }

    private void addApproverButton(BusinessDataVo businessDataVo) {
        ProcessActionButtonVo addApproverButton = ProcessActionButtonVo.builder().buttonType(ProcessOperationEnum.BUTTON_TYPE_JP.getCode()).name(ProcessOperationEnum.BUTTON_TYPE_JP.getDesc()).build();
        Map pcButtons = businessDataVo.getProcessRecordInfo().getPcButtons();
        List pcProcButtons = (List)pcButtons.get(ButtonPageTypeEnum.AUDIT.getName());
        if (!pcProcButtons.stream().anyMatch(a -> ProcessOperationEnum.BUTTON_TYPE_JP.getCode().equals(a.getButtonType()))) {
            pcProcButtons.add(addApproverButton);
        }
        businessDataVo.getProcessRecordInfo().setPcButtons(pcButtons);
    }

    private Boolean isOperatable(TaskMgmtVO vo) {
        return ((ProcessApprovalMapper)this.getBaseMapper()).isOperational(vo) <= 0;
    }
}

