/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openoa.base.constant.enums.AppApplicationType;
import org.openoa.base.entity.BpmProcessAppData;
import org.openoa.base.entity.QuickEntry;
import org.openoa.base.entity.QuickEntryType;
import org.openoa.base.entity.SysVersion;
import org.openoa.engine.bpmnconf.mapper.QuickEntryMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessAppDataService;
import org.openoa.engine.bpmnconf.service.interf.repository.QuickEntryBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.QuickEntryService;
import org.openoa.engine.bpmnconf.service.interf.repository.QuickEntryTypeService;
import org.openoa.engine.bpmnconf.service.interf.repository.SysVersionService;
import org.openoa.engine.vo.BpmProcessAppApplicationVo;
import org.openoa.engine.vo.ProcessTypeInforVo;
import org.openoa.engine.vo.QuickEntryVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QuickEntryBizServiceImpl
implements QuickEntryBizService {
    @Autowired
    private QuickEntryTypeService quickEntryTypeService;
    @Autowired
    private BpmProcessAppDataService bpmProcessAppDataService;
    @Autowired
    private SysVersionService sysVersionService;

    @Override
    public boolean editQuickEntry(QuickEntryVo vo) {
        QuickEntry quickEntry = new QuickEntry();
        BeanUtils.copyProperties((Object)vo, (Object)quickEntry, (String[])new String[]{"serialVersionUID"});
        String route = StringEscapeUtils.unescapeHtml3((String)vo.getRoute());
        if (vo.getId() != null) {
            quickEntry.setRoute(route);
            ((QuickEntryService)this.getService()).updateById(quickEntry);
        } else {
            quickEntry.setRoute(route);
            quickEntry.setCreateTime(new Date());
            ((QuickEntryMapper)this.getMapper()).insert(quickEntry);
        }
        Serializable id = Optional.ofNullable(Optional.ofNullable(quickEntry).orElseGet(QuickEntry::new).getId()).orElse(0);
        vo.setId((Integer)id);
        this.quickEntryTypeService.addQuickEntryType(vo);
        return true;
    }

    @Override
    public ProcessTypeInforVo allQuickEntry(String version) {
        ArrayList<BpmProcessAppApplicationVo> appApplicationList = new ArrayList<BpmProcessAppApplicationVo>();
        SysVersion infoByVersion = this.sysVersionService.getInfoByVersion(version);
        if (infoByVersion == null) {
            return null;
        }
        List<BpmProcessAppData> processAppData = this.bpmProcessAppDataService.getProcessAppData(infoByVersion.getId(), 0, AppApplicationType.THREE_TYPE.getCode());
        if (processAppData == null) {
            return null;
        }
        List<Long> collect = processAppData.stream().map(BpmProcessAppData::getApplicationId).collect(Collectors.toList());
        List<QuickEntry> quickEntries = this.listQuickEntry(collect);
        if (!CollectionUtils.isEmpty(quickEntries)) {
            appApplicationList.addAll(quickEntries.stream().map(o -> BpmProcessAppApplicationVo.builder().title(o.getTitle()).route(o.getRoute()).source(o.getEffectiveSource()).sort(o.getSort()).build()).collect(Collectors.toList()));
            return ProcessTypeInforVo.builder().applicationList(appApplicationList).processTypeName("\u5feb\u6377\u5165\u53e3").build();
        }
        return null;
    }

    @Override
    public List<QuickEntry> listQuickEntry(List<Long> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            return ((QuickEntryMapper)this.getMapper()).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_del", (Object)0)).eq((Object)"status", (Object)0)).in((Object)"id", ids));
        }
        return Arrays.asList(new QuickEntry[0]);
    }

    @Override
    public List<QuickEntry> listQuickEntry(Boolean isApp) {
        List<QuickEntryType> quickEntryTypes = this.quickEntryTypeService.quickEntryTypeList(isApp);
        List collect = quickEntryTypes.stream().map(QuickEntryType::getQuickEntryId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"is_del", (Object)0);
            wrapper.in((Object)"id", collect);
            wrapper.orderByAsc((Object)"sort");
            wrapper.orderByAsc((Object)"create_time");
            return ((QuickEntryMapper)this.getMapper()).selectList((Wrapper)wrapper);
        }
        return Collections.emptyList();
    }
}

