/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.AppApplicationType;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.SysVersion;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.PageUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.mapper.SysVersionMapper;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessAppDataBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.SysVersionBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.SysVersionService;
import org.openoa.engine.vo.SysVersionVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysVersionBizServiceImpl
implements SysVersionBizService {
    @Autowired
    private BpmProcessAppDataBizService processAppDataBizService;

    @Override
    public ResultAndPage<SysVersionVo> list(SysVersionVo vo) {
        PageDto pageDto = PageUtils.getPageDtoByVo((Object)vo);
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto);
        Integer totalCount = ((SysVersionMapper)this.getMapper()).selectPageListCount(vo);
        page.setTotal((long)totalCount.intValue());
        List<SysVersionVo> dtoList = totalCount > 0 ? ((SysVersionMapper)this.getMapper()).selectPageList(vo, pageDto) : Collections.EMPTY_LIST;
        page.setRecords((List)dtoList);
        page.setRecords(dtoList.stream().map(o -> {
            List<BaseIdTranStruVo> quickEntryList;
            List<BaseIdTranStruVo> dataList;
            List<BaseIdTranStruVo> appList = this.processAppDataBizService.findAppDataByVersionId(o.getId(), AppApplicationType.ONE_TYPE.getCode());
            if (!CollectionUtils.isEmpty(appList)) {
                o.setApplication(appList);
            }
            if (!CollectionUtils.isEmpty(dataList = this.processAppDataBizService.findAppDataByVersionId(o.getId(), AppApplicationType.TWO_TYPE.getCode()))) {
                o.setData(dataList);
            }
            if (!CollectionUtils.isEmpty(quickEntryList = this.processAppDataBizService.findAppDataByVersionId(o.getId(), AppApplicationType.THREE_TYPE.getCode()))) {
                o.setQuickEntryList(quickEntryList);
            }
            return o;
        }).collect(Collectors.toList()));
        return new ResultAndPage(dtoList, PageUtils.getPageDto((Page)page));
    }

    @Override
    @Transactional
    public Boolean edit(SysVersionVo vo) {
        if (vo == null) {
            throw new AFBizException("object can not be null");
        }
        if (vo.getId() != null) {
            SysVersion sysVersion = new SysVersion();
            BeanUtils.copyProperties((Object)vo, (Object)sysVersion);
            if (vo.getIsHide() != null) {
                sysVersion.setEffectiveTime(new Date());
            }
            if (((SysVersionService)this.getService()).updateById(sysVersion)) {
                if (!CollectionUtils.isEmpty(vo.getAppIds()) && !CollectionUtils.isEmpty(vo.getDataIds())) {
                    this.processAppDataBizService.addAppVersionData(vo.getAppIds(), sysVersion.getId(), AppApplicationType.ONE_TYPE.getCode());
                    this.processAppDataBizService.addAppVersionData(vo.getDataIds(), sysVersion.getId(), AppApplicationType.TWO_TYPE.getCode());
                    this.processAppDataBizService.addVersionData(vo.getQuickEntryIds(), sysVersion.getId(), AppApplicationType.THREE_TYPE.getCode());
                }
                return true;
            }
        } else {
            SysVersion sysVersion = new SysVersion();
            BeanUtils.copyProperties((Object)vo, (Object)sysVersion);
            Integer index = ((SysVersionMapper)this.getMapper()).maxIndex() + 1;
            sysVersion.setIsHide(Integer.valueOf(1));
            sysVersion.setIndex(index);
            if (((SysVersionService)this.getService()).save(sysVersion)) {
                if (!CollectionUtils.isEmpty(vo.getAppIds()) && !CollectionUtils.isEmpty(vo.getDataIds())) {
                    this.processAppDataBizService.addAppVersionData(vo.getAppIds(), sysVersion.getId(), 1);
                    this.processAppDataBizService.addAppVersionData(vo.getDataIds(), sysVersion.getId(), 2);
                }
                return true;
            }
        }
        return false;
    }
}

