/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.entity.ActHiTaskinst;
import org.openoa.base.vo.BpmVerifyInfoVo;
import org.openoa.engine.bpmnconf.common.ProcessServiceFactory;
import org.openoa.engine.bpmnconf.mapper.BpmVerifyInfoMapper;
import org.openoa.engine.bpmnconf.service.impl.ActHiTaskinstServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class TemplateMgmtServiceImpl
extends ProcessServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(TemplateMgmtServiceImpl.class);
    public static final String PROCESS_TEMPLATE = "process201804161604";
    @Autowired
    private BpmVerifyInfoMapper bpmVerifyInfoMapper;
    @Autowired
    private ActHiTaskinstServiceImpl actHiTaskinstService;

    public void processDeployment(String filePath, String processName) throws Exception {
        InputStream fis = new ClassPathResource(filePath).getInputStream();
        this.repositoryService.createDeployment().addInputStream(processName, fis).deploy();
    }

    public void delProcessTemplate(String deployId) {
        this.repositoryService.deleteDeployment(deployId, true);
    }

    @Deprecated
    public List<BpmVerifyInfoVo> findVerifyInfo(String business_id) {
        return this.bpmVerifyInfoMapper.findVerifyInfo(business_id);
    }

    public List<String> findProcess(String processId) {
        ArrayList<String> list = new ArrayList<String>();
        BpmnModel model = this.repositoryService.getBpmnModel(processId);
        if (model != null) {
            Collection flowElements = model.getMainProcess().getFlowElements();
            for (FlowElement e : flowElements) {
                if (e.getId().contains("flow") || e.getName().contains("Start") || e.getName().contains("End")) continue;
                list.add(e.getId());
            }
        }
        return list;
    }

    public void commitProcess(String taskId, Map<String, Object> variables, String activityId) {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            this.taskService.complete(taskId, variables);
        } else {
            try {
                this.turnTransition(taskId, activityId, variables);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void endProcess(String taskId) throws Exception {
        ActivityImpl endActivity = this.findActivitiImpl(taskId, "end");
        this.commitProcess(taskId, null, endActivity.getId());
    }

    private void turnTransition(String taskId, String activityId, Map<String, Object> variables) throws Exception {
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        List<PvmTransition> oriPvmTransitionList = this.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        ActivityImpl pointActivity = this.findActivitiImpl(taskId, activityId);
        newTransition.setDestination(pointActivity);
        this.taskService.complete(taskId, variables);
        pointActivity.getIncomingTransitions().remove(newTransition);
        this.restoreTransition(currActivity, oriPvmTransitionList);
    }

    public ActivityImpl findActivitiImpl(String taskId, String activityId) throws Exception {
        ProcessDefinitionEntity processDefinition = this.findProcessDefinitionEntityByTaskId(taskId);
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            activityId = this.findTaskById(taskId).getTaskDefinitionKey();
        }
        if (activityId.toUpperCase().equals("END")) {
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl;
            }
        }
        ActivityImpl activityImpl = processDefinition.findActivity(activityId);
        return activityImpl;
    }

    private ProcessDefinitionEntity findProcessDefinitionEntityByTaskId(String taskId) throws Exception {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(this.findTaskById(taskId).getProcessDefinitionId());
        if (processDefinition == null) {
            throw new Exception("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230!");
        }
        return processDefinition;
    }

    private TaskEntity findTaskById(String taskId) throws Exception {
        TaskEntity task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new Exception("\u4efb\u52a1\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return task;
    }

    private void restoreTransition(ActivityImpl activityImpl, List<PvmTransition> oriPvmTransitionList) {
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        pvmTransitionList.clear();
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
    }

    private List<PvmTransition> clearTransition(ActivityImpl activityImpl) {
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List pvmTransitionList = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        return oriPvmTransitionList;
    }

    public void rejectNode(String taskId, String taskNode) {
        String destTaskkey = taskNode;
        ActHiTaskinst currTask = this.actHiTaskinstService.queryByTaskId(taskId);
        ExecutionEntity entity = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(currTask.getProcInstId()).singleResult();
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(entity.getProcessDefinitionId());
        Map variables = entity.getProcessVariables();
        ActivityImpl currActivityImpl = definition.findActivity(entity.getActivityId());
        ActivityImpl nextActivityImpl = definition.findActivity(destTaskkey);
        if (currActivityImpl != null) {
            List pvmTransitions = currActivityImpl.getOutgoingTransitions();
            ArrayList<PvmTransition> oriPvmTransitions = new ArrayList<PvmTransition>();
            for (PvmTransition transition : pvmTransitions) {
                oriPvmTransitions.add(transition);
            }
            pvmTransitions.clear();
            ArrayList<TransitionImpl> transitionImpls = new ArrayList<TransitionImpl>();
            TransitionImpl tImpl = currActivityImpl.createOutgoingTransition();
            tImpl.setDestination(nextActivityImpl);
            transitionImpls.add(tImpl);
            List list = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(entity.getProcessInstanceId())).taskDefinitionKey(entity.getActivityId())).list();
            for (Task task : list) {
                this.taskService.complete(task.getId(), variables);
                this.actHiTaskinstService.deleteById(task.getId());
            }
            for (TransitionImpl transitionImpl : transitionImpls) {
                currActivityImpl.getOutgoingTransitions().remove(transitionImpl);
            }
            for (PvmTransition pvmTransition : oriPvmTransitions) {
                pvmTransitions.add(pvmTransition);
            }
        }
    }

    public String getNextNode(String procInstanceId) {
        List tasks = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(procInstanceId)).list();
        String nextId = "";
        block0: for (Task task : tasks) {
            RepositoryService rs = this.processEngine.getRepositoryService();
            ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)rs).getDeployedProcessDefinition(task.getProcessDefinitionId());
            List activitiList = def.getActivities();
            String excId = task.getExecutionId();
            RuntimeService runtimeService = this.processEngine.getRuntimeService();
            ExecutionEntity execution = (ExecutionEntity)runtimeService.createExecutionQuery().executionId(excId).singleResult();
            String activitiId = execution.getActivityId();
            for (ActivityImpl activityImpl : activitiList) {
                String id = activityImpl.getId();
                if (!activitiId.equals(id)) continue;
                List outTransitions = activityImpl.getOutgoingTransitions();
                for (PvmTransition tr : outTransitions) {
                    PvmActivity ac = tr.getDestination();
                    nextId = ac.getId();
                }
                continue block0;
            }
        }
        return nextId;
    }
}

