/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Date;
import org.openoa.base.constant.enums.MessageLimit;
import org.openoa.base.entity.Employee;
import org.openoa.base.entity.UserEmailSend;
import org.openoa.base.entity.UserMessage;
import org.openoa.base.entity.UserMessageStatus;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.DateUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseMsgInfo;
import org.openoa.base.vo.MailInfo;
import org.openoa.base.vo.MessageInfo;
import org.openoa.base.vo.SendInfo;
import org.openoa.base.vo.SendParam;
import org.openoa.base.vo.UrlParams;
import org.openoa.engine.bpmnconf.mapper.UserEmailSendMapper;
import org.openoa.engine.bpmnconf.mapper.UserMessageStatusMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.UserMessageBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.UserMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserMessageBizServiceImpl
implements UserMessageBizService {
    @Autowired
    private UserMessageStatusMapper userMessageStatusMapper;
    @Autowired
    private UserEmailSendMapper userEmailSendMapper;
    @Autowired
    private AfUserService employeeService;
    @Value(value="${message.email.password:none}")
    private String password;
    @Value(value="${message.email.account:none}")
    private String account;
    @Value(value="${message.email.host:none}")
    private String host;
    @Value(value="${system.domain:none}")
    private String systemDomain;
    private static final String APPLY_UPDATE = "applyUpdate";
    private static final String EXAMINE = "examine";
    private static final String CHECK = "check";
    private static final String NEWS = "news";
    private static final String WORKFLOW_LIST = "workflowList";
    private static final String MY_TASK = "myTask";

    @Override
    @Transactional
    public Boolean sendAllMessage(SendInfo sendInfo) {
        if ("".equals(sendInfo.getUserMessage().getUrl()) || sendInfo.getUserMessage().getUrl() == null) {
            UrlParams urlParams = sendInfo.getUserMessage().getUrlParams();
            String url = "";
            if (sendInfo.getUserMessage().getUrlParams() != null) {
                sendInfo.getUserMessage().getParams().getClass();
            }
            sendInfo.getUserMessage().setUrl(url);
        }
        ((UserMessageService)this.getService()).insertMessage(sendInfo.getUserMessage());
        UserMessageStatus userMessageStatus = new UserMessageStatus();
        String senderName = "system";
        senderName = SecurityUtils.getLogInEmpNameSafe();
        userMessageStatus.setUserId(sendInfo.getUserMessage().getUserId());
        Object userMessageStatusInfo = null;
        if (userMessageStatusInfo != null) {
            Date dayEnd = DateUtil.getDayEnd((Date)new Date());
            Date dayStar = DateUtil.getDayStart((Date)new Date());
            if (userMessageStatusInfo.getMailStatus().booleanValue() && sendInfo.getMail() != null) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"receiver", (Object)sendInfo.getMail().getReceiver());
                wrapper.ge((Object)"create_time", (Object)dayStar);
                wrapper.le((Object)"create_time", (Object)dayEnd);
                long totalCount = this.userEmailSendMapper.selectCount((Wrapper)wrapper);
                if (totalCount < (long)MessageLimit.EMAIL_A_DAY.getCode()) {
                    UserEmailSend userEmailSend = new UserEmailSend();
                    userEmailSend.setTitle(sendInfo.getMail().getTitle());
                    userEmailSend.setReceiver(sendInfo.getMail().getReceiver());
                    String emailJumpUrl = "";
                    emailJumpUrl = "".equals(sendInfo.getUserMessage().getUrl()) || sendInfo.getUserMessage().getUrl() == null ? "" : "<a href='http://" + this.systemDomain + "#" + sendInfo.getUserMessage().getUrl() + "'>\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>";
                    sendInfo.getMail().setContent(sendInfo.getMail().getContent() + emailJumpUrl);
                    userEmailSend.setContent(sendInfo.getMail().getContent());
                    userEmailSend.setUpdateUser(senderName);
                    userEmailSend.setCreateUser(senderName);
                    userEmailSend.setSender(senderName);
                    this.userEmailSendMapper.insert(userEmailSend);
                    MailInfo mail = new MailInfo();
                    mail.setContent(sendInfo.getMail().getContent());
                    mail.setReceiver(sendInfo.getMail().getReceiver());
                    mail.setTitle(sendInfo.getMail().getTitle());
                    ((UserMessageService)this.getService()).sendMail(mail);
                }
            }
            if (userMessageStatusInfo.getMessageStatus().booleanValue()) {
                MessageInfo messageInfo = new MessageInfo();
                messageInfo.setReceiver(sendInfo.getMessageInfo().getReceiver());
                messageInfo.setContent(sendInfo.getMessageInfo().getContent());
                ((UserMessageService)this.getService()).sendMessage(messageInfo);
            }
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public Boolean sendMailOnly(SendInfo sendInfo) {
        ((UserMessageService)this.getService()).insertMessage(sendInfo.getUserMessage());
        String senderName = "system";
        senderName = SecurityUtils.getLogInEmpNameSafe();
        Date dayEnd = DateUtil.getDayEnd((Date)new Date());
        Date dayStar = DateUtil.getDayStart((Date)new Date());
        if (sendInfo.getMail() != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"receiver", (Object)sendInfo.getMail().getReceiver());
            wrapper.ge((Object)"create_time", (Object)dayStar);
            wrapper.le((Object)"create_time", (Object)dayEnd);
            long totalCount = this.userEmailSendMapper.selectCount((Wrapper)wrapper);
            if (totalCount < (long)MessageLimit.EMAIL_A_DAY.getCode()) {
                UserEmailSend userEmailSend = new UserEmailSend();
                userEmailSend.setTitle(sendInfo.getMail().getTitle());
                userEmailSend.setReceiver(sendInfo.getMail().getReceiver());
                String emailJumpUrl = "";
                emailJumpUrl = "".equals(sendInfo.getUserMessage().getUrl()) || sendInfo.getUserMessage().getUrl() == null ? "" : "<a href='http://" + this.systemDomain + "#" + sendInfo.getUserMessage().getUrl() + "'>\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>";
                sendInfo.getMail().setContent(sendInfo.getMail().getContent() + emailJumpUrl);
                userEmailSend.setContent(sendInfo.getMail().getContent());
                userEmailSend.setUpdateUser(senderName);
                userEmailSend.setCreateUser(senderName);
                userEmailSend.setSender(senderName);
                this.userEmailSendMapper.insert(userEmailSend);
                MailInfo mail = new MailInfo();
                mail.setContent(sendInfo.getMail().getContent());
                mail.setReceiver(sendInfo.getMail().getReceiver());
                mail.setTitle(sendInfo.getMail().getTitle());
                ((UserMessageService)this.getService()).sendMail(mail);
                return true;
            }
        }
        return false;
    }

    @Override
    @Async
    public Boolean sendMessagePre(SendParam sendParam) {
        Employee detail = this.employeeService.getEmployeeDetailById(sendParam.getUserId());
        if (detail == null) {
            throw new AFBizException("999999", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u7684\u7528\u6237!");
        }
        String senderUser = "";
        senderUser = SecurityUtils.getLogInEmpNameSafe();
        MailInfo mailInfo = MailInfo.builder().content(sendParam.getContent()).receiver(detail.getEmail()).title(sendParam.getTitle()).build();
        MessageInfo message = MessageInfo.builder().receiver(detail.getMobile()).content(sendParam.getContent()).build();
        UserMessage userMessage = UserMessage.builder().content(sendParam.getContent()).title(sendParam.getTitle()).createUser(senderUser).isRead(Boolean.valueOf(false)).params(sendParam.getParams()).updateUser(SecurityUtils.getLogInEmpNameSafe()).urlParams(sendParam.getUrlParams()).appUrl(sendParam.getAppUrl() == null ? "" : sendParam.getAppUrl()).url(sendParam.getUrl()).userId(sendParam.getUserId()).build();
        BaseMsgInfo baseMsgInfo = BaseMsgInfo.builder().url(sendParam.getAppUrl()).msgTitle(sendParam.getTitle()).build();
        SendInfo build = SendInfo.builder().mail(mailInfo).messageInfo(message).userMessage(userMessage).baseMsgInfo(baseMsgInfo).build();
        return this.sendAllMessage(build);
    }
}

