/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz;

import java.util.List;
import org.openoa.base.constant.enums.MessageSendTypeEnum;
import org.openoa.base.entity.Employee;
import org.openoa.base.entity.UserMessage;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseMsgInfo;
import org.openoa.base.vo.MailInfo;
import org.openoa.base.vo.MessageInfo;
import org.openoa.base.vo.SendInfo;
import org.openoa.base.vo.SendParam;
import org.openoa.engine.bpmnconf.service.interf.repository.UserMessageBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.UserMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UserMessagePreServiceImpl {
    @Autowired
    private UserMessageBizService userMessageBizService;
    @Autowired
    private AfUserService employeeService;

    @Async
    public Boolean sendMessagePre(SendParam sendParam) {
        Employee detail = this.employeeService.getEmployeeDetailById(sendParam.getUserId());
        if (detail == null) {
            throw new AFBizException("999999", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u7684\u7528\u6237!");
        }
        String senderUser = SecurityUtils.getLogInEmpNameSafe();
        MailInfo mailInfo = MailInfo.builder().content(sendParam.getContent()).receiver(detail.getEmail()).title(sendParam.getTitle()).build();
        MessageInfo message = MessageInfo.builder().receiver(detail.getMobile()).content(sendParam.getContent()).build();
        UserMessage userMessage = UserMessage.builder().content(sendParam.getContent()).title(sendParam.getTitle()).createUser(senderUser).isRead(Boolean.valueOf(false)).node(sendParam.getNode()).params(sendParam.getParams()).updateUser(SecurityUtils.getLogInEmpNameSafe()).urlParams(sendParam.getUrlParams()).appUrl(sendParam.getAppUrl() == null ? "" : sendParam.getAppUrl()).url(sendParam.getUrl()).userId(sendParam.getUserId()).build();
        BaseMsgInfo baseMsgInfo = BaseMsgInfo.builder().url(sendParam.getAppUrl()).msgTitle(sendParam.getTitle()).build();
        SendInfo build = SendInfo.builder().mail(mailInfo).messageInfo(message).userMessage(userMessage).baseMsgInfo(baseMsgInfo).build();
        return this.userMessageBizService.sendAllMessage(build);
    }

    @Async
    public Boolean sendMessagePre(SendParam sendParam, MessageSendTypeEnum messageSendTypeEnum) {
        Employee detail = this.employeeService.getEmployeeDetailById(sendParam.getUserId());
        if (detail == null) {
            throw new AFBizException("999999", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u7684\u7528\u6237!");
        }
        String senderUser = "";
        senderUser = SecurityUtils.getLogInEmpNameSafe();
        MailInfo mailInfo = MailInfo.builder().content(sendParam.getContent()).receiver(detail.getEmail()).title(sendParam.getTitle()).build();
        MessageInfo message = MessageInfo.builder().receiver(detail.getMobile()).content(sendParam.getContent()).build();
        UserMessage userMessage = UserMessage.builder().content(sendParam.getContent()).title(sendParam.getTitle()).createUser(senderUser).isRead(Boolean.valueOf(false)).params(sendParam.getParams()).updateUser(SecurityUtils.getLogInEmpNameSafe()).urlParams(sendParam.getUrlParams()).appUrl(sendParam.getAppUrl() == null ? "" : sendParam.getAppUrl()).url(sendParam.getUrl()).userId(sendParam.getUserId()).build();
        BaseMsgInfo baseMsgInfo = BaseMsgInfo.builder().url(sendParam.getAppUrl()).msgTitle(sendParam.getTitle()).build();
        SendInfo build = SendInfo.builder().mail(mailInfo).messageInfo(message).userMessage(userMessage).baseMsgInfo(baseMsgInfo).build();
        switch (messageSendTypeEnum) {
            case MAIL: {
                return this.userMessageBizService.sendMailOnly(build);
            }
            case MESSAGE: {
                return ((UserMessageService)this.userMessageBizService.getService()).sendMessageOnly(build);
            }
        }
        return false;
    }

    @Async
    public Boolean sendMessagePreBatch(List<SendParam> sendParams) {
        for (SendParam sendParam : sendParams) {
            try {
                Thread.sleep(200L);
                Employee detail = this.employeeService.getEmployeeDetailById(sendParam.getUserId());
                if (detail == null) {
                    throw new AFBizException("999999", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u7684\u7528\u6237!");
                }
                String senderUser = "";
                senderUser = SecurityUtils.getLogInEmpNameSafe();
                MailInfo mailInfo = MailInfo.builder().content(sendParam.getContent()).receiver(detail.getEmail()).title(sendParam.getTitle()).build();
                MessageInfo message = MessageInfo.builder().receiver(detail.getMobile()).content(sendParam.getContent()).build();
                UserMessage userMessage = UserMessage.builder().content(sendParam.getContent()).title(sendParam.getTitle()).createUser(senderUser).isRead(Boolean.valueOf(false)).params(sendParam.getParams()).updateUser(SecurityUtils.getLogInEmpNameSafe()).urlParams(sendParam.getUrlParams()).appUrl(sendParam.getAppUrl() == null ? "" : sendParam.getAppUrl()).url(sendParam.getUrl()).userId(sendParam.getUserId()).build();
                BaseMsgInfo baseMsgInfo = BaseMsgInfo.builder().url(sendParam.getAppUrl()).msgTitle(sendParam.getTitle()).build();
                SendInfo build = SendInfo.builder().mail(mailInfo).messageInfo(message).userMessage(userMessage).baseMsgInfo(baseMsgInfo).build();
                this.userMessageBizService.sendAllMessage(build);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Async
    public Boolean sendMessagePreBatch(List<SendParam> sendParams, MessageSendTypeEnum messageSendTypeEnum) {
        for (SendParam sendParam : sendParams) {
            try {
                Thread.sleep(200L);
                Employee detail = this.employeeService.getEmployeeDetailById(sendParam.getUserId());
                if (detail == null) {
                    throw new AFBizException("999999", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u7684\u7528\u6237!");
                }
                String senderUser = "";
                senderUser = SecurityUtils.getLogInEmpNameSafe();
                MailInfo mailInfo = MailInfo.builder().content(sendParam.getContent()).receiver(detail.getEmail()).title(sendParam.getTitle()).build();
                MessageInfo message = MessageInfo.builder().receiver(detail.getMobile()).content(sendParam.getContent()).build();
                UserMessage userMessage = UserMessage.builder().content(sendParam.getContent()).title(sendParam.getTitle()).createUser(senderUser).isRead(Boolean.valueOf(false)).params(sendParam.getParams()).updateUser(SecurityUtils.getLogInEmpNameSafe()).urlParams(sendParam.getUrlParams()).appUrl(sendParam.getAppUrl() == null ? "" : sendParam.getAppUrl()).url(sendParam.getUrl()).userId(sendParam.getUserId()).build();
                BaseMsgInfo baseMsgInfo = BaseMsgInfo.builder().url(sendParam.getAppUrl()).msgTitle(sendParam.getTitle()).build();
                SendInfo build = SendInfo.builder().mail(mailInfo).messageInfo(message).userMessage(userMessage).baseMsgInfo(baseMsgInfo).build();
                switch (messageSendTypeEnum) {
                    case MAIL: {
                        this.userMessageBizService.sendMailOnly(build);
                        break;
                    }
                    case MESSAGE: {
                        ((UserMessageService)this.userMessageBizService.getService()).sendMessageOnly(build);
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

