/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz.callback;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openoa.base.constant.enums.BusinessCallbackEnum;
import org.openoa.base.interf.BusinessCallBackAdaptor;
import org.openoa.base.service.BusinessCallBackFace;
import org.openoa.base.util.Retryer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class BusinessCallBackFactory {
    private static final Logger log = LoggerFactory.getLogger(BusinessCallBackFactory.class);
    private static Map<BusinessCallbackEnum, List<BusinessCallBackAdaptor>> allAdaptorsOfType = null;
    private static final BusinessCallBackFactory instance;

    private BusinessCallBackFactory() {
    }

    public static BusinessCallBackFactory build() {
        return instance;
    }

    public <T> void doCallBack(T params, BusinessCallbackEnum callbackEnum, Integer code) {
        BusinessCallBackFace[] enumFaces;
        List<BusinessCallBackAdaptor> callBackAdaptorsOfType = this.getCallBackAdaptorsOfType(callbackEnum);
        if (CollectionUtils.isEmpty(callBackAdaptorsOfType)) {
            return;
        }
        Class clsz = callbackEnum.getClsz();
        block2: for (BusinessCallBackFace callBackFace : enumFaces = (BusinessCallBackFace[])clsz.getEnumConstants()) {
            if (!Objects.equals(callBackFace.getCode(), code)) continue;
            BusinessCallBackAdaptor businessCallBackAdaptor = callBackFace.getClszAdaptorInstance();
            Retryer.Default retryer = new Retryer.Default();
            while (true) {
                try {
                    businessCallBackAdaptor.doCallBack(params);
                    continue block2;
                }
                catch (RuntimeException e) {
                    retryer.continueOrPropagate(e);
                    continue;
                }
                break;
            }
        }
    }

    public <T> void doCallBacks(T params, BusinessCallbackEnum callbackEnum) {
        List<BusinessCallBackAdaptor> callBackAdaptors = this.getCallBackAdaptorsOfType(callbackEnum);
        for (BusinessCallBackAdaptor callBackAdaptor : callBackAdaptors) {
            try {
                callBackAdaptor.doCallBack(params);
            }
            catch (Exception e) {
                log.error("error while executing callback method,className:{}", (Object)callBackAdaptor.getClass().getName(), (Object)e);
            }
        }
    }

    private List<BusinessCallBackAdaptor> getCallBackAdaptorsOfType(BusinessCallbackEnum businessCallbackEnum) {
        List<BusinessCallBackAdaptor> businessCallBackAdaptors = allAdaptorsOfType.get(businessCallbackEnum);
        return businessCallBackAdaptors;
    }

    static {
        allAdaptorsOfType = BusinessCallbackEnum.getAllAdaptorsByType();
        instance = new BusinessCallBackFactory();
    }
}

