/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz.personnelinfoprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.AFSpecialAssigneeEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.BpmnPersonnelProviderService;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class CustomizePersonnelProvider
implements BpmnPersonnelProviderService {
    public List<BpmnNodeParamsAssigneeVo> getAssigneeList(BpmnNodeVo bpmnNodeVo, BpmnStartConditionsVo bpmnStartConditions) {
        if (bpmnNodeVo == null) {
            throw new AFBizException("node can not be null!");
        }
        Map nodeId2Assignees = bpmnStartConditions.getApproversList();
        ArrayList currentNodeAssignees = new ArrayList();
        ArrayList<BpmnNodeParamsAssigneeVo> emList = new ArrayList<BpmnNodeParamsAssigneeVo>();
        if (!CollectionUtils.isEmpty((Map)nodeId2Assignees)) {
            if (nodeId2Assignees.size() == 1) {
                List assignees = nodeId2Assignees.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                currentNodeAssignees.addAll(assignees);
            } else {
                List baseIdTranStruVos = (List)nodeId2Assignees.get(bpmnNodeVo.getId().toString());
                if (!CollectionUtils.isEmpty((Collection)baseIdTranStruVos)) {
                    currentNodeAssignees.addAll(baseIdTranStruVos);
                }
            }
            if (!ObjectUtils.isEmpty(currentNodeAssignees)) {
                int fIndex = 1;
                for (BaseIdTranStruVo s : currentNodeAssignees) {
                    BpmnNodeParamsAssigneeVo vo = new BpmnNodeParamsAssigneeVo();
                    vo.setAssignee(s.getId());
                    vo.setAssigneeName(s.getName());
                    if (!ObjectUtils.isEmpty((Object)bpmnNodeVo.getNodeName())) {
                        vo.setElementName(bpmnNodeVo.getNodeName());
                    } else {
                        vo.setElementName("\u81ea\u5b9a\u4e49\u5ba1\u6279\u4eba" + fIndex);
                    }
                    ++fIndex;
                    emList.add(vo);
                }
            } else {
                BpmnNodeParamsAssigneeVo vo = new BpmnNodeParamsAssigneeVo();
                vo.setAssignee("0");
                emList.add(vo);
            }
        } else {
            BpmnNodeParamsAssigneeVo vo = new BpmnNodeParamsAssigneeVo();
            vo.setAssignee(AFSpecialAssigneeEnum.TO_BE_REMOVED.getId());
            emList.add(vo);
        }
        return emList;
    }
}

