/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.biz.personnelinfoprovider;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openoa.base.entity.Result;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.empinfoprovider.BpmnRoleInfoProvider;
import org.openoa.base.util.ThreadLocalContainer;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.common.util.AssigneeVoBuildUtils;
import org.openoa.engine.bpmnconf.service.biz.personnelinfoprovider.AbstractMissingAssignNodeAssigneeVoProvider;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmApproveTemplateServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class RolePersonnelProvider
extends AbstractMissingAssignNodeAssigneeVoProvider {
    private static final Logger log = LoggerFactory.getLogger(RolePersonnelProvider.class);
    @Autowired
    private BpmnRoleInfoProvider roleInfoProvider;
    @Autowired
    private AssigneeVoBuildUtils assigneeVoBuildUtils;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private OutSideBpmApproveTemplateServiceImpl outSideBpmApproveTemplateService;

    public List<BpmnNodeParamsAssigneeVo> getAssigneeList(BpmnNodeVo bpmnNodeVo, BpmnStartConditionsVo startConditionsVo) {
        BpmnNodePropertysVo propertysVo = bpmnNodeVo.getProperty();
        if (propertysVo == null || CollectionUtils.isEmpty((Collection)propertysVo.getRoleIds())) {
            throw new AFBizException("\u6307\u5b9a\u89d2\u8272\u627e\u4eba\u6761\u4ef6\u4e0d\u5168\uff0c\u65e0\u6cd5\u627e\u4eba\uff01");
        }
        if (bpmnNodeVo.getIsOutSideProcess() != null && bpmnNodeVo.getIsOutSideProcess().equals(1)) {
            Object currentuser;
            if ("Gb2".equals(bpmnNodeVo.getNodeId()) && (currentuser = ThreadLocalContainer.get((String)"currentuser")) != null) {
                BaseIdTranStruVo user = (BaseIdTranStruVo)currentuser;
                return this.assigneeVoBuildUtils.buildVOs((Collection)Lists.newArrayList((Object[])new BaseIdTranStruVo[]{user}), bpmnNodeVo.getNodeName(), false);
            }
            String roelApiUrl = this.outSideBpmApproveTemplateService.getRoelApiUrlByConfId(bpmnNodeVo.getConfId());
            if (roelApiUrl == null) {
                throw new AFBizException("can not find specified out side process template user info url  via confId:" + bpmnNodeVo.getConfId());
            }
            ParameterizedTypeReference<Result<List<BaseIdTranStruVo>>> typeRef = new ParameterizedTypeReference<Result<List<BaseIdTranStruVo>>>(){};
            ResponseEntity responseEntity = this.restTemplate.exchange(roelApiUrl + "/" + (String)bpmnNodeVo.getProperty().getRoleIds().get(0), HttpMethod.GET, null, (ParameterizedTypeReference)typeRef, new Object[0]);
            Result result = (Result)responseEntity.getBody();
            if (result == null || !result.isSuccess()) {
                throw new AFBizException("can not find specified out side process template user info url via confId:" + bpmnNodeVo.getConfId());
            }
            List userList = (List)result.getData();
            if (CollectionUtils.isEmpty((Collection)userList)) {
                throw new AFBizException("can not find specified out side process template user info url via confId:" + bpmnNodeVo.getConfId());
            }
            return this.assigneeVoBuildUtils.buildVOs((Collection)userList, bpmnNodeVo.getNodeName(), false);
        }
        List roleIds = propertysVo.getRoleIds();
        Map roleEmployeeInfo = this.roleInfoProvider.provideRoleEmployeeInfo((Collection)roleIds);
        ArrayList<BaseIdTranStruVo> baseIdTranStruVoList = CollectionUtils.isEmpty((Map)roleEmployeeInfo) ? new ArrayList<BaseIdTranStruVo>() : roleEmployeeInfo.entrySet().stream().map(a -> BaseIdTranStruVo.builder().id((String)a.getKey()).name((String)a.getValue()).build()).collect(Collectors.toList());
        return super.provideAssigneeList(bpmnNodeVo, baseIdTranStruVoList);
    }
}

