/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.cmd;

import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartActivityCmd
implements Command<Void> {
    private static final Logger log = LoggerFactory.getLogger(StartActivityCmd.class);
    private ActivityImpl _activity;
    private String _executionId;
    private final String variableName;
    private final String variableValue;

    public StartActivityCmd(String executionId, ActivityImpl activity, String variableName, String variableValue) {
        this._activity = activity;
        this._executionId = executionId;
        this.variableName = variableName;
        this.variableValue = variableValue;
    }

    public Void execute(CommandContext commandContext) {
        log.debug(String.format("executing activity: %s", this._activity.getId()));
        ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(this._executionId);
        execution.setVariable(this.variableName, (Object)this.variableValue);
        execution.setActivity(this._activity);
        execution.performOperation(AtomicOperation.ACTIVITY_START);
        return null;
    }
}

