/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.flowcontrol;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.entity.ActHiTaskinst;
import org.openoa.base.util.ProcessDefinitionUtils;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.common.mapper.BpmVariableMultiplayerMapper;
import org.openoa.common.service.BpmVariableMultiplayerServiceImpl;
import org.openoa.engine.bpmnconf.adp.processoperation.AddAssigneeProcessImpl;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.cmd.DeleteRunningTaskCmd;
import org.openoa.engine.bpmnconf.service.cmd.StartActivityCmd;
import org.openoa.engine.bpmnconf.service.flowcontrol.TaskFlowControlService;
import org.openoa.engine.bpmnconf.service.impl.ActHiTaskinstServiceImpl;
import org.springframework.util.CollectionUtils;

public class DefaultTaskFlowControlService
implements TaskFlowControlService {
    ProcessDefinitionEntity _processDefinition;
    ProcessEngine _processEngine;
    private String _processInstanceId;
    private final BpmVariableMultiplayerServiceImpl _bpmVariableMultiplayerService;

    public DefaultTaskFlowControlService(ProcessEngine processEngine, String processId, BpmVariableMultiplayerServiceImpl bpmVariableMultiplayerService) {
        this._processEngine = processEngine;
        this._processInstanceId = processId;
        this._bpmVariableMultiplayerService = bpmVariableMultiplayerService;
        String processDefId = ((ProcessInstance)this._processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(this._processInstanceId).singleResult()).getProcessDefinitionId();
        this._processDefinition = ProcessDefinitionUtils.getProcessDefinition((ProcessEngine)this._processEngine, (String)processDefId);
    }

    private void executeCommand(Command<Void> command) {
        ((RuntimeServiceImpl)this._processEngine.getRuntimeService()).getCommandExecutor().execute(command);
    }

    private List<Task> getCurrentTasks() {
        return ((TaskQuery)this._processEngine.getTaskService().createTaskQuery().processInstanceId(this._processInstanceId)).active().list();
    }

    private List<Task> getTaskById(String taskId) {
        List tasks = ((TaskQuery)this._processEngine.getTaskService().createTaskQuery().taskId(taskId)).list();
        return tasks;
    }

    @Override
    public List<String> moveTo(String currentTaskDefKey, String targetTaskDefinitionKey) throws Exception {
        List<Task> currentTasks = this.getCurrentTasks();
        this.moveTo(currentTasks, currentTaskDefKey, targetTaskDefinitionKey);
        List<String> otherParallTaskDefKeys = currentTasks.stream().map(TaskInfo::getTaskDefinitionKey).filter(a -> !a.equals(currentTaskDefKey)).collect(Collectors.toList());
        return otherParallTaskDefKeys;
    }

    private List<String> moveTov1(List<Task> currentTaskEntitys, String currentTaskDefKey, ActivityImpl activity) {
        ArrayList<String> taskDefKeys = new ArrayList<String>();
        ArrayList<String> allTaskDefKeys = new ArrayList<String>();
        HashSet<String> alreadyProcessed = new HashSet<String>();
        for (Task currentTaskEntity : currentTaskEntitys) {
            allTaskDefKeys.add(currentTaskEntity.getTaskDefinitionKey());
            if (!currentTaskEntity.getTaskDefinitionKey().equals(currentTaskDefKey)) {
                taskDefKeys.add(currentTaskEntity.getTaskDefinitionKey());
            }
            this.executeCommand(new DeleteRunningTaskCmd((TaskEntity)currentTaskEntity));
            if (alreadyProcessed.contains(currentTaskEntity.getTaskDefinitionKey())) continue;
            alreadyProcessed.add(currentTaskEntity.getTaskDefinitionKey());
            this.executeCommand(new StartActivityCmd(currentTaskEntity.getExecutionId(), activity, "todo", "todo"));
        }
        if (allTaskDefKeys.size() > 1 && allTaskDefKeys.stream().distinct().distinct().distinct().count() == 1L) {
            this.executeCommand(new StartActivityCmd(currentTaskEntitys.get(1).getExecutionId(), activity, "todo", "todo"));
        }
        return taskDefKeys;
    }

    private List<String> moveTov2(List<Task> currentTaskEntitys, String currentTaskDefKey, ActivityImpl activity) {
        Map variables = this._processEngine.getTaskService().getVariables(currentTaskEntitys.get(0).getId());
        String processNumber = variables.get("processNumber").toString();
        String variableName = this._bpmVariableMultiplayerService.queryVariableNameByElementId(processNumber, activity.getId());
        List assigneeListByElementId = ((BpmVariableMultiplayerMapper)this._bpmVariableMultiplayerService.getBaseMapper()).getAssigneeByElementId(processNumber, activity.getId());
        TaskEntity taskEntity = null;
        int currentEqualCount = 0;
        for (int i = 0; i < currentTaskEntitys.size(); ++i) {
            Task currentTaskEntity = currentTaskEntitys.get(i);
            if (currentTaskEntity.getTaskDefinitionKey().equals(currentTaskDefKey)) {
                ++currentEqualCount;
                if (taskEntity == null) {
                    taskEntity = (TaskEntity)currentTaskEntity;
                }
                BaseIdTranStruVo assignee = i < assigneeListByElementId.size() ? (BaseIdTranStruVo)assigneeListByElementId.get(i) : (BaseIdTranStruVo)assigneeListByElementId.get(assigneeListByElementId.size() - 1);
                String variableVal = "startUser".equals(variableName) ? variables.get("startUser").toString() : assignee.getId();
                int index = variableName.indexOf("List");
                String newVarName = "";
                newVarName = index != -1 ? ("startUser".equals(variableName) ? variableName : variableName.substring(0, index) + variableName.substring(index).replace("List", "") + "s") : variableName + "s";
                this.executeCommand(new DeleteRunningTaskCmd((TaskEntity)currentTaskEntity));
                this.executeCommand(new StartActivityCmd(currentTaskEntity.getExecutionId(), activity, newVarName, variableVal));
                continue;
            }
            this.executeCommand(new DeleteRunningTaskCmd((TaskEntity)currentTaskEntity));
        }
        ActHiTaskinstServiceImpl actHiTaskinstService = (ActHiTaskinstServiceImpl)((Object)SpringBeanUtils.getBean(ActHiTaskinstServiceImpl.class));
        List historicTaskInstances = actHiTaskinstService.queryRecordsByProcInstId(this._processInstanceId).stream().filter(a -> currentTaskDefKey.equals(a.getTaskDefKey())).collect(Collectors.toList());
        List finishedHistoryTasks = historicTaskInstances.stream().filter(a -> a.getEndTime() != null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(finishedHistoryTasks)) {
            TaskMgmtMapper taskMgmtMapper = (TaskMgmtMapper)SpringBeanUtils.getBean(TaskMgmtMapper.class);
            for (ActHiTaskinst finishedHistoryTask : finishedHistoryTasks) {
                taskMgmtMapper.deleteExecutionById(finishedHistoryTask.getExecutionId());
            }
            RuntimeService runtimeService = this._processEngine.getRuntimeService();
            String executionId = taskEntity.getExecutionId();
            int nrOfInstances = (Integer)runtimeService.getVariable(executionId, "nrOfInstances");
            int nrOfActiveInstances = (Integer)runtimeService.getVariable(executionId, "nrOfInstances");
            int nrOfCompletedInstances = (Integer)runtimeService.getVariable(executionId, "nrOfInstances");
            if (nrOfInstances != currentEqualCount || nrOfActiveInstances != currentEqualCount || nrOfCompletedInstances != 0) {
                runtimeService.setVariable(executionId, "nrOfInstances", (Object)currentEqualCount);
                runtimeService.setVariable(executionId, "nrOfActiveInstances", (Object)currentEqualCount);
                runtimeService.setVariable(executionId, "nrOfCompletedInstances", (Object)0);
            }
            currentEqualCount += finishedHistoryTasks.size();
        }
        if (currentEqualCount < assigneeListByElementId.size()) {
            List baseIdTranStruVos = assigneeListByElementId.subList(currentEqualCount, assigneeListByElementId.size());
            AddAssigneeProcessImpl bean = (AddAssigneeProcessImpl)SpringBeanUtils.getBean(AddAssigneeProcessImpl.class);
            BusinessDataVo vo = new BusinessDataVo();
            vo.setFormCode(variables.get("formCode").toString());
            vo.setProcessNumber(processNumber);
            vo.setTaskDefKey(activity.getId());
            vo.setOperationType(ProcessOperationEnum.BUTTON_TYPE_ADD_ASSIGNEE.getCode());
            for (BaseIdTranStruVo baseIdTranStruVo : baseIdTranStruVos) {
                ArrayList<BaseIdTranStruVo> userInfos = new ArrayList<BaseIdTranStruVo>();
                userInfos.add(baseIdTranStruVo);
                vo.setUserInfos(userInfos);
                bean.doProcessButton(vo);
            }
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> moveTo(List<Task> currentTaskEntitys, String currentTaskDefKey, String targetTaskDefinitionKey) throws Exception {
        ActivityImpl activity = ProcessDefinitionUtils.getActivity((ProcessEngine)this._processEngine, (String)currentTaskEntitys.get(0).getProcessDefinitionId(), (String)targetTaskDefinitionKey);
        return this.moveTov2(currentTaskEntitys, currentTaskDefKey, activity);
    }
}

