/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.flowcontrol;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.common.mapper.BpmVariableMultiplayerMapper;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.ActHiTaskinstServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmFlowrunEntrustServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class MultiInstanceSignOffService {
    private static final Logger log = LoggerFactory.getLogger(MultiInstanceSignOffService.class);
    private final RuntimeService runtimeService;
    private final TaskService taskService;
    private final TaskMgmtMapper taskMgmtMapper;
    private final BpmVariableMultiplayerMapper bpmVariableMultiplayerMapper;
    private final BpmBusinessProcessServiceImpl bpmBusinessProcessService;
    private final BpmFlowrunEntrustServiceImpl flowrunEntrustService;
    private final ActHiTaskinstServiceImpl actHiTaskinstService;

    public MultiInstanceSignOffService(@Autowired ProcessEngine processEngine, TaskMgmtMapper taskMgmtMapper, BpmVariableMultiplayerMapper bpmVariableMultiplayerMapper, BpmBusinessProcessServiceImpl bpmBusinessProcessService, BpmFlowrunEntrustServiceImpl flowrunEntrustService, ActHiTaskinstServiceImpl actHiTaskinstService) {
        this.runtimeService = processEngine.getRuntimeService();
        this.taskService = processEngine.getTaskService();
        this.taskMgmtMapper = taskMgmtMapper;
        this.bpmVariableMultiplayerMapper = bpmVariableMultiplayerMapper;
        this.bpmBusinessProcessService = bpmBusinessProcessService;
        this.flowrunEntrustService = flowrunEntrustService;
        this.actHiTaskinstService = actHiTaskinstService;
    }

    public void removeAssignee(String processNumber, String taskDefKey, String userToRemove, String userToRemoveName) {
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(processNumber);
        if (bpmBusinessProcess == null) {
            throw new RuntimeException("\u672a\u627e\u6839\u636e\u6d41\u7a0b\u7f16\u53f7\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b" + processNumber);
        }
        String processInstanceId = bpmBusinessProcess.getProcInstId();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).activityId(taskDefKey).list();
        if (CollectionUtils.isEmpty((Collection)executions)) {
            throw new RuntimeException("\u672a\u627e\u5230\u591a\u5b9e\u4f8b\u8282\u70b9\u6267\u884c\u5b9e\u4f8b");
        }
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskDefinitionKey(taskDefKey)).list();
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            throw new RuntimeException("\u672a\u80fd\u6839\u636e\u5f53\u524dtaskdefkey" + taskDefKey + "\u627e\u5230\u4efb\u52a1");
        }
        if (tasks.size() == 1) {
            throw new RuntimeException("\u5f53\u524d\u4efb\u52a1\u53ea\u6709\u4e00\u4e2a\u5ba1\u6279\u4eba,\u65e0\u6cd5\u53bb\u6389!");
        }
        List currentAssigneeTasks = tasks.stream().filter(a -> a.getAssignee().equals(userToRemove)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(currentAssigneeTasks)) {
            throw new RuntimeException("\u672a\u80fd\u6839\u636e\u5f53\u524d\u7528\u6237" + userToRemove + "\u7684\u5ba1\u6279\u4efb\u52a1");
        }
        Task currentAssigneeTask = (Task)currentAssigneeTasks.get(0);
        String myExecutionId = currentAssigneeTask.getExecutionId();
        Execution myExecution = (Execution)this.runtimeService.createExecutionQuery().executionId(myExecutionId).singleResult();
        if (myExecution == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u7528\u6237 " + userToRemove + " \u7684 Execution");
        }
        String variableName = this.bpmVariableMultiplayerMapper.getVarNameByElementId(processNumber, taskDefKey);
        if (!StringUtils.hasText((String)variableName)) {
            throw new RuntimeException("\u672a\u627e\u6839\u636e\u6d41\u7a0b\u7f16\u53f7:" + processNumber + "\u548c\u8282\u70b9id:" + taskDefKey + "\u627e\u5230\u6d41\u7a0b\u53d8\u91cf\u540d\u79f0");
        }
        List assigneeList = (List)this.runtimeService.getVariable(myExecution.getId(), variableName);
        if (!assigneeList.remove(userToRemove)) {
            throw new RuntimeException("\u7528\u6237 " + userToRemove + " \u4e0d\u5728\u53c2\u4e0e\u8005\u5217\u8868\u4e2d");
        }
        this.runtimeService.setVariable(myExecution.getParentId(), "personnelList2", (Object)assigneeList);
        this.taskMgmtMapper.deleteExecutionById(myExecution.getId());
        this.taskMgmtMapper.deletTask(currentAssigneeTask.getId());
        this.flowrunEntrustService.addFlowrunEntrust("0", "\u7ba1\u7406\u5458\u51cf\u7b7e", userToRemove, userToRemoveName, currentAssigneeTask.getId(), 0, processInstanceId, bpmBusinessProcess.getProcessinessKey());
        Integer nrOfCompleted = (Integer)this.runtimeService.getVariable(myExecution.getParentId(), "nrOfCompletedInstances");
        Integer nrOfInstances = (Integer)this.runtimeService.getVariable(myExecution.getParentId(), "nrOfInstances");
        long completedCount = this.actHiTaskinstService.queryRecordsByProcInstId(processInstanceId).stream().filter(a -> a.getEndTime() != null && a.getAssignee().equals(userToRemove)).count();
        if (completedCount > 0L && nrOfCompleted != null) {
            this.runtimeService.setVariable(myExecution.getParentId(), "nrOfCompletedInstances", (Object)(nrOfCompleted - 1));
        }
        if (nrOfInstances != null) {
            this.runtimeService.setVariable(myExecution.getParentId(), "nrOfInstances", (Object)(nrOfInstances - 1));
        }
        Integer updatedCompleted = (Integer)this.runtimeService.getVariable(myExecution.getParentId(), "nrOfCompletedInstances");
        int activeInstances = assigneeList.size() - updatedCompleted;
        this.runtimeService.setVariable(myExecution.getParentId(), "nrOfActiveInstances", (Object)activeInstances);
    }
}

