/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.base.Strings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.openoa.base.entity.BpmFlowrunEntrust;
import org.openoa.base.entity.UserEntrust;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmFlowrunEntrustVo;
import org.openoa.engine.bpmnconf.mapper.BpmFlowrunEntrustMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmFlowrunEntrustService;
import org.openoa.engine.utils.AFWrappers;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class BpmFlowrunEntrustServiceImpl
extends ServiceImpl<BpmFlowrunEntrustMapper, BpmFlowrunEntrust>
implements BpmFlowrunEntrustService {
    @Override
    public void addFlowrunEntrust(String actual, String actualName, String original, String originalName, String runtaskid, Integer type, String ProcessInstanceId, String processKey) {
        BpmFlowrunEntrust entrust = new BpmFlowrunEntrust();
        entrust.setType(type);
        entrust.setRuntaskid(runtaskid);
        entrust.setActual(actual);
        entrust.setActualName(actualName);
        entrust.setOriginal(original);
        entrust.setOriginalName(originalName);
        entrust.setIsRead(Integer.valueOf(2));
        entrust.setProcDefId(processKey);
        entrust.setRuninfoid(ProcessInstanceId);
        entrust.setTenantId(MultiTenantUtil.getCurrentTenantId());
        ((BpmFlowrunEntrustMapper)this.getBaseMapper()).insert(entrust);
    }

    @Override
    public boolean addFlowrunEntrust(BpmFlowrunEntrust flowrunEntrust) {
        ((BpmFlowrunEntrustMapper)this.getBaseMapper()).insert(flowrunEntrust);
        return true;
    }

    @Override
    public UserEntrust getBpmEntrust(String receiverId, String processKey) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = df.parse(df.format(new Date()));
        }
        catch (ParseException e) {
            this.log.error("error occur when parsing:", (Throwable)e);
        }
        String key = "";
        if (processKey.contains(":")) {
            key = processKey.split(":")[0];
        }
        UserEntrust entrust = ((BpmFlowrunEntrustMapper)this.getBaseMapper()).getBpmEntrust(receiverId, !Strings.isNullOrEmpty((String)key) ? key : processKey);
        UserEntrust userEntrust = null;
        if (!ObjectUtils.isEmpty((Object)entrust) && date != null) {
            if (entrust.getBeginTime() == null && entrust.getEndTime() == null) {
                userEntrust = entrust;
            } else if (entrust.getBeginTime() != null && entrust.getEndTime() != null) {
                if (date.getTime() >= entrust.getBeginTime().getTime() && date.getTime() <= entrust.getEndTime().getTime()) {
                    userEntrust = entrust;
                }
            } else if (entrust.getBeginTime() == null && entrust.getEndTime() != null) {
                if (entrust.getEndTime().getTime() >= date.getTime()) {
                    userEntrust = entrust;
                }
            } else if (entrust.getBeginTime() != null && entrust.getEndTime() == null && entrust.getBeginTime().getTime() <= date.getTime()) {
                userEntrust = entrust;
            }
        }
        return userEntrust;
    }

    @Override
    public Boolean updateBpmFlowrunEntrust(String processInstanceId, Integer loginUserId) {
        ((BpmFlowrunEntrustMapper)this.getBaseMapper()).updateBpmFlowrunEntrust(processInstanceId, loginUserId);
        return true;
    }

    @Override
    public boolean editFlowrunEntrustState(String processInstanceId) {
        ((BpmFlowrunEntrustMapper)this.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmFlowrunEntrust::getRuninfoid, (Object)processInstanceId)).eq(BpmFlowrunEntrust::getOriginal, (Object)SecurityUtils.getLogInEmpIdSafe())).forEach(o -> {
            o.setIsView(Integer.valueOf(1));
            ((BpmFlowrunEntrustMapper)this.getBaseMapper()).updateById(o);
        });
        return true;
    }

    @Override
    public List<BpmFlowrunEntrust> findFlowrunEntrustByProcessInstanceId(BpmFlowrunEntrustVo vo) {
        return Optional.ofNullable(((BpmFlowrunEntrustMapper)this.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmFlowrunEntrust::getType, (Object)vo.getType())).eq(BpmFlowrunEntrust::getRuninfoid, (Object)vo.getRuninfoid()))).orElse(Collections.emptyList());
    }
}

