/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openoa.base.entity.BpmProcessAppApplication;
import org.openoa.base.entity.BpmProcessAppData;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.StrUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.engine.bpmnconf.mapper.BpmProcessAppApplicationMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessAppApplicationService;
import org.openoa.engine.vo.BpmProcessAppApplicationVo;
import org.openoa.engine.vo.ProcessTypeInforVo;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class BpmProcessAppApplicationServiceImpl
extends ServiceImpl<BpmProcessAppApplicationMapper, BpmProcessAppApplication>
implements BpmProcessAppApplicationService {
    @Deprecated
    public List<BpmProcessAppApplication> getBpmProcessAppApplication(List<String> list) {
        ArrayList<BpmProcessAppApplication> appApplications = new ArrayList<BpmProcessAppApplication>();
        QueryWrapper applicationWrapper = new QueryWrapper();
        applicationWrapper.in((Object)"process_key", list);
        applicationWrapper.eq((Object)"is_del", (Object)0);
        ((BpmProcessAppApplicationMapper)this.getBaseMapper()).selectList((Wrapper)applicationWrapper).forEach(o -> appApplications.add(BpmProcessAppApplication.builder().id(o.getId()).source(o.getEffectiveSource()).state(o.getState()).sort(o.getSort()).route(o.getRoute()).processKey(o.getProcessKey()).title(o.getTitle()).build()));
        return appApplications;
    }

    @Deprecated
    public List<BpmProcessAppApplication> allProcessAppApplication(List<BpmProcessAppData> list) {
        ArrayList<BpmProcessAppApplication> appApplications = new ArrayList<BpmProcessAppApplication>();
        for (BpmProcessAppData processAppData : list) {
            BpmProcessAppApplication appApplication = (BpmProcessAppApplication)((BpmProcessAppApplicationMapper)this.getBaseMapper()).selectById(processAppData.getApplicationId());
            if (processAppData.getState().equals(1)) {
                appApplication.setRoute("");
            } else {
                appApplication.setSource(appApplication.getEffectiveSource());
            }
            if (!appApplication.getIsDel().equals("0")) continue;
            appApplications.add(appApplication);
        }
        return appApplications;
    }

    @Deprecated
    public List<BpmProcessAppApplication> processAppApplicationList(List<BpmProcessAppApplication> list) {
        return list.stream().map(o -> {
            if (o.getRoute() != null) {
                String route = StringEscapeUtils.unescapeJson((String)o.getRoute());
                try {
                    o.setRoute(URLEncoder.encode(route, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return o;
        }).collect(Collectors.toList());
    }

    @Override
    public boolean addBpmProcessAppApplication(BpmProcessAppApplicationVo vo) {
        String[] passFilList = new String[]{"serialVersionUID", "isAll"};
        BpmProcessAppApplication forVo = new BpmProcessAppApplication();
        String route = StringEscapeUtils.unescapeHtml3((String)vo.getRoute());
        vo.setRoute(route);
        BeanUtils.copyProperties((Object)vo, (Object)forVo, (String[])passFilList);
        if (vo.getId() != null) {
            forVo.setEffectiveSource(vo.getEffectiveSource());
            this.updateById(forVo);
        } else {
            forVo.setCreateTime(new Date());
            forVo.setEffectiveSource(vo.getEffectiveSource());
            forVo.setProcessKey(vo.getBusinessCode() + "_" + StrUtils.getFirstLetters((String)vo.getTitle()));
            QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"process_name", (Object)vo.getTitle())).eq((Object)"is_del", (Object)0);
            if (this.count((Wrapper)wrapper) > 0L) {
                throw new AFBizException("\u8be5\u9009\u9879\u540d\u79f0\u5df2\u5b58\u5728");
            }
            this.save(forVo);
        }
        return true;
    }

    @Override
    public boolean deleteAppIcon(Long id) {
        BpmProcessAppApplication processApplicationType = (BpmProcessAppApplication)((BpmProcessAppApplicationMapper)this.getBaseMapper()).selectById(id);
        processApplicationType.setIsDel(Integer.valueOf(1));
        ((BpmProcessAppApplicationMapper)this.getBaseMapper()).updateById(processApplicationType);
        return true;
    }

    @Override
    public List<ProcessTypeInforVo> list(String version) {
        return null;
    }

    @Override
    public List<BpmProcessAppApplicationVo> listProcessApplication() {
        ArrayList<BpmProcessAppApplicationVo> result = new ArrayList<BpmProcessAppApplicationVo>();
        QueryWrapper wrapper = new QueryWrapper();
        List list = ((BpmProcessAppApplicationMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (BpmProcessAppApplication b : list) {
                BpmProcessAppApplicationVo vo = new BpmProcessAppApplicationVo();
                vo.setId(b.getId());
                vo.setProcessName(b.getTitle());
                vo.setCreateTime(b.getCreateTime());
                vo.setCreateTimeStr(df.format(b.getCreateTime()));
                vo.setName(b.getTitle() + "(" + df.format(b.getCreateTime()) + ")");
                result.add(vo);
            }
        }
        return result;
    }

    @Override
    public List<BaseIdTranStruVo> listProcessAppApplication(String search, Integer limitSize) {
        if (limitSize == null) {
            limitSize = 10;
        }
        List<BpmProcessAppApplicationVo> vos = ((BpmProcessAppApplicationMapper)this.getBaseMapper()).searchIcon(BpmProcessAppApplicationVo.builder().search(search).limitSize(limitSize).build());
        ArrayList<BaseIdTranStruVo> list = new ArrayList<BaseIdTranStruVo>();
        list.addAll(vos.stream().map(o -> BaseIdTranStruVo.builder().id(o.getId().toString()).name(o.getProcessName()).build()).collect(Collectors.toList()));
        return list;
    }

    @Override
    public List<BpmProcessAppApplicationVo> selectThirdPartyApplications(String businessPartyMark) {
        return ((BpmProcessAppApplicationMapper)this.getBaseMapper()).selectAllByBusinessPart(businessPartyMark);
    }

    @Override
    public List<BpmProcessAppApplicationVo> selectAllByPartMarkId(Integer partyMarkId) {
        return ((BpmProcessAppApplicationMapper)this.getBaseMapper()).selectAllByPartMarkId(partyMarkId);
    }

    @Override
    public List<BpmProcessAppApplication> selectApplicationList() {
        return ((BpmProcessAppApplicationMapper)this.getBaseMapper()).selectList(null);
    }

    private List<BpmProcessAppApplication> applicationsList() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"is_del", (Object)0);
        return ((BpmProcessAppApplicationMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
    }
}

