/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.openoa.base.entity.BpmProcessApplicationType;
import org.openoa.engine.bpmnconf.mapper.BpmProcessApplicationTypeMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessApplicationTypeService;
import org.openoa.engine.vo.BpmProcessApplicationTypeVo;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class BpmProcessApplicationTypeServiceImpl
extends ServiceImpl<BpmProcessApplicationTypeMapper, BpmProcessApplicationType>
implements BpmProcessApplicationTypeService {
    @Override
    public List<BpmProcessApplicationType> applicationTypes(BpmProcessApplicationTypeVo vo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"is_del", (Object)0);
        if (vo.getApplicationId() != null) {
            wrapper.eq((Object)"application_id", (Object)vo.getApplicationId());
        }
        if (vo.getCategoryId() == null) {
            wrapper.eq((Object)"category_id", (Object)vo.getCategoryId());
        }
        return ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
    }

    @Override
    public boolean deletProcessApplicationType(BpmProcessApplicationTypeVo vo) {
        List<BpmProcessApplicationType> bpmProcessApplicationTypes = this.applicationTypes(vo);
        if (!CollectionUtils.isEmpty(bpmProcessApplicationTypes)) {
            for (BpmProcessApplicationType type : bpmProcessApplicationTypes) {
                BpmProcessApplicationType applicationType = (BpmProcessApplicationType)((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectById(type.getHistoryId());
                if (applicationType != null) {
                    Integer sort = applicationType.getSort();
                    applicationType.setIsDel(Integer.valueOf(0));
                    applicationType.setSort(Integer.valueOf(0));
                    ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).deleteById(applicationType);
                    this.sortProcessApplicationType(sort, applicationType.getCategoryId());
                }
                ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).deleteById(type);
            }
        }
        return true;
    }

    @Override
    public boolean sortProcessApplicationType(Integer sort, Long processTypeId) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_del", (Object)0)).eq((Object)"category_id", (Object)processTypeId);
        Long countTotal = ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectCount((Wrapper)wrapper);
        List list = ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectList((Wrapper)wrapper.gt((Object)"sort", (Object)sort));
        if ((long)sort.intValue() < countTotal) {
            int countChanged = 0;
            for (BpmProcessApplicationType o : list) {
                o.setSort(Integer.valueOf(o.getSort() - 1));
                countChanged += ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).updateById(o);
            }
            return (long)countChanged == countTotal - (long)sort.intValue();
        }
        return true;
    }

    @Override
    public boolean sortProcessApplicationType(Integer sort, Integer countTotal, List<BpmProcessApplicationType> list) {
        if (sort < countTotal) {
            int countChanged = 0;
            for (BpmProcessApplicationType o : list) {
                o.setSort(Integer.valueOf(o.getSort() - 1));
                countChanged += ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).updateById(o);
            }
            return countChanged == countTotal - sort;
        }
        return true;
    }

    @Override
    public boolean editProcessApplicationType(BpmProcessApplicationTypeVo vo) {
        QueryWrapper wrapper;
        List<BpmProcessApplicationType> list = this.applicationTypes(vo);
        for (BpmProcessApplicationType type : list) {
            wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_del", (Object)0)).eq((Object)"category_id", (Object)type.getCategoryId());
            Long countTotal = ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectCount((Wrapper)wrapper);
            Integer sort = type.getSort();
            List processApplicationTypes = ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectList((Wrapper)wrapper.gt((Object)"sort", (Object)sort));
            ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).deleteById(type);
            this.sortProcessApplicationType(sort, countTotal.intValue(), processApplicationTypes);
        }
        for (Long id : vo.getProcessTypes()) {
            wrapper = new QueryWrapper();
            wrapper.eq((Object)"is_del", (Object)0);
            wrapper.eq((Object)"category_id", (Object)id);
            Long countCode = ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectCount((Wrapper)wrapper);
            BpmProcessApplicationType type = BpmProcessApplicationType.builder().applicationId(vo.getApplicationId()).categoryId(id).createTime(new Date()).sort(Integer.valueOf(countCode.intValue() + 1)).build();
            if (vo.getVisbleState() != null) {
                type.setVisbleState(vo.getVisbleState());
            }
            this.save(type);
        }
        return true;
    }

    @Override
    public Long addProcessApplicationType(BpmProcessApplicationTypeVo vo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.eq((Object)"category_id", (Object)vo.getCategoryId());
        String passFilList = "serialVersionUID";
        BpmProcessApplicationType type = new BpmProcessApplicationType();
        BeanUtils.copyProperties((Object)vo, (Object)type, (String[])new String[]{passFilList});
        Long countCode = ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectCount((Wrapper)wrapper);
        type.setSort(Integer.valueOf(countCode.intValue() + 1));
        type.setCreateTime(new Date());
        ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).insert(type);
        Serializable id = Optional.ofNullable(Optional.ofNullable(type).orElseGet(() -> new BpmProcessApplicationType()).getId()).orElse(0L);
        return Long.parseLong(id.toString());
    }

    @Override
    public boolean hiddenApplication(Long id, boolean isHidden, Long commonUseId) {
        BpmProcessApplicationType applicationType = (BpmProcessApplicationType)((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectById(id);
        Integer visbleState = 0;
        if (!isHidden) {
            visbleState = 1;
        }
        if (applicationType.getHistoryId() != null) {
            BpmProcessApplicationType type = (BpmProcessApplicationType)((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectById(applicationType.getHistoryId());
            type.setVisbleState(visbleState);
            this.updateById(type);
        } else {
            List<BpmProcessApplicationType> applicationTypeList = this.getProcessApplicationType(BpmProcessApplicationTypeVo.builder().categoryId(commonUseId).applicationId(applicationType.getApplicationId()).build());
            if (!CollectionUtils.isEmpty(applicationTypeList)) {
                BpmProcessApplicationType processApplicationType = applicationTypeList.get(0);
                processApplicationType.setVisbleState(visbleState);
                this.updateById(processApplicationType);
            }
        }
        applicationType.setVisbleState(visbleState);
        this.updateById(applicationType);
        return true;
    }

    @Override
    public List<BpmProcessApplicationType> getProcessApplicationType(BpmProcessApplicationTypeVo vo) {
        QueryWrapper wrapper = new QueryWrapper();
        if (vo.getCategoryId() != null) {
            wrapper.eq((Object)"category_id", (Object)vo.getCategoryId());
        }
        if (vo.getApplicationId() != null) {
            wrapper.eq((Object)"application_id", (Object)vo.getApplicationId());
        }
        if (vo.getVisbleState() != null) {
            wrapper.eq((Object)"visble_state", (Object)vo.getVisbleState());
        }
        List bpmProcessApplicationTypes = ((BpmProcessApplicationTypeMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
        return bpmProcessApplicationTypes;
    }
}

