/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.openoa.base.entity.BpmProcessCategory;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.engine.bpmnconf.mapper.BpmProcessCategoryMapper;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessApplicationTypeBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessCategoryService;
import org.openoa.engine.vo.BpmProcessCategoryVo;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class BpmProcessCategoryServiceImpl
extends ServiceImpl<BpmProcessCategoryMapper, BpmProcessCategory>
implements BpmProcessCategoryService {
    @Override
    public boolean editProcessCategory(BpmProcessCategoryVo vo) {
        String passFilList = "serialVersionUID";
        BpmProcessCategory forVo = new BpmProcessCategory();
        BeanUtils.copyProperties((Object)vo, (Object)forVo, (String[])new String[]{passFilList});
        if (vo.getId() != null) {
            this.updateById(forVo);
        } else {
            QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"process_type_name", (Object)vo.getProcessTypeName())).eq((Object)"is_app", (Object)vo.getIsApp())).eq((Object)"is_del", (Object)0);
            if (this.count((Wrapper)wrapper) > 0L) {
                throw new AFBizException("\u8be5\u9009\u9879\u540d\u79f0\u5df2\u5b58\u5728");
            }
            QueryWrapper categoryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_app", (Object)vo.getIsApp())).eq((Object)"is_del", (Object)0);
            Long countCode = ((BpmProcessCategoryMapper)this.getBaseMapper()).selectCount((Wrapper)categoryWrapper);
            if (vo.getIsApp().equals(0)) {
                forVo.setEntrance("PC");
            } else if (vo.getIsApp().equals(1)) {
                forVo.setEntrance("APP");
            }
            forVo.setSort(Integer.valueOf(countCode.intValue() + 1));
            this.save(forVo);
        }
        return true;
    }

    @Override
    public boolean categoryOperation(Integer type, Long id) {
        switch (type) {
            case 2: {
                this.moveUp(id);
                break;
            }
            case 3: {
                this.moveDown(id);
                break;
            }
            case 4: {
                ((BpmProcessApplicationTypeBizService)SpringBeanUtils.getBean(BpmProcessApplicationTypeBizService.class)).delete(id);
            }
        }
        return true;
    }

    @Override
    public boolean moveUp(Long id) {
        BpmProcessCategory bpmProcessCategory = (BpmProcessCategory)((BpmProcessCategoryMapper)this.getBaseMapper()).selectById(id);
        if (bpmProcessCategory == null) {
            throw new AFBizException("\u65e0\u6b64\u6761\u8bb0\u5f55");
        }
        Integer sort = bpmProcessCategory.getSort();
        if (sort == 2) {
            throw new AFBizException("\u5f53\u524d\u8bb0\u5f55\u5df2\u5230\u9876");
        }
        BpmProcessCategory processCategory = (BpmProcessCategory)((BpmProcessCategoryMapper)this.getBaseMapper()).selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_app", (Object)bpmProcessCategory.getIsApp())).eq((Object)"sort", (Object)(sort - 1))).eq((Object)"is_del", (Object)0));
        processCategory.setSort(sort);
        this.updateById(processCategory);
        bpmProcessCategory.setSort(Integer.valueOf(sort - 1));
        this.updateById(bpmProcessCategory);
        return true;
    }

    @Override
    public boolean moveDown(Long id) {
        BpmProcessCategory bpmProcessCategory = (BpmProcessCategory)((BpmProcessCategoryMapper)this.getBaseMapper()).selectById(id);
        if (bpmProcessCategory == null) {
            new AFBizException("\u65e0\u6b64\u6761\u8bb0\u5f55");
        }
        Integer sort = bpmProcessCategory.getSort();
        Long count = ((BpmProcessCategoryMapper)this.getBaseMapper()).selectCount((Wrapper)new QueryWrapper().eq((Object)"is_del", (Object)0));
        if ((long)sort.intValue() >= count) {
            throw new AFBizException("\u5f53\u524d\u8bb0\u5f55\u5df2\u5230\u5e95");
        }
        BpmProcessCategory processCategory = (BpmProcessCategory)((BpmProcessCategoryMapper)this.getBaseMapper()).selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_app", (Object)bpmProcessCategory.getIsApp())).eq((Object)"sort", (Object)(sort + 1))).eq((Object)"is_del", (Object)0));
        processCategory.setSort(sort);
        this.updateById(processCategory);
        bpmProcessCategory.setSort(Integer.valueOf(sort + 1));
        this.updateById(bpmProcessCategory);
        return true;
    }

    @Override
    public List<BpmProcessCategory> processCategoryList(BpmProcessCategoryVo vo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"is_del", (Object)0);
        if (vo.getIsApp() != null) {
            wrapper.eq((Object)"is_app", (Object)vo.getIsApp());
        }
        List bpmProcessCategories = ((BpmProcessCategoryMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
        bpmProcessCategories.sort(Comparator.comparing(BpmProcessCategory::getSort));
        return bpmProcessCategories;
    }

    public List<BpmProcessCategoryVo> processCategoryVos(BpmProcessCategoryVo vo) {
        return this.bpmProcessAppApplicationVoList(((BpmProcessCategoryMapper)this.getBaseMapper()).findProcessCategory(vo));
    }

    @Override
    public List<BpmProcessCategoryVo> bpmProcessAppApplicationVoList(List<BpmProcessCategoryVo> list) {
        return list.stream().map(o -> {
            o.setName(o.getProcessTypeName() + o.getEntrance());
            return o;
        }).collect(Collectors.toList());
    }

    @Override
    public BpmProcessCategory getProcessCategory(Long id) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.eq((Object)"id", (Object)id);
        List bpmProcessCategoryList = ((BpmProcessCategoryMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)bpmProcessCategoryList)) {
            return (BpmProcessCategory)bpmProcessCategoryList.get(0);
        }
        return null;
    }
}

